<?php
/*********************************************************************************
 * The content of this file is subject to the Quick Search 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

require_once 'modules/Webforms/model/WebformsModel.php';
require_once 'include/Webservices/DescribeObject.php';

class ITS4YouQuickSearch
{
    public $list_fields_name = [];
    public $list_fields = [];
    protected static $moduleDescribeCache = array();
    public $LBL_MODULE_NAME = 'Quick Search 4 You';
    public $LBL_MODULE_NAME_OLD = 'Quick Search 4 You';
    public $db;

    // Cache to speed up describe information store
    public $log;

    public function __construct()
    {
        global $log, $currentModule;

        $this->db = PearDatabase::getInstance();
        $this->log = $log;
    }

    public static function checkAdminAccess($user)
    {

    }

    public static function getModuleDescribe($module)
    {

    }

    public static function getFieldInfo($module, $fieldname)
    {

    }

    public static function getFieldInfos($module)
    {

    }

    /**
     * Invoked when special actions are performed on the module.
     * @param String Module name
     * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
     */
    public function vtlib_handler($modulename, $event_type)
    {
        switch ($event_type) {
            case 'module.postinstall':
            case 'module.enabled':
            case 'module.postupdate':
                $this->addCustomLinks();
                break;
            case 'module.disabled':
            case 'module.preuninstall':
            case 'module.preupdate':
                $this->deleteCustomLinks();
                break;
        }
    }

    public function updateSettings($register = true)
    {
        $image = '';
        $description = '';
        $linkto = 'index.php?module=ITS4YouQuickSearch&parent=Settings&view=Index';

        $result1 = $this->db->pquery('SELECT 1 FROM vtiger_settings_field WHERE name=?', array($this->LBL_MODULE_NAME_OLD));
        if ($this->db->num_rows($result1)) {
            $this->db->pquery('UPDATE vtiger_settings_field SET name=?, iconpath=?, description=?, linkto=? WHERE name=?', array($this->LBL_MODULE_NAME, $image, $description, $linkto, $this->LBL_MODULE_NAME_OLD));
        }

        $result2 = $this->db->pquery('SELECT 1 FROM vtiger_settings_field WHERE name=?', array($this->LBL_MODULE_NAME));
        if (!$this->db->num_rows($result2)) {

            $fieldid = $this->db->getUniqueID('vtiger_settings_field');
            $blockid = getSettingsBlockId('LBL_OTHER_SETTINGS');
            $seq_res = $this->db->pquery("SELECT max(sequence) AS max_seq FROM vtiger_settings_field WHERE blockid = ?", array($blockid));
            if ($this->db->num_rows($seq_res) > 0) {
                $cur_seq = $this->db->query_result($seq_res, 0, 'max_seq');
                if ($cur_seq != null) {
                    $seq = $cur_seq + 1;
                }
            }

            $this->db->pquery('INSERT INTO vtiger_settings_field(fieldid, blockid, name, iconpath, description, linkto, sequence) VALUES (?,?,?,?,?,?,?)', array($fieldid, $blockid, $this->LBL_MODULE_NAME, $image, $description, $linkto, $seq));
        }

        if($register) {
            $this->db->pquery('UPDATE vtiger_settings_field SET active= 0  WHERE  name= ?', array($this->LBL_MODULE_NAME));
        } else {
            $this->db->pquery('UPDATE vtiger_settings_field SET active= 1  WHERE  name= ?', array($this->LBL_MODULE_NAME));
        }
    }

    public function addCustomLinks()
    {
        $this->updateCustomLinks();
        $this->updateSettings();
    }

    public function deleteCustomLinks()
    {
        $this->updateCustomLinks(false);
        $this->updateSettings(false);
    }

    /**
     * [module, type, label, url, icon, sequence, handlerInfo]
     * @return array
     */
    public $registerCustomLinks = array(
        ['ITS4YouQuickSearch', 'HEADERSCRIPT', 'LBL_ITS4YOU_QUICK_SEARCH', 'layouts/v7/modules/ITS4YouQuickSearch/resources/ITS4YouQuickSearchHeader.js'],
        ['ITS4YouQuickSearch', 'HEADERSCRIPT', 'ITS4YouQuickSearch_SearchList_Js', 'layouts/v7/modules/ITS4YouQuickSearch/resources/SearchList.js'],
    );

    /**
     * @param bool $register
     */
    public function updateCustomLinks($register = true)
    {
        foreach ($this->registerCustomLinks as $customLink) {
            $module = Vtiger_Module::getInstance($customLink[0]);
            $type = $customLink[1];
            $label = $customLink[2];
            $url = str_replace('$LAYOUT$', Vtiger_Viewer::getDefaultLayoutName(), $customLink[3]);

            if ($module) {
                $module->deleteLink($type, $label);

                if ($register) {
                    $module->addLink($type, $label, $url, $customLink[4], $customLink[5], $customLink[6]);
                }
            }
        }
    }

}