<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions
 * All Rights Reserved.
 *************************************************************************************/

class GeoTools_PopupAjax_View extends GeoTools_Popup_View {
    
    function __construct() {
        parent::__construct();
        $this->exposeMethod('getListViewCount');
        $this->exposeMethod('getRecordsCount');
        $this->exposeMethod('getPageCount');
    }

    function preProcess(Vtiger_Request $request) {
        return true;
    }

    function postProcess(Vtiger_Request $request) {
        return true;
    }

    function process (Vtiger_Request $request) {
        $mode = $request->get('mode');
        if(!empty($mode)) {
            $this->invokeExposedMethod($mode, $request);
            return;
        }
        $viewer = $this->getViewer($request);
        $moduleName = $request->get('tgt_module');

        $searchModel = GeoTools_Search_Model::getInstance();
        $configuredModulesData = $searchModel->getConfiguredModules();
        $configuredModules = array_keys($configuredModulesData);
        
        $this->initializeListViewContents($request, $viewer);

        $viewer->assign('CONFIGURED_MODULES', $configuredModules);

        echo $viewer->view('PopupContents.tpl', 'GeoTools', true);
    }

}
