<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions
 * All Rights Reserved.
 *************************************************************************************/

class GeoTools_ListAjax_View extends GeoTools_GeoTools_View {

    function __construct() {
        parent::__construct();
        $this->exposeMethod('getListViewCount');
        $this->exposeMethod('getRecordsCount');
        $this->exposeMethod('getPageCount');
    }

    function preProcess(Vtiger_Request $request) {
        return true;
    }

    function postProcess(Vtiger_Request $request) {
        return true;
    }

    function process(Vtiger_Request $request) {
        
        $searchModel = GeoTools_Search_Model::getInstance();
        
        // Get the default Search paramaters
        $this->defaultUnit = $searchModel->defaults['distance'];
        $this->defaultRadius = $searchModel->defaults['radius'];
        $this->defaultCenter = $searchModel->defaults['mapcentre'];
        $this->defaultModule = $searchModel->defaults['defaultmod'];
        $this->defaultZoom = $searchModel->defaults['zoom'];
        
        // Centre of Map 
        if($request->get('geotoolsMapCenter')){
            $this->settings['mapcentre'] = $request->get('geotoolsMapCenter');
        } else {
            $this->settings['mapcentre'] = $this->defaultCenter;
        }
        
        // Distance Units
        if($request->get('geotoolsDistanceUnits')){
            $this->settings['distance'] = $request->get('geotoolsDistanceUnits');
        } else {
            $this->settings['distance'] = $this->defaultUnit;
        }
        
        // Search Radius
        if($request->get('geotoolsRadius')){
            $this->settings['radius'] = $request->get('geotoolsRadius');
        } else {
            $this->settings['radius'] = $this->defaultRadius;
        }

        // Radius Constraint (Inside or outside the Radius)
        if($request->get('geotoolsConstraint')){
            $this->settings['constraint'] = $request->get('geotoolsConstraint');
        } else {
            $this->settings['constraint'] = $this->defaultConstraint;
        }
        
        // Order By (Nearest or Farthest first)
        if($request->get('geotoolsSortOrder')){
            $this->settings['geotoolsSortOrder'] = $request->get('geotoolsSortOrder');
        } else {
            $this->settings['geotoolsSortOrder'] = $this->defaultGeoSortOrder;
        }

        $mode = $request->get('mode');
        if(!empty($mode)) {
            $this->invokeExposedMethod($mode, $request);
            return;
        }
    }
}
