<?php
/*************************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions
 * All Rights Reserved.
 *************************************************************************************/
 
// Event Handler triggered on entity.aftersave.final
// If it's a new record, try and geocode it and save it to the database
// If it's an exisiting record see if any of the address fields have changed
// and if so, try and update the location coordinates.

require_once 'data/VTEntityDelta.php';
require_once('includes/main/WebUI.php');

class GeoToolsEventHandler extends VTEventHandler{

    public function handleEvent($handlerType, $data){
        global $log, $adb;
        $log->debug("In GeoToolsEventHandler");

        if($handlerType == 'vtiger.entity.aftersave.final') {

            $DoGeoCode = false;

            $moduleName = $data->getModuleName();
            $recordId = array_pop(explode("x", $data->getId()));

            // Check if triggering module is configured for Geocoding
            $GeoToolsModuleSettingsModel = Settings_GeoTools_ModuleEditor_Model::getInstance();
            $ConfiguredModules = $GeoToolsModuleSettingsModel->getConfiguredModules();

            if(array_key_exists($moduleName, $ConfiguredModules)) {

                $fieldNames = $this->getFieldNames($ConfiguredModules[$moduleName]);
                
                if(is_array($fieldNames) && $fieldNames) {

                    // Get a GeoCoder Object
                    $GeoToolsCoreSettingsModel = Settings_GeoTools_CoreEditor_Model::getInstance();
					$providerModel = GeoTools_Provider_Model::getInstanceById($GeoToolsCoreSettingsModel->get('geocoder'));
				    $providerCode = $providerModel->get('code');
				    $className = "GeoTools_".$providerCode."GeoCoder_Model";
                    $GeoCoder = new $className();
				    
				    $GeoCoder->setParams($providerModel->getData());

                    // Handle difference between new and changed data
                    if ($data->isNew()) {
                        $DoGeoCode = true;
                        
                    } else {
                        // First see if record is locked
                        if($GeoCoder->isLocked($recordId)) {
                            $log->debug("Record is marked as Locked. Finishing");
                            return false;
                        }
                        // Have any of the address fields changed?
                        $vtEntityDelta = new VTEntityDelta();
                        $delta = $vtEntityDelta->getEntityDelta($moduleName, $recordId, true);
                        $delta = array_change_key_case($delta,CASE_LOWER);

                        if(is_array($delta)) {
                            foreach($delta as $modFieldName => $values) {
                                if(in_array($modFieldName, $fieldNames)) {
                                     $DoGeoCode = true;
                                     break;
                                }
                            }
                        }
                    }
                }

                // GeoCode this record?
                if($DoGeoCode) {
                    $save = false;

                    $location = array();
                    $location['crmid'] = $recordId;
                    $location['module'] = $moduleName;

                    foreach($fieldNames as $gtFieldName => $modFieldName) {
                        $location[$gtFieldName] = $data->get($modFieldName);
                    }

                    $result = $GeoCoder->getGeocode($location);
                                        
                    if($result['status'] == 'OK') {
                    	$save = true;
                    }
                    if($result['status'] == 'ZERO_RESULTS') {
                    	// Try with a reduced dataset
                    	$location['field_street'] = '';
                    	$location['field_state'] = '';
                    	$result = $GeoCoder->getGeocode($location);
                    	if($result['status'] == 'OK') {
                    		$save = true;
                    	}
                    }
                    if($save == true) {
                        $GeoCoder->save($result);
                    } else {
                        $log->debug("Unable to save record");
                        $log->debug(print_r($result,true));
                    }
                }
            }
        }
    }

    // get fieldNames from fieldids
    function getFieldNames($fieldsArray) {
        global $adb, $log;
        $fieldids = array();
        foreach($fieldsArray as $fields) {
            //$log->debug(print_r($fields,true));
            if($fields['fieldtype'] == 'field') {
                $fieldids[$fields['fieldname']] = $fields['fieldid'];
            }
        }
        $query = "SELECT fieldid, fieldname FROM vtiger_field WHERE fieldid IN (" . generateQuestionMarks($fieldids) . ")";
        $result = $adb->pquery($query, $fieldids);

        while($row = $adb->fetch_array($result)) {
            $gtFieldName = array_search($row['fieldid'] , $fieldids, true);
            $fieldNames[$gtFieldName] = $row['fieldname'];
        }
        return $fieldNames;
    }
}

