<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions
 * All Rights Reserved.
 *************************************************************************************/

class GeoTools_Search_Model extends Settings_GeoTools_ModuleEditor_Model {
    
    var $defaults = '';
    
    /**
     * Function to get the instance of module model
     * @return <GeoTools_Search_Model> $moduleModel 
     * Had to do this to get access to the default 
     * params from the parent::parent::class
     */
    public static function getInstance($name = false) {
        $db = PearDatabase::getInstance();
        $moduleModel = new self();
        $tableName = $moduleModel->baseTable;
        $result = $db->pquery("SELECT * FROM $tableName", array());
        if ($db->num_rows($result) == 1) {
            $moduleModel->defaults = $db->query_result_rowdata($result);
        }
        
        // Replace tabid with Module name
        $moduleModel->defaults['defaultmod'] = Vtiger_Functions::getModuleName($moduleModel->defaults['defaultmod']);
        
        // Replace gecoder and mapservice with code from provider table
        $GeocoderProviderModel = GeoTools_Provider_Model::getInstanceById($moduleModel->defaults['geocoder']);        
        $MapProviderModel = GeoTools_Provider_Model::getInstanceById($moduleModel->defaults['mapservice']);        
        
        $moduleModel->defaults['geocoder'] = $GeocoderProviderModel->get('code');
        $moduleModel->defaults['mapservice'] = $MapProviderModel->get('code');

        // Set url for map javascript code
        if($moduleModel->defaults['mapservice'] == 'Google') {
            $moduleModel->defaults['mapJS_URL'] = 'http://maps.googleapis.com/maps/api/js?sensor=false';
        } else {
            $moduleModel->defaults['mapJS_URL'] = '';
        }
        
        return $moduleModel;
    }
    
    public function getUserAddressLocation() {
        $db = PearDatabase::getInstance();
        
        // Get current user's lat/lng if available
        $currentUser = Users_Record_Model::getCurrentUserModel();
        $userId = $currentUser->get('id');
        
        if($userId) {
            $query = "SELECT CONCAT(lat, ',', lng) AS location
                      FROM $this->geocodeTable
                      WHERE module = 'Users'
                      AND crmid = ?";
            $result = $db->pquery($query, array($userId));
            if ($db->num_rows($result) == 1) {
                return $db->query_result($result, 0, 'location');
            }
        } else {
            return '';
        }    
    }
    
    /*
     * function to get the pre-coded latlng of a module record
     * used when coming in to GeoTools via a radius search
    */
    public function getLatLng($module, $id) {
        if($module && $id) {
            $db = PearDatabase::getInstance();
            $query = "SELECT CONCAT(lat, ',', lng) AS location 
                      FROM $this->geocodeTable
                      WHERE module = ?
                      AND crmid = ?";
            $result = $db->pquery($query, array($module, $id));
            if ($db->num_rows($result) == 1) {
                return $db->query_result($result, 0, 'location');
            }
        } else {
            return '';
        } 
    }   
}
