<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions
 * All Rights Reserved.
 *************************************************************************************/

class GeoTools_Provider_Model extends Vtiger_Base_Model {

	const ProviderTable = 'libertus_geotools_providers';

    // Currently only Geocoding and Map Tile services
   	var $providerTypes = array(
   		'Geocoder' => 'geocoder',
   		'Map' => 'mapservice'
   	);

	public static function getProvidersInfo($type) {
	    $db = PearDatabase::getInstance();
	    $query = "SELECT * FROM " . self::ProviderTable . " WHERE `type` = ?";
        $result = $db->pquery($query, array($type));
		$numOfRows = $db->num_rows($result);
		$data = array();
		for ($i = 0; $i < $numOfRows; $i++) {
			$row = $db->query_result_rowdata($result, $i);
			$data[$row['providerid']] = $row['name'];
		}
	    return $data;
	}

	/**
	 * If this Provider has mandatory params
	 */
	public function hasReqParams() {
		$params = $this->get('params');
		if($params['req_params']) {
			return true;
		}
		return false;
	}

	/**
	 * If this Provider has optional params
	 */
	public function hasOptParams() {
		$params = $this->get('params');
		if($params['opt_params']) {
			return true;
		}
		return false;
	}

	/**
	 * Is this Provider already configured.
	 * Used to determine the approriate label
	 */
	public function isConfigured() {
		$params = $this->get('params');
		$config = $this->get('config');
		$status = false;
		foreach($params['req_params'] as $name) {
			if($config[$name]) {
				$status = true; //TODO This won't work properly for multiple params.
			}
		}
		return $status;
	}

    /**
     * Update Provider configuration
     *
    */
    public function update($updateValues) {
	    $db = PearDatabase::getInstance();
	    if(is_array($updateValues) && $updateValues['providerid']) {
	        $i = 0;
	        $providerid = $updateValues['providerid'];
	        unset($updateValues['providerid']);
	        $query = "UPDATE " . self::ProviderTable . " SET ";
	        if($updateValues['req_params']) {
		        foreach($updateValues['req_params'] as $key => $value) {
		        	$params[$key] = $value;
		        }
	        }
	        if($updateValues['opt_params']) {
		        foreach($updateValues['opt_params'] as $key => $value) {
		           	$params[$key] = $value;
		        }
	        }
			if($params) {
			    $config[] = json_encode($params, JSON_FORCE_OBJECT);
			}
            $query .= " config = ? WHERE providerid = ?";
            $config[] = $providerid;
            $result = $db->pquery($query, $config);
            
            if($result) {
            	return true;
            } else {
            	return "An error occured saving to the database.";
            }
        } else {
        	return "Insufficient data to update Provider.";
        }
    }

    public static function getInstanceById($providerId) {
    	$moduleModel = new self();
   		if($providerId) {
   			$db = PearDatabase::getInstance();
   			$query = "SELECT * FROM " . self::ProviderTable . " WHERE `providerid` = ?";
   			$result = $db->pquery($query, array($providerId));
   			if ($db->num_rows($result) == 1) {
   				$row = $db->raw_query_result_rowdata($result);
   				$moduleModel->set('code', $row['code']);
   				$moduleModel->set('params', json_decode($row['params'], true));
   				$moduleModel->set('config', json_decode($row['config'], true));
   				$moduleModel->set('url', $row['url']);
   			}
   		}
   		return $moduleModel;
    }
}
