<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions
 * All Rights Reserved.
 *************************************************************************************/
 
/**
 * Geocoder for the Open Street Maps Nominatim API
 * http://wiki.openstreetmap.org/wiki/Nominatim
 *
 **/

class GeoTools_OSMGeoCoder_Model extends GeoTools_GeoCoder_Model {

    const APIURL = 'https://nominatim.openstreetmap.org/search';
    const APIVER = '3';
    const APIDAYLIMIT = '2500'; // Hardcoded for this free service
    const MAXRATE = '1500000'; // Hardcoded for this free service

    function __construct() {
    	parent::setDelay(self::MAXRATE);
    	parent::setRate(self::APIDAYLIMIT);
    	parent::setHttpAdapter();
    }
    
    /*
     * Implementation specific function to call provider of Geocoding
     * services.
     * 
     */
    public function getGeocode($location) {
        global $log;
        
        $params['format'] = 'jsonv2';
        $params['limit'] = '1';
        
        // Format for Nominatim's API
        // https://nominatim.openstreetmap.org/search?q=United%20Kingdom,BA3%204BH&format=jsonv2&limit=1

        $locs = array();
        foreach($location as $field => $addr) {
            if (0 === strpos($field, 'field_') && $addr) {
                $locs[] = $addr;
            }       
        }

        if($locs) {
            
            $address = urlencode(implode(',', $locs));
            $request_url = self::APIURL . "?q=" . $address . "&" . http_build_query($params);
            
		    $log->debug("Request URL: $request_url");

			if($this->getHttpAdapter() == 'fopen') {
                $result = $this->fopen_get_contents($request_url);
    	    } else if($this->getHttpAdapter() == 'curl') {
                $result = $this->curl_get_contents($request_url);
            } else {
    	        throw new Exception('No Http Adapter configured. Giving up');
            }
    
            $json = json_decode($result, true);

            $log->debug(print_r($json,true));

            if($json && ($json[0]['lat'] && $json[0]['lon'])) {
                $location['status'] = 'OK';
                $location['lat'] = round($json[0]['lat'], 7);
                $location['lng'] = round($json[0]['lon'], 7);
            } else {
                $location['status'] = 'ZERO_RESULTS';
            }
            return $location;
        } else {
            return array('status' => 'NO_LOCATION_DATA');
        }
    }

}
