<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions
 * All Rights Reserved.
 *************************************************************************************/
 
/**
 * Geocoder for the OpenCage Geocoding API
 * http://geocoder.opencagedata.com/
 *
 * You must be registered and have an API key
 * to use this provider
 *
 **/

class GeoTools_OPCGeoCoder_Model extends GeoTools_GeoCoder_Model {

    const APIURL = 'https://api.opencagedata.com/geocode';
    const APIVER = 'v1';
    const APIDAYLIMIT = '2500'; // Depends on service level
    const NOANNOTATIONS = 'no_annotations=1';
    
    function __construct() {
        parent::setHttpAdapter();
    }
    
    /*
     * Implementation specific function to call provider of Geocoding
     * services.
     *
     */
    public function getGeocode($location) {
    	global $log;
    	
    	$params['format'] = 'json';
    	$params['limit'] = '1';
    	
        // Format for Open Cage's API
		// http://api.opencagedata.com/geocode/v1/json?q=PLACENAME&key=YOURKEY
    	$locs = array();
       	foreach($location as $field => $addr) {
       		if (0 === strpos($field, 'field_') && $addr) {
				$locs[] = $addr;
			}
        }

        if($locs) {
        	
	        $address = urlencode(implode(', ', $locs));
	    
		    $request_url = self::APIURL . "/" . self::APIVER . "/" . $params['format'] . "?q=" . $address . "&key=" . $this->getParam('apikey') . '&' . self::NOANNOTATIONS;
	        
		    $log->debug("Request URL: $request_url");
		    
		    if($this->getHttpAdapter() == 'fopen') {
    	        $result = $this->fopen_get_contents($request_url);
    	    } else if($this->getHttpAdapter() == 'curl') {
        	    $result = $this->curl_get_contents($request_url);
    	    } else {
    	        throw new Exception('No Http Adapter configured. Giving up');
            }
            
	        $json = json_decode($result, true);

	        $log->debug(print_r($json,true));
	        
	        if($json && ($json['status'][code] == '200')) {
				if(count($json['results'])) {
					$location['status'] = 'OK';
					$location['lat'] = $json['results'][0]['geometry']['lat'];
					$location['lng'] = $json['results'][0]['geometry']['lng'];
				} else {
		            $location['status'] = 'ZERO_RESULTS';
				}
		    }
		    return $location;
        } else {
        	return array('status' => 'NO_LOCATION_DATA');
        }
    }

}

