<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions
 * All Rights Reserved.
 *************************************************************************************/

vimport('~~/vtlib/Vtiger/Module.php');

/**
 * GeoTools Module Model Class
 */
class GeoTools_Module_Model extends Vtiger_Module_Model {

    /**
     * Function returns the default view for the GeoTools module
     * @return <String>
     */
    public function getDefaultViewName() {
        return $this->getGeoToolsViewName();
    }

    /**
     * Function returns the GeoTools view name
     * @return <String>
     */
    public function getGeoToolsViewName() {
        return 'GeoTools';
    }

    /**
     *  Function returns the url for GeoTools view
     * @return <String>
     */
    public function getGeoToolsViewUrl() {
        return 'index.php?module='.$this->get('name').'&view='.$this->getGeoToolsViewName();
    }
    
    /**
     * Function to check whether the module is summary view supported
     * @return <Boolean> - true/false
     */
    public function isSummaryViewSupported() {
        return false;
    }

    /**
     * Function to get list of field for related list
     * @return <Array> empty array
     */
    public function getConfigureRelatedListFields() {
        return array();
    }

    /**
     * Function to get list of field for summary view
     * @return <Array> empty array
     */
    public function getSummaryViewFieldsList() {
        return array();
    }
    
    /**
     * Function to get Settings links
     * @return <Array>
     */
    public function getSettingLinks(){
    
        $settingsLinks[] =  array(
                'linktype' => 'LISTVIEWSETTING',
                'linklabel' => vtranslate('LBL GEOTOOLS MODULE CONFIG', $moduleName),
                'linkurl' => 'index.php?module=GeoTools&parent=Settings&view=ModuleEditor',
                'linkicon' => ''
        );
        $settingsLinks[] =  array(
                'linktype' => 'LISTVIEWSETTING',
                'linklabel' => vtranslate('LBL GEOTOOLS CONFIG', $moduleName),
                'linkurl' => 'index.php?module=GeoTools&parent=Settings&view=CoreEditorDetail',
                'linkicon' => ''
        );
        return $settingsLinks;
    }

    /**
     * Function to get the embedded module's listview instance
     * @param <String> $moduleName - module name
     * @return <Vtiger_Entity_Model>
     */
    public static function getListViewInstance($moduleName) {
        $modelClassName = Vtiger_Loader::getComponentClassName('Model', 'ListView', $moduleName);
        $instance = new $modelClassName();
        
        return $instance->getInstance($moduleName);

    }
}
