<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions
 * All Rights Reserved.
 *************************************************************************************/
 
/**
 * Geocoder for the Open Street Maps Nominatim API
 * http://wiki.openstreetmap.org/wiki/Nominatim
 *
 **/

class GeoTools_MQUGeoCoder_Model extends GeoTools_GeoCoder_Model {

//    const APIURL = 'http://nominatim.openstreetmap.org/search';
    const APIURL = 'http://open.mapquestapi.com/nominatim/v1/search.php';
    const APIVER = '3';
    const APIDAYLIMIT = '2500';
    const APIKEY = 'sThT16r8ztC86Gsq2EgUA2VyR2nHPh3W';
    
    /*
    
Consumer Key	sThT16r8ztC86Gsq2EgUA2VyR2nHPh3W
Consumer Secret	gkGFt0oCwNJDIUU7
Key Issued	Thu, 04/12/2018 - 00:55
Key Expires	Never
*/
    
    /*
     * Implementation specific function to call provider of Geocoding
     * services.
     * 
     */
    public function getGeocode($location) {
    	global $log;
    	
//    	$params['format'] = 'jsonv2';
    	$params['format'] = 'json';
    	$params['limit'] = '1';
    	
        // Format for Nominatim's API
        // http://nominatim.openstreetmap.org/search?q=United%20Kingdom,BA3%204BH&format=jsonv2&limit=1
        // alternatief http://open.mapquestapi.com/nominatim/v1/search.php

    	$locs = array();
       	foreach($location as $field => $addr) {
       		if (0 === strpos($field, 'field_') && $addr) {
				$locs[] = $addr;
			}   	
        }

        if($locs) {
        	
	        $address = urlencode(implode(',', $locs));
	    
//		    $request_url = self::APIURL . "?q=" . $address . "&" . http_build_query($params);
		    $request_url = self::APIURL;
		    $request_url .= "?q=" . $address . "&" . http_build_query($params);
		    $request_url .= (self::APIKEY != '') ? '&key='.self::APIKEY : '';
	        
	        // Use cURL if available and we can't use file_get_contents
		    if(ini_get('allow_url_fopen')) {
    	        $result = file_get_contents($request_url);
    	    } else {
    	        if(function_exists('curl_version')) {
        	        $result = $this->curl_get_contents($request_url);
        	    } else {
        	        return array('status' => 'UNABLE_TO_CONNECT');
        	    }
    	    }

        file_put_contents('/home/cs1002/public_html/crm/mqugeocoder.log', $request_url."\n".$result."\n\n", FILE_APPEND);
    
	        $json = json_decode($result, true);

	        if ($json[0]['lat'] && $json[0]['lon']) {
	            $location['status'] = 'OK';
	            $location['lat'] = $json[0]['lat'];
	      			$location['lng'] = $json[0]['lon'];
		    } else {
		        $location['status'] = 'ZERO_RESULTS';
		    }
		    return $location;
        } else {
        	return array('status' => 'NO_LOCATION_DATA');
        }
    }

    public function curl_get_contents($url) {
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HEADER, false);
        $data = curl_exec($curl);
        curl_close($curl);
        return $data;
    }
}
