<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions
 * All Rights Reserved.
 *************************************************************************************/

/**
 * GeoTools Field Model Helper Class 
 * This creates a Field model object so we can add a dynamic column for the
 * ListView Header which we insert at the end of the Header Array
 */
class GeoTools_DistanceField_Model extends Vtiger_Field {

    public function __construct(){
        $this->set('name', 'distance');
        $this->set('column', 'distance');
        $this->set('label', 'LBL GEOTOOLS DISTANCE');
        $this->set('uitype', 1);
    }
    
    public function getName() {
        return $this->name;
    }

    /**
     * Function to get the value of a given property
     * @param <String> $propertyName
     * @return <Object>
     * @throws Exception
     */
    public function get($propertyName) {
        if(property_exists($this,$propertyName)) {
            return $this->$propertyName;
        }
        return null;
    }

    /**
     * Function which sets value for given name
     * @param <String> $name - name for which value need to be assinged
     * @param <type> $value - values that need to be assigned
     * @return Vtiger_Field_Model
     */
    public function set($name, $value) {
        $this->$name = $value;
        return $this;
    }
    
    public function getFieldName() {
        return $this->name;
    }
    
        /**
     * Function to get the minimum amount of field details
     * @return <Array> - array of field values
     */
    public function getFieldInfo() {
        $currentUser = Users_Record_Model::getCurrentUserModel();
        $fieldDataType = $this->getFieldDataType();

        $this->fieldInfo['type'] = $fieldDataType;
        $this->fieldInfo['name'] = $this->get('name');
        $this->fieldInfo['label'] = vtranslate($this->get('label'), $this->getModuleName());

        return $this->fieldInfo;
    }
    
    /**
     * Function to get the Webservice Field data type
     * @return <String> Data type of the field
     */
    public function getFieldDataType() {
        if(!$this->fieldDataType) {
            $this->fieldDataType = 'string';
        }
        return $this->fieldDataType;
    }
    
    /**
     * Function to check if the field is named field of the module
     * @return <Boolean> - True/False
     */
    public function isNameField() {
        return false;
    }
    
    /**
     * Function from modules/Vtiger/models/Field.php
     *
     */
    public function getUITypeModel() {
        return Vtiger_Base_UIType::getInstanceFromField($this);
    }
    
}
