<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions
 * All Rights Reserved.
 *************************************************************************************/

class GeoTools_SaveLocationAjax_Action extends Vtiger_BasicAjax_Action {

    public function process(Vtiger_Request $request) {
        
        $module = $request->get('listModule');
        $crmid = $request->get('id');
        $lat = $request->get('lat');
        $lng = $request->get('lng');
        $locked = 0;
        if($request->get('locked') == 'true'){
            $locked = 1;
        }
        
        $response = new Vtiger_Response();
        $qualifiedModuleName = $request->getModule(false);
        
        if($module && $crmid && $lat && $lng) {     
            // Get the GeoCoder Object Model
            $GeoToolsCoreSettingsModel = Settings_GeoTools_CoreEditor_Model::getInstance();
        	$providerModel = GeoTools_Provider_Model::getInstanceById($GeoToolsCoreSettingsModel->get('geocoder'));
            $providerCode = $providerModel->get('code');
            $className = "GeoTools_".$providerCode."GeoCoder_Model";
            $GeoCoder = new $className();
            
            $location['crmid'] = $crmid;
            $location['module'] = $module;

            $location['lat'] = $lat;
            $location['lng'] = $lng;
            
            $result = $GeoCoder->save($location, $locked);
        }
        
        // TODO Get the right way to test for a successful save
        if($result == true) {
            $response->setResult(array('OK'));
        } else {
            $msg = 'LBL GEOTOOLS UNABLE TO SAVE LOCATION';
            $response->setError(vtranslate($msg, $qualifiedModuleName));
        }
        
        $response->emit();
    }
}
