<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions
 * All Rights Reserved.
 *************************************************************************************/

class GeoTools_GetLatLngAjax_Action extends Vtiger_BasicAjax_Action {

    public function process(Vtiger_Request $request) {
        
        // Get the Core Settings Object
        $searchModel = GeoTools_Search_Model::getInstance();
        
        $module = $request->get('listModule');
        $crmid = $request->get('id');
        
        $response = new Vtiger_Response();
        $qualifiedModuleName = $request->getModule(false);
                            
        $result = $searchModel->getLatLng($module, $crmid);
        
        if($result) {
            $response->setResult(array($result));
        } else {
            $msg = 'LBL GEOTOOLS UNABLE TO GEOCODE ADDRESS';
            $response->setError(vtranslate($msg, $qualifiedModuleName));
        }
                
        $response->emit();
    }
}
