<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions.
 * All Rights Reserved.
 *************************************************************************************/

class GeoTools_GeocodeAddressAjax_Action extends Vtiger_BasicAjax_Action {

    public function process(Vtiger_Request $request) {
        
        // Get the Core Settings Object
        $GeoToolsCoreSettingsModel = Settings_GeoTools_CoreEditor_Model::getInstance();

      	$providerModel = GeoTools_Provider_Model::getInstanceById($GeoToolsCoreSettingsModel->get('geocoder'));
        $providerCode = $providerModel->get('code');
        $className = "GeoTools_".$providerCode."GeoCoder_Model";
	    $GeoCoder = new $className();
        $GeoCoder->setParams($providerModel->getData());
        
        $response = new Vtiger_Response();
        $qualifiedModuleName = $request->getModule(false);

        $location['field_street'] = $request->get('street');
        $location['field_city'] = $request->get('city');
        $location['field_state'] = $request->get('state');
        $location['field_postcode'] = $request->get('postcode');
        $location['field_country'] = $request->get('country');
                            
        $result = $GeoCoder->getGeocode($location);
        if($result['status'] == 'OK') {
            $coords = $result['lat'] . ',' . $result['lng'];
            $response->setResult(array($coords));
        } else {
            $msg = 'LBL GEOTOOLS UNABLE TO GEOCODE ADDRESS';
            $response->setError(vtranslate($msg, $qualifiedModuleName));
        }
        
        $response->emit();
    }
}
