<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions
 * All Rights Reserved.
 *************************************************************************************/
require_once('data/CRMEntity.php');
require_once('data/Tracker.php');
include_once('vtlib/Vtiger/Event.php');

class GeoTools {
    function vtlib_handler($moduleName, $eventType) {
        if ($eventType == 'module.postinstall') {
            $this->configureGeoTools();

            $this->registerEventHandler();
        } else if ($eventType == 'module.disabled') {

            global $adb;
            $em = new VTEventsManager($adb);
            $em->setHandlerInActive('GeoToolsEventHandler');

            Vtiger_Cron::deregister('Geocoding Scheduler');
        } else if ($eventType == 'module.enabled') {
        
            global $adb;
            $em = new VTEventsManager($adb);
            $em->setHandlerActive('GeoToolsEventHandler');

            Vtiger_Cron::register('Geocoding Scheduler', 'modules/GeoTools/resources/GeoToolsCron.service', 86400);
        } else if ($eventType == 'module.preuninstall') {

            global $adb;
            $em = new VTEventsManager($adb);
            $em->unregisterHandler('GeoToolsEventHandler');
            Vtiger_Cron::deregister('Geocoding Scheduler');
        } else if ($eventType == 'module.preupdate') {

        } else if ($eventType == 'module.postupdate') {
        
            $this->configureGeoTools();
            $this->registerEventHandler();
        
        }
    }
    
    function configureGeoTools() {
        global $adb;
        $adb->pquery("UPDATE vtiger_tab SET customized = 0 WHERE name='GeoTools'", array());
        
        $res = $adb->pquery("SELECT * FROM libertus_geotools_settings", array());
        if(!$adb->num_rows($res)) {
            $insertSettings = "INSERT INTO `libertus_geotools_settings`
                                (`geocoder`, `mapservice`, `rate`,`radius`,`zoom`,`mapcentre`,`distance`,
                                 `defaultmod`,`lastrun`,`iconpath`,`companyloc`,`defaultcentre`)
                               VALUES
                                (1, 2, 2500, 15, 12, '51.212381,-0.791071','Miles','','',
                                 'modules/GeoTools/assets/markers/centre/green-star.png','','1')";
            $adb->pquery($insertSettings, array());
        }
        $insertProviderSettings = "INSERT IGNORE INTO libertus_geotools_providers
                                    (`providerid`, `type`, `name`, `code`, `params`, `url`)
                                    VALUES
                                    (?, ?, ?, ?, ?, ?)";
        $providerParams = array();
        $providerParams[] = array(1, 'Geocoder', 'Nominatim',       'OSM', '{"req_params":[],"opt_params":[]}', null);
        $providerParams[] = array(2, 'Map',      'Open Street Map', 'OSM', '{"req_params":[],"opt_params":[]}', null);
        $providerParams[] = array(3, 'Geocoder', 'OpenCage',        'OPC', '{"req_params":["apikey"],"opt_params":[]}', 'https://www.opencagedata.com/');
        foreach($providerParams as $params) {
            $adb->pquery($insertProviderSettings, $params);
        }
    }
    
    function registerEventHandler() {
        global $adb;
        $em = new VTEventsManager($adb);
        $em->registerHandler('vtiger.entity.aftersave.final', 'modules/GeoTools/resources/GeoToolsEventHandler.php', 'GeoToolsEventHandler');
    }
}
?>
