<?php
//--TECHNOKRAFTS STARTS
function tksGetTemplateName() {

  $tid = $_REQUEST['tkstempid'];
  $templ_name = $_REQUEST['tkstempname'];

  $adb = PearDatabase::getInstance();

  if ($tid != "0") {

    $result = $adb->pquery('SELECT templatename FROM vtiger_emailtemplates WHERE templateid=?', array($tid));

    if ($adb->num_rows($result)) {

      $templ_name = decode_html($adb->query_result($result, 0, 'templatename'));
    }
    else {
      $templ_name = "";
    }
  }

  // @change lro 190112
  elseif ($templ_name == '') {

    // tid = "0" so there is no template
    $templ_name = '';
  }

  return $templ_name;
}

function tksMakeClickable($cid, $description) {

  // get the config setting for urls owned by the customer
  // no need to add the trackingcodes to urls pointing to you
  // include('tksConfig.php');
  $ownUrls = Settings_VebSettings_Record_Model::getSetting('own_urls', 'VebEmailConsent');
  $validUrls = explode("\n", $ownUrls);
  $ownUrlArray = array_map('trim', $validUrls);

  // get the template name (will be used as utm_campaigns)
  $templ_name = tksGetTemplateName();

  //TECHNOKRAFTS --STARTS to add link to plain urls
  $description = make_clickable($description);

  //--TECHNOKRAFTS declare array items which are valid
  $reg_exUrl = "/(https?|ftp|gopher|telnet|file|notes|ms-help):((\/\/)|(\\\\))+[\w\d:#@%\/;$(~_?\+-=\\\.&\s]*/";

  // The Text you want to filter for urls
  // Check if there is a url in the text
  if (preg_match_all($reg_exUrl, $description, $urls)) {

    $url = $urls[0];
    $zc = count($url);
    $r = 0;
    $link1 = array();

    for ($z = 0; $z < $zc; $z++) {

      $pattern = '/(https?|ftp|gopher|telnet|file|notes|ms-help):((\/\/)|(\\\\))+[\w\d:#@%\/;$(~_?\+-=\\\.&]*><img[^>]+src[\\s=\'"]+([^"\'>\\s]+)/is';
      $prev = $z + 1;

      if (preg_match_all('!http://.+\.(?:jpe?g|png|gif)!Ui', $url[$prev], $matches)) {

        $linktype = "logolink";
      }
      else {

        $linktype = "textlink";
      }

      // make the urls hyper links
      $x = parse_url($url[$z]);

      $url[$z] = strip_tags($url[$z], '<p>');

      //to get query string parameters into variable
      for ($own = 0; $own < count($ownUrlArray); $own++) {

        if ($x['host'] == $ownUrlArray[$own]) {

          if (strpos($ownUrlArray[$own], $x['host']) !== false) {

            $found = 1;
            break;
          }
          else {

            $found = 0;
            continue;
          }
        }
      }

      if ($found == 0) continue;

      $query = trim($x["query"]);

      if ($x["path"] == "/") {

        $x["path"] = "";
      }

      if ($query != "") {

        $list_query = explode("&", $query);

        $list_query_cnt = count($list_query);

        // @change lro 190829
        $utm_tags = array('utm_source' => 'crm',
                          'utm_medium' => 'email',
                          'utm_content' => $linktype,
                    );

        $utm_tags['utm_campaign'] = ($templ_name != '' and $templ_name != "0" ) ? $templ_name : "";

        $newurl = vebAddTrackingParamsToUrl($url[$z], $mycrmid, $utm_tags);

        $query_string = parse_url($newurl, PHP_URL_QUERY);
        // end of @change lro 190829

        $query_string_new = explode("&", $query_string);
        $query_string_new_cnt = count($query_string_new);

        for ($j = 0; $j < $query_string_new_cnt; $j++) {

          $query_old[$j] = explode("=", $list_query[$j]);
          $query_new[$j] = explode("=", $query_string_new[$j]);
        }

        if ($query_string_new_cnt >= $list_query_cnt) {

          $large_cnt = $query_string_new_cnt;
          $small_cnt = $list_query_cnt;
        }
        else {

          $large_cnt = $list_query_cnt;
          $small_cnt = $query_string_new_cnt;
        }

        for ($i = 0; $i < $large_cnt; $i++) {

          for ($j = 0; $j < $small_cnt; $j++) {

            if ($query_new[$i][0] == $query_old[$j][0]) {

              $x = $large_cnt - 1;

              if ($i == $x) {

                $amp = "";
                $startamp = "&";
              }
              else {

                $startamp = "";
                $amp = "&";
              }

              $query_string = str_replace($startamp . $query_new[$i][0] . "=" . $query_new[$i][1] . $amp, "", $query_string);
              $replace_var = $query_old[$j][1];
              $new_var_name[$j] = $query_new[$j][0];
              $new_var_value[$j] = $query_new[$j][1];
              $new_var_string[$j] = "&" . $query_old[$j][0] . "=" . $query_old[$j][1];
              $new_query_var = "";
            }
            else {

              $new_query_var[$j] = "&" . $query_old[$j][0] . "=" . $query_old[$j][1];
            }
          }

          $new_query_string = $query_string;
        }

        //replace parameters if already exists is new query string
        if ($new_var_string != "") {

          $replace_vars = implode("", $new_var_string);
          $new_query_string = $new_query_string . $replace_vars;
        }

        if ($new_query_var != "") {

          $extra_vars = implode("", $new_query_var);
          $extra_params = explode("&", $extra_vars);
          $extra_params_cnt = count($extra_params);

          for ($q = 1; $q < $extra_params_cnt; $q++) {

            if (strcmp($extra_params[$q], $new_query_string)) {

              $new_query_string = str_replace("&" . $extra_params[$q], "", $new_query_string);
            }
          }

          $new_query_string = $new_query_string . $extra_vars;
        }

        $u[$z] = explode("?", $url[$z]);
        $link1[$z] = $u[$z][0] . "?" . $new_query_string;
        $u[$z][0];
        $rep[$z] = $link1[$z];
      }
      else {

        // @change lro 170114 have recordid in stead of No
        // $link[$z] = $url[$z]."?cid=$tksrecordno&utm_source=crm&utm_medium=email&utm_term=$tid&utm_content=$linktype&utm_campaign=$templ_name";

        // @change lro 190112 cleanup empty values, Google does not like them
        //$link[$z] = $url[$z]."?cid=$vebrecordid&utm_source=crm&utm_medium=email&utm_term=$tid&utm_content=$linktype&utm_campaign=$templ_name";
        $utm_tags = array('utm_source' => 'crm',
                          'utm_medium' => 'email',
                          'utm_content' => $linktype,
                    );

        $utm_tags['utm_campaign'] = ($templ_name != '' and $templ_name != "0" ) ? $templ_name : "";

        $newurl = vebAddTrackingParamsToUrl($url[$z], $mycrmid, $utm_tags);

        $link[$z] = $newurl;
        // end of @change lro 190829

        $rep[$z] = $link[$z];
      }

      $description = str_replace_limit($url[$z], "%" . $z . "%", $description, 1);

      if (preg_match_all('!http://.+\.(?:jpe?g|png|gif)!Ui', $url[$prev], $matches)) {

        ++$z;
      }

      $new_query_string = "";
      unset($new_query_string);
      unset($new_var_string);
      unset($new_query_var);
    }

    for ($z = 0; $z < $zc; $z++) {

      $rep[$z] = str_replace("?", "&", $rep[$z]);
      $rep[$z] = str_replace_limit("&", "?", trim($rep[$z]), 1);
      $rep[$z] = str_replace_limit("?ttp", "http", trim($rep[$z]), 1);

      $description = str_replace("%" . $z . "%", $rep[$z], $description);

      $replace = "";
    }
  }

  return $description;
}

//function to replace url only once in description
function str_replace_limit($search, $replace, $string, $limit = 1) {

  if (is_bool($pos = (strpos($string, $search)))) {
    //return $string;
  }

  $search_len = strlen($search);

  for ($i = 0; $i < $limit; $i++) {

    $string = substr_replace($string, $replace, $pos, $search_len);
      if (is_bool($pos = (strpos($string, $search)))) break;
  }

  return $string;
}

//TECHNOKRAFTS --STARTS to add link to plain urls
function make_clickable($ret) {

  $ret = ' ' . $ret;
  // in testing, using arrays here was found to be faster
  $ret = preg_replace_callback('#([\s>])([\(|\w]+?://[\w\\x80-\\xff\#$%&~/.\-;:=,?@\[\]+]*)#is', '_make_url_clickable_cb', $ret);
  $ret = preg_replace_callback('#([\s>])((www|ftp)\.[\w\\x80-\\xff\#$%&~/.\-;:=,?@\[\]+]*)#is', '_make_web_ftp_clickable_cb', $ret);
  $ret = preg_replace_callback('#([\s>])([.0-9a-z_+-]+)@(([0-9a-z-]+\.)+[0-9a-z]{2,})#i', '_make_email_clickable_cb', $ret);

  // this one is not in an array because we need it to run last, for cleanup of accidental links within links
  $ret = preg_replace("#(<a( [^>]+?>|>))<a [^>]+?>([^>]+?)</a></a>#i", "$1$3</a>", $ret);
  $ret = trim($ret);
  return $ret;
}

//TECHNOKRAFTS --STARTS to add link to plain urls
function _make_url_clickable_cb($matches) {

  $ret = '';
  $url = $matches[2];

  if (empty($url)) return $matches[0];

  // removed trailing [.,;:] from URL
  if (in_array(substr($url, -1), array('.', ',', ';', ':')) === true) {

    $ret = substr($url, -1);
    $url = substr($url, 0, strlen($url) - 1);
  }

  $tksurl = str_replace('(', '', $url);
  return $matches[1] . "<a href=\"$tksurl\" rel=\"nofollow\">" . str_replace("http://", "", $url) . "</a>" . $ret;
}

function _make_web_ftp_clickable_cb($matches) {

  $ret = '';
  $dest = $matches[2];
  $dest = 'http://' . $dest;

  if (empty($dest)) return $matches[0];

  // removed trailing [,;:] from URL
  if (in_array(substr($dest, -1), array('.', ',', ';', ':')) === true) {

    $ret = substr($dest, -1);
    $dest = substr($dest, 0, strlen($dest) - 1);
  }

  return $matches[1] . "<a href=\"$dest\" rel=\"nofollow\">" . str_replace("http://", "", $dest) . "</a>" . $ret;
}

function _make_email_clickable_cb($matches) {

  $email = $matches[2] . '@' . $matches[3];
  return $matches[1] . "<a href=\"mailto:$email\">$email</a>";
}
