<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

// @change lro 170114
// ?cid=$vebrecordid&utm_source=crm&utm_medium=email&utm_term=$tid&utm_content=$linktype&utm_campaign=$templ_name";
// $mailer->Signature = vebAddSignature($currentUserModel->get('user_name'), $vebrecordid, $tid, $templ_name);
function vebAddSignature($fromname = "sales@vicus.nl", $sendtocrmid = 0, $tid = 0, $templ_name = "")
{
  global $adb;
  $adb->println("Inside the function vebAddSignature");
  
  $sign = null;
  
  // @change lro 190112 cleanuo, dont show params that are empty
// $linkParams = "?cid=$sendtocrmid&utm_source=crm&utm_medium=email";
  $linkParams = "?utm_source=crm&utm_medium=email";
  $linkParams .= ($sendtocrmid > 0  && $sendtocrmid != '$leads-lead_no$') ? "&cid=$sendtocrmid" : "";
  $linkParams .= ($tid > 0) ? "&utm_term=$tid" : "";
  $linkParams .= "&utm_content=textlink";
  $linkParams .= ($templ_name != '' and $templ_name != "0" ) ? "&utm_campaign=$templ_name" : "";
  
  $sign = VTCacheUtils::getUserSignature($fromname);
  
  if($sign === null) 
  {
    $result = $adb->pquery("select first_name, last_name, title from vtiger_users where user_name=?", array($fromname));
    
//    print_r($adb); die('queried');
    
    $firstname = $adb->query_result($result,0,"first_name");
    $lastname = $adb->query_result($result,0,"last_name");
    $jobtitle = $adb->query_result($result,0,"title");

    $sign = '<p style="font-family:Roboto,arial,sans-serif;font-size:14px;font-weight:normal;color:rgb(61,61,61);background-color:rgb(255,255,255);">Met vriendelijke groet,<br /><br />'.$firstname.' ' .$lastname. '<br>'.$jobtitle.'</p>';

    // ===============================================================================    
    // Standaard reclame
    $sign .= '<p style="color:rgb(4,21,38);font-size:12px;line-height:14px;">Vicus verbetert uw marketing, verkoop en klantenservice met <a href="https://www.vicus.nl/magento'.$linkParams.'" style="color:rgb(238,130,30);text-decoration:none;">Magento webshops</a> en <a href="https://www.vicus.nl/vtiger'.$linkParams.'" style="color:rgb(238,130,30);text-decoration:none;">vtiger CRM</a> en integreert deze met backoffice systemen zoals King, Exact, Baan, Dynamics NAV/AX. Winnaar iCMG Award 2016 met WebVisitAnalyser en het achterliggende <a href="https://www.vicus.nl/modellen/journeyfunnel-model'.$linkParams.'" style="color:rgb(238,130,30);text-decoration:none;">JourneyFunnel Model</a> - kwalitatief meer en betere prospects en klanten.</p>';
    
    // ===============================================================================
    // Prestaties
//    $sign .= '<p style="color:rgb(4,21,38);font-size:12px;line-height:14px;">Winnaar iCMG Award 2016 met <a href="https://www.vicus.nl/journeyfunnel/webvisitanalyser.html'.$linkParams.'" style="color:rgb(238,130,30);text-decoration:none;">WebVisitAnalyser</a> en het achterliggende JourneyFunnel Model - kwalitatief meer en betere prospects en klanten.</p>';

    // ===============================================================================
    // Extra Teaser
    // Kent u <a href="https://www.vicus.nl/journeyfunnel/webvisitanalyser.html'.$linkParams.'" style="color:rgb(238,130,30);text-decoration:none;">WebVisitAnalyser</a> al? De meest betaalbare online marketing & sales automation voor B2B bedrijven. Volledig automatisch informatie over uw klanten en prospects, kant en klaar in uw vtiger crm-systeem, inclusief kredietscore en KvK-gegevens.
//    $sign .= '<p style="color:rgb(4,21,38);font-size:12px;line-height:14px;">Wij ondersteunen u graag met het <a href="https://www.vicus.nl/magento/e-commerce-succes-model.html'.$linkParams.'" style="color:rgb(238,130,30);text-decoration:none;">ecommerce succesmodel</a> en het <a href="https://www.vicus.nl/actueel/persberichten/persbericht/archive/2016/september/article/vicus-wint-prestigieuze-internationale-award-met-journeyfunnelc-model-en-webvisitanalyser.html'.$linkParams.'" style="color:rgb(238,130,30);text-decoration:none;">bekroonde JourneyFunnel model</a> om uw succes te ondersteunen. </p>';
// less links ivm spam <br />Twitter: <a href="https://vicus.nl/s/twvicuseb" style="color:rgb(238,130,30);text-decoration:none;">vicus_ebusiness</a>

    // ===============================================================================
    // formal / company adres
    $sign .= '<p style="color:rgb(4,21,38);font-size:12px;"><b>Vicus eBusiness Solutions B.V.</b><br>Vanadiumweg 22, 3812 PZ  Amersfoort<br>KvK: 32105890<br>Web: <a href="https://www.vicus.nl'.$linkParams.'" style="color:rgb(238,130,30);text-decoration:none;">www.vicus.nl</a><br />Tel: +31(0)334611196';

    // ===============================================================================
    // user adders (missing fields for twitter and linkedIn from vtiger user settings
    if ($firstname == 'Luuk' && $lastname == 'Roovers') {
      $sign .= '<br>LinkedIn: <a href="https://nl.linkedin.com/in/lroovers" style="color:rgb(238,130,30);text-decoration:none;">lroovers</a>';
    }
    if ($firstname == 'Helenus' && $lastname == 'de Rijke') {
      $sign .= '<br>LinkedIn: <a href="https://www.linkedin.com/in/helenusderijke" style="color:rgb(238,130,30);text-decoration:none;">helenusderijke</a>';
    }

    $sign .= '</p>';


    // ===============================================================================
    // disclaimer
    // 
    
    // ===============================================================================
    // store in cache
    VTCacheUtils::setUserSignature($fromname, $sign);
    VTCacheUtils::setUserFullName($fromname, $firstname.' '.$lastname);
  }
		
  return $sign;
}


function vebAddStyling($description, $templ_name = false)
{
  // Tags => css
  // p,h2,a,em,table,tr,th,td,ul,li
  // <>
  // ul
  $csstagStyling = array(
    '<p>' => '<p style="font-family:Roboto,arial,sans-serif;font-size:14px;font-weight:normal;color:rgb(61,61,61);background-color:rgb(255,255,255);margin: 0 0 1em 0;">',
    '<h2>' => '<h2 style="font-family:Roboto,arial,sans-serif;font-size:14px;font-weight:bold;color:rgb(78,78,108);background-color:rgb(255,255,255);margin: 1.5em 0 0.5em 0;">',
    '<a' => '<a style="font-size:14px;color:rgb(238,128,24);margin: 0 0 1em;"',
    '<em>' => '<em style="color:rgb(78,78,108);font-weight:bold;">',
    '<table>' => '<table style="width:100%;background-color:#ffffff;border:none;cellspacing:10px;border-collapse:collapse;empty-cells:show;">',
//    '<tr>' => '',
    '<th>' => '<th style="text-align:center;background-color:rgb(78,78,108);font-family:Roboto,arial,sans-serif;font-size:14px;font-weight:normal;color:rgb(255,255,255);background-color:transparent;">',
    '<td>' => '<td style="text-align:left;font-family:Roboto,arial,sans-serif;font-size:14px;font-weight:normal;color:rgb(61,61,61);background-color:rgb(255,255,255);">',
    '<ul>' => '<ul style="list-style:circle;padding:0;font-family:Roboto,arial,sans-serif;font-size:14px;font-weight:normal;color:rgb(61,61,61);background-color:rgb(255,255,255);margin: 0 0 1em 20px;">',
    // ul.benefits
    // background: url('."'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAAXNSR0IArs4c6QAAAAZiS0dEAP8A/wD/oL2nkwAAAAlwSFlzAAABuwAAAbsBOuzj4gAAAAd0SU1FB9wFDAcZKIDkUVsAAAE2SURBVDjLpZKxSoNBEIS/iXcg4iNoYyFibWWRxkZBMI2QH2yC0QcICIKVELCykUAKxYABtVCwCERJoaQUfAALX8JCRaNr4fGT+CeEJAMHdzc7y+7syswYBSlGxFAJVNLU0AlU1hFjPKmseQAN4oGOdQgUwvMFmIsrUEWzqqhnRaroAEcBBzjecORty1opAFW1gOMRx6mqUkJc1T6O3SD+wLFmOXsAEOc44BmYCfEnwLZFf73pQntAMXCfQMYiq8cmWmQtPFk8r3jAk8dTAtCVdvAUw/8XnvV2cYeJutEicAdMBq4JpMO9BWQtY9eJ9tqnoJrSQB2YaIv5BjZs1S67mvt/jLrVElADxoEfIGfLdtZztmaWODRYocE7DTa78R2xPYl7pvuJzWywTewGF/ee3J++MDN+Abrurwftrh4rAAAAAElFTkSuQmCC'".') no-repeat 0 0;
    '<ul class="benefits">' => '<ul class="benefits" style="margin: 0 0 0.5em 0;padding:0;display:block;list-style-type:disc;">',
    // ul.login    
    '<ul class="login">' => '<ul class="login" style="margin: 0 0 0.5em 0;padding:0;display:block;list-style-type:disc;">',
    // ul.links
    '<ul class="links">' => '<ul class="links" style="margin: 0 0 0.5em 0;padding:0;display:block;list-style-type:disc;">',
    '<ol class="numbers">' => '<ul class="numbers" style="margin: 0 0 0.5em 0;padding:0;display:block;list-style-type:decimal;">',
    '<li>' => '<li style="font-family:Roboto,arial,sans-serif;font-size:14px;font-weight:normal;color:rgb(61,61,61);background-color:rgb(255,255,255);margin: 0 0 0.5em 21px;">',
    // ul.links
//    'ul.benefits li' => "margin:0;padding:0 0 0 221px;list-style-type:disc;
    // ul.links
//    'ul.login li' => 'margin:0 0 0 21px;padding:0 0 0 0;list-style-type:disc;',
    // ul.links
//    'ul.links li' => 'margin:0 0 0 21px;padding:0 0 0 0;list-style-type:square;',  
  );

  if ($templ_name)
  {
    // if we have a template we should do the stuff, else we skip it
    foreach ($csstagStyling as $tag => $style)
    {
        $description = str_ireplace($tag, $style, $description);
    }
    
  }
  
//  die('templ_name:'.$templ_name.' --- '.$description);

  return $description;

}




//TECHNOKRAFTS --STARTS to add link to plain urls
 function _make_url_clickable_cb($matches) {
	$ret = '';
	$url = $matches[2];
 
	if ( empty($url) )
		return $matches[0];
	// removed trailing [.,;:] from URL
	if ( in_array(substr($url, -1), array('.', ',', ';', ':')) === true ) {
		$ret = substr($url, -1);
		$url = substr($url, 0, strlen($url)-1);
	}
	$tksurl = str_replace('(','',$url);
	return $matches[1] . "<a href=\"$tksurl\" rel=\"nofollow\">". str_replace("http://","",$url)."</a>" . $ret;
}
 
function _make_web_ftp_clickable_cb($matches) {
	$ret = '';
	$dest = $matches[2];
	$dest = 'http://' . $dest;
 
	if ( empty($dest) )
		return $matches[0];
	// removed trailing [,;:] from URL
	if ( in_array(substr($dest, -1), array('.', ',', ';', ':')) === true ) {
		$ret = substr($dest, -1);
		$dest = substr($dest, 0, strlen($dest)-1);
	}
	return $matches[1] . "<a href=\"$dest\" rel=\"nofollow\">".str_replace("http://","",$dest)."</a>" . $ret;
}
 
function _make_email_clickable_cb($matches) {
	$email = $matches[2] . '@' . $matches[3];
	return $matches[1] . "<a href=\"mailto:$email\">$email</a>";
}
//TECHNOKRAFTS --ENDS to add link to plain urls

class Emails_Record_Model extends Vtiger_Record_Model {

	/**
	 * Function to get the Detail View url for the record
	 * @return <String> - Record Detail View Url
	 */
	public function getDetailViewUrl($parentId = false) {
		if(!$parentId) {
			list($parentId, $status) = explode('@', reset(array_filter(explode('|', $this->get('parent_id')))));
		}
		return 'Javascript:Vtiger_Index_Js.showEmailPreview("'.$this->getId().'","'.$parentId.'")';
	}

	/**
	 * Function to save an Email
	 */
	public function save() {
		//Opensource fix for MailManager data mail attachment
		if($this->get('email_flag')!='MailManager'){
			$this->set('date_start', date('Y-m-d'));
			$this->set('time_start', date('H:i'));
		}
		$this->set('activitytype', 'Emails');

		//$currentUserModel = Users_Record_Model::getCurrentUserModel();
		//$this->set('assigned_user_id', $currentUserModel->getId());
		$this->getModule()->saveRecord($this);
		$documentIds = $this->get('documentids');
		if (!empty ($documentIds)) {
			$this->deleteDocumentLink();
			$this->saveDocumentDetails();
		}
	}

	//TECHNOKRAFTS --STARTS to add link to plain urls
public function make_clickable($ret) {
	$ret = ' ' . $ret;
	// in testing, using arrays here was found to be faster
	$ret = preg_replace_callback('#([\s>])([\(|\w]+?://[\w\\x80-\\xff\#$%&~/.\-;:=,?@\[\]+]*)#is', '_make_url_clickable_cb', $ret);
	$ret = preg_replace_callback('#([\s>])((www|ftp)\.[\w\\x80-\\xff\#$%&~/.\-;:=,?@\[\]+]*)#is', '_make_web_ftp_clickable_cb', $ret);
	$ret = preg_replace_callback('#([\s>])([.0-9a-z_+-]+)@(([0-9a-z-]+\.)+[0-9a-z]{2,})#i', '_make_email_clickable_cb', $ret);
 
	// this one is not in an array because we need it to run last, for cleanup of accidental links within links
	$ret = preg_replace("#(<a( [^>]+?>|>))<a [^>]+?>([^>]+?)</a></a>#i", "$1$3</a>", $ret);
	$ret = trim($ret);
	return $ret;
}
//TECHNOKRAFTS --ENDS to add link to plain urls


	/**
	 * Function sends mail
	 */
	public function send($addToQueue = false) {
		$currentUserModel = Users_Record_Model::getCurrentUserModel();
		$rootDirectory = vglobal('root_directory');

		$mailer = Emails_Mailer_Model::getInstance();
		$mailer->IsHTML(true);

		$fromEmail = $this->getFromEmailAddress();
		$replyTo = $this->getReplyToEmail();
		$userName = $currentUserModel->getName();

		// To eliminate the empty value of an array
		$toEmailInfo = array_filter($this->get('toemailinfo'));
		$emailsInfo = array();
		foreach ($toEmailInfo as $id => $emails) {
			foreach($emails as $key => $value){
				array_push($emailsInfo, $value);
			}
		}

		$toEmailInfo = array_map("unserialize", array_unique(array_map("serialize", array_map("array_unique", $toEmailInfo))));
		$toFieldData = array_diff(explode(',', $this->get('saved_toid')), $emailsInfo);
		$toEmailsData = array();
		$i = 1;
		foreach ($toFieldData as $value) {
			$toEmailInfo['to'.$i++] = array($value);
		}
		$attachments = $this->getAttachmentDetails();
		$status = false;

		// Merge Users module merge tags based on current user.
		$mergedDescription = getMergedDescription($this->get('description'), $currentUserModel->getId(), 'Users');
		$mergedSubject = getMergedDescription($this->get('subject'),$currentUserModel->getId(), 'Users');

		//--TECHNOKRAFTS STARTS
		$tid 				=   $_REQUEST['tkstempid'];
		$templ_name 			=   $_REQUEST['tkstempname'];
		$adb 	= PearDatabase::getInstance();
		if($tid !="0")
		{
			
			$result = $adb->pquery('SELECT templatename FROM vtiger_emailtemplates WHERE templateid=?', array($tid));
			if ($adb->num_rows($result)) 
			{
				$templ_name 	= 	decode_html($adb->query_result($result, 0, 'templatename'));
			}
			else
			{
				$templ_name 	= 	"";
			}
		 	
		// @change ro 190112
		}	elseif ($templ_name = '')  {
		  // tid = "0" so thee is no template
		  $templ_name = '';
		}
		
		//--TECHNOKRAFTS ENDS

		foreach($toEmailInfo as $id => $emails) {
			$inReplyToMessageId = ''; 
			$generatedMessageId = '';
			$mailer->reinitialize();
			$mailer->ConfigSenderInfo($fromEmail, $userName, $replyTo);
			$old_mod_strings = vglobal('mod_strings');
			$description = $this->get('description');
			$subject = $this->get('subject');
			$parentModule = $this->getEntityType($id);
			if ($parentModule) {
				//TECHNOKRAFTS --STARTS to get the current record no 
  			$tksRecordModel 	= Vtiger_Record_Model::getInstanceById($id, $parentModule);
  			$tabid 				= getTabid($parentModule);
  			$sql 				= "SELECT columnname FROM vtiger_field WHERE uitype=4 and tabid=$tabid";
  			$result1 			= $adb->pquery($sql, array());
  			$columnname 		= $adb->query_result($result1, 0, "columnname");
  			$tksrecordno 		= $tksRecordModel->get($columnname);
  			//TECHNOKRAFTS --ENDS to get the current record no 
  			
  			// @change lro 170114
  			$vebrecordid     = $mycrmid;

				$currentLanguage = Vtiger_Language_Handler::getLanguage();
				$moduleLanguageStrings = Vtiger_Language_Handler::getModuleStringsFromFile($currentLanguage,$parentModule);
				vglobal('mod_strings', $moduleLanguageStrings['languageStrings']);
				$mergedDescriptionWithHyperLinkConversion = $this->replaceBrowserMergeTagWithValue($mergedDescription,$parentModule,$id); 
				if ($parentModule != 'Users') {
					//Retrieve MessageID from Mailroom table only if module is not users 
					$inReplyToMessageId = $mailer->retrieveMessageIdFromMailroom($id); 

					$generatedMessageId = $mailer->generateMessageID();
					//If there is no reference id exist in crm. 
					//Generate messageId for sending email and attach to mailer header
					if(empty($inReplyToMessageId)){
						$inReplyToMessageId = $generatedMessageId;
					}
					// Apply merge for non-Users module merge tags.
					$description = getMergedDescription($mergedDescriptionWithHyperLinkConversion, $id, $parentModule);
					$subject = getMergedDescription($mergedSubject, $id, $parentModule);
				} else {
					// Re-merge the description for user tags based on actual user.
					$description = getMergedDescription($mergedDescriptionWithHyperLinkConversion, $id, 'Users');
					$subject = getMergedDescription($mergedSubject, $id, 'Users');
					vglobal('mod_strings', $old_mod_strings);
				}
			}

			//If variable is not empty then add custom header 
			if(!empty($inReplyToMessageId)){ 
				$mailer->AddCustomHeader("In-Reply-To", $inReplyToMessageId); 
			} 

			if(!empty($generatedMessageId)){
				$mailer->MessageID = $generatedMessageId;
			}

			if (strpos($description, '$logo$')) {
				$description = str_replace('$logo$',"<img src='cid:companyLogo' />", $description);
				$logo = true;
			}

			//TECHNOKRAFTS --STARTS to add link to plain urls
				$description =  $this->make_clickable($description);
			//TECHNOKRAFTS --ENDS to add link to plain urls
			//--TECHNOKRAFTS STARTS
                    // The Regular Expression filter
			//--TECHNOKRAFTS declare array items which are valid
			$own_urlarray = array("vicus.nl","www.vicus.nl", "v-tiger.nl", "magento4king.nl" , "zencart-experts.nl", "zencart.nl", "crm2king.nl", "vosba.nl", "webshop2king.nl", "webvisitanalyser.nl");
      //--TECHNOKRAFTS declare array items which are valid

			foreach($emails as $email) {
				$mailer->Body = $description;
				if ($parentModule) {
					$mailer->Body = $this->convertUrlsToTrackUrls($mailer->Body, $id);;
					$mailer->Body .= $this->getTrackImageDetails($id, $this->isEmailTrackEnabled($parentModule));
				}
				//Checking whether user requested to add signature or not
				if($this->get('signature') == 'Yes'){
					// @change lro 170114 add footer
					$mailer->Signature = vebAddSignature($currentUserModel->get('signature'));
					if($mailer->Signature != '') {
						//$mailer->Body.= '<br><br>'.decode_html($mailer->Signature);
						$mailer->Body.= '<br>'.decode_html($mailer->Signature);
					}
				}
				$mailer->Subject = decode_html(strip_tags($subject));

				$plainBody = decode_emptyspace_html($description);
				$plainBody = preg_replace(array("/<p>/i","/<br>/i","/<br \/>/i"),array("\n","\n","\n"),$plainBody);
				$plainBody .= "\n\n".$currentUserModel->get('signature');
				$plainBody = utf8_encode(strip_tags($plainBody));
				$plainBody = Emails_Mailer_Model::convertToAscii($plainBody);
				$plainBody = $this->convertUrlsToTrackUrls($plainBody, $id,'plain');
				$mailer->AltBody = $plainBody;
				$mailer->AddAddress($email);

				//Adding attachments to mail
				if(is_array($attachments)) {
					foreach($attachments as $attachment) {
						$fileNameWithPath = $rootDirectory.$attachment['path'].$attachment['fileid']."_".$attachment['attachment'];
						if(is_file($fileNameWithPath)) {
							$mailer->AddAttachment($fileNameWithPath, $attachment['attachment']);
						}
					}
				}
				if ($logo) {
					$companyDetails = Vtiger_CompanyDetails_Model::getInstanceById();
					$companyLogoDetails = $companyDetails->getLogo();
					//While sending email template and which has '$logo$' then it should replace with company logo
					$mailer->AddEmbeddedImage($companyLogoDetails->get('imagepath'), 'companyLogo', 'attachment', 'base64', 'image/jpg');
				}

				$ccs = array_filter(explode(',',$this->get('ccmail')));
				$bccs = array_filter(explode(',',$this->get('bccmail')));

				if(!empty($ccs)) {
					foreach($ccs as $cc) $mailer->AddCC($cc);
				}
				if(!empty($bccs)) {
					foreach($bccs as $bcc) $mailer->AddBCC($bcc);
				}
			}
			// to convert external css to inline css
			$mailer->Body = Emails_Mailer_Model::convertCssToInline($mailer->Body);	
			//To convert image url to valid
			$mailer->Body = Emails_Mailer_Model::makeImageURLValid($mailer->Body);
			if ($addToQueue) {
				$status = $mailer->Send(false, $this->get('parent_id'));
			} else {
				$status = $mailer->Send(true);
			}
			if(!$status) {
				$status = $mailer->getError();
				//If mailer error, then update emailflag as saved
				if($status){
					$this->updateEmailFlag();
				}
			} else {
				//If mail sending is success store message Id for given crmId
				if($generatedMessageId && $id){
					$mailer->updateMessageIdByCrmId($generatedMessageId,$id);
				}

				$mailString=$mailer->getMailString();
				$mailBoxModel = MailManager_Mailbox_Model::activeInstance();
				$folderName = $mailBoxModel->folder();
				if(!empty($folderName) && !empty($mailString)) {
					$connector = MailManager_Connector_Connector::connectorWithModel($mailBoxModel, '');
					$message = str_replace("\n", "\r\n", $mailString);
					if (function_exists('mb_convert_encoding')) {
						$folderName = mb_convert_encoding($folderName, "UTF7-IMAP", "UTF-8");
					}
					imap_append($connector->mBox, $connector->mBoxUrl.$folderName, $message, "\\Seen");
				}
			}
		}
		return $status;
	}

	/**
	 * Returns the From Email address that will be used for the sent mails
	 * @return <String> - from email address
	 */
	function getFromEmailAddress() {
		$db = PearDatabase::getInstance();
		$currentUserModel = Users_Record_Model::getCurrentUserModel();

		$fromEmail = false;
		$result = $db->pquery('SELECT from_email_field FROM vtiger_systems WHERE server_type=?', array('email'));
		if ($db->num_rows($result)) {
			$fromEmail = decode_html($db->query_result($result, 0, 'from_email_field'));
		}
		if (empty($fromEmail)) $fromEmail = $currentUserModel->get('email1');
		return $fromEmail;
	}

	/**
	 * Function returns the attachment details for a email
	 * @return <Array> List of attachments
	 */
	function getAttachmentDetails() {
		$db = PearDatabase::getInstance();

		$attachmentRes = $db->pquery("SELECT * FROM vtiger_attachments
						INNER JOIN vtiger_seattachmentsrel ON vtiger_attachments.attachmentsid = vtiger_seattachmentsrel.attachmentsid
						WHERE vtiger_seattachmentsrel.crmid = ?", array($this->getId()));
		$numOfRows = $db->num_rows($attachmentRes);
		$attachmentsList = array();
		if($numOfRows) {
			for($i=0; $i<$numOfRows; $i++) {
				$attachmentsList[$i]['fileid'] = $db->query_result($attachmentRes, $i, 'attachmentsid');
				$attachmentsList[$i]['attachment'] = decode_html($db->query_result($attachmentRes, $i, 'name'));
				$path = $db->query_result($attachmentRes, $i, 'path');
				$attachmentsList[$i]['path'] = $path;
				$attachmentsList[$i]['size'] = filesize($path.$attachmentsList[$i]['fileid'].'_'.$attachmentsList[$i]['attachment']);
				$attachmentsList[$i]['type'] = $db->query_result($attachmentRes, $i, 'type');
				$attachmentsList[$i]['cid'] = $db->query_result($attachmentRes, $i, 'cid');
			}
		}

		$documentsList = $this->getRelatedDocuments();

		//Attachments are getting duplicated when forwarding a mail in Mail Manager.
		if($documentsList) {
			foreach ($documentsList as $document) {
				$flag = false;
				foreach ($attachmentsList as $attachment) {
					if($attachment['fileid'] == $document['fileid']) {
						$flag = true;
						break;
					}
				}
				if(!$flag) $attachmentsList[] = $document;
			}
		}

		return $attachmentsList;
	}

	/**
	 * Function returns the document details for a email
	 * @return <Array> List of Documents
	 */
	public function getRelatedDocuments() {
		$db = PearDatabase::getInstance();

		$documentRes = $db->pquery("SELECT * FROM vtiger_senotesrel
						INNER JOIN vtiger_crmentity ON vtiger_senotesrel.notesid = vtiger_crmentity.crmid AND vtiger_senotesrel.crmid = ?
						INNER JOIN vtiger_notes ON vtiger_notes.notesid = vtiger_senotesrel.notesid
						INNER JOIN vtiger_seattachmentsrel ON vtiger_seattachmentsrel.crmid = vtiger_notes.notesid
						INNER JOIN vtiger_attachments ON vtiger_attachments.attachmentsid = vtiger_seattachmentsrel.attachmentsid
						WHERE vtiger_crmentity.deleted = 0", array($this->getId()));
		$numOfRows = $db->num_rows($documentRes);

		$documentsList = array();
		if($numOfRows) {
			for($i=0; $i<$numOfRows; $i++) {
				$documentsList[$i]['name'] = $db->query_result($documentRes, $i, 'filename');
				$filesize = $db->query_result($documentRes, $i, 'filesize');
				$documentsList[$i]['size'] = $this->getFormattedFileSize($filesize);
				$documentsList[$i]['docid'] = $db->query_result($documentRes, $i, 'notesid');
				$documentsList[$i]['path'] = $db->query_result($documentRes, $i, 'path');
				$documentsList[$i]['fileid'] = $db->query_result($documentRes, $i, 'attachmentsid');
				$documentsList[$i]['attachment'] = decode_html($db->query_result($documentRes, $i, 'name'));
				$documentsList[$i]['type'] = $db->query_result($documentRes, $i, 'type');
			}
		}
		return $documentsList;
	}

	/**
	 * Function to get File size
	 * @param <Integer> $filesize
	 * @return <String> filesize
	 */
	public function getFormattedFileSize($filesize) {
		if($filesize < 1024) {
			$filesize = sprintf("%0.2f",round($filesize, 2)).'B';
		} else if($filesize > 1024 && $filesize < 1048576) {
			$filesize = sprintf("%0.2f",round($filesize/1024, 2)).'KB';
		} else if($filesize > 1048576) {
			$filesize = sprintf("%0.2f",round($filesize/(1024*1024), 2)).'MB';
		}
		return $filesize;
	}

	/**
	 * Function to save details of document and email
	 */
	public function saveDocumentDetails() {
		$db = PearDatabase::getInstance();
		$record = $this->getId();

		$documentIds = array_unique($this->get('documentids'));

		$count = count($documentIds);
		for ($i=0; $i<$count; $i++) {
			$db->pquery("INSERT INTO vtiger_senotesrel(crmid, notesid) VALUES(?, ?)", array($record, $documentIds[$i]));
		}
	}

	/**
	 * Function which will remove all the exising document links with email
	 * @param <Array> $idList - array of ids
	 */
	public function deleteDocumentLink($idList = array()){
		$db = PearDatabase::getInstance();
		$query = 'DELETE FROM vtiger_senotesrel where crmid=?';
		$params = array($this->getId());
		if(count($idList) > 0) {
			$query .= 'AND notesid IN ('.generateQuestionMarks($idList).')';
			$params = array_merge($params,$idList);
		}
		$db->pquery($query,$params);
	}

	/**
	 * Function which will delete the existing attachments for the emails
	 * @param <Array> $emailAttachmentDetails - array of value which will be having fileid key as attachement id which need to be deleted
	 */
	public function deleteAttachment($emailAttachmentDetails = array()) {
		$db = PearDatabase::getInstance();

		if(count($emailAttachmentDetails) <= 0) {
			return;
		}
		$attachmentIdList = array();
		foreach($emailAttachmentDetails as $index => $attachInfo){
			$attachmentIdList[] = $attachInfo['fileid'];
		}

		$db->pquery('UPDATE vtiger_crmentity SET deleted=0 WHERE crmid IN('.generateQuestionMarks($attachmentIdList).')',$attachmentIdList);
		$db->pquery('DELETE FROM vtiger_attachments WHERE attachmentsid IN('.generateQuestionMarks($attachmentIdList).')',$attachmentIdList);
		$db->pquery('DELETE FROM vtiger_seattachmentsrel WHERE crmid=? and attachmentsid IN('.generateQuestionMarks($attachmentIdList).')',
				array_merge(array($this->getId()),$attachmentIdList));

	}

	/**
	 * Function to check the total size of files is morethan max upload size or not
	 * @param <Array> $documentIds
	 * @return <Boolean> true/false
	 */
	public function checkUploadSize($documentIds = false) {
		$totalFileSize = 0;
		if (!empty ($_FILES)) {
			foreach ($_FILES as $fileDetails) {
				$totalFileSize = $totalFileSize + (int) $fileDetails['size'];
			}
		}
		if (!empty ($documentIds)) {
			$count = count($documentIds);
			for ($i=0; $i<$count; $i++) {
				try {
					$documentRecordModel = Vtiger_Record_Model::getInstanceById($documentIds[$i], 'Documents');
					$totalFileSize = $totalFileSize + (int) $documentRecordModel->get('filesize');
				} catch(Exception $ex) {
					continue;
				}
			}
		}
		$uploadLimit = Vtiger_Util_Helper::getMaxUploadSizeInBytes();
		if ($totalFileSize > $uploadLimit) {
			return false;
		}
		return true;
	}

	/**
	 * Function to get Track image details
	 * @param <Integer> $crmId
	 * @param <boolean> $emailTrack true/false
	 * @return <String>
	 */
	public function getTrackImageDetails($crmId, $emailTrack = true) {
		// return open tracking shorturl only if email tracking is enabled in configuration editor
		if($emailTrack){
			$emailId = $this->getId();
			$imageDetails = Vtiger_Functions::getTrackImageContent($emailId, $crmId);
			return $imageDetails;
		} else {
			return null;
		}
	}


	/**
	 * Function check email track enabled or not
	 * @return <boolean> true/false
	 */
	public function isEmailTrackEnabled() {
		$emailTracking = vglobal("email_tracking");
		if($emailTracking == 'Yes'){
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Function to update Email track(opens) details.
	 * @param <String> $parentId
	 */
	public function updateTrackDetails($parentId) {
		$db = PearDatabase::getInstance();
		$recordId = $this->getId();

		$db->pquery("INSERT INTO vtiger_email_access(crmid, mailid, accessdate, accesstime) VALUES(?, ?, ?, ?)", array($parentId, $recordId, date('Y-m-d'), date('Y-m-d H:i:s')));

		$result = $db->pquery("SELECT 1 FROM vtiger_email_track WHERE crmid = ? AND mailid = ?", array($parentId, $recordId));
		if ($db->num_rows($result)>0) {
			$db->pquery("UPDATE vtiger_email_track SET access_count = access_count+1 WHERE crmid = ? AND mailid = ?", array($parentId, $recordId));
		} else {
			$db->pquery("INSERT INTO vtiger_email_track(crmid, mailid, access_count) values(?, ?, ?)", array($parentId, $recordId, 1));
		}
	}

	/**
	 * Function to set Access count value by default as 0
	 */
	public function setAccessCountValue() {
		$record = $this->getId();
		$moduleName = $this->getModuleName();

		$focus = new $moduleName();
		$focus->setEmailAccessCountValue($record);
	}

	public function getClickCountValue($parentId){
		$db = PearDatabase::getInstance();

		$result = $db->pquery("SELECT click_count FROM vtiger_email_track WHERE crmid = ? AND mailid = ?", array($parentId, $this->getId()));
		return $db->query_result($result, 0, 'click_count');
	}

	/**
	 * Function to get Access count value
	 * @param <String> $parentId
	 * @return <String>
	 */
	public function getAccessCountValue($parentId) {
		$db = PearDatabase::getInstance();

		$result = $db->pquery("SELECT access_count FROM vtiger_email_track WHERE crmid = ? AND mailid = ?", array($parentId, $this->getId()));
		return $db->query_result($result, 0, 'access_count');
	}

	public static function getTrackingInfo($emailIds,$parentId) {
		if(!is_array($emailIds)) {
			$emailIds = array($emailIds);
		}
		$trackingInfo = array();

		if(empty($emailIds)) {
			return $trackingInfo;
		}
		$db = PearDatabase::getInstance();

		$sql = 'SELECT mailid, access_count,click_count FROM vtiger_email_track WHERE crmid = ? AND mailid IN('.generateQuestionMarks($emailIds).')';
		$result = $db->pquery($sql, array($parentId, $emailIds));
		$numRows = $db->num_rows($result);
		if($numRows > 0) {
			for($i=0;$i<$numRows;$i++){
				$row = $db->query_result_rowdata($result,$i);
				$trackingInfo[$row['mailid']] = array('access_count' => $row['access_count'],'click_count' => $row['click_count']);
			}
		}
		return $trackingInfo;
	}

	public function getEmailFlag() {
		if(!array_key_exists('email_flag', $this->getData())) {
			$db = PearDatabase::getInstance();
			$result = $db->pquery("SELECT email_flag FROM vtiger_emaildetails WHERE emailid = ?", array($this->getId()));
			if($db->num_rows($result) > 0) {
				$this->set('email_flag', $db->query_result($result, 0, 'email_flag'));
			} else {
				return false;
			}
		}
		return $this->get('email_flag');
	}

	function getEntityType($id) {
		$db = PearDatabase::getInstance();
		$moduleModel = $this->getModule();
		$emailRelatedModules = $moduleModel->getEmailRelatedModules();
		$relatedModule = '';
		if (!empty($id)) {
			$sql = "SELECT setype FROM vtiger_crmentity WHERE crmid=?";
			$result = $db->pquery($sql, array($id));
			$relatedModule = $db->query_result($result, 0, "setype");

			if(!in_array($relatedModule, $emailRelatedModules)){
				$sql = 'SELECT id FROM vtiger_users WHERE id=?';
				$result = $db->pquery($sql, array($id));
				if($db->num_rows($result) > 0){
					$relatedModule = 'Users';
				}
			}
		}
		return $relatedModule;
	}

	/**
	 * Function stores emailid,parentmodule and generates shorturl 
	 * @param type $parentModule 
	 * @return type 
	 */
	public function getTrackingShortUrl($parentModule) {
		$options = array(
			'handler_path' => 'modules/Emails/handlers/ViewInBrowser.php',
			'handler_class' => 'Emails_ViewInBrowser_Handler',
			'handler_function' => "viewInBrowser",
			'handler_data' => array(
				'emailId' => $this->getId(),
				'parentModule' => $parentModule
			)
		);
		$trackURL = Vtiger_ShortURL_Helper::generateURL($options);
		return $trackURL;
	}

	/**
	 * Function to replace browser merge tag with value 
	 * @param type $mergedDescription 
	 * @param type $parentModule 
	 * @param type $recipientId 
	 * @return type 
	 */
	public function replaceBrowserMergeTagWithValue($mergedDescription, $parentModule, $recipientId) {
		global $application_unique_key;
		if (!$this->trackURL) {
			$this->trackURL = $this->getTrackingShortUrl($parentModule);
		}
		$receiverId = $parentModule[0] . $recipientId;
		$urlParameters = http_build_query(array('rid' => $receiverId, 'applicationKey' => $application_unique_key));
		$rlock = $this->generateSecureKey($urlParameters);
		$URL = $this->trackURL . "&$urlParameters" . "&rv=$rlock";
		return str_replace(EmailTemplates_Module_Model::$BROWSER_MERGE_TAG, $URL, $mergedDescription);
	}

	public function generateSecureKey($urlParameters) {
		return md5($urlParameters);
	}

	/**
	 * Functiont to track clicks
	 * @param <int> $parentId
	 */
	public function trackClicks($parentId) {
		$db = PearDatabase::getInstance();
		$recordId = $this->getId();

		$db->pquery("INSERT INTO vtiger_email_access(crmid, mailid, accessdate, accesstime) VALUES(?, ?, ?, ?)", array($parentId, $recordId, date('Y-m-d'), date('Y-m-d H:i:s')));

		$result = $db->pquery("SELECT 1 FROM vtiger_email_track WHERE crmid = ? AND mailid = ?", array($parentId, $recordId));
		if ($db->num_rows($result) > 0) {
			$db->pquery("UPDATE vtiger_email_track SET click_count = click_count+1 WHERE crmid = ? AND mailid = ?", array($parentId, $recordId));
		} else {
			$db->pquery("INSERT INTO vtiger_email_track(crmid, mailid, click_count) values(?, ?, ?)", array($parentId, $recordId, 1));
		}
	}

	/**
	 * Function to get Sender Name for the email
	 * @return <String> Sender Name or Email
	 */
	public function getSenderName($relatedModule = false, $relatedRecordId = false) {
			$db = PearDatabase::getInstance();
			$result = $db->pquery("SELECT from_email,idlists FROM vtiger_emaildetails WHERE emailid = ?", array($this->getId()));
		if ($db->num_rows($result) > 0) {
				$fromEmail = $db->query_result($result, 0, 'from_email');
				$supportEmail = vglobal('HELPDESK_SUPPORT_EMAIL_ID');
				$supportName = vglobal('HELPDESK_SUPPORT_NAME');
				if ($fromEmail == $supportEmail && !empty($supportName)) {
					return $supportName;
				}
				$moduleModel = $this->getModule();
				$emails = $moduleModel->searchEmails($fromEmail);
				if ($emails) {
					if ($emails[$relatedModule][$relatedRecordId]) {
						return $emails[$relatedModule][$relatedRecordId][0]['name'];
					}

					if ($emails['Users']) {
						$emailInfo = array_values($emails['Users']);
					} else {
						$emailsInfo = array_values($emails);
						$emailInfo = array_values($emailsInfo[0]);
					}
					return $emailInfo[0][0]['name'];
				}
				return $fromEmail;
			} else {
				return false;
			}
	}

	public function convertUrlsToTrackUrls($content, $crmid, $type = 'html') {
		if ($this->isEmailTrackEnabled()) {
			$extractedUrls = Vtiger_Functions::getUrlsFromHtml($content);

			foreach ($extractedUrls as $sourceUrl => $value) {
				$trackingUrl = $this->getTrackUrlForClicks($crmid, $sourceUrl);
				$content = $this->replaceLinkWithShortUrl($content, $trackingUrl, $sourceUrl, $type);
			}
		}
		return $content;
	}

	public function replaceLinkWithShortUrl($content, $toReplace, $search, $type) {
		if ($type == 'html') {
			$search = '"' . $search . '"';
			$toReplace = '"' . $toReplace . '"';
		}
		$pos = strpos($content, $search);

		if ($pos != false) {
			$replacedContent = substr_replace($content, $toReplace, $pos) . substr($content, $pos + strlen($search));
			return $replacedContent;
		}

		return $content;
	}

	public function getTrackUrlForClicks($parentId, $redirectUrl = false) {
		$siteURL = vglobal('site_URL');
		$applicationKey = vglobal('application_unique_key');
		$recordId = $this->getId();
		$trackURL = "$siteURL/modules/Emails/actions/TrackAccess.php?record=$recordId&parentId=$parentId&applicationKey=$applicationKey&method=click";
		if ($redirectUrl) {
			$encodedRedirUrl = rawurlencode($redirectUrl);
			$trackURL .= "&redirectUrl=$encodedRedirUrl";
		}
		return $trackURL;
	}

	/**
	 * Function to save email lookup value for searching
	 * @param type $fieldName
	 * @param type $values
	 */
	function recieveEmailLookup($fieldId, $values) {
		$db = PearDatabase::getInstance();
		$params = array($values['crmid'], $values['setype'], $values[$fieldId], $fieldId);

		$db->pquery('INSERT INTO vtiger_emailslookup
					(crmid, setype, value, fieldid) 
					VALUES(?,?,?,?) 
					ON DUPLICATE KEY 
					UPDATE value=VALUES(value)', $params);
	}

	 /**
	 * Function to delete email lookup value for searching
	 * @param type $crmid
	 * @param type $fieldid
	 */
	function deleteEmailLookup($crmid, $fieldid = false) {
		$db = PearDatabase::getInstance();
		if ($fieldid) {
			$params = array($crmid, $fieldid);
			$db->pquery('DELETE FROM vtiger_emailslookup WHERE crmid=? AND fieldid=?', $params);
		} else {
			$params = array($crmid);
			$db->pquery('DELETE FROM vtiger_emailslookup WHERE crmid=?', $params);
		}
	}

	 /**
	 * Function to update Email flag if SMTP fails
	 */
	public function updateEmailFlag() {
		$db = PearDatabase::getInstance();
		$query = 'UPDATE vtiger_emaildetails SET email_flag="SAVED" WHERE emailid=?';
		$db->pquery($query, array($this->get('id')));
	}

	function replaceMergeTags($id) {
		$currentUserModel = Users_Record_Model::getCurrentUserModel();
		$entityType = $this->getEntityType($id);

		$description = getMergedDescription($this->get('description'), $currentUserModel->getId(), 'Users');
		$subject = getMergedDescription($this->get('subject'), $currentUserModel->getId(), 'Users');

		$description = getMergedDescription($description, $id, $entityType);
		$subject = getMergedDescription($subject, $id, $entityType);

		if (strpos($description, '$logo$')) {
			$description = str_replace('$logo$', "<img src='cid:logo' />", $description);
		}

		$this->set('description', $description);
		$this->set('subject', strip_tags($subject));
	}

	function getReplyToEmail() {
		$db = PearDatabase::getInstance();
		$defaultReplyTo = vglobal('default_reply_to');
		$currentUserModel = Users_Record_Model::getCurrentUserModel();
		$replyTo = $currentUserModel->get('email1');

		if ($defaultReplyTo == 'outgoing_server_from_email') {
			$result = $db->pquery('SELECT from_email_field FROM vtiger_systems WHERE server_type=?', array('email'));
			if ($db->num_rows($result)) {
				$fromEmail = decode_html($db->query_result($result, 0, 'from_email_field'));
			}
			if (!empty($fromEmail)) {
				$replyTo = $fromEmail;
			}
		} else if ($defaultReplyTo == 'hepldesk_support_email') {
			$helpDeskEmail = vglobal('HELPDESK_SUPPORT_EMAIL_ID');
			if (!empty($helpDeskEmail)) {
				$replyTo = $helpDeskEmail;
			}
		}

		return $replyTo;
	}
}
