<?php
/**
 * Replace standard tags in emails/templates by inline styles
 * @change see T33129
 * @author L.Roovers
 * @copyright Vicus eBusiness Solutions B.V.
 */
function vebAddStyling($description, $templ_name = false)
{
    // Tags => css
    // p,h2,a,em,table,tr,th,td,ul,li
    // <>
    // ul
    $csstagStyling = array(
        '<p>' => '<p style="font-family:Roboto,arial,sans-serif;font-size:14px;font-weight:normal;color:rgb(61,61,61);background-color:rgb(255,255,255);margin: 0 0 1em 0;">',
        '<h2>' => '<h2 style="font-family:Roboto,arial,sans-serif;font-size:16px;font-weight:bold;color:rgb(78,78,108);background-color:rgb(255,255,255);margin: 1.5em 0 0.5em 0;">',
        '<a' => '<a style="font-size:14px;color:rgb(238,128,24);margin: 0 0 1em;"',
        '<em>' => '<em style="color:rgb(78,78,108);font-weight:bold;">',
        '<table>' => '<table style="width:100%;background-color:#ffffff;border:none;cellspacing:10px;border-collapse:collapse;empty-cells:show;">',
//    '<tr>' => '',
        '<th>' => '<th style="text-align:center;background-color:rgb(78,78,108);font-family:Roboto,arial,sans-serif;font-size:14px;font-weight:normal;color:rgb(255,255,255);background-color:transparent;">',
        '<td>' => '<td style="text-align:left;font-family:Roboto,arial,sans-serif;font-size:14px;font-weight:normal;color:rgb(61,61,61);background-color:rgb(255,255,255);">',
        '<ul>' => '<ul style="list-style:circle;padding:0;font-family:Roboto,arial,sans-serif;font-size:14px;font-weight:normal;color:rgb(61,61,61);background-color:rgb(255,255,255);margin: 0 0 1em 20px;">',
        // ul.benefits
        // background: url('."'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAAXNSR0IArs4c6QAAAAZiS0dEAP8A/wD/oL2nkwAAAAlwSFlzAAABuwAAAbsBOuzj4gAAAAd0SU1FB9wFDAcZKIDkUVsAAAE2SURBVDjLpZKxSoNBEIS/iXcg4iNoYyFibWWRxkZBMI2QH2yC0QcICIKVELCykUAKxYABtVCwCERJoaQUfAALX8JCRaNr4fGT+CeEJAMHdzc7y+7syswYBSlGxFAJVNLU0AlU1hFjPKmseQAN4oGOdQgUwvMFmIsrUEWzqqhnRaroAEcBBzjecORty1opAFW1gOMRx6mqUkJc1T6O3SD+wLFmOXsAEOc44BmYCfEnwLZFf73pQntAMXCfQMYiq8cmWmQtPFk8r3jAk8dTAtCVdvAUw/8XnvV2cYeJutEicAdMBq4JpMO9BWQtY9eJ9tqnoJrSQB2YaIv5BjZs1S67mvt/jLrVElADxoEfIGfLdtZztmaWODRYocE7DTa78R2xPYl7pvuJzWywTewGF/ee3J++MDN+Abrurwftrh4rAAAAAElFTkSuQmCC'".') no-repeat 0 0;
        '<ul class="benefits">' => '<ul class="benefits" style="margin: 0 0 0.5em 0;padding:0;display:block;list-style-type:disc;">',
        // ul.login    
        '<ul class="login">' => '<ul class="login" style="margin: 0 0 0.5em 0;padding:0;display:block;list-style-type:disc;">',
        // ul.links
        '<ul class="links">' => '<ul class="links" style="margin: 0 0 0.5em 0;padding:0;display:block;list-style-type:disc;">',
        '<ol class="numbers">' => '<ul class="numbers" style="margin: 0 0 0.5em 0;padding:0;display:block;list-style-type:decimal;">',
        '<li>' => '<li style="font-family:Roboto,arial,sans-serif;font-size:14px;font-weight:normal;color:rgb(61,61,61);background-color:rgb(255,255,255);margin: 0 0 0.5em 21px;">',
            // ul.links
//    'ul.benefits li' => "margin:0;padding:0 0 0 221px;list-style-type:disc;
            // ul.links
//    'ul.login li' => 'margin:0 0 0 21px;padding:0 0 0 0;list-style-type:disc;',
            // ul.links
//    'ul.links li' => 'margin:0 0 0 21px;padding:0 0 0 0;list-style-type:square;',  
    );

// @change lro - 200423 do it always
//    if ($templ_name)
//    {
        // if we have a template we should do the stuff, else we skip it
        foreach ($csstagStyling as $tag => $style)
        {
            $description = str_ireplace($tag, $style, $description);
        }
//    }

//  die('templ_name:'.$templ_name.' --- '.$description);

    return $description;
}