<?php

class EmailCampaigns_RelatedRecordsAjax_View extends Vtiger_Basic_View
{

    private $listModules = array();
    private $selectedModule = false;
    protected $listViewEntries = false;
    protected $listViewCount = false;
    protected $listViewLinks = false;
    protected $listViewHeaders = false;
    protected $noOfEntries = false;
    protected $pagingModel = false;
    protected $listViewModel = false;
    /**
     * EmailCampaigns_RelatedRecordsAjax_View constructor.
     */
    public function __construct()
    {
        parent::__construct();
        $this->exposeMethod('LoadRelatedRecordList');
        $this->exposeMethod('LoadRelatedRecordListAjax');
    }

    /**
     * A dummy function to overwrite the parent function
     */
    public function checkPermission()
    {
    }

    /**
     * @param Vtiger_Request $request
     */
    public function process(Vtiger_Request $request)
    {
        $mode = $request->get('mode');
        if (!empty($mode)) {
            $this->invokeExposedMethod($mode, $request);
        }
        return;
    }

    /**
     * @param Vtiger_Request $request
     */
    public function GetPageCount(\Vtiger_Request $request){
        $listViewCount = $this->getListViewCount($request);
        $pagingModel = new Vtiger_Paging_Model();
        $pageLimit = $pagingModel->getPageLimit();
        $pageCount = ceil((int) $listViewCount / (int) $pageLimit);

        if($pageCount == 0){
            $pageCount = 1;
        }
        $result = array();
        $result['page'] = $pageCount;
        $result['numberOfRecords'] = $listViewCount;
        $response = new Vtiger_Response();
        $response->setResult($result);
        $response->emit();
    }

    /**
     * Function to get listView count
     * @param Vtiger_Request $request
     */
    function getListViewCount(Vtiger_Request $request){
        $moduleName = $request->getModule();
        $listId = $request->get('relId');
        $list = new \EmailCampaigns\Lists($listId);

        $searchParams = $request->get('search_params');
        if(empty($searchParams) && !is_array($searchParams)){
            $searchParams = array();
        }
        $list->set('search_params',$this->transferListSearchParamsToFilterCondition($searchParams, $listViewModel->getModule()));
        $list->set('operator', $request->get('operator'));

        $count = $list->GetListViewCount();

        return $count;
    }

    /**
     * @param Vtiger_Request $request
     */
    public function LoadRelatedRecordListAjax(\Vtiger_Request $request){
        $viewer = $this->getViewer($request);
        $moduleName = $request->getModule();
        $moduleModel = \Vtiger_Module_Model::getInstance($moduleName);

        $this->initializeListViewContents($request, $viewer);
        $viewer->assign('VIEW', $request->get('view'));
        $viewer->assign('MODE', $request->get('mode'));
        $viewer->assign('MODULE_MODEL', $moduleModel);
        $viewer->assign('SELECTED_MODULE_MODEL', \Vtiger_Module_Model::getInstance($this->selectedModule));
        $viewer->assign('CURRENT_USER_MODEL', \Users_Record_Model::getCurrentUserModel());
        $viewer->view('RelListViewContents.tpl', $moduleName);
    }
    /**
     * @param Vtiger_Request $request
     */
    public function LoadRelatedRecordList(Vtiger_Request $request)
    {
        $viewer = $this->getViewer($request);
        $moduleName = $request->getModule();
        $moduleModel = \Vtiger_Module_Model::getInstance($moduleName);

        $this->initializeListViewContents($request, $viewer);
        $viewer->assign('VIEW', $request->get('view'));
        $viewer->assign('MODE', $request->get('mode'));
        $viewer->assign('MODULE_MODEL', $moduleModel);
        $viewer->assign('SELECTED_MODULE_MODEL', \Vtiger_Module_Model::getInstance($this->selectedModule));
        $viewer->assign('CURRENT_USER_MODEL', \Users_Record_Model::getCurrentUserModel());
        $viewer->view('RelListViewFullContents.tpl', $moduleName);
    }

    private function initializeListViewContents($request, $viewer)
    {
        $listId = $request->get('relId');
        $moduleName = $request->getModule();
        $pageNumber = $request->get('page');
        $orderBy = $request->get('orderby');
        $sortOrder = $request->get('sortorder');
        $searchParams = $request->get('search_params');
        $list = new \EmailCampaigns\Lists($listId);
        $this->listModules = $list->GetListModules();
        $this->selectedModule = $request->get('relModule', false);
        if(!$this->selectedModule){
            $this->selectedModule = $this->listModules[0];
        }else{
            $list->SetSelectedModule($this->selectedModule);
        }
        $selectedModuleModel = \Vtiger_Module_Model::getInstance($this->selectedModule);
        $list->SetSelectedModule($this->selectedModule);
        if ($request->get('mode') == 'removeSorting') {
            $orderBy = '';
            $sortOrder = '';
        }

        if ($sortOrder == "ASC") {
            $nextSortOrder = "DESC";
            $sortImage = "icon-chevron-down";
            $faSortImage = "fa-sort-desc";
        } else {
            $nextSortOrder = "ASC";
            $sortImage = "icon-chevron-up";
            $faSortImage = "fa-sort-asc";
        }
        if (empty ($pageNumber)) {
            $pageNumber = '1';
        }
        $currentUser = \Users_Record_Model::getCurrentUserModel();

        // preProcess is already loading this, we can reuse
        if(!$this->pagingModel){
            $pagingModel = new \Vtiger_Paging_Model();
            $pagingModel->set('page', $pageNumber);
        } else{
            $pagingModel = $this->pagingModel;
        }

        if (!empty($orderBy)) {
            $list->set('orderby', $orderBy);
            $list->set('sortorder', $sortOrder);
        }

        if (empty($searchParams)) {
            $searchParams = array();
        }
        if (count($searchParams) == 2 && empty($searchParams[1])) {
            unset($searchParams[1]);
        }
        $transformedSearchParams = $this->transferListSearchParamsToFilterCondition($searchParams, $selectedModuleModel);
        $list->set('search_params',$transformedSearchParams);

        //To make smarty to get the details easily accesible
        foreach ($searchParams as $fieldListGroup) {
            foreach ($fieldListGroup as $fieldSearchInfo) {
                $fieldSearchInfo['searchValue'] = $fieldSearchInfo[2];
                $fieldSearchInfo['fieldName'] = $fieldName = $fieldSearchInfo[0];
                $fieldSearchInfo['comparator'] = $fieldSearchInfo[1];
                $searchParams[$fieldName] = $fieldSearchInfo;
            }
        }
        if(!$this->listViewHeaders){
            $this->listViewHeaders = $list->GetListViewHeaders();
        }

        if(!$this->listViewEntries){
            $this->listViewEntries = $list->GetListViewEntries($pagingModel);
        }
        //if list view entries restricted to show, paging should not fail
        if(!$this->noOfEntries) {
            $this->noOfEntries = $pagingModel->get('_listcount');
        }
        if(!$this->noOfEntries) {
            $noOfEntries = count($this->listViewEntries);
        } else {
            $noOfEntries = $this->noOfEntries;
        }

        $viewer->assign('MODULE', $moduleName);
        $viewer->assign('SELECTED_MODULE', $this->selectedModule);
        $viewer->assign('PAGING_MODEL', $pagingModel);
        if (!$this->pagingModel) {
            $this->pagingModel = $pagingModel;
        }
        $viewer->assign('PAGE_NUMBER', $pageNumber);

        if (!$this->moduleFieldStructure) {
            $recordStructure = \Vtiger_RecordStructure_Model::getInstanceForModule($selectedModuleModel,
                \Vtiger_RecordStructure_Model::RECORD_STRUCTURE_MODE_FILTER);
            $this->moduleFieldStructure = $recordStructure->getStructure();
        }

        $viewer->assign('ORDER_BY', $orderBy);
        $viewer->assign('SORT_ORDER', $sortOrder);
        $viewer->assign('NEXT_SORT_ORDER', $nextSortOrder);
        $viewer->assign('SORT_IMAGE', $sortImage);
        $viewer->assign('FASORT_IMAGE', $faSortImage);
        $viewer->assign('COLUMN_NAME', $orderBy);

        $viewer->assign('LISTVIEW_ENTRIES_COUNT', $noOfEntries);
        $viewer->assign('LISTVIEW_HEADERS', $this->listViewHeaders);
        $viewer->assign('LIST_HEADER_FIELDS', json_encode(array_keys($this->listViewHeaders)));
        $viewer->assign('LISTVIEW_ENTRIES', $this->listViewEntries);
        $viewer->assign('MODULE_FIELD_STRUCTURE', $this->moduleFieldStructure);
        $appName = $request->get('app');
            if (!$this->listViewCount) {
                $this->listViewCount = $list->getListViewCount();
            }
            $totalCount = $this->listViewCount;
            $pageLimit = $pagingModel->getPageLimit();
            $pageCount = ceil((int)$totalCount / (int)$pageLimit);

            if ($pageCount == 0) {
                $pageCount = 1;
            }
            $viewer->assign('PAGE_COUNT', $pageCount);
            $viewer->assign('LISTVIEW_COUNT', $totalCount);
        $viewer->assign('LIST_VIEW_MODEL', $this->listViewModel);
        $viewer->assign('SEARCH_DETAILS', $searchParams);
        $viewer->assign('NO_SEARCH_PARAMS_CACHE', $request->get('nolistcache'));
        $viewer->assign('LISTID', $listId);
        $viewer->assign('LIST_MODULES', $this->listModules);
        $viewer->assign('TITLE', $list->GetListDetails()->name);
    }

    /**
     * @param $listSearchParams
     * @param $moduleModel
     * @return mixed
     */
    public function transferListSearchParamsToFilterCondition($listSearchParams, $moduleModel) {
        return Vtiger_Util_Helper::transferListSearchParamsToFilterCondition($listSearchParams, $moduleModel);
    }
}