<?php
global $root_directory;
require_once($root_directory."/modules/EmailCampaigns/autoload_wf.php");
class EmailCampaigns_MassActionAjax_View extends Vtiger_Index_View {

	 function __construct()
    {
        parent::__construct();
        $this->exposeMethod('showListview');
        $this->exposeMethod('showMassEditForm');
        $this->exposeMethod('updateSequence');
    }

    function checkPermission(Vtiger_Request $request) {
        return true;
    }

    public function process(Vtiger_Request $request) {

    	$mode = $request->get('mode');
        if (!empty($mode)) {
            $this->invokeExposedMethod($mode, $request);
            return;
        }

    }

    public function showListview(Vtiger_Request $request){
        global $adb,$current_user;
    	
        $viewer = $this->getViewer($request);
        $res = $adb->pquery("SELECT * FROM vtiger_emailcampaigns_smtpsettings ORDER BY sequence ASC",array());
        $servers = array();
        $c=0;
        while($resultrow = $adb->fetch_array($res)) {
                $servers[$c]['username']=$resultrow['email'];
                $servers[$c]['server']=$resultrow['servername'];
                $servers[$c]['from_email_field']=$resultrow['fromemail'];
                $servers[$c]['from_name_field']=$resultrow['fromname'];
                $servers[$c]['replyto_email_field']=$resultrow['replytoemail'];
                $servers[$c]['returnpath']=$resultrow['returnpath'];
                $servers[$c]['smtp_auth']=$resultrow['auth'];
                $servers[$c]['id']=$resultrow['id'];
                $c+=1;  
        }
        $moduleName = $request->getModule();
        $viewer->assign('SERVERS_LIST', $servers);
        return $viewer->view('ListView.tpl', $moduleName);
    }

    public function showMassEditForm(Vtiger_Request $request){
        global $adb,$current_user;
        $moduleName = $request->getModule();
        $viewer = $this->getViewer ($request);

        $res = $adb->pquery("SELECT * FROM vtiger_emailcampaigns_smtpsettings WHERE id=? LIMIT 1",array($request->get('id')));
        $serverinfo = array();
        while($resultrow = $adb->fetch_array($res)) {
                $serverinfo['server_username']=$resultrow['email'];
                $serverinfo['server']=$resultrow['servername'];
                $serverinfo['from_email_field']=$resultrow['fromemail'];
                $serverinfo['from_name_field']=$resultrow['fromname'];
                $serverinfo['replyto_email_field']=$resultrow['replytoemail'];
                $serverinfo['returnpath']=$resultrow['returnpath'];
                $serverinfo['smtp_auth']=$resultrow['auth'];
                $serverinfo['id']=$resultrow['id'];
                $serverinfo['server_password']=$resultrow['password'];
        }
        $viewer->assign('SERVER_INFO', $serverinfo);
        return $viewer->view('MassEditForm.tpl', $moduleName);

    }

    public function updateSequence(Vtiger_Request $request){
        global $adb,$current_user;
        
        $viewer = $this->getViewer($request);

        $data = $request->get('params')['data'];
        //print_r($data);
        foreach ($data as $id => $seq) {
            $res = $adb->pquery("UPDATE vtiger_emailcampaigns_smtpsettings SET sequence=? WHERE id= ?",array($seq['index'],$id));
        }
        $response = new Vtiger_Response();
        $response->setEmitType(Vtiger_Response::$EMIT_JSON);
        $response->setResult(array('message'=>'Saved'));
        $response->emit();
        return;
    }


}