<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/
global $root_directory;

require_once($root_directory."/modules/EmailCampaigns/autoload_wf.php");
require_once($root_directory."/modules/SubscribersList/autoload_wf.php");

class EmailCampaigns_ListRecordAjax_View extends Vtiger_Basic_View {

  public function __construct() {

    parent::__construct();

    $this->exposeMethod('getListofUniqueOpen');
    $this->exposeMethod('getSubscriberList');
    $this->exposeMethod('getUniqueLinkClick');
    $this->exposeMethod('getRecordsCountCampaign');
    $this->exposeMethod('getsingleUniqueLinkClick');
    $this->exposeMethod('getRelatedRecords');
    $this->exposeMethod('getListofSentEmails');
    $this->exposeMethod('GetListsDetails');
    $this->exposeMethod('LoadListDataByType');
  }

  function checkPermission() { }

  public function process(Vtiger_Request $request) {

    $mode = $request->get('mode');

    if (!empty($mode)) {

      $this->invokeExposedMethod($mode, $request);
    }

    return;
  }

  /**
   * @param Vtiger_Request $request
   */
  public function LoadListDataByType(Vtiger_Request $request) {

    $recordId = $request->get('record');
    $moduleName = $request->getModule();
    $listId = $request->get('list_id');
    $listInfo = EmailCampaigns\Reports::GetListInfoById($recordId, $listId);
    $viewer = $this->getViewer($request);
    $viewer->assign('MODULE_NAME', $moduleName);
    if ($listInfo->type == 'fromlist') {
      try{
        $preset = new \SubscribersList\ComplexeCondition('condition', array(
                    'fromModule' => '',
                    'toModule' => $listInfo->complexCondition['module'],
                    'enableHasChanged' => false,
                    'container' => 'content_'.$listInfo->id,
                    'enableTemplateFields' => false,
                    'references' => false,
                    'variables' => false,
                    'disableTemplateFields' => true,
                    'disableConditionMode' => true
                ));
      }
      catch (Exception $e) {

        echo $e->getMessage();exit;
      }

      $preset->InitViewer(array(
                    array(
                        'condition' => $listInfo->complexCondition['condition']
                    ),
                    $viewer
                )
            );

      $viewer->assign('ConditionScopeModule', $moduleName);
      $viewer->assign('toModule', $listInfo->complexCondition['module']);
      $viewer->assign('title', "title");
      echo $viewer->view('AdvanceFilter.tpl', $moduleName, true);exit;
    }
    else if ($listInfo->type == 'fromEmailcampaign') {

      $viewer->assign('DATA', $listInfo->data);
      $viewer->assign('TYPE', $listInfo->type);
      echo $viewer->view('ReportListsByType.tpl', $moduleName, true);exit;
    }
  }

  /**
   * @param Vtiger_Request $request
   * @return HTML content
   */
  public function GetListsDetails(Vtiger_Request $request) {
    $lists = EmailCampaigns\Reports::GetAllLists($request->get('record'));
    $moduleName = $request->getModule();
    $viewer = $this->getViewer($request);
    $viewer->assign('LISTS', $lists);
    $viewer->assign('MODULE_NAME', $moduleName);
    return $viewer->view('ReportLists.tpl',$moduleName);
  }

  public function getListofSentEmails(Vtiger_Request $request) {

    global $current_user;

    $viewer = $this->getViewer($request);
    $db = PearDatabase::getInstance();
    $module = $request->getModule();
    $actionbtn = array();

    $recordId = $request->get('record');
    $moduleName = $request->getModule();
    $page = $request->get('page_no');
    $filter = $request->get('filter','all');

    $related_modulename = $request->get("relmodule","Contacts");
    $this->initializeListViewContents($request, $viewer,$related_modulename);

    if ($related_modulename == 'Leads') {

      $jointable = ' INNER JOIN vtiger_leaddetails ON vtiger_leaddetails.leadid = vtiger_emailcamp_sendemail.related_id '
                   . 'INNER JOIN Vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_leaddetails.leadid';
    }
    else if ($related_modulename == 'Contacts') {

      $jointable = ' INNER JOIN vtiger_contactdetails ON vtiger_contactdetails.contactid = vtiger_emailcamp_sendemail.related_id '
                   . 'INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_contactdetails.contactid';
    }
    else if ($related_modulename == 'Accounts') {

      $jointable = ' INNER JOIN vtiger_account ON vtiger_account.accountid = vtiger_emailcamp_sendemail.related_id '
                   . 'INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_account.accountid';
    }

    $query_total_count = "SELECT * FROM vtiger_emailcamp_sendemail $jointable ";

    if ($current_user->is_admin != "on") {

      $crmentity = new CRMEntity();
      $query_total_count .= $crmentity->getNonAdminAccessControlQuery($related_modulename, $current_user);
    }

    if ($filter == 'all') {

      $query_total_count .= " WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ? GROUP BY vtiger_emailcamp_sendemail.related_id";
    }
    elseif ($filter == 'sent') {

      $query_total_count .= " WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
                             AND vtiger_emailcamp_sendemail.issent=1
                             GROUP BY vtiger_emailcamp_sendemail.related_id";
    }
    elseif ($filter == 'notsent') {

      $query_total_count .= " WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
                             AND vtiger_emailcamp_sendemail.issent=0
                             GROUP BY Vtiger_emailcamp_sendemail.related_id";
    }
    elseif ($filter == 'error') {

      $query_total_count .= " WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
                             AND vtiger_emailcamp_sendemail.issent=-1
                             GROUP BY vtiger_emailcamp_sendemail.related_id";
    }

    $result_total_count = $db->pquery($query_total_count, array($recordId));
    $total_count = $db->num_rows($result_total_count);

    $configdetailmodel = Settings_Vtiger_ConfigModule_Model::getInstance();
    $record = $configdetailmodel->getViewableData();
    $noofdata = $record['list_max_entries_per_page'];

    if ($noofdata <= 0) $noofdata = 10;

    $max_page_limit = $page * $noofdata;
    $min_page_limit = $max_page_limit - $noofdata;

    $qry_limit = " LIMIT 0,$noofdata";

    if ($page > 1) $qry_limit = " LIMIT $min_page_limit,$noofdata";

    $max_page = ceil($total_count/$noofdata);
    $query = $query_total_count.$qry_limit;

    $result_links = $db->pquery($query, array($recordId));

    $uniq_open = $db->num_rows($result_links);
    $previous_page = $page - 1;
    $next_page = $page + 1;

    if ($max_page==0 ) {

      $page=0;
      $max_page=0;
      $disablenxt = 'disabled';
      $disablepre = 'disabled';
    }

    $totalpage = 'Page '.$page.' of '.$max_page;

    if ($page == 1) $disablepre = 'disabled';
    if ($page == $max_page) $disablenxt = 'disabled';

    for($i=0;$i<$uniq_open;$i++) {

      if ($related_modulename == 'Leads' || $related_modulename == 'Contacts') {

        $firstname = $db->query_result($result_links,$i,'firstname');
        $lastname = $db->query_result($result_links,$i,'lastname');
        $name = $firstname.' '.$lastname;
        $email = $db->query_result($result_links,$i,'email');
        $status = $db->query_result($result_links,$i,'issent');

        if ($related_modulename == 'Contacts') {

          $id = $db->query_result($result_links,$i,'contactid');
          $link = "index.php?module=Contacts&view=Detail&record";
          $type = 'Contacts';
        }
        else if ($related_modulename == 'Leads') {

          $id = $db->query_result($result_links,$i,'leadid');
          $link = "index.php?module=Leads&view=Detail&record";
          $type = 'Leads';
        }
      }
      else if ($related_modulename == 'Accounts') {

        $name = $db->query_result($result_links,$i,'accountname');
        $email = $db->query_result($result_links,$i,'email1');
        $id = $db->query_result($result_links,$i,'accountid');
        $link = "index.php?module=Accounts&view=Detail&record";
        $status = $db->query_result($result_links,$i,'issent');
        $type = 'Accounts';
      }

      //$uniq = $db->query_result($result_links,$i,'access_count');
      $record_data[$i] = array($name, $email, $status, $id, $type);
    }

    $recordCount = $this->getRecordsCountModule($recordId,$filter,false);
    $numacc = $recordCount[0];
    $numcon = $recordCount[1];
    $numlead = $recordCount[2];
    $viewer->assign('LEADNUM', $numlead);
    $viewer->assign('CONTNUM', $numcon);
    $viewer->assign('ACCNUM', $numacc);
    $viewer->assign('MODULE', $module);
    $viewer->assign('DISABLEPRE', $disablepre);
    $viewer->assign('DISABLENXT', $disablenxt);
    $viewer->assign('RELATED_MODULE', $related_modulename);
    $viewer->assign('DISPLAYTOTALPAGE', $totalpage);
    $viewer->assign('PAGE', $page);
    $viewer->assign('RECORD_DATA', $record_data);
    $viewer->assign('CURRENTFILTER', $filter);
    $viewer->assign('link', $link);

    return $viewer->view('SentEmailsList.tpl',$module);
  }

  public function getListofUniqueOpen(Vtiger_Request $request) {
    global $current_user;
    $viewer = $this->getViewer($request);
    $db = PearDatabase::getInstance();
    $module = $request->getModule();
    $actionbtn = array();

    $recordId = $request->get('record');
    $moduleName = $request->getModule();
    $page = $request->get('page_no');

    $related_modulename = $request->get("relmodule","Contacts");

    $this->initializeListViewContents($request, $viewer,$related_modulename);

    if ($related_modulename == 'Leads') {
      $jointable = ' INNER JOIN vtiger_leaddetails ON vtiger_leaddetails.leadid = vtiger_emailcamp_sendemail.related_id '
      . 'inner join vtiger_crmentity on vtiger_crmentity.crmid = vtiger_leaddetails.leadid';
    } else if ($related_modulename == 'Contacts') {
      $jointable = ' INNER JOIN vtiger_contactdetails ON vtiger_contactdetails.contactid = vtiger_emailcamp_sendemail.related_id '
      . 'inner join vtiger_crmentity on vtiger_crmentity.crmid = vtiger_contactdetails.contactid';
    } else if ($related_modulename == 'Accounts') {
      $jointable = ' INNER JOIN vtiger_account ON vtiger_account.accountid = vtiger_emailcamp_sendemail.related_id '
      . 'inner join vtiger_crmentity on vtiger_crmentity.crmid = vtiger_account.accountid';
    }

    $query_total_count = "SELECT * FROM  vtiger_emailtrackingreport
      INNER JOIN vtiger_emailcamp_sendemail ON vtiger_emailcamp_sendemail.activityid  = vtiger_emailtrackingreport.emailtrackingreportid
    $jointable ";

    if ($current_user->is_admin != "on") {
        $crmentity = new CRMEntity();
        $query_total_count .= $crmentity->getNonAdminAccessControlQuery($related_modulename, $current_user);
    }

    $query_total_count .= " where vtiger_emailcamp_sendemail.emailcampaignsid = ?
      and vtiger_emailtrackingreport.email_open > 0 group by vtiger_emailcamp_sendemail.related_id";

    $result_total_count = $db->pquery($query_total_count, array($recordId));
    $total_count = $db->num_rows($result_total_count);



    $configdetailmodel = Settings_Vtiger_ConfigModule_Model::getInstance();
    $record = $configdetailmodel->getViewableData();
    $noofdata = $record['list_max_entries_per_page'];
    if ($noofdata <= 0) {
      $noofdata = 10;
    }

    $max_page_limit = $page * $noofdata;
    $min_page_limit = $max_page_limit - $noofdata;
    $qry_limit = " LIMIT 0,$noofdata";
    if ($page > 1)
      $qry_limit = " LIMIT $min_page_limit,$noofdata";

    $max_page = ceil($total_count/$noofdata);
    $query = $query_total_count.$qry_limit;

    if ($related_modulename!='All') {
      $result_links = $db->pquery($query, array($recordId));
    }else{
      $result_links = $db->pquery($query, array($recordId,$recordId,$recordId));
    }
    $uniq_open = $db->num_rows($result_links);
    $previous_page = $page - 1;
    $next_page = $page + 1;
    if ($max_page==0 ) {
      $page=0;
      $max_page=0;
      $disablenxt = 'disabled';
      $disablepre = 'disabled';
    }

    $totalpage = 'Page '.$page.' of '.$max_page;

    if ($page == 1) $disablepre = 'disabled';
    if ($page == $max_page) $disablenxt = 'disabled';

    for($i=0;$i<$uniq_open;$i++) {
      if ($related_modulename == 'Leads' || $related_modulename == 'Contacts') {
        $firstname = $db->query_result($result_links,$i,'firstname');
        $lastname = $db->query_result($result_links,$i,'lastname');
        $name = $firstname.' '.$lastname;
        $email = $db->query_result($result_links,$i,'email');
        $uniq = $db->query_result($result_links,$i,'email_open');
                $ip = $db->query_result($result_links,$i,'ip');
        if ($related_modulename == 'Contacts') {
          $id = $db->query_result($result_links,$i,'contactid');
          $link = "index.php?module=Contacts&view=Detail&record";
          $type='Contacts';
        }else if ($related_modulename == 'Leads') {
          $id = $db->query_result($result_links,$i,'leadid');
          $link = "index.php?module=Leads&view=Detail&record";
          $type='Leads';
        }
      } else if ($related_modulename == 'Accounts') {
        $name = $db->query_result($result_links,$i,'accountname');
        $email = $db->query_result($result_links,$i,'email1');
        $id = $db->query_result($result_links,$i,'accountid');
        $link = "index.php?module=Accounts&view=Detail&record";
        $uniq = $db->query_result($result_links,$i,'email_open');
                $ip = $db->query_result($result_links,$i,'ip');
        $type = 'Accounts';
      }
      //$uniq = $db->query_result($result_links,$i,'access_count');
      $record_data[$i] = array($name, $email, $uniq, $id, $type,$ip);
    }

    $recordCount = $this->getRecordsCountModule($recordId,'sent',true);
    $numacc = $recordCount[0];
    $numcon = $recordCount[1];
    $numlead = $recordCount[2];
    $viewer->assign('LEADNUM', $numlead);
    $viewer->assign('CONTNUM', $numcon);
    $viewer->assign('ACCNUM', $numacc);
    $viewer->assign('MODULE', $module);
    $viewer->assign('DISABLEPRE', $disablepre);
    $viewer->assign('DISABLENXT', $disablenxt);
    $viewer->assign('RELATED_MODULE', $related_modulename);
    $viewer->assign('DISPLAYTOTALPAGE', $totalpage);
    $viewer->assign('PAGE', $page);
    $viewer->assign('RECORD_DATA', $record_data);
    $viewer->assign('link', $link);
    echo $viewer->view('UniqueOpenList.tpl',$module, true);
  }

  public function getRecordsCountModule($campaignid,$filter='all',$onlyopen=true) {

    global $current_user;
    $db = PearDatabase::getInstance();

    $accquery = "SELECT 'ACCOUNTS' AS type
                 FROM vtiger_emailcamp_sendemail
                 INNER JOIN vtiger_account ON vtiger_account.accountid = vtiger_emailcamp_sendemail.related_id
                 INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_account.accountid
                 LEFT JOIN vtiger_emailtrackingreport ON vtiger_emailtrackingreport.emailtrackingreportid=vtiger_emailcamp_sendemail.activityid";

    if ($current_user->is_admin != "on") {

      $crmentity = new CRMEntity();
      $accquery .= $crmentity->getNonAdminAccessControlQuery('Accounts', $current_user);
    }

    $accquery .= ' WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?';

    $conquery = "SELECT 'CONTACTS' AS type
                 FROM  vtiger_emailcamp_sendemail
                 INNER JOIN vtiger_contactdetails ON vtiger_contactdetails.contactid = vtiger_emailcamp_sendemail.related_id
                 INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_contactdetails.contactid
                 LEFT JOIN  vtiger_emailtrackingreport ON vtiger_emailtrackingreport.emailtrackingreportid=vtiger_emailcamp_sendemail.activityid";

    if ($current_user->is_admin != "on") {

      $crmentity = new CRMEntity();
      $conquery .= $crmentity->getNonAdminAccessControlQuery('Contacts', $current_user);
    }

    $conquery.=' WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?';

    $leadquery = "SELECT 'LEADS' AS type
                  FROM vtiger_emailcamp_sendemail
                  INNER JOIN vtiger_leaddetails ON vtiger_leaddetails.leadid = vtiger_emailcamp_sendemail.related_id
                  INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_leaddetails.leadid
                  LEFT JOIN vtiger_emailtrackingreport ON vtiger_emailtrackingreport.emailtrackingreportid=vtiger_emailcamp_sendemail.activityid";

    if ($current_user->is_admin != "on") {

      $crmentity = new CRMEntity();
      $leadquery .= $crmentity->getNonAdminAccessControlQuery('Leads', $current_user);
    }

    $leadquery.=' WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?';

    $get_open_query = ' AND vtiger_emailtrackingreport.email_open > 0';

    if ($onlyopen) {

      $conquery .= $get_open_query;
      $leadquery .= $get_open_query;
      $accquery .= $get_open_query;
    }

    $filter_sent = ' AND vtiger_emailcamp_sendemail.issent=1;';
    $filter_notsent = ' AND vtiger_emailcamp_sendemail.issent=0;';
    $filter_error = ' AND vtiger_emailcamp_sendemail.issent=-1;';

    if ($filter == 'sent') {

      $conquery .= $filter_sent;
      $leadquery .= $filter_sent;
      $accquery .= $filter_sent;
    }
    elseif ($filter == 'notsent') {

      $conquery .= $filter_notsent;
      $leadquery .= $filter_notsent;
      $accquery .= $filter_notsent;
    }
    elseif ($filter =='error') {

      $conquery .= $filter_error;
      $leadquery .= $filter_error;
      $accquery .= $filter_error;
    }

    $rescon =  $db->pquery($conquery,array($campaignid));
    $numcon = $db->num_rows($rescon);
    $reslead =  $db->pquery($leadquery,array($campaignid));
    $numlead = $db->num_rows($reslead);
    $resacc =  $db->pquery($accquery,array($campaignid));
    $numacc = $db->num_rows($resacc);

    return array($numacc,$numcon,$numlead);
  }

  public function getSubscriberList(Vtiger_Request $request) {

    $viewer = $this->getViewer($request);
    $db = PearDatabase::getInstance();
    $module = $request->getModule();

    $recordId = $request->get('record');
    $moduleName = $request->getModule();
    $page = $request->get('page_no');
    $optout = $request->get('optout');

    $related_modulename = $request->get('relmodule','Contacts');

    $this->initializeListViewContents($request, $viewer,$related_modulename);

    $subscriber = EmailCampaigns_Record_Model::getSubscribersWithShar($recordId, $optout,null,$related_modulename);

    $total_count = $db->num_rows($subscriber);
    $configdetailmodel = Settings_Vtiger_ConfigModule_Model::getInstance();
    $record = $configdetailmodel->getViewableData();
    $noofdata = $record['list_max_entries_per_page'];

    if ($noofdata <= 0) $noofdata = 10;

    $max_page = ceil($total_count/$noofdata);
    $max_page_limit = $page * $noofdata;
    $min_page_limit = $max_page_limit - $noofdata;
    $qry_limit = " LIMIT 0,$noofdata";
    if ($page > 1)
      $qry_limit = " LIMIT $min_page_limit,$noofdata";

    $subscriber_limited = EmailCampaigns_Record_Model::getSubscribersWithShar($recordId, $optout, $qry_limit,$related_modulename);
    $subscriber_list = $db->num_rows($subscriber_limited);
    $previous_page = $page - 1;
    $next_page = $page + 1;
    if ($max_page==0 ) {
      $page=0;
      $max_page=0;
      $disablenxt = 'disabled';
      $disablepre = 'disabled';
    }
    $totalpage = 'Page '.$page.' of '.$max_page;

    if ($page == 1) $disablepre = 'disabled';
    if ($page == $max_page) $disablenxt = 'disabled';

    for($i=0; $i<$subscriber_list; $i++) {
      $imodule = $db->query_result($subscriber_limited,$i,'modulefield');
      if ($imodule == $related_modulename) {
        $record_data[$i] = array(
          "name" => $db->query_result($subscriber_limited,$i,'namefield'),
          "email" => $db->query_result($subscriber_limited,$i,'emailfield'),
          "id" => $db->query_result($subscriber_limited,$i,'idfield'),
          "link" => "index.php?module=".$imodule."&view=Detail&record".$id);
      }else if ( $related_modulename=='All') {
        $record_data[$i] = array(
          "name" => $db->query_result($subscriber_limited,$i,'namefield'),
          "email" => $db->query_result($subscriber_limited,$i,'emailfield'),
          "id" => $db->query_result($subscriber_limited,$i,'idfield'),
          "link" => "index.php?module=".$imodule."&view=Detail&record".$id);
      }
    }
    $recordCount = $this->getUnsubCount($recordId);
    $numacc = $recordCount[0];
    $numcon = $recordCount[1];
    $numlead = $recordCount[2];

    $viewer->assign('LEADNUM', $numlead);
    $viewer->assign('CONTNUM', $numcon);
    $viewer->assign('ACCNUM', $numacc);
    $viewer->assign('MODULE', $module);
    $viewer->assign('DISABLEPRE', $disablepre);
    $viewer->assign('DISABLENXT', $disablenxt);
    $viewer->assign('RELATED_MODULE', $related_modulename);
    $viewer->assign('DISPLAYTOTALPAGE', $totalpage);
    $viewer->assign('PAGE', $page);
    $viewer->assign('LISTTYPE', $optout);
    $viewer->assign('RECORD_DATA', $record_data);
    echo $viewer->view('SubscriberList.tpl',$module, true);
  }

  public function getsingleUniqueLinkClick(Vtiger_Request $request) {

    $viewer = $this->getViewer($request);
    $db = PearDatabase::getInstance();
    $module = $request->getModule();

    $recordId = $request->get('record');
    $moduleName = $request->getModule();
    $page = $request->get('page_no');
    $link = $request->get('link');
    $url = $request->get('url');

    // @change t49443
    $link =  $this->replace($link);
    $url =  $this->replace($url);
    //

    $related_modulename = $request->get('relmodule','Contacts');

    $linkclickrecords = EmailCampaigns_Record_Model::getsingleUniqueLinkClickRecords($recordId,$limit=null,$link,$url,$related_modulename);
    $total_count = $db->num_rows($linkclickrecords);
    $this->initializeListViewContents($request, $viewer,$related_modulename);
    $configdetailmodel = Settings_Vtiger_ConfigModule_Model::getInstance();
    $record = $configdetailmodel->getViewableData();
    $noofdata = $record['list_max_entries_per_page'];

    if ($noofdata <= 0) $noofdata = 10;

    $max_page = ceil($total_count/$noofdata);
    $max_page_limit = $page * $noofdata;
    $min_page_limit = $max_page_limit - $noofdata;
    $qry_limit = " LIMIT 0,$noofdata";

    if ($page > 1) $qry_limit = " LIMIT $min_page_limit,$noofdata";

    $linkclickrecords_limited = EmailCampaigns_Record_Model::getsingleUniqueLinkClickRecords($recordId, $qry_limit,$link,$url,$related_modulename);
    $linkclickrecords_list = $db->num_rows($linkclickrecords_limited);
    $previous_page = $page - 1;
    $next_page = $page + 1;
    if ($max_page==0 ) {
      $page=0;
      $max_page=0;
      $disablenxt = 'disabled';
      $disablepre = 'disabled';
    }
    $totalpage = 'Page '.$page.' of '.$max_page;

    if ($page == 1) $disablepre = 'disabled';
    if ($page == $max_page) $disablenxt = 'disabled';

    for($i=0; $i<$linkclickrecords_list; $i++) {
      if ($related_modulename == 'Leads' || $related_modulename == 'Contacts') {
        $firstname  = $db->query_result($linkclickrecords_limited,$i,'firstname');
        $lastname   = $db->query_result($linkclickrecords_limited,$i,'lastname');
        $name = $firstname.' '.$lastname;
        $email     = $db->query_result($linkclickrecords_limited,$i,'email');
        if ($related_modulename == 'Contacts') {
          $id = $db->query_result($linkclickrecords_limited,$i,'contactid');
          $link1 = "index.php?module=Contacts&view=Detail&record";
          $type='Contacts';
        }else if ($related_modulename == 'Leads') {
          $id = $db->query_result($linkclickrecords_limited,$i,'leadid');
          $link1="index.php?module=Leads&view=Detail&record";
          $type='Leads';
        }
      } else if ($related_modulename == 'Accounts') {
        $name   = $db->query_result($linkclickrecords_limited,$i,'accountname');
        $email   = $db->query_result($linkclickrecords_limited,$i,'email1');
        $id = $db->query_result($linkclickrecords_limited,$i,'accountid');
        $link1="index.php?module=Accounts&view=Detail&record";
        $type='Accounts';
      }else{
        $name   = $db->query_result($linkclickrecords_limited,$i,'name');
        $email   = $db->query_result($linkclickrecords_limited,$i,'email');
        $id = $db->query_result($linkclickrecords_limited,$i,'id');
        $link1="index.php?module=Accounts&view=Detail&record";
        $type=$db->query_result($linkclickrecords_limited,$i,'type');
      }
      $link  = $db->query_result($linkclickrecords_limited,$i,'link');
      $url  = $db->query_result($linkclickrecords_limited,$i,'url');
      $click   = $db->query_result($linkclickrecords_limited,$i,'click');
      $ip = $db->query_result($linkclickrecords_limited,$i,'ip');
      $record_data[$i] = array($name, $email,$link,$url,$click,$id,$type,$ip);
    }

    $recordCount = $this->getLinksCount($recordId,$link,$url);

    $numacc = $recordCount[0];
    $numcon = $recordCount[1];
    $numlead = $recordCount[2];
    $viewer->assign('LEADNUM', $numlead);
    $viewer->assign('CONTNUM', $numcon);
    $viewer->assign('ACCNUM', $numacc);
    $viewer->assign('MODULE', $module);
    $viewer->assign('DISABLEPRE', $disablepre);
    $viewer->assign('DISABLENXT', $disablenxt);
    $viewer->assign('RELATED_MODULE', $related_modulename);
    $viewer->assign('DISPLAYTOTALPAGE', $totalpage);
    $viewer->assign('PAGE', $page);
    $viewer->assign('RECORD_DATA', $record_data);
    $viewer->assign('link', $link1);

    $viewer->assign('siglelink', $request->get('link'));
    $viewer->assign('url', $request->get('url'));

    echo $viewer->view('singleUniqueLinkClick.tpl',$module, true);
  }

  public function getUniqueLinkClick(Vtiger_Request $request) {

    $viewer = $this->getViewer($request);
    $db = PearDatabase::getInstance();
    $module = $request->getModule();

    $recordId = $request->get('record');
    $moduleName = $request->getModule();
    $page = $request->get('page_no');

    $related_modulename = $request->get('relmodule','Contacts');

    $linkclickrecords = EmailCampaigns_Record_Model::getUniqueLinkClickRecords($recordId, null, $related_modulename);
    $total_count = $db->num_rows($linkclickrecords);
    $this->initializeListViewContents($request, $viewer,$related_modulename);
    $configdetailmodel = Settings_Vtiger_ConfigModule_Model::getInstance();
    $record = $configdetailmodel->getViewableData();
    $noofdata = $record['list_max_entries_per_page'];

    if ($noofdata <= 0) $noofdata = 10;

    $max_page = ceil($total_count/$noofdata);
    $max_page_limit = $page * $noofdata;
    $min_page_limit = $max_page_limit - $noofdata;
    $qry_limit = " LIMIT 0,$noofdata";

    if ($page > 1) $qry_limit = " LIMIT $min_page_limit,$noofdata";

    $linkclickrecords_limited = EmailCampaigns_Record_Model::getUniqueLinkClickRecords($recordId, $qry_limit, $related_modulename);
    $linkclickrecords_list = $db->num_rows($linkclickrecords_limited);
    $previous_page = $page - 1;
    $next_page = $page + 1;
    if ($max_page==0 ) {
      $page=0;
      $max_page=0;
      $disablenxt = 'disabled';
      $disablepre = 'disabled';
    }

    $totalpage = 'Page '.$page.' of '.$max_page;

    if ($page == 1) $disablepre = 'disabled';
    if ($page == $max_page) $disablenxt = 'disabled';

    for($i=0; $i<$linkclickrecords_list; $i++) {

      if ($related_modulename=='All') {
        $id = $db->query_result($linkclickrecords_limited,$i,'id');
        $email   = $db->query_result($linkclickrecords_limited,$i,'email');
        $name   = $db->query_result($linkclickrecords_limited,$i,'name');
        $type   = $db->query_result($linkclickrecords_limited,$i,'type');
      }else if ($related_modulename == 'Leads' || $related_modulename == 'Contacts') {
        $firstname  = $db->query_result($linkclickrecords_limited,$i,'firstname');
        $lastname   = $db->query_result($linkclickrecords_limited,$i,'lastname');
        $name = $firstname.' '.$lastname;
        $email     = $db->query_result($linkclickrecords_limited,$i,'email');
        if ($related_modulename == 'Contacts') {
          $id = $db->query_result($linkclickrecords_limited,$i,'contactid');
          $link1 = "index.php?module=Contacts&view=Detail&record";
        }else if ($related_modulename == 'Leads') {
          $id = $db->query_result($linkclickrecords_limited,$i,'leadid');
          $link1="index.php?module=Leads&view=Detail&record";
        }
      } else if ($related_modulename == 'Accounts') {
        $name   = $db->query_result($linkclickrecords_limited,$i,'accountname');
        $email   = $db->query_result($linkclickrecords_limited,$i,'email1');
        $id = $db->query_result($linkclickrecords_limited,$i,'accountid');
        $link1="index.php?module=Accounts&view=Detail&record";
      }
      $link  = $db->query_result($linkclickrecords_limited,$i,'link');
      $url  = $db->query_result($linkclickrecords_limited,$i,'url');
      $click   = $db->query_result($linkclickrecords_limited,$i,'click');
            $ip   = $db->query_result($linkclickrecords_limited,$i,'ip');
      $record_data[$i] = array($name, $email,$link,$url,$click,$id,$type,$ip);
    }

    $recordCount = $this->getLinksCount($recordId);

    $numacc = $recordCount[0];
    $numcon = $recordCount[1];
    $numlead = $recordCount[2];
    $viewer->assign('LEADNUM', $numlead);
    $viewer->assign('CONTNUM', $numcon);
    $viewer->assign('ACCNUM', $numacc);
    $viewer->assign('MODULE', $module);
    $viewer->assign('DISABLEPRE', $disablepre);
    $viewer->assign('DISABLENXT', $disablenxt);
    $viewer->assign('RELATED_MODULE', $related_modulename);
    $viewer->assign('DISPLAYTOTALPAGE', $totalpage);
    $viewer->assign('PAGE', $page);
    $viewer->assign('RECORD_DATA', $record_data);
    $viewer->assign('link', $link1);
    echo $viewer->view('UniqueLinkClick.tpl',$module, true);
  }

  /**
   * Function returns the number of records for the current filter
   * @param Vtiger_Request $request
   */
  function getRecordsCountCampaign(Vtiger_Request $request) {
    $moduleName = $request->getModule();
    $cvId = $request->get('viewname');
    $count = $this->getListViewCountCampaign($request);

    $result = array();
    $result['module'] = $moduleName;
    $result['viewname'] = $cvId;
    $result['count'] = $count;

    $response = new Vtiger_Response();
    $response->setEmitType(Vtiger_Response::$EMIT_JSON);
    $response->setResult($result);
    $response->emit();
  }


  public function getUnsubCount($campaignid) {

    $db = PearDatabase::getInstance();

    $leadquery = "SELECT '1' FROM vtiger_emailcamp_sendemail
                  INNER JOIN vtiger_leaddetails ON vtiger_leaddetails.leadid = vtiger_emailcamp_sendemail.related_id
                  INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_leaddetails.leadid
                  WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
                  AND (vtiger_leaddetails.emailcampaign_optout=1)";

    $reslead =  $db->pquery($leadquery,array($campaignid));
    $numlead = $db->num_rows($reslead);

    $contactquery = "SELECT '1' FROM vtiger_emailcamp_sendemail
                     INNER JOIN vtiger_contactdetails ON vtiger_contactdetails.contactid = vtiger_emailcamp_sendemail.related_id
                     INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_contactdetails.contactid
                     WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
                     AND (vtiger_contactdetails.emailcampaign_optout=1)";

    $rescont =  $db->pquery($contactquery,array($campaignid));
    $numcon = $db->num_rows($rescont);

    $accountquery = "SELECT '1' FROM vtiger_emailcamp_sendemail
                     INNER JOIN vtiger_account ON vtiger_account.accountid = vtiger_emailcamp_sendemail.related_id
                     INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_account.accountid
                     WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
                     AND (vtiger_account.emailcampaign_optout=1)";

    $resacc =  $db->pquery($accountquery,array($campaignid));
    $numacc = $db->num_rows($resacc);

    return array($numacc,$numcon,$numlead);

  }

  public function getLinksCount($campaignid,$link,$url) {

    global $current_user;
    $db = PearDatabase::getInstance();

    // @change t49443
    $link = $this->replace($link);
    $url = $this->replace($url);
    //

    $leadquery = "SELECT 'LEADS' AS type
                  FROM  vtiger_emailcamp_sendemail
                  INNER JOIN vtiger_leaddetails ON vtiger_leaddetails.leadid = vtiger_emailcamp_sendemail.related_id
                  INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_leaddetails.leadid
                  INNER JOIN vtiger_link_tracker ON vtiger_link_tracker.emailid = vtiger_emailcamp_sendemail.activityid";

    if ($current_user->is_admin != "on") {

      $crmentity = new CRMEntity();
      $leadquery .= $crmentity->getNonAdminAccessControlQuery('Leads', $current_user);
    }

    if ($url!='') {

      $leadquery .= " WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
                      AND vtiger_link_tracker.link = ?
                      AND vtiger_link_tracker.url = ?
                      AND vtiger_link_tracker.emailid<>0";

      $reslead =  $db->pquery($leadquery,array($campaignid,$link,$url));
    }
    else{

      $leadquery .= " WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
                      AND vtiger_link_tracker.emailid<>0";

      $reslead =  $db->pquery($leadquery,array($campaignid));
    }

    $numlead = $db->num_rows($reslead);

    $contactquery = "SELECT 'CONTACTS' AS type
                     FROM  vtiger_emailcamp_sendemail
                     INNER JOIN vtiger_contactdetails ON vtiger_contactdetails.contactid = vtiger_emailcamp_sendemail.related_id
                     INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_contactdetails.contactid
                     INNER JOIN vtiger_link_tracker ON vtiger_link_tracker.emailid = vtiger_emailcamp_sendemail.activityid";

    if ($current_user->is_admin != "on") {

      $crmentity = new CRMEntity();
      $contactquery .= $crmentity->getNonAdminAccessControlQuery('Contacts', $current_user);
    }

    if ($url!='') {
      $contactquery .= " WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
                         AND vtiger_link_tracker.link = ?
                         AND vtiger_link_tracker.url = ?
                         AND vtiger_link_tracker.emailid<>0";

      $rescont =  $db->pquery($contactquery,array($campaignid,$link,$url));
    }
    else{

      $contactquery .=" WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
                        AND vtiger_link_tracker.emailid<>0";

      $rescont =  $db->pquery($contactquery,array($campaignid));
    }

    $numcon = $db->num_rows($rescont);

    $accquery = "SELECT 'ACCOUNTS' AS type
                 FROM  vtiger_emailcamp_sendemail
                 INNER JOIN vtiger_account ON vtiger_account.accountid = vtiger_emailcamp_sendemail.related_id
                 INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_account.accountid
                 INNER JOIN vtiger_link_tracker ON vtiger_link_tracker.emailid = vtiger_emailcamp_sendemail.activityid";

    if ($current_user->is_admin != "on") {

      $crmentity = new CRMEntity();
      $accquery .= $crmentity->getNonAdminAccessControlQuery('Accounts', $current_user);
    }

    if ($url!='') {

      $accquery .= " WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
                     AND vtiger_link_tracker.link = ?
                     AND vtiger_link_tracker.url = ?
                     AND vtiger_link_tracker.emailid<>0";

      $resacc =  $db->pquery($accquery,array($campaignid,$link,$url));


    }
    else{

      $accquery .= " WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
                     AND vtiger_link_tracker.emailid<>0";

      $resacc =  $db->pquery($accquery,array($campaignid));
    }

    $numacc = $db->num_rows($resacc);

    return array($numacc,$numcon,$numlead);
  }

  function getListViewCountCampaign(Vtiger_Request $request) {

    $campaignid = $request->get('record');
    $recordType = $request->get('recordType');
    $link = $request->get('link');
    $url = $request->get('url');
    $db = PearDatabase::getInstance();

    // @change t49443
    $link = $this->replace($link);
    $url = $this->replace($url);

    if ($recordType == 'UniqueOpenList') {

      $query = "SELECT * FROM vtiger_emailtrackingreport
                INNER JOIN vtiger_emailcamp_sendemail ON vtiger_emailcamp_sendemail.activityid = vtiger_emailtrackingreport.emailtrackingreportid
                WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ? AND vtiger_emailtrackingreport.email_open > 0";

      $result = $db->pquery($query, array($campaignid));
      return $db->num_rows($result);
    }
    else {

      $query_links = "SELECT vtiger_link_tracker.link,sum(click) as click FROM vtiger_link_tracker
                      INNER JOIN vtiger_emailcamp_sendemail ON vtiger_link_tracker.emailid = vtiger_emailcamp_sendemail.activityid
                      WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ? ";

      if ($link!='' || $url!='') {

        $query_links .=  " AND vtiger_link_tracker.link = ? AND vtiger_link_tracker.url = ?";
      }

      $query_links .=  " GROUP BY vtiger_link_tracker.url";

      if ($link!='' || $url!='') {

        $result_links = $db->pquery($query_links, array($campaignid,$link,$url));
      }
      else{

        $result_links = $db->pquery($query_links, array($campaignid));
      }

      $count = $db->num_rows($result_links);

      $query_open_count = "SELECT count(email) as open FROM vtiger_link_tracker
                           INNER JOIN vtiger_emailcamp_sendemail ON vtiger_link_tracker.emailid  = vtiger_emailcamp_sendemail.activityid
                           INNER JOIN vtiger_leaddetails ON vtiger_leaddetails.leadid  = vtiger_emailcamp_sendemail.related_id
                           WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ? ";

      if ($link!='' || $url!='') {

        $query_open_count .=  " AND vtiger_link_tracker.link = ? AND vtiger_link_tracker.url = ?";
      }

      $query_open_count .=  " GROUP BY vtiger_link_tracker.url";

      if ($link!='' || $url!='') {

        $result_open_count = $db->pquery($query_open_count, array($campaignid,$link,$url));
      }
      else{

        $result_open_count = $db->pquery($query_open_count, array($campaignid));
      }

      for($i=0;$i<$count;$i++) {

        $linkname    = $db->query_result($result_links, $i, 'link');
        $click      = $db->query_result($result_links, $i, 'click');
        $uniqe_open    = $db->query_result($result_open_count, $i, 'open');
        $result[$i+1]   = array($linkname, $click, $uniqe_open);
      }

      $countRecord = 0;

      foreach ($result as $key => $value) {

        $countRecord = $countRecord + $value[1];
      }

      return $countRecord;
    }

  }

  function getRelatedRecords(Vtiger_Request $request) {

    $moduleName = $request->getModule();
    $cvId = $request->get('viewname');
    $relatedrecords = $this->getRelatedRecordsId($request);

    $response = new Vtiger_Response();
    $response->setEmitType(Vtiger_Response::$EMIT_JSON);
    $response->setResult($relatedrecords);
    $response->emit();
  }


  function getRelatedRecordsId(Vtiger_Request $request) {

    $campaignid = $request->get('record');
    $link = $request->get('link');
    $url = $request->get('url');
    $db = PearDatabase::getInstance();
    $RelatedRecordsIdarray =  array();

    // @change t49443
    $link = $this->replace($link);
    $ulr = $this->replace($ulr);
    //

    $query_open_count = "SELECT DISTINCT vtiger_emailcamp_sendemail.related_id as related_id FROM vtiger_link_tracker
                         INNER JOIN vtiger_emailcamp_sendemail ON vtiger_link_tracker.emailid  = vtiger_emailcamp_sendemail.activityid
                         INNER JOIN vtiger_leaddetails ON vtiger_leaddetails.leadid  = vtiger_emailcamp_sendemail.related_id
                         WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ? ";

    if ($link!='' || $url!='') {

      $query_open_count .=  " AND vtiger_link_tracker.link = ? AND vtiger_link_tracker.url = ?";
    }

    if ($link!='' || $url!='') {

      $result_open_count = $db->pquery($query_open_count, array($campaignid,$link,$url));
    }
    else {

      $result_open_count = $db->pquery($query_open_count, array($campaignid));
    }

    $count = $db->num_rows($result_open_count);

    for($i=0;$i<$count;$i++) {

      $related_id = $db->query_result($result_open_count, $i, 'related_id');
      array_push($RelatedRecordsIdarray,$related_id);
    }

    return $RelatedRecordsIdarray;
  }

  /*
   * Function to initialize the required data in smarty to display the List View Contents
   */
  public function initializeListViewContents(Vtiger_Request $request, Vtiger_Viewer $viewer, $related_modulename) {
    $moduleName = $request->getModule();
    //$cvId = $this->viewName;
    $cvId = 1;

    $listViewModel = Vtiger_ListView_Model::getInstance($moduleName, $cvId);
    $currentUser = Users_Record_Model::getCurrentUserModel();

    $linkParams = array('MODULE'=>$moduleName, 'ACTION'=>$request->get('view'), 'CVID'=>$cvId);

    $editRecordPermission = Users_Privileges_Model::isPermitted($related_modulename, 'EditView', $record);

    if (!empty($editRecordPermission)) {
      $actionbtn['editRecordPermission'] = $editRecordPermission;
    }

    $calendarRecordPermission = Users_Privileges_Model::isPermitted($related_modulename, 'Calendar', $record);
    if (!empty($calendarRecordPermission)) {
      $actionbtn['calendarRecordPermission'] = $calendarRecordPermission;
    }
    $linkModels = $listViewModel->getListViewMassActions($linkParams);

    $pagingModel = new Vtiger_Paging_Model();

    $viewer->assign('actionbtn',$actionbtn);
    $viewer->assign('MODULE', $moduleName);
    $viewer->assign('relatedModule', $related_modulename);

    if (!$this->listViewLinks) {
      $this->listViewLinks = $listViewModel->getListViewLinks($linkParams);
    }

    $viewer->assign('LISTVIEW_LINKS', $this->listViewLinks);

    $viewer->assign('LISTVIEW_MASSACTIONS', $linkModels['LISTVIEWMASSACTION']);

  }

  // @change t49443
  private function replace($str) {

    if (!empty($str) && strpos($str, '&amp;') !== false) {

      // get rid of &amp;
      $str = str_replace('&amp;', '&', $str);
    }

    return $str;
  }
  //
}
