<?php

/* +**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * ********************************************************************************** */
global $root_directory;
require_once($root_directory."/modules/SubscribersList/autoload_wf.php");

class EmailCampaigns_BasicAjax_View extends Vtiger_Basic_View {

    function __construct() {
        parent::__construct();
        $this->exposeMethod('showAdvancedSearch');
        $this->exposeMethod('AdvanceFilter');
        $this->exposeMethod('refreshTotalCount');
        $this->exposeMethod('deleteRel');
        $this->exposeMethod('refreshTotalStep4');
    }

    function checkPermission() {
        
    }

    function preProcess(Vtiger_Request $request) {
        return true;
    }

    function postProcess(Vtiger_Request $request) {
        return true;
    }

    function process(Vtiger_Request $request) {
        $mode = $request->get('mode');
        if (!empty($mode)) {
            $this->invokeExposedMethod($mode, $request);
        }
        return;
    }

    function refreshTotalStep4(Vtiger_Request $request) {
        $recordId = $request->get('record');
        $db = PearDatabase::getInstance();
        $adb = PearDatabase::getInstance();
        $campaignRelResult = $adb->pquery("SELECT * FROM vtiger_emailcampaigns_list_rel WHERE emailcampaignsid=$recordId");
        $campaignRelRecords = array();
        $recordModel = Vtiger_Record_Model::getInstanceById($recordId);
        while ($campaignRelRecord = $adb->fetch_array($campaignRelResult)) {
            $relData = $db->pquery("select * from vtiger_emailcampaigns_list_rel where id =?", array($campaignRelRecord['id']));
//            echo '<pre>';var_dump($relData->fields['list_type'],json_decode($relData->fields['list_data']));exit;
            $emails_list = $recordModel->getEmailListByListType($relData->fields['list_type'], json_decode($relData->fields['list_data'],true));
            foreach($emails_list as $crmid => $email){
                 if(!in_array($email,$campaignRelRecords)){
                    $campaignRelRecords[$crmid] = $email;
                }
            }
            
        }
        
        $response = new Vtiger_Response();
        $response->setResult(array('count' => count($campaignRelRecords)));
        $response->emit();
    }

    function deleteRel(Vtiger_Request $request) {
        $relId = $request->get('relId');
        $adb = PearDatabase::getInstance();
        $adb->pquery("delete from vtiger_emailcampaigns_list_rel where id =?", array($relId));
        $response = new Vtiger_Response();
        $response->setResult(array('deleted' => true));
        $response->emit();
    }

    function refreshTotalCount(Vtiger_Request $request) {
        $relId = $request->get('relId');
        $adb = PearDatabase::getInstance();
        $relData = $adb->pquery("select * from vtiger_emailcampaigns_list_rel where id =?", array($relId));
//        echo '<pre>';var_dump($relData->fields,get_object_vars(json_decode($relData->fields['list_data'])),$relData->fields['list_type'],$relData->fields['emailcampaignsid']);exit;
        $recordModel = Vtiger_Record_Model::getInstanceById($relData->fields['emailcampaignsid']);
        $emails_list = $recordModel->getEmailListByListType($relData->fields['list_type'], json_decode($relData->fields['list_data'],true));
        $response = new Vtiger_Response();
        $response->setResult(array('count' => count($emails_list)));
        $response->emit();
    }
     function AdvanceFilter(Vtiger_Request $request) {
        global $vtiger_current_version;
            if($vtiger_current_version > "6.5.0") {
                $this->AdvanceFilter7($request);
            }else{
                $this->AdvanceFilter6($request);
            }
     }


    function AdvanceFilter6(Vtiger_Request $request) {

        $viewer = $this->getViewer($request);
        $moduleName = $request->getModule();
        $record = $request->get('record');
        if(!empty($record)) {
            $recordModel = Vtiger_Record_Model::getInstanceById($record, "SubscribersList");
        } else {
            $recordModel = Vtiger_Record_Model::getCleanInstance("SubscribersList");
        }
        
    $moduleModel = $recordModel->getModule();
        
    $fieldList = $moduleModel->getFields();
        

        
        //$recordStructureInstance = Vtiger_RecordStructure_Model::getInstanceFromRecordModel($recordModel, Vtiger_RecordStructure_Model::RECORD_STRUCTURE_MODE_EDIT);
        //$picklistDependencyDatasource = Vtiger_DependencyPicklist::getPicklistDependencyDatasource($moduleName);

        //$viewer->assign('PICKIST_DEPENDENCY_DATASOURCE',Zend_Json::encode($picklistDependencyDatasource));
        //$viewer->assign('RECORD_STRUCTURE_MODEL', $recordStructureInstance);
        //$viewer->assign('RECORD_STRUCTURE', $recordStructureInstance->getStructure());
        
        //$viewer->assign('MODULE', $moduleName);
        $viewer->assign('CURRENTDATE', date('Y-n-j'));
        $viewer->assign('USER_MODEL', Users_Record_Model::getCurrentUserModel());
        $viewer->assign('SEARCHABLE_MODULES', SubscribersList_Module_Model::getSearchableModules());
        //$viewer->assign('SOURCE_MODULE', '');
        //filter
        
                $source_module = $recordModel->get('module_name');

        $viewer->assign('SOURCE_MODULE', $source_module);
                
        if($source_module !=''){
            if($request->get('viewid')) {
                $viewid = $request->get('viewid');
            }else{
                $customView = new CustomView();
                $viewid = $customView->getViewId($source_module);
            }
            
            $sourcemoduleModel = Vtiger_Module_Model::getInstance($source_module);
            $sourcerecordStructureInstance = Vtiger_RecordStructure_Model::getInstanceForModule($sourcemoduleModel);
            
            if(!empty($viewid)) {
                $customViewModel = CustomView_Record_Model::getInstanceById($viewid);
                $viewer->assign('MODE', 'edit');
            } else {
                $customViewModel = new CustomView_Record_Model();
                $customViewModel->setModule($source_module);
                $viewer->assign('MODE', '');
            }

            $viewer->assign('SEARCHABLE_MODULES', EmailCampaigns_Module_Model::getSearchableModules());
            $viewer->assign('CUSTOMVIEW_MODEL', $customViewModel);
        
            if($recordModel->get('conditions') && $request->get('viewid')=='' && $request->get('mode1')!='selectsourmodule') {
                $conditions = $recordModel->get('conditions');
                $conditions = str_replace('&quot;', '"', $conditions);
                $conditions = json_decode($conditions, true);
                $transformedConditions = array();
                if(!empty($conditions)) {
                    foreach($conditions as $index => $info) {
                        if(!($info['groupid'])) {
                            $firstGroup[] = array('columnname' => $info['fieldname'], 'comparator' => $info['operation'], 'value' => $info['value'],
                                'column_condition' => $info['joincondition'], 'valuetype' => $info['valuetype'], 'groupid' => $info['groupid']);
                        } else {
                            $secondGroup[] = array('columnname' => $info['fieldname'], 'comparator' => $info['operation'], 'value' => $info['value'],
                                'column_condition' => $info['joincondition'], 'valuetype' => $info['valuetype'], 'groupid' => $info['groupid']);
                        }
                    }
                }
                $transformedConditions[1] = array('columns'=>$firstGroup);
                $transformedConditions[2] = array('columns'=>$secondGroup);
                $viewer->assign('ADVANCE_CRITERIA', $transformedConditions);
            }else{
                //print_r($customViewModel->transformToNewAdvancedFilter());
                $viewer->assign('ADVANCE_CRITERIA', $customViewModel->transformToNewAdvancedFilter());
            }
            
            
            $viewer->assign('CURRENTDATE', date('Y-n-j'));
            
            $advanceFilterOpsByFieldType = Vtiger_Field_Model::getAdvancedFilterOpsByFieldType();
            $viewer->assign('ADVANCED_FILTER_OPTIONS', Vtiger_Field_Model::getAdvancedFilterOptions());
            $viewer->assign('ADVANCED_FILTER_OPTIONS_BY_TYPE', $advanceFilterOpsByFieldType);
            $dateFilters = Vtiger_Field_Model::getDateFilterTypes();
            foreach($dateFilters as $comparatorKey => $comparatorInfo) {
                $comparatorInfo['startdate'] = DateTimeField::convertToUserFormat($comparatorInfo['startdate']);
                $comparatorInfo['enddate'] = DateTimeField::convertToUserFormat($comparatorInfo['enddate']);
                $comparatorInfo['label'] = vtranslate($comparatorInfo['label'],$module);
                $dateFilters[$comparatorKey] = $comparatorInfo;
            }
            
            $viewer->assign('DATE_FILTERS', $dateFilters);
            $viewer->assign('RECORD_STRUCTURE', $sourcerecordStructureInstance->getStructure());
            $viewer->assign('MODULE',$source_module);
            $viewer->assign('SOURCE_MODULE_MODEL', $sourcemoduleModel);
            //$viewer->assign('MODULE', $module);
            $viewer->assign('VIEWID', $viewid);
            //$viewer->assign('RECORD_ID', $record);
            
            $viewer->assign('CUSTOM_VIEWS', CustomView_Record_Model::getAllByGroup($source_module));
        }
        echo $viewer->view('AdvanceFilter.tpl', $moduleName, true);
    }    

    /**
     * Function to display the UI for advance search on any of the module
     * @param Vtiger_Request $request
     */
    function AdvanceFilter7(Vtiger_Request $request) {

        $viewer = $this->getViewer($request);
        $moduleName = $request->getModule();
        $record = $request->get('record');
        if(!empty($record)) {
            $recordModel = Vtiger_Record_Model::getInstanceById($record, "SubscribersList");
            $conditions = json_decode(base64_decode($recordModel->get("conditions")));
            $configuration = array(
                    'module' => $recordModel->get('module_name'),
                    'condition' => $conditions
            );
        } else {
            throw new Exception("List not found");
        }
      /*   $recordModel = Vtiger_Record_Model::getCleanInstance("SubscribersList");
            $toModule = "Contacts";
            $configuration = array(
                    'module' => $toModule,
                    'condition' => array()
            ); */
        
        $preset = new \SubscribersList\ComplexeCondition('condition', array(
                'fromModule' => '',
                'toModule' => $configuration['module'],
                'enableHasChanged' => false,
                'container' => 'conditionalPopupContainer',
                'enableTemplateFields' => false,
                'references' => true,
                'variables' => false,
                'disableTemplateFields' => true,
                'disableConditionMode' => true
        ));
//        echo '<pre>';var_dump($configuration);exit;
        $preset->InitViewer(array(
                array(
                        'condition' => $configuration['condition']
                ),
                $viewer
        )
                );
        
        $viewer->assign('ConditionScopeModule', $moduleName);
        
        $viewer->assign('toModule', $configuration['module']);
        $viewer->assign('title', "title");
        
        //$recordStructureInstance = Vtiger_RecordStructure_Model::getInstanceFromRecordModel($recordModel, Vtiger_RecordStructure_Model::RECORD_STRUCTURE_MODE_EDIT);
    
        echo $viewer->view('AdvanceFilter.tpl', $moduleName, true);
    }    
    /**
     * Function to display the UI for advance search on any of the module
     * @param Vtiger_Request $request
     */
    function showAdvancedSearch(Vtiger_Request $request) {
        //Modules for which search is excluded
        $excludedModuleForSearch = array('Vtiger');

        $viewer = $this->getViewer($request);
        $moduleName = $request->getModule();

        if ($request->get('source_module')) {
            $moduleName = $request->get('source_module');
        }
        if ($request->get('record')) {
            $record = $request->get('record');
        } else {
            $customView = new CustomView();
            $record = $customView->getViewId($moduleName);
        }

        $saveFilterPermitted = true;
        $saveFilterexcludedModules = array('ModComments', 'RSS', 'Portal', 'Integration', 'PBXManager', 'DashBoard');
        if (in_array($moduleName, $saveFilterexcludedModules)) {
            $saveFilterPermitted = false;
        }

        //See if it is an excluded module, If so search in home module
        if (in_array($moduleName, $excludedModuleForSearch)) {
            $moduleName = 'Home';
        }
        $module = $request->getModule();

        if (!empty($record)) {
            $customViewModel = CustomView_Record_Model::getInstanceById($record);
            $viewer->assign('MODE', 'edit');
        } else {
            $customViewModel = new CustomView_Record_Model();
            $customViewModel->setModule($moduleName);
            $viewer->assign('MODE', '');
        }

        $moduleModel = Vtiger_Module_Model::getInstance($moduleName);
        $recordStructureInstance = Vtiger_RecordStructure_Model::getInstanceForModule($moduleModel);

        $viewer->assign('SEARCHABLE_MODULES', EmailCampaigns_Module_Model::getSearchableModules());
        $viewer->assign('CUSTOMVIEW_MODEL', $customViewModel);

        $viewer->assign('ADVANCE_CRITERIA', $customViewModel->transformToNewAdvancedFilter());
        $viewer->assign('CURRENTDATE', date('Y-n-j'));


        if ($moduleName == 'Calendar') {
            $advanceFilterOpsByFieldType = Calendar_Field_Model::getAdvancedFilterOpsByFieldType();
        } else {
            $advanceFilterOpsByFieldType = Vtiger_Field_Model::getAdvancedFilterOpsByFieldType();
        }
        $viewer->assign('ADVANCED_FILTER_OPTIONS', Vtiger_Field_Model::getAdvancedFilterOptions());
        $viewer->assign('ADVANCED_FILTER_OPTIONS_BY_TYPE', $advanceFilterOpsByFieldType);
        $dateFilters = Vtiger_Field_Model::getDateFilterTypes();
        foreach ($dateFilters as $comparatorKey => $comparatorInfo) {
            $comparatorInfo['startdate'] = DateTimeField::convertToUserFormat($comparatorInfo['startdate']);
            $comparatorInfo['enddate'] = DateTimeField::convertToUserFormat($comparatorInfo['enddate']);
            $comparatorInfo['label'] = vtranslate($comparatorInfo['label'], $module);
            $dateFilters[$comparatorKey] = $comparatorInfo;
        }
        $viewer->assign('DATE_FILTERS', $dateFilters);
        $viewer->assign('RECORD_STRUCTURE', $recordStructureInstance->getStructure());
        $viewer->assign('SOURCE_MODULE', $moduleName);
        $viewer->assign('SOURCE_MODULE_MODEL', $moduleModel);
        $viewer->assign('MODULE', $module);
        $viewer->assign('VIEWID', $record);
        $viewer->assign('RECORD_ID', $record);
        $viewer->assign('CUSTOM_VIEWS', CustomView_Record_Model::getAllByGroup($moduleName));
        $viewer->assign('SAVE_FILTER_PERMITTED', $saveFilterPermitted);
        echo $viewer->view('AdvanceSearch.tpl', $module, true);
    }

}
