<?php

error_reporting(0);
/* +********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * ******************************************************************************* */

chdir(dirname(__FILE__) . '/../../');

include_once 'include/Webservices/Relation.php';
include_once 'include/Webservices/Revise.php';
require_once ('config.inc.php');
require_once ('include/database/PearDatabase.php');
include_once 'vtlib/Vtiger/Module.php';
include_once 'includes/Loader.php';
require_once ('include/utils/utils.php');
vimport('includes.runtime.EntryPoint');

class EmailCampaigns_Unsubscriber {

    public function Unsubscriber($request) {
        $id = $request['recordid'];
        $modulename = $request['modulename'];

        $adb = PearDatabase::getInstance();
        $unsuball = $adb->pquery("select * from vtiger_emailcampaign_outgoingserverdetail where id = 1 and isremoveduplicate=1", array());
        $numrows = $adb->num_rows($unsuball);
        $model = Vtiger_Record_Model::getInstanceById($id, $modulename);

        $user = new Users();
        $current_user = $user->retrieveCurrentUserInfoFromFile(Users::getActiveAdminId());
        $date_var = date("Y-m-d H:i:s");
        try {
            include_once 'modules/' . $modulename . '/models/Record.php';
            $rModelClass = $modulename . '_Record_Model';
            $rModel = $rModelClass::getInstanceById($id);

            if ($rModel->get('emailcampaign_optout') != 1) {
                $adb->pquery('UPDATE vtiger_crmentity SET modifiedtime=?, modifiedby=? where crmid=?', array($date_var, $current_user->id, $id));
                if ($modulename == 'Leads') {
                    $adb->pquery('UPDATE vtiger_leaddetails SET emailcampaign_optout=? where leadid=?', array(1, $id));
                } else if ($modulename == 'Contacts') {
                    $adb->pquery('UPDATE vtiger_contactdetails SET emailcampaign_optout=? where contactid=?', array(1, $id));
                } else if ($modulename == 'Accounts') {
                    $adb->pquery('UPDATE vtiger_account SET emailcampaign_optout=? where accountid=?', array(1, $id));
                }
                updateModTracker($id, $current_user, $modulename, $rModel->get('emailcampaign_optout'), 1, 'emailcampaign_optout', $date_var);
            }
        } catch (WebServiceException $ex) {
            echo $ex->getMessage();
        }

        if ($modulename == 'Contacts') {
            $fieldname = $adb->pquery("SELECT columnname FROM vtiger_emailcampaign_outgoingserverdetail o INNER JOIN vtiger_field f on f.fieldid=o.mapping_cont", array())->fields["columnname"];
            $email = $model->get($fieldname);
        } elseif ($modulename == 'Accounts') {
            $fieldname = $adb->pquery("SELECT columnname FROM vtiger_emailcampaign_outgoingserverdetail o INNER JOIN vtiger_field f on f.fieldid=o.mapping_acc", array())->fields["columnname"];
            $email = $model->get($fieldname);
        } elseif ($modulename == 'Leads') {
            $fieldname = $adb->pquery("SELECT columnname FROM vtiger_emailcampaign_outgoingserverdetail o INNER JOIN vtiger_field f on f.fieldid=o.mapping_lead", array())->fields["columnname"];
            $email = $model->get($fieldname);
        }

        if ($email != '' && $numrows > 0) {
            if ($modulename == 'Contacts') {
                $query2 = "SELECT co.contactid, co.emailcampaign_optout FROM `vtiger_contactdetails` co INNER JOIN vtiger_crmentity c on c.crmid=co.contactid INNER JOIN vtiger_contactscf cf on cf.contactid=co.contactid WHERE deleted=0 AND " . $fieldname . " = ? ";
                $result = $adb->pquery($query2, array($email));
                if ($adb->num_rows($result) > 0) {
                    while ($row = $adb->fetch_array($result)) {
                        if ($row['emailcampaign_optout'] != 1) {
                            $adb->pquery('UPDATE vtiger_crmentity SET modifiedtime=?, modifiedby=? where crmid=?', array($date_var, $current_user->id, $row['contactid']));
                            $adb->pquery('UPDATE vtiger_contactdetails SET emailcampaign_optout=? where contactid=?', array(1, $row['contactid']));
                            $this->updateModTracker($row['contactid'], $current_user, 'Contacts', $row['emailcampaign_optout'], 1, 'emailcampaign_optout', $date_var);
                        }
                    }
                }
            }
            if ($modulename == 'Leads') {
                $query2 = "SELECT ld.leadid, ld.emailcampaign_optout FROM `vtiger_leaddetails` ld INNER JOIN vtiger_crmentity c on c.crmid=ld.leadid INNER JOIN vtiger_leadscf cf on cf.leadid=ld.leadid WHERE deleted=0 AND " . $fieldname . " = ? ";
                $result = $adb->pquery($query2, array($email));
                if ($adb->num_rows($result) > 0) {
                    while ($row = $adb->fetch_array($result)) {
                        if ($row['emailcampaign_optout'] != 1) {
                            $adb->pquery('UPDATE vtiger_crmentity SET modifiedtime=?, modifiedby=? where crmid=?', array($date_var, $current_user->id, $row['leadid']));
                            $adb->pquery('UPDATE vtiger_leaddetails SET emailcampaign_optout=? where leadid=?', array(1, $row['leadid']));
                            $this->updateModTracker($row['leadid'], $current_user, 'Leads', $row['emailcampaign_optout'], 1, 'emailcampaign_optout', $date_var);
                        }
                    }
                }
            }
            if ($modulename == 'Accounts') {
                $query2 = "SELECT ac.accountid, ac.emailcampaign_optout FROM `vtiger_account` ac INNER JOIN vtiger_crmentity c on c.crmid=ac.accountid INNER JOIN vtiger_accountscf cf on cf.accountid=ac.accountid WHERE deleted=0 AND " . $fieldname . " = ? ";
                $result = $adb->pquery($query2, array($email));
                if ($adb->num_rows($result) > 0) {
                    while ($row = $adb->fetch_array($result)) {
                        if ($row['emailcampaign_optout'] != 1) {
                            $adb->pquery('UPDATE vtiger_crmentity SET modifiedtime=?, modifiedby=? where crmid=?', array($date_var, $current_user->id, $row['accountid']));
                            $adb->pquery('UPDATE vtiger_account SET emailcampaign_optout=? where accountid=?', array(1, $row['accountid']));
                            $this->updateModTracker($row['accountid'], $current_user, 'Accounts', $row['emailcampaign_optout'], 1, 'emailcampaign_optout', $date_var);
                        }
                    }
                }
            }
        }

        $query = "select * from vtiger_emailcampaign_setting where id = 1";
        $result = $adb->query($query);
        if ($adb->num_rows($result) > 0) {
            $landingpage = nl2br($adb->query_result($result, 0, 'unsubscribed'));
            echo html_entity_decode($landingpage);
        } else {
            echo "<h2>You are successfully unsubscribed from our newsletter</h2>";
        }
    }
    
    /**
     * 
     * @param Int $recordId
     * @param Object $current_user User_Record_Model
     * @param String $moduleName
     * @param Mixed $preValue
     * @param Mixed $currentValue
     * @param String $fieldName
     * @param DateTime $changedOn
     */
    private function updateModTracker($recordId, $current_user, $moduleName, $preValue, $currentValue, $fieldName, $changedOn) {
        $adb = \PearDatabase::getInstance();
        $status = 0;
        $id = $adb->getUniqueId('vtiger_modtracker_basic');
        $adb->pquery('INSERT INTO vtiger_modtracker_basic(id, crmid, module, whodid, changedon, status)
										VALUES(?,?,?,?,?,?)', Array($id, $recordId, $moduleName,
            $current_user->id, $changedOn, $status));

        $adb->pquery('INSERT INTO vtiger_modtracker_detail(id,fieldname,prevalue,postvalue) VALUES(?,?,?,?)', Array($id, $fieldName, $preValue, $currentValue));
    }

}