<?php
/* +***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * *********************************************************************************** */
require_once 'config.inc.php';
global $root_directory;
require_once($root_directory . "/modules/SubscribersList/autoload_wf.php");

class EmailCampaigns_Record_Model extends Vtiger_Record_Model
{

    public function getCampaignModuleList()
    {
        $moduleList = array(
            "Leads",
            'Accounts',
            'Contacts'
        );
        return $moduleList;
    }

    public function getDetailViewUrl()
    {
        $id = Vtiger_Record_Model::getId($moduleName);
        return 'index.php?module=EmailCampaigns&view=Detail&record=' . $id;
    }

    public function getScheduledReport()
    {
        return EmailCampaigns_ScheduleEmailCampaigns_Model::getInstanceById($this->getId());
    }

    public function getAllModuleList()
    {
        $db = PearDatabase::getInstance();
        $query = 'SELECT DISTINCT(name) AS modulename FROM vtiger_tab
        LEFT JOIN vtiger_field ON vtiger_field.tabid = vtiger_tab.tabid
        WHERE vtiger_field.uitype = ? ';
        $result = $db->pquery($query, array(
            13
        ));
        $num_rows = $db->num_rows($result);
        $moduleList = array();
        for ($i = 0; $i < $num_rows; $i++) {
            $moduleList[] = $db->query_result($result, $i, 'modulename');
        }

        return $moduleList;
    }

    public function getEmailTemplateFields()
    {
        return $this->getModule()->getAllModuleEmailTemplateFields();
    }

    public function getRelatedFields($module, $currentUserModel)
    {
        $handler = vtws_getModuleHandlerFromName($module, $currentUserModel);
        $meta = $handler->getMeta();
        $moduleFields = $meta->getModuleFields();
        $returnData = array();
        foreach ($moduleFields as $key => $field) {
            $referencelist = array();
            $relatedField = $field->getReferenceList();
            if ($field->getFieldName() == 'assigned_user_id') {
                $relModule = 'Users';
                $referencelist = $this->getRelatedModuleFieldList($relModule, $currentUserModel);
            }

            if (!empty($relatedField)) {
                foreach ($relatedField as $ind => $relModule) {
                    $referencelist = $this->getRelatedModuleFieldList($relModule, $currentUserModel);
                }
            }

            $returnData[] = array(
                'module' => $module,
                'fieldname' => $field->getFieldName(),
                'columnname' => $field->getColumnName(),
                'fieldlabel' => $field->getFieldLabelKey(),
                'referencelist' => $referencelist
            );
        }

        return $returnData;
    }

    public function getRelatedModuleFieldList($relModule, $user)
    {
        $handler = vtws_getModuleHandlerFromName($relModule, $user);
        $relMeta = $handler->getMeta();
        if (!$relMeta->isModuleEntity()) {
            return null;
        }

        $relModuleFields = $relMeta->getModuleFields();
        $relModuleFieldList = array();
        foreach ($relModuleFields as $relind => $relModuleField) {
            if ($relModule == 'Users') {
                if ($relModuleField->getFieldDataType() == 'string' || $relModuleField->getFieldDataType() == 'email' || $relModuleField->getFieldDataType() == 'phone') {
                    $skipFields = array(
                        98,
                        115,
                        116,
                        31,
                        32
                    );
                    if (!in_array($relModuleField->getUIType(), $skipFields) && $relModuleField->getFieldName() != 'asterisk_extension') {
                        $relModuleFieldList[] = array(
                            'module' => $relModule,
                            'fieldname' => $relModuleField->getFieldName(),
                            'columnname' => $relModuleField->getColumnName(),
                            'fieldlabel' => $relModuleField->getFieldLabelKey()
                        );
                    }
                }
            } else {
                $relModuleFieldList[] = array(
                    'module' => $relModule,
                    'fieldname' => $relModuleField->getFieldName(),
                    'columnname' => $relModuleField->getColumnName(),
                    'fieldlabel' => $relModuleField->getFieldLabelKey()
                );
            }
        }

        return $relModuleFieldList;
    }

    public function getEmailCampaignRecordRelatedModule($campaignid)
    {
        $db = PearDatabase::getInstance();
        $related_module_query = "SELECT * FROM vtiger_emailcamp_sendemail
        INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid  = vtiger_emailcamp_sendemail.related_id
        where vtiger_emailcamp_sendemail.emailcampaignsid = ?";
        $related_module_result = $db->pquery($related_module_query, array(
            $campaignid
        ));
        return $db->query_result($related_module_result, 0, 'setype');
    }

    public function getSubscribers($campaignid, $optout, $limit = null, $module = 'Accounts')
    {
        $db = PearDatabase::getInstance();
        if ($module == 'Leads') {
            $query = "   SELECT vtiger_leaddetails.leadid as idfield,
            concat(vtiger_leaddetails.firstname,' ',vtiger_leaddetails.lastname) as namefield,
            vtiger_leaddetails.email as emailfield, 'Leads' as modulefield
            FROM vtiger_emailcamp_sendemail
            INNER JOIN vtiger_leaddetails ON vtiger_leaddetails.leadid = vtiger_emailcamp_sendemail.related_id
            WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
            AND (vtiger_leaddetails.emailcampaign_optout=?)";
            if ($limit) {
                $query .= $limit;
            }

            return $db->pquery($query, array(
                    $campaignid,
                    $optout
            ));
        } else if ($module == 'Contacts') {
            $query = "SELECT vtiger_contactdetails.contactid as idfield,
            concat(vtiger_contactdetails.firstname,' ',vtiger_contactdetails.lastname) as namefield,
            vtiger_contactdetails.email as emailfield, 'Contacts' as modulefield
            FROM vtiger_emailcamp_sendemail
            INNER JOIN vtiger_contactdetails ON vtiger_contactdetails.contactid = vtiger_emailcamp_sendemail.related_id
            WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
            AND (vtiger_contactdetails.emailcampaign_optout=?)";
            if ($limit) {
                $query .= $limit;
            }

            return $db->pquery($query, array(
                    $campaignid,
                    $optout
            ));
        } else if ($module == 'Accounts') {
            $query = "SELECT vtiger_account.accountid as idfield,
            vtiger_account.accountname as namefield,
            vtiger_account.email1 as emailfield, 'Accounts' as modulefield
            FROM vtiger_emailcamp_sendemail
            INNER JOIN vtiger_account ON vtiger_account.accountid = vtiger_emailcamp_sendemail.related_id
            WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
            AND (vtiger_account.emailcampaign_optout=?)";
            if ($limit) {
                $query .= $limit;
            }

            return $db->pquery($query, array(
                    $campaignid,
                    $optout
            ));
        } else if ($module == 'All') {
            $query = "  SELECT vtiger_leaddetails.leadid as idfield,
            concat(vtiger_leaddetails.firstname,' ',vtiger_leaddetails.lastname) as namefield,
            vtiger_leaddetails.email as emailfield, 'Leads' as modulefield
            FROM vtiger_emailcamp_sendemail
            INNER JOIN vtiger_leaddetails ON vtiger_leaddetails.leadid = vtiger_emailcamp_sendemail.related_id
            WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
            AND (vtiger_leaddetails.emailcampaign_optout=?)
            UNION
            SELECT vtiger_contactdetails.contactid as idfield,
            concat(vtiger_contactdetails.firstname,' ',vtiger_contactdetails.lastname) as namefield,
            vtiger_contactdetails.email as emailfield, 'Contacts' as modulefield
            FROM vtiger_emailcamp_sendemail
            INNER JOIN vtiger_contactdetails ON vtiger_contactdetails.contactid = vtiger_emailcamp_sendemail.related_id
            WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
            AND (vtiger_contactdetails.emailcampaign_optout=?)
            UNION
            SELECT vtiger_account.accountid as idfield,
            vtiger_account.accountname as namefield,
            vtiger_account.email1 as emailfield, 'Accounts' as modulefield
            FROM vtiger_emailcamp_sendemail
            INNER JOIN vtiger_account ON vtiger_account.accountid = vtiger_emailcamp_sendemail.related_id
            WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
            AND (vtiger_account.emailcampaign_optout=?)";
            if ($limit) {
                $query .= $limit;
            }

            return $db->pquery($query, array(
                    $campaignid,
                    $optout,
                    $campaignid,
                    $optout,
                    $campaignid,
                    $optout
            ));
        }
    }

    public function getSubscribersWithShar($campaignid, $optout, $limit = null, $module = 'All')
    {

        global $current_user;
        $db = PearDatabase::getInstance();
        if ($module == 'Leads') {
            $query = "SELECT vtiger_leaddetails.leadid as idfield,
            concat(vtiger_leaddetails.firstname,' ',vtiger_leaddetails.lastname) as namefield,
            vtiger_leaddetails.email as emailfield, 'Leads' as modulefield
            FROM vtiger_emailcamp_sendemail
            INNER JOIN vtiger_leaddetails ON vtiger_leaddetails.leadid = vtiger_emailcamp_sendemail.related_id
            INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_leaddetails.leadid ";
            if ($current_user->is_admin != "on") {
                $crmentity = new CRMEntity();
                $query .= $crmentity->getNonAdminAccessControlQuery('Leads', $current_user);
            }

            $query .= " WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
            AND (vtiger_leaddetails.emailcampaign_optout=?) and issent=1";
        } else if ($module == 'Contacts') {
            $query = "SELECT vtiger_contactdetails.contactid as idfield,
            concat(vtiger_contactdetails.firstname,' ',vtiger_contactdetails.lastname) as namefield,
            vtiger_contactdetails.email as emailfield, 'Contacts' as modulefield
            FROM vtiger_emailcamp_sendemail
            INNER JOIN vtiger_contactdetails ON vtiger_contactdetails.contactid = vtiger_emailcamp_sendemail.related_id
            INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_contactdetails.contactid ";
            if ($current_user->is_admin != "on") {
                $crmentity = new CRMEntity();
                $query .= $crmentity->getNonAdminAccessControlQuery('Contacts', $current_user);
            }

            $query .= " WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
            AND (vtiger_contactdetails.emailcampaign_optout=?)";
        } else if ($module == 'Accounts') {
            $query = "SELECT vtiger_account.accountid as idfield,
            vtiger_account.accountname as namefield,
            vtiger_account.email1 as emailfield, 'Accounts' as modulefield
            FROM vtiger_emailcamp_sendemail
            INNER JOIN vtiger_account ON vtiger_account.accountid = vtiger_emailcamp_sendemail.related_id
            INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_account.accountid ";
            if ($current_user->is_admin != "on") {
                $crmentity = new CRMEntity();
                $query .= $crmentity->getNonAdminAccessControlQuery('Accounts', $current_user);
            }

            $query .= " WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
            AND (vtiger_account.emailcampaign_optout=?) and issent=1";
        } else if ($module == 'All') {
            $query = "  SELECT vtiger_leaddetails.leadid as idfield,
            concat(vtiger_leaddetails.firstname,' ',vtiger_leaddetails.lastname) as namefield,
            vtiger_leaddetails.email as emailfield, 'Leads' as modulefield
            FROM vtiger_emailcamp_sendemail
            INNER JOIN vtiger_leaddetails ON vtiger_leaddetails.leadid = vtiger_emailcamp_sendemail.related_id
            INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_leaddetails.leadid ";
            if ($current_user->is_admin != "on") {
                $crmentity = new CRMEntity();
                $query .= $crmentity->getNonAdminAccessControlQuery('Leads', $current_user);
            }

            $query .= " WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
            AND (vtiger_leaddetails.emailcampaign_optout=?) and issent=1
            UNION
            SELECT vtiger_contactdetails.contactid as idfield,
            concat(vtiger_contactdetails.firstname,' ',vtiger_contactdetails.lastname) as namefield,
            vtiger_contactdetails.email as emailfield, 'Contacts' as modulefield
            FROM vtiger_emailcamp_sendemail
            INNER JOIN vtiger_contactdetails ON vtiger_contactdetails.contactid = vtiger_emailcamp_sendemail.related_id
            INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_contactdetails.contactid ";
            if ($current_user->is_admin != "on") {
                $crmentity = new CRMEntity();
                $query .= $crmentity->getNonAdminAccessControlQuery('Contacts', $current_user);
            }

            $query .= " WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
            AND (vtiger_contactdetails.emailcampaign_optout=?) and issent=1
            UNION
            SELECT vtiger_account.accountid as idfield,
            vtiger_account.accountname as namefield,
            vtiger_account.email1 as emailfield, 'Accounts' as modulefield
            FROM vtiger_emailcamp_sendemail
            INNER JOIN vtiger_account ON vtiger_account.accountid = vtiger_emailcamp_sendemail.related_id
            INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_account.accountid ";
            if ($current_user->is_admin != "on") {
                $crmentity = new CRMEntity();
                $query .= $crmentity->getNonAdminAccessControlQuery('Accounts', $current_user);
            }

            $query .= " WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
            AND (vtiger_account.emailcampaign_optout=?) and issent=1
            ";


            if ($limit) {
                $query .= $limit;
            }

            return $db->pquery($query, array(
                    $campaignid,
                    $optout,
                    $campaignid,
                    $optout,
                    $campaignid,
                    $optout
            ));
        }
        if ($limit) {
            $query .= $limit;
        }

        return $db->pquery($query, array(
                $campaignid,
                $optout
        ));
    }

    public function getClickedEmailsUnique($campaignid)
    {
        $db = PearDatabase::getInstance();
        $query = "SELECT '1' FROM vtiger_emailtrackingreport WHERE emailcampaignsid=? AND email_click<>''";
        $result = $db->pquery($query, array($campaignid));
        $numtot = $db->num_rows($result);
        return $numtot;
    }

    public function getUniqueLinkClickRecords($campaignid, $limit = null, $module = "Accounts")
    {
        global $current_user;
        $db = PearDatabase::getInstance();

        // $module = EmailCampaigns_Record_Model::getEmailCampaignRecordRelatedModule($campaignid);
        if ($module == 'Leads') {
            $table = 'vtiger_leaddetails ON vtiger_leaddetails.leadid';
        } else if ($module == 'Contacts') {
            $table = 'vtiger_contactdetails ON vtiger_contactdetails.contactid';
        } else if ($module == 'Accounts') {
            $table = 'vtiger_account ON vtiger_account.accountid';
        } else {
            $query = "SELECT u.* FROM (SELECT vtiger_account.accountname as name,vtiger_link_tracker.*,vtiger_account.email1 as email,'ACCOUNTS' as type FROM  vtiger_emailcamp_sendemail
            INNER JOIN vtiger_account ON vtiger_account.accountid = vtiger_emailcamp_sendemail.related_id
            INNER JOIN vtiger_link_tracker ON vtiger_link_tracker.emailid = vtiger_emailcamp_sendemail.activityid
            where vtiger_emailcamp_sendemail.emailcampaignsid = ? and vtiger_link_tracker.emailid<>0
            UNION
            SELECT concat(vtiger_leaddetails.firstname,' ',vtiger_leaddetails.lastname) as name,vtiger_link_tracker.*,vtiger_leaddetails.email,'LEADS' as type FROM  vtiger_emailcamp_sendemail
            INNER JOIN vtiger_leaddetails ON vtiger_leaddetails.leadid = vtiger_emailcamp_sendemail.related_id
            INNER JOIN vtiger_link_tracker ON vtiger_link_tracker.emailid = vtiger_emailcamp_sendemail.activityid
            where vtiger_emailcamp_sendemail.emailcampaignsid = ? and vtiger_link_tracker.emailid<>0
            UNION
            SELECT concat(vtiger_contactdetails.firstname,' ',vtiger_contactdetails.lastname) as name,vtiger_link_tracker.*,vtiger_contactdetails.email,'CONTACTS' as type  FROM  vtiger_emailcamp_sendemail
            INNER JOIN vtiger_contactdetails ON vtiger_contactdetails.contactid = vtiger_emailcamp_sendemail.related_id
            INNER JOIN vtiger_link_tracker ON vtiger_link_tracker.emailid = vtiger_emailcamp_sendemail.activityid
            where vtiger_emailcamp_sendemail.emailcampaignsid = ? and vtiger_link_tracker.emailid<>0) as u $limit
            ";
            return $db->pquery($query, array(
                    $campaignid,
                    $campaignid,
                    $campaignid
            ));
        }

        if ($module != 'All') {
            $query = "SELECT * FROM  vtiger_emailcamp_sendemail
            INNER JOIN $table = vtiger_emailcamp_sendemail.related_id
            INNER JOIN vtiger_link_tracker ON vtiger_link_tracker.emailid = vtiger_emailcamp_sendemail.activityid
            inner join vtiger_crmentity on vtiger_crmentity.crmid=vtiger_emailcamp_sendemail.related_id";
            if ($current_user->is_admin != "on") {
                $crmentity = new CRMEntity();
                $query .= $crmentity->getNonAdminAccessControlQuery($module, $current_user);
            }
            $query .= " where vtiger_emailcamp_sendemail.emailcampaignsid = ? and vtiger_link_tracker.emailid<>0 order by vtiger_link_tracker.link ASC $limit";
            return $db->pquery($query, array(
                    $campaignid
            ));
        }
    }

    public function getsingleUniqueLinkClickRecords($campaignid, $limit = null, $link, $url, $module = "Accounts")
    {
        global $current_user;


        // dev06 add new function

        $db = PearDatabase::getInstance();

        // $module = EmailCampaigns_Record_Model::getEmailCampaignRecordRelatedModule($campaignid);

        if ($module == 'Leads') {
            $table = 'INNER JOIN vtiger_leaddetails ON vtiger_leaddetails.leadid = vtiger_emailcamp_sendemail.related_id inner join vtiger_crmentity on vtiger_crmentity.crmid = vtiger_leaddetails.leadid ';
        } else if ($module == 'Contacts') {
            $table = 'INNER JOIN vtiger_contactdetails ON vtiger_contactdetails.contactid = vtiger_emailcamp_sendemail.related_id inner join vtiger_crmentity on vtiger_crmentity.crmid = vtiger_contactdetails.contactid ';
        } else if ($module == 'Accounts') {
            $table = 'INNER JOIN vtiger_account ON vtiger_account.accountid = vtiger_emailcamp_sendemail.related_id inner join vtiger_crmentity on vtiger_crmentity.crmid = vtiger_account.accountid ';
        } else {
            $query = "SELECT u.* FROM (SELECT concat(vtiger_leaddetails.firstname,' ',vtiger_leaddetails.lastname) as name, vtiger_leaddetails.email,'LEADS' as type,vtiger_leaddetails.leadid as id,vtiger_link_tracker.link,vtiger_link_tracker.url,vtiger_link_tracker.click FROM  vtiger_emailcamp_sendemail
            INNER JOIN vtiger_leaddetails ON vtiger_leaddetails.leadid = vtiger_emailcamp_sendemail.related_id inner join vtiger_crmentity on vtiger_crmentity.crmid = vtiger_leaddetails.leadid
            INNER JOIN vtiger_link_tracker ON vtiger_link_tracker.emailid = vtiger_emailcamp_sendemail.activityid
            where vtiger_emailcamp_sendemail.emailcampaignsid = ? and vtiger_link_tracker.link = ? and vtiger_link_tracker.url = ? and vtiger_link_tracker.emailid<>0
            UNION
            SELECT concat(vtiger_contactdetails.firstname,' ',vtiger_contactdetails.lastname) as name, vtiger_contactdetails.email,'CONTACTS' as type,vtiger_contactdetails.contactid as id,vtiger_link_tracker.link,vtiger_link_tracker.url,vtiger_link_tracker.click FROM  vtiger_emailcamp_sendemail
            INNER JOIN vtiger_contactdetails ON vtiger_contactdetails.contactid = vtiger_emailcamp_sendemail.related_id inner join vtiger_crmentity on vtiger_crmentity.crmid = vtiger_contactdetails.contactid
            INNER JOIN vtiger_link_tracker ON vtiger_link_tracker.emailid = vtiger_emailcamp_sendemail.activityid
            where vtiger_emailcamp_sendemail.emailcampaignsid = ? and vtiger_link_tracker.link = ? and vtiger_link_tracker.url = ? and vtiger_link_tracker.emailid<>0
            UNION
            SELECT vtiger_account.accountname, vtiger_account.email1 as email, 'ACCOUNTS' as type,vtiger_account.accountid as id,vtiger_link_tracker.link,vtiger_link_tracker.url,vtiger_link_tracker.click FROM  vtiger_emailcamp_sendemail
            INNER JOIN vtiger_account ON vtiger_account.accountid = vtiger_emailcamp_sendemail.related_id inner join vtiger_crmentity on vtiger_crmentity.crmid = vtiger_account.accountid
            INNER JOIN vtiger_link_tracker ON vtiger_link_tracker.emailid = vtiger_emailcamp_sendemail.activityid
            where vtiger_emailcamp_sendemail.emailcampaignsid = ? and vtiger_link_tracker.link = ? and vtiger_link_tracker.url = ? and vtiger_link_tracker.emailid<>0) as u order by name asc $limit";
            return $db->pquery($query, array(
                    $campaignid,
                    $link,
                    $url,
                    $campaignid,
                    $link,
                    $url,
                    $campaignid,
                    $link,
                    $url
            ));
        }

        if ($current_user->is_admin != "on") {
            $crmentity = new CRMEntity();
            $table .= $crmentity->getNonAdminAccessControlQuery($module, $current_user);
        }

        $query = "SELECT * FROM  vtiger_emailcamp_sendemail
        $table
        INNER JOIN vtiger_link_tracker ON vtiger_link_tracker.emailid = vtiger_emailcamp_sendemail.activityid
        where vtiger_emailcamp_sendemail.emailcampaignsid = ? and vtiger_link_tracker.link = ? and vtiger_link_tracker.url = ? and vtiger_link_tracker.emailid<>0 order by vtiger_link_tracker.link ASC $limit";
        return $db->pquery($query, array(
                $campaignid,
                $link,
                $url
        ));
    }

    public function getTotalEmails($campaignid)
    {

        global $current_user;
        $db = PearDatabase::getInstance();
        $campaignModuleList = EmailCampaigns_Record_Model::getCampaignModuleList();

        $query = "SELECT '1' FROM vtiger_emailcamp_sendemail WHERE emailcampaignsid=?";
        $result = $db->pquery($query, array(
            $campaignid
        ));
        $total = $db->num_rows($result);

        return $total;
    }

    public function getTotalSentEmailCount($campaignid)
    {

        global $current_user;
        $db = PearDatabase::getInstance();
        $campaignModuleList = EmailCampaigns_Record_Model::getCampaignModuleList();
        $total = 0;
        foreach ($campaignModuleList as $module) {
            $query = "SELECT * FROM  vtiger_emailtrackingreport
            INNER JOIN vtiger_emailcamp_sendemail ON vtiger_emailtrackingreport.emailtrackingreportid  = vtiger_emailcamp_sendemail.activityid ";
            if ($module == 'Leads') {
                $query .= " inner join vtiger_leaddetails on vtiger_leaddetails.leadid = vtiger_emailtrackingreport.parent_id " . "inner join vtiger_crmentity on vtiger_leaddetails.leadid = vtiger_crmentity.crmid";
            } elseif ($module == 'Accounts') {
                $query .= " inner join vtiger_account on vtiger_account.accountid = vtiger_emailtrackingreport.parent_id " . "inner join vtiger_crmentity on vtiger_account.accountid = vtiger_crmentity.crmid";
            } elseif ($module == 'Contacts') {
                $query .= " inner join vtiger_contactdetails on vtiger_contactdetails.contactid = vtiger_emailtrackingreport.parent_id " . "inner join vtiger_crmentity on vtiger_contactdetails.contactid = vtiger_crmentity.crmid";
            }

            if ($current_user->is_admin != "on") {
                $crmentity = new CRMEntity();
                $query .= $crmentity->getNonAdminAccessControlQuery($module, $current_user);
            }

            $query .= " WHERE vtiger_emailcamp_sendemail.emailcampaignsid=? AND vtiger_emailcamp_sendemail.issent=1 ";
            $result = $db->pquery($query, array(
                $campaignid
            ));
            $total += $db->num_rows($result);
        }

        return $total;
    }

    public function getUniqOpenCount($campaignid)
    {

        // VTCONN_TT17191 #RG Inizio

        global $current_user;
        $db = PearDatabase::getInstance();
        $campaignModuleList = EmailCampaigns_Record_Model::getCampaignModuleList();
        $total = 0;
        foreach ($campaignModuleList as $module) {
            $query = "SELECT *
            FROM vtiger_emailtrackingreport
            INNER JOIN vtiger_emailcamp_sendemail ON vtiger_emailcamp_sendemail.activityid  = vtiger_emailtrackingreport.emailtrackingreportid ";
            if ($module == 'Leads') {
                $query .= " inner join vtiger_leaddetails on vtiger_leaddetails.leadid = vtiger_emailtrackingreport.parent_id " . "inner join vtiger_crmentity on vtiger_leaddetails.leadid = vtiger_crmentity.crmid";
            } elseif ($module == 'Accounts') {
                $query .= " inner join vtiger_account on vtiger_account.accountid = vtiger_emailtrackingreport.parent_id " . "inner join vtiger_crmentity on vtiger_account.accountid = vtiger_crmentity.crmid";
            } elseif ($module == 'Contacts') {
                $query .= " inner join vtiger_contactdetails on vtiger_contactdetails.contactid = vtiger_emailtrackingreport.parent_id " . "inner join vtiger_crmentity on vtiger_contactdetails.contactid = vtiger_crmentity.crmid";
            }

            if ($current_user->is_admin != "on") {
                $crmentity = new CRMEntity();
                $query .= $crmentity->getNonAdminAccessControlQuery($module, $current_user);
            }

            $query .= " WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ? AND vtiger_emailtrackingreport.email_open > 0";
            $result = $db->pquery($query, array(
                $campaignid
            ));
            $total += $db->num_rows($result);
        }

        return $total;

        // VTCONN_TT17191 #RG Fine
    }

    public static function getLinkList($campaignid) {

        // VTCONN_TT17191 #RG Inizio
        global $current_user;

        // dev06 add url
        // dev06 change order by url to link

        $campaignModuleList = EmailCampaigns_Record_Model::getCampaignModuleList();
        $result = array();

        $db = PearDatabase::getInstance();

        foreach ($campaignModuleList as $module) {

            $query_links = "SELECT vtiger_link_tracker.link,vtiger_link_tracker.url,sum(click) as click
                            FROM vtiger_link_tracker
                            INNER JOIN vtiger_emailcamp_sendemail ON vtiger_link_tracker.emailid = vtiger_emailcamp_sendemail.activityid
                            AND vtiger_link_tracker.emailid<>0
                            INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_emailcamp_sendemail.related_id
                            AND vtiger_crmentity.setype = '$module' ";

            if ($current_user->is_admin != "on") {

                $crmentity = new CRMEntity();
                $query_links .= $crmentity->getNonAdminAccessControlQuery($module, $current_user);
            }

            $query_links .= "WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ? and issent=1 GROUP BY vtiger_link_tracker.url";

            $result_links = $db->pquery($query_links, array(
                $campaignid
            ));

            $count = $db->num_rows($result_links);

            $query_open_count = "SELECT count(vtiger_emailcamp_sendemail.related_id) AS open, vtiger_link_tracker.id
                                 FROM vtiger_link_tracker
                                 INNER JOIN vtiger_emailcamp_sendemail ON vtiger_link_tracker.emailid = vtiger_emailcamp_sendemail.activityid
                                 AND vtiger_link_tracker.emailid<>0
                                 INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_emailcamp_sendemail.related_id
                                 AND vtiger_crmentity.setype = '$module' ";

            if ($current_user->is_admin != "on") {
                $crmentity = new CRMEntity();
                $query_open_count .= $crmentity->getNonAdminAccessControlQuery($module, $current_user);
            }

            $query_open_count .= "WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ?
                                  AND vtiger_link_tracker.url = ? and issent=1
                                  GROUP BY vtiger_link_tracker.url ";

            for ($i = 0; $i < $count; $i++) {

                $linkname = $db->query_result($result_links, $i, 'link');
                $linkurl = $db->query_result($result_links, $i, 'url');
                $click = $db->query_result($result_links, $i, 'click');

                // @change t46572
                // check for &amp and replace if any for &
                if (strpos($linkurl, '&amp;') !== false) $linkurl = str_replace('amp;', '', $linkurl);
                //

                $result_open_count = $db->pquery($query_open_count, array(
                    $campaignid,
                    $linkurl
                ));

                $uniqe_open = $db->query_result($result_open_count, 0, 'open');
                $id = $db->query_result($result_open_count, 0, 'id');
                if ($result[$id]) {
                    $click = $click + $$result[$id][1];
                    $uniqe_open = $uniqe_open + $$result[$id][2];
                }

                $result[$id] = array(
                    $linkname,
                    $click,
                    $uniqe_open,
                    $linkurl
                );
            }
        }

        $newArr = array();

        foreach ($result as $key => $value) {

            $k = md5($value[0] . $value[3]);

            if (array_key_exists($k, $newArr)) {

                $newArr[$k][1] = $newArr[$k][1] + $value[1];
                $newArr[$k][2] = $newArr[$k][2] + $value[2];
            } else {
                $newArr[$k] = $value;
            }
        }

        $results = array();
        $count = 1;

        foreach ($newArr as $value) {

            $results[$count] = $value;
            $count++;
        }

        return $results;
        // VTCONN_TT17191 #RG Fine
    }
    // VTCONN_TT17192 #RG Inizio

    /**
     * Funzione che, dato un crmid del modulo EmailCampaigns, ritorna il numero di iscritti alla campagna
     * @param crmid $campaignid Il record id della campagna
     * @return integer Il numero di iscritti alla campagna
     */
    public static function getSubscribersCount($campaignid)
    {
        $db = PearDatabase::getInstance();
        $result = $db->pquery("SELECT related_recorts FROM vtiger_emailcampaigns WHERE emailcampaignsid=?", array(
            $campaignid
        ));
        $related_recorts = $db->query_result($result, 0, 'related_recorts');
        return count(explode(',', $related_recorts));
    }
    // VTCONN_TT17192 #RG Fine
    // VTCONN_TT17192 #RG Inizio

    /**
     * Funzione che, dato un crmid del modulo EmailCampaigns, ritorna il numero totale di click per la campagna
     * @param crmid $campaignid Il record id della campagna
     * @return integer Il numero di click totali della campagna
     */
    public static function getClickedLinksTotal($campaignid)
    {
        $db = PearDatabase::getInstance();
        $link_details = self::getLinkList($campaignid);
        $sum = 0;
        foreach ($link_details as $k => $details) {
            $sum += $details[2];
        }

        return $sum;
    }
    /* public function getClickedEmailsTotal($campaignid)
      {
      global $current_user;
      $db     = PearDatabase::getInstance();
      $query  = "SELECT * from vtiger_emailcamp_sendemail s
      INNER JOIN vtiger_link_tracker ON vtiger_link_tracker.emailid = s.activityid
      inner join vtiger_emailtrackingreport t on t.emailcampaignsid=s.emailcampaignsid
      inner join vtiger_crmentity on vtiger_crmentity.crmid=t.emailtrackingreportid";


      if ($current_user->is_admin != "on") {
      $crmentity = new CRMEntity();
      $query .= $crmentity->getNonAdminAccessControlQuery('EmailTrackingReport', $current_user);
      }
      $query.= " where s.emailcampaignsid=? group by related_id";

      $result = $db->pquery($query, array(
      $campaignid
      ));
      print_r( $result);
      return $db->num_rows($result);
      } */

    public function getClickedEmailsTotal($campaignid)
    {
        global $current_user;
        $numtot = 0;
        $db = PearDatabase::getInstance();
        $query = "SELECT * from vtiger_emailcamp_sendemail s
                  INNER JOIN vtiger_link_tracker ON vtiger_link_tracker.emailid = s.activityid
                  INNER JOIN vtiger_leaddetails l ON l.leadid=s.related_id
                  INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid=l.leadid ";

        if ($current_user->is_admin != "on") {
            $crmentity = new CRMEntity();
            $query .= $crmentity->getNonAdminAccessControlQuery('Leads', $current_user);
        }

        $query .= " where emailcampaignsid=? and s.activityid<>0";
        $result = $db->pquery($query, array($campaignid));
        $numtot += $db->num_rows($result);
        $query = "SELECT * from vtiger_emailcamp_sendemail s
                  INNER JOIN vtiger_link_tracker ON vtiger_link_tracker.emailid = s.activityid
                  INNER JOIN vtiger_contactdetails c oN c.contactid=s.related_id
                  INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid=c.contactid ";

        if ($current_user->is_admin != "on") {
            $crmentity = new CRMEntity();
            $query .= $crmentity->getNonAdminAccessControlQuery('Contacts', $current_user);
        }

        $query .= " where emailcampaignsid=? and s.activityid<>0";
        $result = $db->pquery($query, array($campaignid));
        $numtot += $db->num_rows($result);
        $query = "SELECT * from vtiger_emailcamp_sendemail s
                  INNER JOIN vtiger_link_tracker ON vtiger_link_tracker.emailid = s.activityid
                  INNER JOIN vtiger_account a ON a.accountid=s.related_id
                  INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid=a.accountid";

        if ($current_user->is_admin != "on") {
            $crmentity = new CRMEntity();
            $query .= $crmentity->getNonAdminAccessControlQuery('Accounts', $current_user);
        }

        $query .= " WHERE emailcampaignsid=? AND s.activityid<>0";
        $result = $db->pquery($query, array($campaignid));
        $numtot += $db->num_rows($result);
        return $numtot;
    }

    // VTCONN_TT17192 #RG Fine
    public function getEmailListByListType($listType, $listData)
    {
        global $vtiger_current_version;

        if ($vtiger_current_version <= "6.5.0") {
            return $this->getEmailListByListType6($listType, $listData);
        } else {
            return $this->getEmailListByListType7($listType, $listData);
        }
    }

    public function getEmailListByListType7($listType, $listData)
    {
        global $root_directory;
        global $adb;
        if (is_object($listData)) {
            $listData = (array) $listData;
        }

        if ($listType == 'fromlist') {
            $conditions = $listData['filter'];
            $data = $conditions['condition'];
            $module = $listData['data']['module'];
            $_POST["join"] = $listData['filter']['join'];

            if (!empty($data['condition'])) {
                $preset = new \SubscribersList\ComplexeCondition('condition', null, array());
                $condition = $preset->getCondition($data['condition']);
                //$text = $preset->getHTML($condition, $module);
            } else {
                $condition = '';
                //$text = '';
            }
            //$json = base64_encode(json_encode($condition));
            $cleanRecordModel = \SubscribersList\VTEntity::getForId('', $module);
            $obj = new \SubscribersList\ConditionMysql($module, $cleanRecordModel);
            $query = $obj->parse($condition);
            $tables = $obj->generateTables();
            $initialSql = 'SELECT * ' . $tables . ' '; // generic to numeric and count

            if (trim($query) != '') {
                $initialSql = $initialSql . ' WHERE deleted=0 AND ' . $query;
            } else {
                $initialSql = $initialSql . ' WHERE deleted=0 ';
            }
            $relResult = $adb->query($initialSql);

            $emails_list = array();

            //Selecting mapped fields for Email.
            if ($module == 'Contacts') {
                $fieldname = $adb->pquery("SELECT columnname FROM vtiger_emailcampaign_outgoingserverdetail o INNER JOIN vtiger_field f on f.fieldid=o.mapping_cont", array())->fields["columnname"];
            } elseif ($module == 'Accounts') {
                $fieldname = $adb->pquery("SELECT columnname FROM vtiger_emailcampaign_outgoingserverdetail o INNER JOIN vtiger_field f on f.fieldid=o.mapping_acc", array())->fields["columnname"];
            } elseif ($module == 'Leads') {
                $fieldname = $adb->pquery("SELECT columnname FROM vtiger_emailcampaign_outgoingserverdetail o INNER JOIN vtiger_field f on f.fieldid=o.mapping_lead", array())->fields["columnname"];
            }

            //for ($i = 0; $i < $count; $i++) {
            while ($row = $adb->fetchByAssoc($relResult)) {
                $row["emca_emailfield"] = trim($row["$fieldname"]);

                if (filter_var($row["emca_emailfield"], FILTER_VALIDATE_EMAIL) // L'email e' valida
                    && !in_array($row["emca_emailfield"], $emails_list) && $row["emailcampaign_optout"] == "0" // L'email non e' caricata
                ) {
                    // Allora inseriscilo
                    $emails_list[$row["crmid"]] = $row["emca_emailfield"];
                }
            }
        } else if ($listType == 'fromEmailcampaign') {

            // A previously sent campaign has been selected

            $whopenemail = $listData['whopenemail'];
            $emailclicklink = $listData['emailclicklink'];
            $notwhopenemail = $listData['notwhopenemail'];
            $notemailclicklink = $listData['notemailclicklink'];
            $allprevsubcribers = $listData['allprevsubcribers'];
            $parent_emailcampaignsid = $listData['parent_emailcampaignsid'];
            $params = array();
            if ($allprevsubcribers == '1') {
                $query = 'select vtiger_emailcamp_sendemail.related_id from vtiger_emailcamp_sendemail 
INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_emailcamp_sendemail.related_id 
where vtiger_emailcamp_sendemail.emailcampaignsid = ? AND vtiger_crmentity.deleted = 0';
                array_push($params, $parent_emailcampaignsid);
            } else {
                if ($emailclicklink == '1') {
                    $query = 'select vtiger_emailcamp_sendemail.related_id from vtiger_emailcamp_sendemail
                    INNER JOIN vtiger_link_tracker ON vtiger_link_tracker.emailid = vtiger_emailcamp_sendemail.activityid
                    inner join vtiger_crmentity c on c.crmid=vtiger_emailcamp_sendemail.related_id and deleted=0
                    where vtiger_link_tracker.click > 0 AND vtiger_emailcamp_sendemail.emailcampaignsid = ? and vtiger_link_tracker.emailid<>0';
                    array_push($params, $parent_emailcampaignsid);
                }

                if ($whopenemail == '1') {
                    if ($query != "")
                        $query .= " UNION ALL ";
                    $query .= 'select vtiger_emailcamp_sendemail.related_id from vtiger_emailcamp_sendemail
                    INNER JOIN vtiger_emailtrackingreport ON vtiger_emailtrackingreport.emailtrackingreportid = vtiger_emailcamp_sendemail.activityid
                    inner join vtiger_crmentity c on c.crmid=vtiger_emailcamp_sendemail.related_id and deleted=0
                    where vtiger_emailtrackingreport.email_open > 0 AND vtiger_emailcamp_sendemail.emailcampaignsid = ?';
                    array_push($params, $parent_emailcampaignsid);
                }

                if ($notwhopenemail == '1') {
                    if ($query != "")
                        $query .= " UNION ALL ";
                    $query .= " select vtiger_emailcamp_sendemail.related_id from vtiger_emailcamp_sendemail
                    INNER JOIN vtiger_emailtrackingreport ON vtiger_emailtrackingreport.emailtrackingreportid = vtiger_emailcamp_sendemail.activityid
                    inner join vtiger_crmentity c on c.crmid=vtiger_emailcamp_sendemail.related_id and deleted=0
                    where vtiger_emailtrackingreport.email_open < 1 AND vtiger_emailcamp_sendemail.emailcampaignsid = ? ";
                    array_push($params, $parent_emailcampaignsid);
                }

                if ($notemailclicklink == '1') {
                    if ($query != "")
                        $query .= " UNION ALL ";
                    $query .= " select vtiger_emailcamp_sendemail.related_id from vtiger_emailcamp_sendemail
                    INNER JOIN vtiger_emailtrackingreport ON vtiger_emailtrackingreport.emailtrackingreportid = vtiger_emailcamp_sendemail.activityid
                    inner join vtiger_crmentity c on c.crmid=vtiger_emailcamp_sendemail.related_id and deleted=0
                    where vtiger_emailtrackingreport.email_click < 1 AND vtiger_emailcamp_sendemail.emailcampaignsid = ? ";
                    array_push($params, $parent_emailcampaignsid);
                }
            }

            $result = $adb->pquery($query, $params);
            $count = $adb->num_rows($result);
            $related_list = array();
            for ($i = 0; $i < $count; $i++) {
                $related_list[] = $adb->query_result($result, $i, 'related_id');
            }

            $emails_list = array();
            foreach ($related_list as $k => $crmid) {
                if ($crmid != "") {
                    $mod = Vtiger_Record_Model::getInstanceById($crmid);
                    $module = $mod->getModuleName();
                    if ($module == 'Accounts') {
                        $fieldname = $adb->pquery("SELECT columnname FROM vtiger_emailcampaign_outgoingserverdetail o INNER JOIN vtiger_field f on f.fieldid=o.mapping_acc", array())->fields["columnname"];
                        $email = $mod->get($fieldname);
                    } elseif ($module == 'Leads') {
                        $fieldname = $adb->pquery("SELECT columnname FROM vtiger_emailcampaign_outgoingserverdetail o INNER JOIN vtiger_field f on f.fieldid=o.mapping_lead", array())->fields["columnname"];
                        $email = $mod->get($fieldname);
                    } elseif ($module == 'Contacts') {
                        $fieldname = $adb->pquery("SELECT columnname FROM vtiger_emailcampaign_outgoingserverdetail o INNER JOIN vtiger_field f on f.fieldid=o.mapping_cont", array())->fields["columnname"];
                        $email = $mod->get($fieldname);
                    }

                    if (in_array(strtolower($email), $emails_list)) {
                        unset($related_list[$k]);
                    } else {
                        $emails_list[$crmid] = strtolower($email);
                    }
                } else {
                    unset($related_list[$k]);
                }
            }
            unset($related_list);
        } else if ($listType == 'fromReport') {
            $parent_reportid = $listData['reportId'];
            $parent_reportmodule = $listData['reportModule'];

            switch ($parent_reportmodule) {
                case "Contacts":
                    $mapping = "mapping_cont";
                    $crmidc = "contactid";
                    break;
                case "Leads":
                    $mapping = "mapping_lead";
                    $crmidc = "leadid";
                    break;
                case "Accounts":
                    $mapping = "mapping_acc";
                    $crmidc = "accountid";
                    break;
            }

            $result_field = $adb->pquery("SELECT tablename,columnname FROM vtiger_emailcampaign_outgoingserverdetail o INNER JOIN vtiger_field f on f.fieldid=o." . $mapping . " LIMIT 1", array());
            while ($row = $adb->fetch_array($result_field)) {
                $table = $row['tablename'];
                $emailc = $table . "." . $row['columnname'];
                $crmidc = $table . "." . $crmidc;
            }

            // Get the report

            $reportModel = Reports_Record_Model::getInstanceById($parent_reportid);
            $reportModel->setModule('Reports');
            $sSQL = $reportModel->getReportSQL();


            $tmp = explode("from", strtolower($sSQL));
            if (count($tmp) > 2) {
                for ($i = 2; $i < count($tmp); $i++) {
                    $tmp[1] .= " FROM " . $tmp[$i];
                }
            }

            $tmp_sql = explode("order by", strtolower($tmp[1]));
            $sSQL = "SELECT DISTINCT coalesce(" . $crmidc . ",'') as crmid, coalesce(" . $emailc . ",'') as emca_emailfield FROM " . $tmp_sql[0];
            $result = $adb->pquery($sSQL, array());
            $emails_list = array();
            while ($row = $adb->fetchByAssoc($result)) {
                if ($row["crmid"] != "" && trim($row["emca_emailfield"]) != "" && filter_var(trim($row["emca_emailfield"]), FILTER_VALIDATE_EMAIL) && !in_array(trim($row["emca_emailfield"]), $emails_list)) {
                    $emails_list[$row["crmid"]] = trim($row["emca_emailfield"]);
                }
            }
        } else if ($listType == 'fromFlexReport') {
            $parent_reportid = $listData['reportId'];
            $parent_reportmodule = $listData['reportModule'];

            global $root_directory;
            require_once($root_directory . "/modules/RedooReports/autoload_wf.php");


            $report = \RedooReports\Report::getInstance($parent_reportid);
            $crmids = $report->getAffectedCRMIDs($parent_reportmodule);

            switch ($parent_reportmodule) {
                case "Contacts":
                    $mapping = "mapping_cont";
                    $crmidc = "contactid";
                    break;
                case "Leads":
                    $mapping = "mapping_lead";
                    $crmidc = "leadid";
                    break;
                case "Accounts":
                    $mapping = "mapping_acc";
                    $crmidc = "accountid";
                    break;
            }

            $result_field = $adb->pquery("SELECT tablename,columnname FROM vtiger_emailcampaign_outgoingserverdetail o INNER JOIN vtiger_field f on f.fieldid=o." . $mapping . " LIMIT 1", array());
            while ($row = $adb->fetch_array($result_field)) {
                $table = $row['tablename'];
                $emailc = $table . "." . $row['columnname'];
                $crmidc = $table . "." . $crmidc;
            }

            $sSQL = "SELECT coalesce(" . $emailc . ",'') as emca_emailfield FROM " . $table . " WHERE " . $crmidc . "= ? ";
            $emails_list = array();
            foreach ($crmids as $value) {

                $result = $adb->pquery($sSQL, array($value));
                while ($row = $adb->fetchByAssoc($result)) {
                    if (trim($row["emca_emailfield"]) != "" && filter_var(trim($row["emca_emailfield"]), FILTER_VALIDATE_EMAIL) && !in_array(trim($row["emca_emailfield"]), $emails_list)) {
                        $emails_list[$value] = trim($row["emca_emailfield"]);
                    }
                }
            }
        }

        return $emails_list;
    }

    public function getEmailListByListType6($listType, $listData)
    {
        $db = PearDatabase::getInstance();
        if (is_object($listData)) {
            $listData = get_object_vars($listData);
        }

        // SubScriper List Start

        if ($listType == 'subscriperList') {
            $module_name = $listData['moduleName'];
            $conditions = $listData['filter'];

            // This means they selected a list

            $wfCondition = array();
            if (!empty($conditions)) {
                if (is_object($conditions)) {
                    $conditions = get_object_vars($conditions);
                }

                foreach ($conditions as $index => $condition) {
                    if (is_object($condition)) {
                        $condition = get_object_vars($condition);
                    }

                    $columns = $condition['columns'];
                    if (!empty($columns) && is_array($columns) && $index == '1') {
                        foreach ($columns as $column) {
                            if (is_object($column)) {
                                $column = get_object_vars($column);
                            }

                            $wfCondition[] = array(
                                'fieldname' => $column['columnname'],
                                'operation' => $column['comparator'],
                                'value' => $column['value'],
                                'valuetype' => $column['valuetype'],
                                'joincondition' => $column['column_condition'],
                                'groupjoin' => $condition['condition'],
                                'groupid' => '0'
                            );
                        }
                    } else if (!empty($columns) && is_array($columns) && $index == '2') {
                        foreach ($columns as $column) {
                            if (is_object($column)) {
                                $column = get_object_vars($column);
                            }

                            $wfCondition[] = array(
                                'fieldname' => $column['columnname'],
                                'operation' => $column['comparator'],
                                'value' => $column['value'],
                                'valuetype' => $column['valuetype'],
                                'joincondition' => $column['column_condition'],
                                'groupjoin' => $condition['condition'],
                                'groupid' => '1'
                            );
                        }
                    }
                }
            }

            // $expr == $wfCondition;

            $listquery = getListQuery($module_name);
            $listviewquery = substr($listquery, strpos($listquery, 'FROM'), strlen($listquery));

            // VTCONN_TT17186 #RG Inizio

            /*
             */

            // Estrai in maniera un minimo deterministica, per il controllo duplicati/validi

            if ($module_name == 'Contacts') {
                $query = "select vtiger_crmentity.crmid as crmid, vtiger_contactdetails.email as emca_emailfield,
                vtiger_contactdetails.* " . $listviewquery . " AND coalesce(vtiger_contactdetails.emailcampaign_optout,0)=0";
            } else if ($module_name == 'Leads') {
                $query = "select vtiger_crmentity.crmid as crmid, vtiger_leaddetails.email as emca_emailfield,
                vtiger_leaddetails.* " . $listviewquery . " AND coalesce(vtiger_leaddetails.emailcampaign_optout,0)=0";
            } else if ($module_name == 'Accounts') {
                $query = "select vtiger_crmentity.crmid as crmid, vtiger_account.email1 as emca_emailfield,
                vtiger_account.* " . $listviewquery . " AND coalesce(vtiger_account.emailcampaign_optout,0)=0";
            }

            // VTCONN_TT17186 #RG Fine

            require_once 'include/utils/CommonUtils.php';

            require_once 'include/utils/VTCacheUtils.php';

            $skip_uitypes = array(
                '4'
            );
            $cachedModuleFields = VTCacheUtils::lookupFieldInfo_Module($module_name);
            $colf = Array();
            if ($cachedModuleFields) {
                foreach ($cachedModuleFields as $fieldinfo) {

                    // Skip non-supported fields

                    if (in_array($fieldinfo['uitype'], $skip_uitypes)) {
                        continue;
                    } else {
                        $colf[$fieldinfo['fieldname']] = $fieldinfo['uitype'];
                    }
                }
            }

            if (is_array($wfCondition)) {
                $groupResults = array();
                $expressionResults = array();
                $i = 0;
                $sqllist_1f = '';
                $sqllist_2f = '';
                foreach ($wfCondition as $cond) {
                    $conditionGroup = $cond['groupid'];
                    if (empty($conditionGroup))
                        $conditionGroup = 0;
                    preg_match('/(\w+) : \((\w+)\) (\w+)/', $cond['fieldname'], $matches);
                    $columnslist = $cond['fieldname'];

                    // echo "</br>".$columnslist."</br>";

                    if (isset($columnslist)) {
                        $tablefield = "";
                        if ($columnslist != "") {
                            $list = explode(":", $columnslist);

                            // Added For getting status for Activities -Jaguar

                            if ($colf[$list[2]] == '51' && $module_name == 'Contacts') {
                                $sqllist_column = "vtiger_account.accountname";
                            } else {

                                // Added For getting status for Activities -Jaguar

                                $sqllist_column = $list[0] . "." . $list[1];
                            }

                            if ($list[1] == "smownerid") {
                                $userNameSql = getSqlForNameInDisplayFormat(array(
                                    'first_name' => 'vtiger_users.first_name',
                                    'last_name' => 'vtiger_users.last_name'
                                    ), 'Users');
                                $sqllist_column = "case when (vtiger_users.user_name not like '') then trim($userNameSql) else vtiger_groups.groupname end";
                            }

                            if ($list[0] == "vtiger_contactdetails" && $list[1] == "lastname") {
                                $sqllist_column = "vtiger_contactdetails.lastname";
                            }

                            $sqllist = '';
                            $comparator = $cond['operation'];
                            $value = $cond['value'];
                            $advfiltersql = EmailCampaigns_SaveAjax_Action::getAdvComparator($comparator, trim($value), $list[4], $sqllist_column);
                        }

                        if ($conditionGroup == 0) {
                            $sqllist_1 = $sqllist . "" . $advfiltersql . " " . $cond['joincondition'] . " ";
                        } else if ($conditionGroup == 1) {
                            $sqllist_2 = $sqllist . "" . $advfiltersql . " " . $cond['joincondition'] . " ";
                        }

                        // $returnsql = implode(",", $sqllist);

                        if (isset($sqllist_1) && $sqllist_1 != '' && $conditionGroup == 0) {
                            $sqllist_1f .= $sqllist_1;
                        }

                        if (isset($sqllist_2) && $sqllist_2 != '' && $conditionGroup == 1) {
                            $sqllist_2f .= $sqllist_2;
                        }
                    }
                }

                if (isset($sqllist_1) && $sqllist_1 != '') {
                    $query .= " and (" . $sqllist_1f . ") ";
                }

                if (isset($sqllist_2) && $sqllist_2 != '') {
                    $query .= " and (" . $sqllist_2f . ")";
                }
            }
            $result = $db->pquery($query, array());
            $emails_list = array();

            // for ($i = 0; $i < $count; $i++) {

            while ($row = $db->fetchByAssoc($result)) {
                if (filter_var(trim($row["emca_emailfield"]), FILTER_VALIDATE_EMAIL) // L'email e' valida
                    && !in_array(trim($row["emca_emailfield"]), $emails_list) // L'email non e'  caricata
                ) {

                    // Allora inseriscilo

                    $emails_list[$row["crmid"]] = trim($row["emca_emailfield"]);
                }
            }
        } else if ($listType == 'fromEmailcampaign') {

            // A previously sent campaign has been selected

            $whopenemail = $listData['whopenemail'];
            $emailclicklink = $listData['emailclicklink'];
            $notwhopenemail = $listData['notwhopenemail'];
            $notemailclicklink = $listData['notemailclicklink'];
            $allprevsubcribers = $listData['allprevsubcribers'];
            $parent_emailcampaignsid = $listData['parent_emailcampaignsid'];
            $params = array();
            $db = PearDatabase::getInstance();
            if ($allprevsubcribers == '1') {
                $query = 'select vtiger_emailcamp_sendemail.related_id from vtiger_emailcamp_sendemail where vtiger_emailcamp_sendemail.emailcampaignsid = ? ';
                array_push($params, $parent_emailcampaignsid);
            } else {
                if ($emailclicklink == '1') {
                    $query = 'select vtiger_emailcamp_sendemail.related_id from vtiger_emailcamp_sendemail
                    INNER JOIN vtiger_link_tracker ON vtiger_link_tracker.emailid = vtiger_emailcamp_sendemail.activityid
                    where vtiger_link_tracker.click > 0 AND vtiger_emailcamp_sendemail.emailcampaignsid = ? and vtiger_link_tracker.emailid<>0';
                    array_push($params, $parent_emailcampaignsid);
                }

                if ($whopenemail == '1') {
                    if ($query != "")
                        $query .= " UNION ALL ";
                    $query .= 'select vtiger_emailcamp_sendemail.related_id from vtiger_emailcamp_sendemail
                    INNER JOIN vtiger_emailtrackingreport ON vtiger_emailtrackingreport.emailtrackingreportid = vtiger_emailcamp_sendemail.activityid
                    where vtiger_emailtrackingreport.email_open > 0 AND vtiger_emailcamp_sendemail.emailcampaignsid = ?';
                    array_push($params, $parent_emailcampaignsid);
                }

                if ($notwhopenemail == '1') {
                    if ($query != "")
                        $query .= " UNION ALL ";
                    $query .= " select vtiger_emailcamp_sendemail.related_id from vtiger_emailcamp_sendemail
                    INNER JOIN vtiger_emailtrackingreport ON vtiger_emailtrackingreport.emailtrackingreportid = vtiger_emailcamp_sendemail.activityid
                    where vtiger_emailtrackingreport.email_open < 1 AND vtiger_emailcamp_sendemail.emailcampaignsid = ? ";
                    array_push($params, $parent_emailcampaignsid);
                }

                if ($notemailclicklink == '1') {
                    if ($query != "")
                        $query .= " UNION ALL ";
                    $query .= " select vtiger_emailcamp_sendemail.related_id from vtiger_emailcamp_sendemail
                    INNER JOIN vtiger_emailtrackingreport ON vtiger_emailtrackingreport.emailtrackingreportid = vtiger_emailcamp_sendemail.activityid
                    where vtiger_emailtrackingreport.email_click < 1 AND vtiger_emailcamp_sendemail.emailcampaignsid = ? ";
                    array_push($params, $parent_emailcampaignsid);
                }
            }

            $result = $db->pquery($query, $params);
            $count = $db->num_rows($result);
            $related_list = '';
            for ($i = 0; $i < $count; $i++) {
                $related_list1 .= $related_list . '' . $db->query_result($result, $i, 'related_id');
                $related_list = ',';
            }

            //                echo '<pre>';var_dump($related_list1,$query,$params);exit;

            $db = PearDatabase::getInstance();
            $query_modulename = 'select module_name from vtiger_emailcampaigns where emailcampaignsid = ?';
            $result_modulename = $db->pquery($query_modulename, array(
                $parent_emailcampaignsid
            ));
            $module_name = $db->query_result($result_modulename, 0, 'module_name');
            $related_list1 = explode(',', $related_list1);
            $emails_list = array();
            foreach ($related_list1 as $k => $crmid) {
                if ($crmid != "") {
                    $mod = Vtiger_Record_Model::getInstanceById($crmid);
                    if ($mod->getModuleName() == "Accounts") {
                        $email = $mod->get("email1");
                    } else {
                        $email = $mod->get("email");
                    }

                    if (in_array($email, $emails_list)) {
                        unset($related_list1[$k]);
                    } else {
                        $emails_list[$crmid] = $email;
                    }
                } else {
                    unset($related_list1[$k]);
                }
            }

            unset($related_list1);
        } else if ($listType == 'fromReport') {
            $parent_reportid = $listData['reportId'];
            $parent_reportmodule = $listData['reportModule'];

            // Get the report

            $reportModel = Reports_Record_Model::getInstanceById($parent_reportid);
            $reportModel->setModule('Reports');
            $sSQL = $reportModel->getReportSQL();

            switch ($parent_reportmodule) {
                case "Contacts":
                    $mapping = "mapping_cont";
                    $crmidc = "contactid";
                    break;
                case "Leads":
                    $mapping = "mapping_lead";
                    $crmidc = "leadid";
                    break;
                case "Accounts":
                    $mapping = "mapping_acc";
                    $crmidc = "accountid";
                    break;
            }

            $result_field = $adb->pquery("SELECT tablename,columnname FROM vtiger_emailcampaign_outgoingserverdetail o INNER JOIN vtiger_field f on f.fieldid=o." . $mapping . " LIMIT 1", array());
            while ($row = $adb->fetch_array($result_field)) {
                $table = $row['tablename'];
                $emailc = $table . "." . $row['columnname'];
                $crmidc = $table . "." . $crmidc;
            }

            $tmp = explode("from", strtolower($sSQL));
            if (count($tmp) > 2) {
                for ($i = 2; $i < count($tmp); $i++) {
                    $tmp[1] .= " FROM " . $tmp[$i];
                }
            }

            $tmp_sql = explode("order by", strtolower($tmp[1]));
            $sSQL = "SELECT DISTINCT coalesce(" . $crmidc . ",'') as crmid, coalesce(" . $emailc . ",'') as emca_emailfield FROM " . $tmp_sql[0];
            $result = $db->pquery($sSQL, array());
            $emails_list = array();
            while ($row = $db->fetchByAssoc($result)) {
                if ($row["crmid"] != "" && trim($row["emca_emailfield"]) != "" && filter_var(trim($row["emca_emailfield"]), FILTER_VALIDATE_EMAIL) && !in_array(trim($row["emca_emailfield"]), $emails_list)) {
                    $emails_list[$row["crmid"]] = trim($row["emca_emailfield"]);
                }
            }
        }

        return $emails_list;
    }
}
