<?php

/* +***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * *********************************************************************************** */

class EmailCampaigns_DetailView_Model extends Vtiger_DetailView_Model {

    /**
     * Function to get the detail view links (links and widgets)
     * @param <array> $linkParams - parameters which will be used to calicaulate the params
     * @return <array> - array of link models in the format as below
     *                   array('linktype'=>list of link models);
     */
    public function getDetailViewLinks($linkParams) {

        $linkModelList = parent::getDetailViewLinks($linkParams);
        $moduleModel = $this->getModule();
        $recordModel = $this->getRecord();

        $moduleName = $moduleModel->getName();
        $recordId = $recordModel->getId();

        $releaselinkModel = array(
                             'linktype' => 'DETAILVIEW',
                             'linklabel' => sprintf("%s %s", getTranslatedString('LBL_CAMPAIGN_RELEASE', $moduleName), vtranslate('SINGLE_'. $moduleName, $moduleName)),
                             'linkurl' => sprintf('javascript:EmailCampaign_Detail_Js.releaseRecord("index.php?module=%s&action=Release&record=%d")', $moduleName, $recordId),
                             'linkicon' => ''
                        );

        $db = PearDatabase::getInstance();
        $res = $db->pquery("SELECT * FROM vtiger_scheduleemailcampagine WHERE emailcampaignsid = ?", array($this->getRecord()->getId()));

        if ($db->num_rows($res)) {

            foreach ($linkModelList["DETAILVIEWBASIC"] as $k => $item) {

                if ($item->getLabel() == "LBL_EDIT") {

                    unset($linkModelList["DETAILVIEWBASIC"][$k]);

                    // add the release option
                    // $linkModelList['DETAILVIEW'][] = Vtiger_Link_Model::getInstanceFromValues($releaselinkModel);
                    // add the release option - if testcampaign
                    $params = array($this->getRecord()->getId());
                    $query = "SELECT campaign_name FROM vtiger_emailcampaigns WHERE emailcampaignsid = ?";
                    $result = $db->pquery($query, $params);

                    $row = $db->fetchByAssoc($result);

                    $normalizedCampaignTitle = strtolower($row['campaign_name']);

                    // english
                    $testcampaignInString = strpos($normalizedCampaignTitle, 'testcampaign:', 0);

                    // dutch
                    if ($testcampaignInString === false) $testcampaignInString = strpos($normalizedCampaignTitle, 'testcampagne:', 0);

                    // found if it is not false - 0 means: begins at start of subject
                    if ($testcampaignInString === 0) {

                      $linkModelList['DETAILVIEW'][] = Vtiger_Link_Model::getInstanceFromValues($releaselinkModel);
                    }
                }
            }

            $statusCheck = array('LBL_CREATED', 'LBL_SCHEDULED');
            if (in_array($recordModel->get('campaign_status'), $statusCheck) && $res->fields['is_scheduled'] == 1) {
                if (Users_Privileges_Model::isPermitted($moduleName, 'EditView', $recordId)) {
                    $detailViewLink = array(
                        'linktype' => 'DETAILVIEWBASIC',
                        'linklabel' => 'LBL_EDIT_SCHEDULER',
                        'linkurl' => 'javascript:EmailCampaigns_Detail_Js.loadSchedulerForm(' . $recordId . ');',
                        'linkicon' => ''
                    );

                    $linkModelList['DETAILVIEWBASIC'][] = Vtiger_Link_Model::getInstanceFromValues($detailViewLink);
                }
            }
        }
        else {
            foreach ($linkModelList["DETAILVIEWBASIC"] as $k => $item) {
                if ($item->getLabel() == "Release Campaign") {
                    unset($linkModelList["DETAILVIEWBASIC"][$k]);
                }
	    }
        }

        foreach ($linkModelList["DETAILVIEW"] as $k => $item) {
            if ($item->getLabel() == "LBL_DUPLICATE") {
                unset($linkModelList["DETAILVIEW"][$k]);
            }
        }
        return $linkModelList;
    }
}
