<?php

/**
 * @author  ITM
 * @developer Ranesh Ragupathy
 */

namespace EmailCampaigns;

class Scheduler {

    /**
     * 
     * @param type $notifyTo
     * @param type $otherNotify
     * @param type $campaignId
     */
    public static function sendSchedulerNotification($notifyTo, $otherNotify, $campaignId) {
        global $site_URL;
        $detailViewLink = $site_URL . 'index.php?module=EmailCampaigns&view=Detail&record=' . $campaignId;
        $recordModel = \Vtiger_Record_Model::getInstanceById($campaignId);
        $arrayData = array(
            '%cn' => $recordModel->get('campaign_name'),
            '%dl' => '<a href="' . $detailViewLink . '">' . $recordModel->get('campaign_name') . '( EmailCampaigns )</a>'
        );
        
        if($otherNotify != ''){
            $user = \Users_Record_Model::getCurrentUserModel();
            \EmailCampaigns\Scheduler::sendMail($user, $otherNotify, $arrayData);
        }
        $notifyTo = explode(',', $notifyTo);
        foreach ($notifyTo as $nUserId) {
            $user = \Users_Record_Model::getInstanceById($nUserId, 'Users');
             \EmailCampaigns\Scheduler::sendMail($user, $user->get('email1'), $arrayData);
        }
    }
    
    /**
     * 
     * @global type $site_URL
     * @global type $HELPDESK_SUPPORT_EMAIL_ID
     * @global type $HELPDESK_SUPPORT_NAME
     * @param type $user
     * @param type $toEmails
     * @param type $arrayData
     */
    public static function sendMail($user, $toEmails, $arrayData){
        global $HELPDESK_SUPPORT_EMAIL_ID, $HELPDESK_SUPPORT_NAME;
        require_once("modules/Emails/class.phpmailer.php");
        require_once("modules/Emails/mail.php");
        $subject = \Vtiger_Language_Handler::getLanguageTranslatedString($user->get('language'), 'LBL_SCHEDULER_EMAIL_SUBJECT', 'EmailCampaigns');
        $body = \Vtiger_Language_Handler::getLanguageTranslatedString($user->get('language'), 'LBL_SCHEDULER_EMAIL_BODY', 'EmailCampaigns');
        foreach ($arrayData as $var => $value) {
            $subject = str_replace($var, $value, $subject);
            $body = str_replace($var, $value, $body);
        }
        send_mail('EmailCampaigns', $toEmails, $HELPDESK_SUPPORT_NAME, $HELPDESK_SUPPORT_EMAIL_ID, $subject, $body);
    }
}
