<?php
namespace EmailCampaigns;

Class Reports extends EmailCampaigns {

    /**
     * @param $campaignId
     * @return int
     */
    public static function GetAllListCount($campaignId){
        global $adb;
        $countResult = $adb->pquery("SELECT count(*) as `count` FROM `vtiger_emailcampaigns_list_rel` 
                                WHERE emailcampaignsid = ?", array($campaignId));
        $totalCount = 0;
        if($countResult && $countResult->fields){
            $totalCount = $countResult->fields['count'];
        }
        return $totalCount;
    }

    /**
     * @param $campaignId
     * @return array
     */
    public static function GetAllLists($campaignId){
        global $adb;
        $query = "SELECT * FROM `vtiger_emailcampaigns_list_rel` WHERE emailcampaignsid = $campaignId";
        $result = $adb->pquery($query, array());
        $num_rows = $adb->num_rows($result);
        $lists = array();
        for($i = 0;$i < $num_rows;$i++){
            $listInfo = new \stdClass();
            $listInfo->id = $adb->query_result($result,$i,"id");
            $listInfo->campaignsId = $adb->query_result($result,$i,'emailcampaignsid');
            $listInfo->type = $adb->query_result($result,$i,'list_type');
            $listInfo->name = $adb->query_result($result,$i,'list_name');
            $lists[$listInfo->id] = $listInfo;
        }
        return $lists;
    }

    /**
     * @param $campaignId
     * @param $listId
     * @return object
     */
    public static function GetListInfoById($campaignId, $listId){
        global $adb;
        $query = "SELECT * FROM `vtiger_emailcampaigns_list_rel` WHERE emailcampaignsid = $campaignId AND id = ?";
        $result = $adb->pquery($query, array($listId));
        $list = new \stdClass();
        if($result->fields){
            $list->id = $result->fields['id'];
            $list->campaignsId = $result->fields['emailcampaignsid'];
            $list->type = $result->fields['list_type'];
            $list->name = $result->fields['list_name'];
            $list->data = json_decode($result->fields['list_data'], true);
            $list->complexCondition = EmailCampaigns::TransformToComplexConditionObject($list->data);
        }
        return $list;
    }


}
