<?php

namespace EmailCampaigns;

class Lists extends EmailCampaigns{
    protected $id;
    protected $listInfo = false;
    protected $selectedModule = false;
    protected $listModules = array();
    protected $params = array();
    protected $listHeaders = false;
    protected $listRecordIds = false;
    protected $listViewModel;

    /**
     * Lists constructor.
     * @param $listId
     */
    public function __construct($listId)
    {
        $this->id = $listId;
        $this->listInfo = parent::GetListInfoById($listId);
        parent::__construct($this->listInfo->campaignsId);
        $this->listModules = parent::GetModuleListByListId($listId);
        $this->selectedModule = $this->listModules[0];
    }

    /**
     * @param $key String
     * @param $value Mixed
     */
    public function Set($key, $value){
        $this->params[$key] = $value;
    }

    /**
     * @param $key String
     * @return bool|mixed
     */
    public function Get($key){
        return (isset($this->params[$key]))?$this->params[$key]:false;
    }

    /**
     * @param $moduleName
     */
    public function SetSelectedModule($moduleName){
        $this->selectedModule = $moduleName;
    }

    /**
     * @return String
     */
    public function GetSelectedModule(){
        return $this->selectedModule;
    }

    /**
     * @return array
     */
    public function GetListModules(){
        return $this->listModules;
    }

    /**
     * @return array
     */
    public function GetListRecordIds(){
        if(!$this->listRecordIds){
            $this->listRecordIds = parent::GetRecordIds($this->listInfo);
        }
        return $this->listRecordIds;
    }

    /**
     * @return Object \Vtiger_ListView_Model
     */
    public function GetListViewModel(){
        if(!$this->listViewModel){
            $this->listViewModel = \Vtiger_ListView_Model::getInstance($this->selectedModule);
        }
        return $this->listViewModel;
    }

    /**
     * @return bool|object|\stdClass
     */
    public function GetListDetails(){
        return $this->listInfo;
    }

    /**
     * @return Object \Vtiger_Field models
     */
    public function GetListViewHeaders(){
        if(!$this->listHeaders){
            $this->listViewModel = \Vtiger_ListView_Model::getInstance($this->selectedModule);
            $this->listHeaders = $this->listViewModel->getListViewHeaders();
        }
        return $this->listHeaders;
    }

    /**
     * @param \Vtiger_Paging_Model $pagingModel
     * @return array
     */
    public function GetListViewEntries(\Vtiger_Paging_Model $pagingModel){
        $db = \PearDatabase::getInstance();

        $moduleName = $this->listViewModel->getModule()->get('name');
        $moduleFocus = \CRMEntity::getInstance($moduleName);
        $moduleModel = \Vtiger_Module_Model::getInstance($moduleName);

        $queryGenerator = $this->listViewModel->get('query_generator');
        $listViewContoller = $this->listViewModel->get('listview_controller');

        $searchParams = $this->get('search_params');
        if(empty($searchParams)) {
            $searchParams = array();
        }
        $glue = "";
        if(count($queryGenerator->getWhereFields()) > 0 && (count($searchParams)) > 0) {
            $glue = \QueryGenerator::$AND;
        }
        $queryGenerator->parseAdvFilterList($searchParams, $glue);

        $orderBy = $this->get('orderby');
        $sortOrder = $this->get('sortorder');

        if(!empty($orderBy)){
            $queryGenerator = $this->listViewModel->get('query_generator');
            $fieldModels = $queryGenerator->getModuleFields();
            $orderByFieldModel = $fieldModels[$orderBy];
            if($orderByFieldModel && ($orderByFieldModel->getFieldDataType() == \Vtiger_Field_Model::REFERENCE_TYPE ||
                    $orderByFieldModel->getFieldDataType() == \Vtiger_Field_Model::OWNER_TYPE)){
                $queryGenerator->addWhereField($orderBy);
            }
        }
        $listQuery = $this->listViewModel->getQuery();

        $listQuery .= " AND vtiger_crmentity.crmid IN(".implode(',',$this->GetListRecordIds()).") ";
        $startIndex = $pagingModel->getStartIndex();
        $pageLimit = $pagingModel->getPageLimit();

        if(!empty($orderBy) && $orderByFieldModel) {
            if($orderBy == 'roleid' && $moduleName == 'Users'){
                $listQuery .= ' ORDER BY vtiger_role.rolename '.' '. $sortOrder;
            } else {
                $listQuery .= ' ORDER BY '.$queryGenerator->getOrderByColumn($orderBy).' '.$sortOrder;
            }

            if ($orderBy == 'first_name' && $moduleName == 'Users') {
                $listQuery .= ' , last_name '.' '. $sortOrder .' ,  email1 '. ' '. $sortOrder;
            }
        } else if(empty($orderBy) && empty($sortOrder) && $moduleName != "Users"){
            //List view will be displayed on recently created/modified records
            $listQuery .= ' ORDER BY vtiger_crmentity.modifiedtime DESC';
        }

        $listQuery .= " LIMIT $startIndex,".($pageLimit+1);
        $listResult = $db->pquery($listQuery, array());

        $listViewRecordModels = array();
        $listViewEntries =  $listViewContoller->getListViewRecords($moduleFocus,$moduleName, $listResult);

        $pagingModel->calculatePageRange($listViewEntries);

        if($db->num_rows($listResult) > $pageLimit){
            array_pop($listViewEntries);
            $pagingModel->set('nextPageExists', true);
        }else{
            $pagingModel->set('nextPageExists', false);
        }

        $index = 0;
        foreach($listViewEntries as $recordId => $record) {
            $rawData = $db->query_result_rowdata($listResult, $index++);
            $record['id'] = $recordId;
            $listViewRecordModels[$recordId] = $moduleModel->getRecordFromArray($record, $rawData);
        }
        return $listViewRecordModels;
    }

    /**
     * @return mixed
     */
    public function GetListViewCount(){
        $db = \PearDatabase::getInstance();
        $listViewModel = $this->GetListViewModel();
        $queryGenerator = $listViewModel->get('query_generator');

        $searchParams = $this->get('search_params');
        if(empty($searchParams)) {
            $searchParams = array();
        }

        $glue = "";
        if(count($queryGenerator->getWhereFields()) > 0 && (count($searchParams)) > 0) {
            $glue = \QueryGenerator::$AND;
        }
        $queryGenerator->parseAdvFilterList($searchParams, $glue);

        $moduleName = $listViewModel->getModule()->get('name');
        $moduleModel = \Vtiger_Module_Model::getInstance($moduleName);

        $listQuery = $listViewModel->getQuery();
        $listQuery .= " AND vtiger_crmentity.crmid IN(".implode(',',$this->GetListRecordIds()).") ";
        $position = stripos($listQuery, ' from ');
        if ($position) {
            $split = preg_split('/ from /i', $listQuery);
            $splitCount = count($split);
            // If records is related to two records then we'll get duplicates. Then count will be wrong
            $meta = $queryGenerator->getMeta($listViewModel->getModule()->getName());
            $columnIndex = $meta->getObectIndexColumn();
            $baseTable = $meta->getEntityBaseTable();
            $listQuery = "SELECT count(distinct($baseTable.$columnIndex)) AS count ";
            for ($i=1; $i<$splitCount; $i++) {
                $listQuery = $listQuery. ' FROM ' .$split[$i];
            }
        }
        $listResult = $db->pquery($listQuery, array());
        return $db->query_result($listResult, 0, 'count');
    }
}