<?php

namespace EmailCampaigns;

global $root_directory;
require_once($root_directory . "/modules/SubscribersList/autoload_wf.php");

class EmailCampaigns
{
    protected $_campaignId = 0;

    /**
     * Reports constructor.
     * @param Int $campaignId
     */
    public function __construct($campaignId = 0)
    {
        $this->_campaignId = $campaignId;
    }

    /**
     * @param Int $campaignId
     */
    public function SetId($campaignId = 0)
    {
        $this->_campaignId = $campaignId;
    }

    /**
     * @return Int
     */
    public function GetId()
    {
        return $this->_campaignId;
    }

    /**
     * @param array $data
     * @return mixed
     */
    public static function TransformToComplexConditionObject($data)
    {
        $conditions['module'] = $data['data']['module'];
        foreach ($data['filter']['condition']['condition'] as $key => $value) {
            $condition = new \stdClass();
            $condition->type = 'field';
            $condition->field = $value['field'];
            $condition->operation = $value['operation'];
            $condition->not = $value['not'];
            $condition->mode = $value['mode'];
            $condition->join = $data['filter']['join'][$key];
            if (isset($value['rawvalue'])) {
                $condition->rawvalue = new \stdClass();
                $condition->rawvalue->value = $value['rawvalue']['value'];
            }
            $conditions['condition'][] = $condition;
        }
        return $conditions;
    }

    /**
     * @param $campaignId
     * @param $listId
     * @return object
     */
    public static function GetListInfoById($listId)
    {
        global $adb;
        $query = "SELECT * FROM `vtiger_emailcampaigns_list_rel` WHERE id = ?";
        $result = $adb->pquery($query, array($listId));
        $list = new \stdClass();
        if ($result->fields) {
            $list->id = $result->fields['id'];
            $list->campaignsId = $result->fields['emailcampaignsid'];
            $list->type = $result->fields['list_type'];
            $list->name = $result->fields['list_name'];
            $list->data = json_decode($result->fields['list_data'], true);
            $list->complexCondition = EmailCampaigns::TransformToComplexConditionObject($list->data);
        }
        return $list;
    }

    /**
     * @param Int $listId
     * @return mixed
     */
    public static function GetModuleListByListId($listId)
    {
        global $adb, $root_directory;
        $listData = EmailCampaigns::GetListInfoById($listId);
        switch ($listData->type){
            case "fromlist":
                $module[] = $listData->data['data']['module'];
                break;
            case "fromEmailcampaign":
                $recordIds = EmailCampaigns::GetRecordIds($listData);
                $result = $adb->query("SELECT setype, count(crmid) FROM `vtiger_crmentity` 
                WHERE deleted = 0 AND crmid IN(".implode(',', $recordIds).") GROUP BY setype");
                while($row = $adb->fetch_array($result)){
                    $module[] = $row['setype'];
                }
                break;
            default:
                $module[] = $listData->data['reportModule'];
        }
        return $module;
    }

    /**
     * @param Object $listData
     * @return array
     */
    public static function GetRecordIds($listData)
    {
        global $adb, $root_directory;
        switch ($listData->type) {
            case "fromlist":
                $conditions = $listData->data['filter'];
                $data = $conditions['condition'];
                $module = $listData->data['data']['module'];
                $_POST["join"] = $listData->data['filter']['join'];

                if (!empty($data['condition'])) {
                    $preset = new \SubscribersList\ComplexeCondition('condition', null, array());
                    $condition = $preset->getCondition($data['condition']);
                } else {
                    $condition = '';
                }

                $cleanRecordModel = \SubscribersList\VTEntity::getForId('', $module);
                $obj = new \SubscribersList\ConditionMysql($module, $cleanRecordModel);
                $WHERE = $obj->parse($condition);
                $tables = $obj->generateTables();
                $query = 'SELECT * ' . $tables . ' '; // generic query

                if (trim($WHERE) != '') {
                    $query .= ' WHERE deleted=0 AND ' . $WHERE;
                } else {
                    $query .= ' WHERE deleted=0 ';
                }
                $relResult = $adb->query($query);
                while ($row = $adb->fetchByAssoc($relResult)) {
                    $ids[$row["crmid"]] = $row["crmid"];
                }
                break;
            case "fromEmailcampaign":
                // A previously sent campaign has been selected
                $whopenemail = $listData->data['whopenemail'];
                $emailclicklink = $listData->data['emailclicklink'];
                $notwhopenemail = $listData->data['notwhopenemail'];
                $notemailclicklink = $listData->data['notemailclicklink'];
                $allprevsubcribers = $listData->data['allprevsubcribers'];
                $parent_emailcampaignsid = $listData->data['parent_emailcampaignsid'];
                $params = array();
                if ($allprevsubcribers == '1') {
                    $query = 'SELECT vtiger_emailcamp_sendemail.related_id FROM vtiger_emailcamp_sendemail 
                        INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_emailcamp_sendemail.related_id 
                        WHERE vtiger_emailcamp_sendemail.emailcampaignsid = ? AND vtiger_crmentity.deleted = 0';
                    array_push($params, $parent_emailcampaignsid);
                } else {
                    if ($emailclicklink == '1') {
                        $query = 'SELECT vtiger_emailcamp_sendemail.related_id FROM vtiger_emailcamp_sendemail
                    INNER JOIN vtiger_link_tracker ON vtiger_link_tracker.emailid = vtiger_emailcamp_sendemail.activityid
                    INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid=vtiger_emailcamp_sendemail.related_id AND deleted=0
                    WHERE vtiger_link_tracker.click > 0 AND vtiger_emailcamp_sendemail.emailcampaignsid = ? AND vtiger_link_tracker.emailid<>0';
                        array_push($params, $parent_emailcampaignsid);
                    }

                    if ($whopenemail == '1') {
                        if ($query != "") {
                            $query .= " UNION ALL ";
                        }
                        $query .= 'SELECT vtiger_emailcamp_sendemail.related_id FROM vtiger_emailcamp_sendemail
                    INNER JOIN vtiger_emailtrackingreport ON vtiger_emailtrackingreport.emailtrackingreportid = vtiger_emailcamp_sendemail.activityid
                    INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid=vtiger_emailcamp_sendemail.related_id AND deleted=0
                    WHERE vtiger_emailtrackingreport.email_open > 0 AND vtiger_emailcamp_sendemail.emailcampaignsid = ?';
                        array_push($params, $parent_emailcampaignsid);
                    }

                    if ($notwhopenemail == '1') {
                        if ($query != "") {
                            $query .= " UNION ALL ";
                        }
                        $query .= " SELECT vtiger_emailcamp_sendemail.related_id FROM vtiger_emailcamp_sendemail
                    INNER JOIN vtiger_emailtrackingreport ON vtiger_emailtrackingreport.emailtrackingreportid = vtiger_emailcamp_sendemail.activityid
                    INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid=vtiger_emailcamp_sendemail.related_id AND deleted=0
                    WHERE vtiger_emailtrackingreport.email_open < 1 AND vtiger_emailcamp_sendemail.emailcampaignsid = ? ";
                        array_push($params, $parent_emailcampaignsid);
                    }

                    if ($notemailclicklink == '1') {
                        if ($query != "") {
                            $query .= " UNION ALL ";
                        }
                        $query .= " SELECT vtiger_emailcamp_sendemail.related_id FROM vtiger_emailcamp_sendemail
                    INNER JOIN vtiger_emailtrackingreport ON vtiger_emailtrackingreport.emailtrackingreportid = vtiger_emailcamp_sendemail.activityid
                    INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid=vtiger_emailcamp_sendemail.related_id AND deleted=0
                    WHERE vtiger_emailtrackingreport.email_click < 1 AND vtiger_emailcamp_sendemail.emailcampaignsid = ? ";
                        array_push($params, $parent_emailcampaignsid);
                    }
                }
                $result = $adb->pquery($query, $params);
                $count = $adb->num_rows($result);
                $related_list = array();
                for ($i = 0; $i < $count; $i++) {
                    $crmId = $adb->query_result($result, $i, 'related_id');
                    $ids[$crmId] = $crmId;
                }
                break;
            case "fromReport":
                $parent_reportid = $listData->data['reportId'];
                $parent_reportmodule = $listData->data['reportModule'];

                switch ($parent_reportmodule) {
                    case "Contacts":
                        $mapping = "mapping_cont";
                        $crmidc = "contactid";
                        break;
                    case "Leads":
                        $mapping = "mapping_lead";
                        $crmidc = "leadid";
                        break;
                    case "Accounts":
                        $mapping = "mapping_acc";
                        $crmidc = "accountid";
                        break;
                }

                $result_field = $adb->pquery("SELECT tablename,columnname FROM vtiger_emailcampaign_outgoingserverdetail o INNER JOIN vtiger_field f on f.fieldid=o." . $mapping . " LIMIT 1",
                    array());
                while ($row = $adb->fetch_array($result_field)) {
                    $table = $row['tablename'];
                    $emailc = $table . "." . $row['columnname'];
                    $crmidc = $table . "." . $crmidc;
                }

                // Get the report
                $reportModel = \Reports_Record_Model::getInstanceById($parent_reportid);
                $reportModel->setModule('Reports');
                $sSQL = $reportModel->getReportSQL();
                $sSQL = str_replace(' from ', ' FROM ', $sSQL);
                $tmp = explode("FROM", $sSQL);
                if (count($tmp) > 2) {
                    for ($i = 2; $i < count($tmp); $i++) {
                        $tmp[1] .= " FROM " . $tmp[$i];
                    }
                }
                $tmp_sql = explode("order by", strtolower($tmp[1]));
                $sSQL = "SELECT DISTINCT coalesce(" . $crmidc . ",'') as crmid, coalesce(" . $emailc . ",'') as emca_emailfield FROM " . $tmp_sql[0];
                $result = $adb->pquery($sSQL, array());
                $emails_list = array();
                while ($row = $adb->fetchByAssoc($result)) {
                    if ($row["crmid"] != "" && trim($row["emca_emailfield"]) != "" && filter_var(trim($row["emca_emailfield"]),
                            FILTER_VALIDATE_EMAIL) && !in_array(trim($row["emca_emailfield"]), $emails_list)) {
                        $ids[$row["crmid"]] = $row["crmid"];
                    }
                }
                break;
            case "fromFlexReport":
                $parent_reportid = $listData->data['reportId'];
                $parent_reportmodule = $listData->data['reportModule'];

                require_once($root_directory . "/modules/RedooReports/autoload_wf.php");
                $report = \RedooReports\Report::getInstance($parent_reportid);
                $crmids = $report->getAffectedCRMIDs($parent_reportmodule);

                switch ($parent_reportmodule) {
                    case "Contacts":
                        $mapping = "mapping_cont";
                        $crmidc = "contactid";
                        break;
                    case "Leads":
                        $mapping = "mapping_lead";
                        $crmidc = "leadid";
                        break;
                    case "Accounts":
                        $mapping = "mapping_acc";
                        $crmidc = "accountid";
                        break;
                }

                $result_field = $adb->pquery("SELECT tablename,columnname FROM vtiger_emailcampaign_outgoingserverdetail o INNER JOIN vtiger_field f on f.fieldid=o." . $mapping . " LIMIT 1",
                    array());
                while ($row = $adb->fetch_array($result_field)) {
                    $table = $row['tablename'];
                    $emailc = $table . "." . $row['columnname'];
                    $crmidc = $table . "." . $crmidc;
                }
                $sSQL = "SELECT coalesce(" . $emailc . ",'') as emca_emailfield FROM " . $table . " WHERE " . $crmidc . "= ? ";
                $emails_list = array();
                foreach ($crmids as $value) {
                    $result = $adb->pquery($sSQL, array($value));
                    while ($row = $adb->fetchByAssoc($result)) {
                        if (trim($row["emca_emailfield"]) != "" && filter_var(trim($row["emca_emailfield"]),
                                FILTER_VALIDATE_EMAIL) && !in_array(trim($row["emca_emailfield"]), $emails_list)) {
                            $ids[$value] = $value;
                        }
                    }
                }
                break;
            default:
                $ids = array();
        }
        return $ids;
    }
}