<?php

class EmailCampaigns_listRecordExport_Action extends Vtiger_Action_Controller
{

    function checkPermission()
    {

    }

    public function process(Vtiger_Request $request)
    {
        $module = $request->getModule();
        $mode = $request->get('mode');
        $data = $this->$mode($request);
        $fileTypeMethod = 'generate' . $request->get('fileType');
        $this->$fileTypeMethod($request, $data);
    }

    private function linkClick(\Vtiger_Request $request)
    {
        $parentId = $request->get('record');
        $moduleName = $request->getModule();
        $link_list = EmailCampaigns_Record_Model::getLinkList($parentId);
        $record_data[] = vtranslate('Link Name', $moduleName) . "," . vtranslate('Link URL', $moduleName) . "," . vtranslate('Count (Unique Click)', $moduleName);
        foreach ($link_list as $data) {
            $record_data[] = $data[0] . ',' . $data[3] . ',' . $data[1] . '(' . $data[2] . ' ' . vtranslate('LBL_UNIQUE', $moduleName) . ')';
        }
        return $record_data;
    }

    private function SentEmailsList(\Vtiger_Request $request)
    {
        global $current_user, $site_URL;
        $db = PearDatabase::getInstance();
        $module = $request->getModule();
        $actionbtn = array();
        $recordId = $request->get('record');
        $moduleName = $request->getModule();
        $page = $request->get('page_no');
        $filter = $request->get('filter', 'all');

// VTCONN_TT17186 #RG Inizio
//$related_modulename = EmailCampaigns_Record_Model::getEmailCampaignRecordRelatedModule($recordId);
        $related_modulename = $request->get("relmodule", "Contacts");

        if ($related_modulename == 'Leads') {
            $jointable = ' INNER JOIN vtiger_leaddetails ON vtiger_leaddetails.leadid = vtiger_emailcamp_sendemail.related_id '
                . 'inner join vtiger_crmentity on vtiger_crmentity.crmid = vtiger_leaddetails.leadid';
        } else if ($related_modulename == 'Contacts') {
            $jointable = ' INNER JOIN vtiger_contactdetails ON vtiger_contactdetails.contactid = vtiger_emailcamp_sendemail.related_id '
                . 'inner join vtiger_crmentity on vtiger_crmentity.crmid = vtiger_contactdetails.contactid';
        } else if ($related_modulename == 'Accounts') {
            $jointable = ' INNER JOIN vtiger_account ON vtiger_account.accountid = vtiger_emailcamp_sendemail.related_id '
                . 'inner join vtiger_crmentity on vtiger_crmentity.crmid = vtiger_account.accountid';
        }

        $query_total_count = "SELECT * FROM vtiger_emailcamp_sendemail $jointable ";

        if ($current_user->is_admin != "on") {
            $crmentity = new CRMEntity();
            $query_total_count .= $crmentity->getNonAdminAccessControlQuery($related_modulename, $current_user);
        }

        $selectedIds = $request->get('selectedIds');
        $excludedIds = $request->get('excludedIds');
        $selectedIdQuery = '';
        if (is_array($selectedIds)) {
            $selectedIdQuery = 'AND vtiger_crmentity.crmid IN(' . implode(',', $selectedIds) . ') ';
        } else if ($selectedIds == 'all' && is_array($excludedIds)) {
            $selectedIdQuery = 'AND vtiger_crmentity.crmid NOT IN(' . implode(',', $excludedIds) . ') ';
        }

        if ($filter == 'all') {
            $query_total_count .= " where vtiger_emailcamp_sendemail.emailcampaignsid = ?" . $selectedIdQuery . " group by vtiger_emailcamp_sendemail.related_id";
        } elseif ($filter == 'sent') {
            $query_total_count .= " where vtiger_emailcamp_sendemail.emailcampaignsid = ?" . $selectedIdQuery . " AND vtiger_emailcamp_sendemail.issent=1 group by vtiger_emailcamp_sendemail.related_id";
        } elseif ($filter == 'notsent') {
            $query_total_count .= " where vtiger_emailcamp_sendemail.emailcampaignsid = ?" . $selectedIdQuery . " AND vtiger_emailcamp_sendemail.issent=0 group by vtiger_emailcamp_sendemail.related_id";
        } elseif ($filter == 'error') {
            $query_total_count .= " where vtiger_emailcamp_sendemail.emailcampaignsid = ?" . $selectedIdQuery . " AND vtiger_emailcamp_sendemail.issent=-1 group by vtiger_emailcamp_sendemail.related_id";
        }

        $result_total_count = $db->pquery($query_total_count, array($recordId));
        $total_count = $db->num_rows($result_total_count);

        $query = $query_total_count;
        if ($request->get('exportmode') == 'ExportCurrentPage') {
            $configdetailmodel = Settings_Vtiger_ConfigModule_Model::getInstance();
            $record = $configdetailmodel->getViewableData();
            $noofdata = $record['list_max_entries_per_page'];
            if ($noofdata <= 0) {
                $noofdata = 10;
            }

            $max_page_limit = $page * $noofdata;
            $min_page_limit = $max_page_limit - $noofdata;
            $qry_limit = " LIMIT 0,$noofdata";
            if ($page > 1)
                $qry_limit = " LIMIT $min_page_limit,$noofdata";

            $max_page = ceil($total_count / $noofdata);
            $query = $query_total_count . $qry_limit;
        }
        $result_links = $db->pquery($query, array($recordId));
        $uniq_open = $db->num_rows($result_links);
        $record_data[] = vtranslate('LBL_MODULE_NAME', $module) . "," . vtranslate('LBL_NAME', $moduleName) . "," . vtranslate('LBL_EMAIL', $moduleName) . "," . vtranslate('LBL_EMAIL_STATUS', $moduleName) . "," . vtranslate('LBL_DETAIL_VIEW_LINK', $moduleName);
        for ($i = 0; $i < $uniq_open; $i++) {
            $status = $db->query_result($result_links, $i, 'issent');
            if ($status == 1) {
                $status = vtranslate('LBL_SENT', $moduleName);
            } else if ($status == -1) {
                $status = vtranslate('LBL_ERROR', $moduleName);
            } else if ($status == 0) {
                $status = vtranslate('LBL_NOT_SENT', $moduleName);
            }
            if ($related_modulename == 'Leads' || $related_modulename == 'Contacts') {
                $firstname = $db->query_result($result_links, $i, 'firstname');
                $lastname = $db->query_result($result_links, $i, 'lastname');
                $name = $firstname . ' ' . $lastname;
                $email = $db->query_result($result_links, $i, 'email');

                if ($related_modulename == 'Contacts') {
                    $id = $db->query_result($result_links, $i, 'contactid');
                    $link = $site_URL . "index.php?module=Contacts&view=Detail&record=" . $id;
                    $type = 'Contacts';
                } else if ($related_modulename == 'Leads') {
                    $id = $db->query_result($result_links, $i, 'leadid');
                    $link = $site_URL . "index.php?module=Leads&view=Detail&record=" . $id;
                    $type = 'Leads';
                }
            } else if ($related_modulename == 'Accounts') {
                $name = $db->query_result($result_links, $i, 'accountname');
                $email = $db->query_result($result_links, $i, 'email1');
                $id = $db->query_result($result_links, $i, 'accountid');
                $link = $site_URL . "index.php?module=Accounts&view=Detail&record=" . $id;
                $type = 'Accounts';
            }
            $record_data[] = vtranslate($type, $type) . "," . $name . "," . $email . "," . $status . "," . $link;
        }
        return $record_data;
    }

    private function SubscriberList(\Vtiger_Request $request)
    {
        global $site_URL;
        $db = PearDatabase::getInstance();
        $module = $request->getModule();

        $recordId = $request->get('record');
        $moduleName = $request->getModule();
        $page = $request->get('page_no');
        $optout = 1;

        // VTCONN_TT17186 #RG Inizio
        $related_modulename = $request->get('relmodule', 'All');
//        $subscriber = EmailCampaigns_Record_Model::getSubscribersWithShar($recordId, $optout, null, $related_modulename);
        $qry_limit = '';
        if ($request->get('exportmode') !== 'ExportAllData') {
            $total_count = $db->num_rows($subscriber);
            $configdetailmodel = Settings_Vtiger_ConfigModule_Model::getInstance();
            $record = $configdetailmodel->getViewableData();
            $noofdata = $record['list_max_entries_per_page'];
            if ($noofdata <= 0) {
                $noofdata = 10;
            }
            $max_page = ceil($total_count / $noofdata);
            $max_page_limit = $page * $noofdata;
            $min_page_limit = $max_page_limit - $noofdata;
            $qry_limit = " LIMIT 0, $noofdata";
            if ($page > 1)
                $qry_limit = " LIMIT $min_page_limit, $noofdata";
        }

        $subscriber_limited = EmailCampaigns_Record_Model::getSubscribersWithShar($recordId, $optout, $qry_limit, $related_modulename);
        $subscriber_list = $db->num_rows($subscriber_limited);

        $record_data[] = vtranslate('LBL_NAME', $moduleName) . ", " . vtranslate('LBL_EMAIL', $moduleName) . ", " . vtranslate('LBL_DETAIL_VIEW_LINK', $moduleName);
        for ($i = 0; $i < $subscriber_list; $i++) {
            $imodule = $db->query_result($subscriber_limited, $i, 'modulefield');
            $id = $db->query_result($subscriber_limited, $i, 'idfield');
            if ($imodule == $related_modulename) {
                $record_data[] = $db->query_result($subscriber_limited, $i, 'namefield') . ", " . $db->query_result($subscriber_limited, $i, 'emailfield') . ", " . $site_URL . "index.php?module = " . $imodule . "&view = Detail&record = " . $id;
            } else if ($related_modulename == 'All') {
                $record_data[] = $db->query_result($subscriber_limited, $i, 'namefield') . ", " . $db->query_result($subscriber_limited, $i, 'emailfield') . ", " . $site_URL . "index.php?module = " . $imodule . "&view = Detail&record = " . $id;
            }
        }
        return $record_data;
    }

    private function UniqueOpenList(\Vtiger_Request $request){
        global $current_user;
        $db = PearDatabase::getInstance();
        $module = $request->getModule();
        $actionbtn = array();

        $recordId = $request->get('record');
        $moduleName = $request->getModule();
        $page = $request->get('page_no');

        // VTCONN_TT17186 #RG Inizio
        //$related_modulename = EmailCampaigns_Record_Model::getEmailCampaignRecordRelatedModule($recordId);
        $related_modulename = $request->get("relmodule", "Contacts");
        // VTCONN_TT17186 #RG Fine

        if ($related_modulename == 'Leads') {
            $jointable = ' INNER JOIN vtiger_leaddetails ON vtiger_leaddetails.leadid = vtiger_emailcamp_sendemail.related_id '
                . 'inner join vtiger_crmentity on vtiger_crmentity.crmid = vtiger_leaddetails.leadid';
        } else if ($related_modulename == 'Contacts') {
            $jointable = ' INNER JOIN vtiger_contactdetails ON vtiger_contactdetails.contactid = vtiger_emailcamp_sendemail.related_id '
                . 'inner join vtiger_crmentity on vtiger_crmentity.crmid = vtiger_contactdetails.contactid';
        } else if ($related_modulename == 'Accounts') {
            $jointable = ' INNER JOIN vtiger_account ON vtiger_account.accountid = vtiger_emailcamp_sendemail.related_id '
                . 'inner join vtiger_crmentity on vtiger_crmentity.crmid = vtiger_account.accountid';
        }

        $query_total_count = "SELECT * FROM  vtiger_emailtrackingreport
            INNER JOIN vtiger_emailcamp_sendemail ON vtiger_emailcamp_sendemail.activityid  = vtiger_emailtrackingreport.emailtrackingreportid
        $jointable ";

        if ($current_user->is_admin != "on") {
            $crmentity = new CRMEntity();
            $query_total_count .= $crmentity->getNonAdminAccessControlQuery($related_modulename, $current_user);
        }

        $selectedIds = $request->get('selectedIds');
        $excludedIds = $request->get('excludedIds');
        $selectedIdQuery = '';
        if (is_array($selectedIds)) {
            $selectedIdQuery = 'AND vtiger_crmentity.crmid IN(' . implode(',', $selectedIds) . ') ';
        } else if ($selectedIds == 'all' && is_array($excludedIds)) {
            $selectedIdQuery = 'AND vtiger_crmentity.crmid NOT IN(' . implode(',', $excludedIds) . ') ';
        }

        $query_total_count .= " where vtiger_emailcamp_sendemail.emailcampaignsid = ?
            and vtiger_emailtrackingreport.email_open > 0 ". $selectedIdQuery." group by vtiger_emailcamp_sendemail.related_id";

        $result_total_count = $db->pquery($query_total_count, array($recordId));
        $total_count = $db->num_rows($result_total_count);


        $qry_limit = '';
        if ($request->get('exportmode') !== 'ExportAllData') {
            $total_count = $db->num_rows($subscriber);
            $configdetailmodel = Settings_Vtiger_ConfigModule_Model::getInstance();
            $record = $configdetailmodel->getViewableData();
            $noofdata = $record['list_max_entries_per_page'];
            if ($noofdata <= 0) {
                $noofdata = 10;
            }
            $max_page = ceil($total_count / $noofdata);
            $max_page_limit = $page * $noofdata;
            $min_page_limit = $max_page_limit - $noofdata;
            $qry_limit = " LIMIT 0, $noofdata";
            if ($page > 1)
                $qry_limit = " LIMIT $min_page_limit, $noofdata";
        }

        $query = $query_total_count . $qry_limit;

        if ($related_modulename != 'All') {
            $result_links = $db->pquery($query, array($recordId));
        } else {
            $result_links = $db->pquery($query, array($recordId, $recordId, $recordId));
        }
        $uniq_open = $db->num_rows($result_links);
        $record_data[] = vtranslate('LBL_NAME', $moduleName) . ", " . vtranslate('LBL_EMAIL', $moduleName) . ", ". vtranslate('Open Count', $moduleName).", ". vtranslate('Last IP', $moduleName).", " . vtranslate('LBL_DETAIL_VIEW_LINK', $moduleName);
        for ($i = 0; $i < $uniq_open; $i++) {
            if ($related_modulename == 'Leads' || $related_modulename == 'Contacts') {
                $firstname = $db->query_result($result_links, $i, 'firstname');
                $lastname = $db->query_result($result_links, $i, 'lastname');
                $name = $firstname . ' ' . $lastname;
                $email = $db->query_result($result_links, $i, 'email');
                $uniq = $db->query_result($result_links, $i, 'email_open');
                $ip = $db->query_result($result_links, $i, 'ip');
                if ($related_modulename == 'Contacts') {
                    $id = $db->query_result($result_links, $i, 'contactid');
                    $link = "index.php?module=Contacts&view=Detail&record";
                    $type = 'Contacts';
                } else if ($related_modulename == 'Leads') {
                    $id = $db->query_result($result_links, $i, 'leadid');
                    $link = "index.php?module=Leads&view=Detail&record";
                    $type = 'Leads';
                }
            } else if ($related_modulename == 'Accounts') {
                $name = $db->query_result($result_links, $i, 'accountname');
                $email = $db->query_result($result_links, $i, 'email1');
                $id = $db->query_result($result_links, $i, 'accountid');
                $link = "index.php?module=Accounts&view=Detail&record";
                $uniq = $db->query_result($result_links, $i, 'email_open');
                $ip = $db->query_result($result_links, $i, 'ip');
                $type = 'Accounts';
            }
            $record_data[] = $name.", ".$email.", ".$uniq.", ".$ip.", ".$link;
        }
        return $record_data;
    }

    private function generatecsv(\Vtiger_Request $request, $data)
    {
        $mode = $request->get('mode');
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment; filename="' . $mode . '.csv"');

        $fp = fopen('php://output', 'wb');
        foreach ($data as $line) {
            $line = html_entity_decode($line);
            $val = explode(",", $line);
            fputcsv($fp, $val);
        }
        fclose($fp);
    }

    private function generateexcel(\Vtiger_Request $request, $data)
    {
        $mode = $request->get('mode');
        $moduleName = $request->getModule();
        require_once 'modules/' . $moduleName . '/include' . DS . 'phpexcel' . DS . 'PHPExcel.php';
        $tmpfile = tempnam(sys_get_temp_dir(), 'html');

        file_put_contents($tmpfile, $this->generateHTML($data));

        $objPHPExcel = new \PHPExcel();
        $excelHTMLReader = \PHPExcel_IOFactory::createReader('HTML');
        $excelHTMLReader->setInputEncoding('UTF-8');
        $excelHTMLReader->loadIntoExisting($tmpfile, $objPHPExcel);
        $objPHPExcel->getActiveSheet()->setTitle(substr($mode, 0, 30)); // Change sheet's title if you want
        unlink($tmpfile);
        header('pragma:public');
        header('Content-type:application/vnd.ms-excel;charset=utf-8;name="' . $mode . '.xlsx"');
        header("Content-Disposition:attachment;filename={$mode}.xlsx");
        $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save('php://output');
    }

    private function generateHTML($data)
    {
        $html = '<?xml encoding="UTF-8">' . PHP_EOL;
        $html .= '<table>' . PHP_EOL;
        $lineCount = 0;
        foreach ($data as $line) {
            $line = html_entity_decode($line);
            $values = explode(",", $line);
            if ($lineCount == 0) {
                $html .= '<thead>' . PHP_EOL;
            }
            $html .= '<tr>' . PHP_EOL;
            foreach ($values as $value) {
                if ($lineCount == 0) {
                    $html .= '<th>' . $value . '</th>' . PHP_EOL;
                } else {
                    $html .= '<td>' . $value . '</td>' . PHP_EOL;
                }
            }
            $html .= '</tr>';
            if ($lineCount == 0) {
                $html .= '</thead>';
                $lineCount = 1;
            }
        }
        return $html;
    }
}
