<?php

/* +***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * *********************************************************************************** */

class EmailCampaigns_Save_Action extends Vtiger_Save_Action {

    public function process(Vtiger_Request $request) {

        $adb = PearDatabase::getInstance();
        $sqlbatch = $adb->pquery("SELECT * FROM vtiger_emailcampaign_setting");
        $batch = $adb->query_result($sqlbatch, 0, 'batch');
        
        $sqlinterval = $adb->pquery("SELECT * FROM vtiger_cron_task WHERE name='ScheduleEmailCampaign'");
        $interval = $adb->query_result($sqlinterval, 0, 'frequency');
        $intervalmin = ($interval/60);
        // VTCONN #RG Inizio


        $request->set("related_recorts", rtrim($request->get("related_recorts"),","));

        $request->set("module_name", "");
        $request->set("subscribers_list", "");

        // VTCONN #RG Fine

        $body = $_REQUEST["description"];
        $recordModel =  Vtiger_Save_Action::getRecordModelFromRequest($request);

        $recordModel = Vtiger_Save_Action::saveRecord($request);
        
        $response = new Vtiger_Response();
        $relatedRecordId = $recordModel->getId();
        if($relatedRecordId){
            $conditions = $request->get('conditions1');
            $wfCondition = array();
            if(!empty($conditions)) {
                foreach($conditions as $index => $condition) {
                    $columns = $condition['columns'];
                    // if($index == '1' && empty($columns)) {
                        // $wfCondition[] = array('fieldname'=>'', 'operation'=>'', 'value'=>'', 'valuetype'=>'', 
                            // 'joincondition'=>'', 'groupid'=>'0');
                    // }
                    if(!empty($columns) && is_array($columns) && $index == '1') {
                        foreach($columns as $column) {
                            $wfCondition[] = array('fieldname'=>$column['columnname'], 'operation'=>$column['comparator'],
                                'value'=>$column['value'], 'valuetype'=>$column['valuetype'], 'joincondition'=>$column['column_condition'],
                                'groupjoin'=>$condition['condition'], 'groupid'=>'0');
                        }
                    }else if(!empty($columns) && is_array($columns) && $index == '2'){
                        foreach($columns as $column) {
                            $wfCondition[] = array('fieldname'=>$column['columnname'], 'operation'=>$column['comparator'],
                                'value'=>$column['value'], 'valuetype'=>$column['valuetype'], 'joincondition'=>$column['column_condition'],
                                'groupjoin'=>$condition['condition'], 'groupid'=>'1');
                        }
                    }
                }
            }
            $moduleName = $request->getModule();
            $recordModel = Vtiger_Record_Model::getInstanceById($relatedRecordId, $moduleName);
            $recordModel->set('id', $relatedRecordId);
            $recordModel->set('mode', 'edit');
            $recordModel->set('batch', $batch);
            $recordModel->set('emailcamp_interval', $intervalmin);
            //$recordModel->set('conditions', Zend_Json::encode($wfCondition));
            $recordModel->set('conditions', ""); 
            $recordModel->set("select_option", "Select a list");

            // $related_recorts = $request->get('related_recorts');
            // $recordModel->set('related_recorts', Zend_Json::decode($related_recorts));
            $recordModel->save();


            $adb->pquery("DELETE FROM vtiger_senotesrel WHERE crmid=? ",array($recordModel->getId()));


            //Files uploaded from client
            foreach ($_FILES['file'] as $idx => $file){
                $attach=[];
                if( $file['name'][$idx]!=''){
                    $attach["name"] = preg_replace('!\s+!', '-', $file['name']);
                    $fileExtension = strtolower(end(explode('.',$attach["name"])));
                    $attach["extension"] = $fileExtension;
                    $attach["tmp_name"] = $file['tmp_name'];
                    $attach["type"] = $file['type'];
                    $attach["size"] = $file['size'];

                    $this->SaveAttachements($recordModel,$attach);
                }
            }

            //Documents selected by the Browse CRM button
            if($request->get('documentids')!=''){
                $documents = $request->get('documentids');
                foreach ($documents as $document){
                    $adb->pquery("INSERT INTO vtiger_senotesrel(crmid, notesid) VALUES(?,?)",
                        Array($recordModel->getId(), $document));
                }
            }

            //Documents that were already in the campaign
            $existingAttachments = $request->get('attachments',array());
            if(is_array($existingAttachments)) {
                $documentIds=array();
                foreach ($existingAttachments as $index =>  $existingAttachInfo) {
                    $existingAttachInfo['tmp_name'] = $existingAttachInfo['name'];
                    $existingAttachments[$index] = $existingAttachInfo;
                    if(array_key_exists('docid',$existingAttachInfo)) {
                        $documentIds[] = $existingAttachInfo['docid'];
                        unset($existingAttachments[$index]);
                    }
                }
                foreach ($documentIds as $document){
                    $adb->pquery("INSERT INTO vtiger_senotesrel(crmid, notesid) VALUES(?,?)",
                        Array($recordModel->getId(), $document));
                }
            }

            $adb->pquery("UPDATE vtiger_crmentity set description=? where crmid=?",array($body,$recordModel->getId()));     
            }       
        $response->setResult(array('id' => $relatedRecordId));
        $response->emit();
    }


    function SaveAttachements($campaignrecordmodel, $attach) {
        global $adb;


        $userid = $campaignrecordmodel->get('assigned_user_id');
        $setype = "Documents Attachment";

        $date_var = $adb->formatDate(date('YmdHis'), true);

        $attachid = $adb->getUniqueId('vtiger_crmentity');
        $description = $attach["name"].".".$attach["extension"];
        $usetime = $adb->formatDate($date_var, true);

        $adb->pquery("INSERT INTO vtiger_crmentity(crmid, smcreatorid, smownerid,
                modifiedby, setype, description, createdtime, modifiedtime, presence, deleted)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)",
            Array($attachid, $userid, $userid, $userid, $setype, $description, $usetime, $usetime, 1, 0));


        $issaved = $this->__SaveAttachmentFile($attachid, $attach);
        if($issaved) {
            $dirname = decideFilePath();
            $filename = str_replace(' ', '-', $attach["name"]);
            require_once('modules/Documents/Documents.php');
            // Create document record
            $document = new Documents();
            $document->column_fields['notes_title']      = $filename;
            $document->column_fields['filename']         = $filename;
            $filename = "$dirname$attachid" . "_$filename";
            $document->column_fields['filesize']         = filesize($filename);
            $document->column_fields['filetype']         = 'application/octet-stream';
            $document->column_fields['filestatus']       = 1;
            $document->column_fields['filelocationtype'] = 'I';
            $document->column_fields['folderid']         = 1; // Default Folder
            $document->column_fields['assigned_user_id'] = $userid;
            $document->save('Documents');

            // Link file attached to document
            $adb->pquery("INSERT INTO vtiger_seattachmentsrel(crmid, attachmentsid) VALUES(?,?)",
                Array($document->id, $attachid));

            // Link document to base record
            $adb->pquery("INSERT INTO vtiger_senotesrel(crmid, notesid) VALUES(?,?)",
                Array($campaignrecordmodel->getId(), $document->id));
        }
    }

    function __SaveAttachmentFile($attachid, $attach) {
        global $adb;

        $dirname = decideFilePath();

        $description = $attach["name"];
        $filename = str_replace(' ', '-', $attach["name"]);

        $filename = "$attachid" . "_$filename";

        $saveasfile = "$dirname$filename";

        $fh = fopen($saveasfile, 'wb');
        fwrite($fh, file_get_contents($attach["tmp_name"]));
        fclose($fh);


        /*$zip = new ZipArchive;
        $zip->open($zipname, ZipArchive::CREATE);
        $zip->addFile($attach["tmp_name"],$filename.".xml");
        //$zip->addFile("modules/EInvoice/tmp/$filename.xml",$filename.".xml");
        $zip->close();*/
        $mimetype = "application/octet-stream";

        $adb->pquery("INSERT INTO vtiger_attachments SET attachmentsid=?, name=?, description=?, type=?, path=?",
            Array($attachid, $attach["name"], $description, $mimetype, $dirname));

        return true;
    }


}
