<?php

/* +***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * *********************************************************************************** */
// require_once 'config.inc.php';

// global $root_directory;

// require_once($root_directory . "/modules/EmailCampaigns/autoload_wf.php");

class EmailCampaigns_Release_Action extends Vtiger_SaveAjax_Action {

  function __construct() {

    parent::__construct();
  }

  public function process(Vtiger_Request $request) {

    $moduleName = 'EmailCampaigns';

    $adb = PearDatabase::getInstance();  

    $response = new Vtiger_Response();

    if($request->get('record') != '') {

      $currId = $request->get('record');

      // check for title of the campaign
      // if it contains 'testcampaign:' allowed to reset
      // otherwise, leave it as is
      if ((int)$currId > 0) {

        $params = array($currId);

        $query = "SELECT campaign_name FROM vtiger_emailcampaigns WHERE emailcampaignsid = ?";
        $result = $adb->pquery($query, $params);

        $row = $adb->fetchByAssoc($result);

        $normalizedCampaignTitle = strtolower($row['campaign_name']);

        // english
        $testcampaignInString = strpos($normalizedCampaignTitle, 'testcampaign:', 0);

        // dutch
        if ($testcampaignInString === false) $testcampaignInString = strpos($normalizedCampaignTitle, 'testcampagne:', 0);

        // found if it is not false - 0 = begins at first character in string
        if ($testcampaignInString === 0) {

          $queries = array();
          $queries[] = "DELETE FROM vtiger_scheduleemailcampagine WHERE emailcampaignsid = ?";
          $queries[] = "DELETE FROM vtiger_emailtrackingreport WHERE emailcampaignsid = ?";
          $queries[] = "DELETE FROM vtiger_emailcamp_sendemail WHERE emailcampaignsid = ?";

          foreach($queries as $query) {

            $adb->pquery($query, $params);
          }

          $response->setResult(array('status' => 'yes', 'message' => vtranslate('LBL_CAMPAIGN_RELEASED', $moduleName), 'record' => $currId));
        }
        else {

          $response->setResult(array('status' => 'no', 'message' => vtranslate('LBL_CAMPAIGN_NOT_RELEASED', $moduleName), 'record' => $currId));
        }
      }
    }
    else {

      $response->setEmitType(Vtiger_Response::$EMIT_JSON);
      $response->setError('Unable to release campaign');
    }

    $response->emit();
  }
}
