<?php
/* +**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * ********************************************************************************** */

include_once 'modules/Vtiger/CRMEntity.php';

class EmailCampaigns extends Vtiger_CRMEntity
{

    var $table_name = 'vtiger_emailcampaigns';
    var $table_index = 'emailcampaignsid';

    /**
     * Mandatory table for supporting custom fields.
     */
    var $customFieldTable = Array('vtiger_emailcampaignscf', 'emailcampaignsid');

    /**
     * Mandatory for Saving, Include tables related to this module.
     */
    var $tab_name = Array('vtiger_crmentity', 'vtiger_emailcampaigns', 'vtiger_emailcampaignscf');

    /**
     * Mandatory for Saving, Include tablename and tablekey columnname here.
     */
    var $tab_name_index = Array(
        'vtiger_crmentity' => 'crmid',
        'vtiger_emailcampaigns' => 'emailcampaignsid',
        'vtiger_emailcampaignscf' => 'emailcampaignsid');

    /**
     * Mandatory for Listing (Related listview)
     */
    var $list_fields = Array(
        /* Format: Field Label => Array(tablename, columnname) */
        // tablename should not have prefix 'vtiger_'
        'Campaign Name' => Array('emailcampaigns', 'campaign_name'),
        'Assigned To' => Array('crmentity', 'smownerid')
    );
    var $list_fields_name = Array(
        /* Format: Field Label => fieldname */
        'Campaign Name' => 'campaign_name',
        'Assigned To' => 'assigned_user_id',
    );
    // Make the field link to detail view
    var $list_link_field = 'campaign_name';
    // For Popup listview and UI type support
    var $search_fields = Array(
        /* Format: Field Label => Array(tablename, columnname) */
        // tablename should not have prefix 'vtiger_'
        'Campaign Name' => Array('emailcampaigns', 'campaign_name'),
        'Assigned To' => Array('vtiger_crmentity', 'assigned_user_id'),
    );
    var $search_fields_name = Array(
        /* Format: Field Label => fieldname */
        'Campaign Name' => 'campaign_name',
        'Assigned To' => 'assigned_user_id',
    );
    // For Popup window record selection
    var $popup_fields = Array('campaign_name');
    // For Alphabetical search
    var $def_basicsearch_col = 'campaign_name';
    // Column value to use on detail view record text display
    var $def_detailview_recname = 'campaign_name';
    // Used when enabling/disabling the mandatory fields for the module.
    // Refers to vtiger_field.fieldname values.
    var $mandatory_fields = Array('campaign_name', 'assigned_user_id');
    var $default_order_by = 'campaign_name';
    var $default_sort_order = 'ASC';

    /**
     * Invoked when special actions are performed on the module.
     * @param String Module name
     * @param String Event Type
     */
    function vtlib_handler($moduleName, $eventType)
    {
        global $adb;
        $displayLabel = 'EmailCampaign';
        if ($eventType == 'module.postinstall') {
            $this->setupIcon();
            try {
                $adb->pquery("UPDATE vtiger_field SET presence=1 WHERE tablename='vtiger_emailcampaigns' AND fieldname IN ('from_email','from_name','reply_to');", array());
            } catch (Exception $e) {
                //This to catch ex in case column doesn't exist.
            }


            if (vtlib_isModuleActive("Workflow2")) {
                $wf2 = CRMEntity::getInstance("Workflow2");
                $wf2->addTrigger("EMARKETING_CLICK", "LBL_EMARKETING_CLICK", "EmailCampaigns", "Triggered when the user clicks on a link");
                $wf2->addTrigger("EMARKETING_OPEN", "LBL_EMARKETING_OPEN", "EmailCampaigns", "Triggered when the mail is opened");
            }

            $this->updateSettings();

            $rlist = $adb->pquery("SELECT '1' FROM vtiger_relatedlists WHERE name='get_report' AND label='Report' AND actions='ADD'", array());
            if ($adb->num_rows($rlist) == 0) {
                $moduleInstance = Vtiger_Module::getInstance('EmailCampaigns');
                $leadsmodule = Vtiger_Module::getInstance('Leads');
                $relationLabel = 'Report';
                $moduleInstance->setRelatedList($leadsmodule, $relationLabel, Array('ADD'), 'get_report');
            }

            $tabId = getTabid("EmailCampaigns");
            $rlist = $adb->pquery("SELECT '1' FROM vtiger_relatedlists WHERE name='get_attachments' AND label='Documents' AND tabid=?", array($tabId));
            if ($adb->num_rows($rlist) == 0) {
                $moduleInstance = Vtiger_Module::getInstance('EmailCampaigns');
                $accountsModule = Vtiger_Module::getInstance('Documents');
                $relationLabel = 'Documents';
                $moduleInstance->setRelatedList(
                    $accountsModule, $relationLabel, Array('1'), 'get_attachments'
                );
            }

            $leadsinstance = Vtiger_Module::getInstance("Leads");
            $blockInstance = Vtiger_Block::getInstance("LBL_LEAD_INFORMATION", $leadsinstance);
            $fieldInstance = Vtiger_Field::getInstance("emailcampaign_optout", $leadsinstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'emailcampaign_optout';
                $fieldInstance->table = 'vtiger_leaddetails';
                $fieldInstance->column = 'emailcampaign_optout';
                $fieldInstance->label = 'Email Campaign Opt Out';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = "VARCHAR(3) NOT NULL DEFAULT '0'";
                $fieldInstance->maximumlength = 3;
                $fieldInstance->uitype = 56;
                $fieldInstance->typeofdata = 'C~O';
                $fieldInstance->generatedtype = 1;
                $blockInstance->addField($fieldInstance);
            }

            $accountsinstance = Vtiger_Module::getInstance("Accounts");
            $blockInstance = Vtiger_Block::getInstance("LBL_ACCOUNT_INFORMATION", $accountsinstance);
            $fieldInstance = Vtiger_Field::getInstance("emailcampaign_optout", $accountsinstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'emailcampaign_optout';
                $fieldInstance->table = 'vtiger_account';
                $fieldInstance->column = 'emailcampaign_optout';
                $fieldInstance->label = 'Email Campaign Opt Out';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = "VARCHAR(3) NOT NULL DEFAULT '0'";
                $fieldInstance->maximumlength = 3;
                $fieldInstance->uitype = 56;
                $fieldInstance->typeofdata = 'C~O';
                $fieldInstance->generatedtype = 1;
                $blockInstance->addField($fieldInstance);
            }

            $leadsinstance = Vtiger_Module::getInstance("Contacts");
            $blockInstance = Vtiger_Block::getInstance("LBL_CONTACT_INFORMATION", $leadsinstance);
            $fieldInstance = Vtiger_Field::getInstance("emailcampaign_optout", $leadsinstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'emailcampaign_optout';
                $fieldInstance->table = 'vtiger_contactdetails';
                $fieldInstance->column = 'emailcampaign_optout';
                $fieldInstance->label = 'Email Campaign Opt Out';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = "VARCHAR(3) NOT NULL DEFAULT '0'";
                $fieldInstance->maximumlength = 3;
                $fieldInstance->uitype = 56;
                $fieldInstance->typeofdata = 'C~O';
                $fieldInstance->generatedtype = 1;
                $blockInstance->addField($fieldInstance);
            }

            $moduleInstance = Vtiger_Module::getInstance($moduleName);
            /* AGGIUNTA CAMPI */
            // Aggiungta blocco Contatori Report
            $blockInstance = Vtiger_Block::getInstance("LBL_CAMPAIGN_REPORT", $moduleInstance);
            if ($blockInstance === false) {
                $blockInstance = new Vtiger_Block();
                $blockInstance->label = 'LBL_CAMPAIGN_REPORT';
                $moduleInstance->addBlock($blockInstance);
            }
            // Aggiunta campo mailsent_tot
            $fieldInstance = Vtiger_Field::getInstance("mailsent_tot", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'mailsent_tot';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'mailsent_tot';
                $fieldInstance->label = 'LBL_MAILSENT_TOT';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'INT(10)';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 7;
                $fieldInstance->typeofdata = 'I~O';
                $fieldInstance->generatedtype = 1;
                $blockInstance->addField($fieldInstance);
            }
            
            // Aggiunta campo tosent_tot
            $fieldInstance = Vtiger_Field::getInstance("tosent_tot", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'tosent_tot';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'tosent_tot';
                $fieldInstance->label = 'LBL_TOSENT_TOT';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'INT(10)';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 7;
                $fieldInstance->typeofdata = 'I~O';
                $fieldInstance->generatedtype = 1;
                $blockInstance->addField($fieldInstance);
            }

            // Aggiunta campo uniqueopen_tot
            $fieldInstance = Vtiger_Field::getInstance("uniqueopen_tot", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'uniqueopen_tot';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'uniqueopen_tot';
                $fieldInstance->label = 'LBL_UNIQUEOPEN_TOT';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'INT(10)';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 7;
                $fieldInstance->typeofdata = 'I~O';
                $fieldInstance->generatedtype = 1;
                $blockInstance->addField($fieldInstance);
            }
            // Aggiunta campo uniqueopen_per
            $fieldInstance = Vtiger_Field::getInstance("uniqueopen_per", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'uniqueopen_per';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'uniqueopen_per';
                $fieldInstance->label = 'LBL_UNIQUEOPEN_PER';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'DECIMAL(5,2)';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 9;
                $fieldInstance->typeofdata = 'N~O~2~2';
                $fieldInstance->generatedtype = 1;
                $blockInstance->addField($fieldInstance);
            }

            // Aggiunta campo unsubscribers_tot
            $fieldInstance = Vtiger_Field::getInstance("unsubscribers_tot", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'unsubscribers_tot';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'unsubscribers_tot';
                $fieldInstance->label = 'LBL_UNSUBSCRIBERS_TOT';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'INT(10)';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 7;
                $fieldInstance->typeofdata = 'I~O';
                $fieldInstance->generatedtype = 1;
                $blockInstance->addField($fieldInstance);
            }
            // Aggiunta campo clickonlink_tot
            $fieldInstance = Vtiger_Field::getInstance("clickonlink_tot", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'clickonlink_tot';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'clickonlink_tot';
                $fieldInstance->label = 'LBL_CLICKONLINK_TOT';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'INT(10)';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 7;
                $fieldInstance->typeofdata = 'I~O';
                $fieldInstance->generatedtype = 1;
                $blockInstance->addField($fieldInstance);
            }

            // Aggiunta campo eclog
            $fieldInstance = Vtiger_Field::getInstance("eclog", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'eclog';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'eclog';
                $fieldInstance->label = 'LBL_ECLOG';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'TEXT';
                $fieldInstance->maximumlength = 0;
                $fieldInstance->uitype = 19;
                $fieldInstance->typeofdata = 'V~O';
                $fieldInstance->generatedtype = 1;
                $fieldInstance->displaytype = 3;
                $blockInstance->addField($fieldInstance);
            }

            $blockInstance = Vtiger_Block::getInstance("Campaign Details", $moduleInstance);

            // Aggiunta campo typeofassignment
            $fieldInstance = Vtiger_Field::getInstance("typeofassignment", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'typeofassignment';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'typeofassignment';
                $fieldInstance->label = 'LBL_TYPEOFASSIGNMENT';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'VARCHAR(100)';
                $fieldInstance->defaultvalue = 'LBL_ASS_CAMPAIGN';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 16;
                $fieldInstance->typeofdata = 'V~M';
                $fieldInstance->generatedtype = 1;
                $fieldInstance->setPicklistValues(Array('LBL_ASS_CAMPAIGN', 'LBL_ASS_ENTITY', 'LBL_ASS_FIX'));
                $blockInstance->addField($fieldInstance);
            }
            $fieldInstance = Vtiger_Field::getInstance("smtpsetting", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'smtpsetting';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'smtpsetting';
                $fieldInstance->label = 'LBL_SMTPSETTING';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'VARCHAR(100)';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 16;
                $fieldInstance->typeofdata = 'V~M';
                $fieldInstance->generatedtype = 1;
                $fieldInstance->setPicklistValues(Array());
                $blockInstance->addField($fieldInstance);
            }
            
                        // Status field I374
            $fieldInstance = Vtiger_Field::getInstance("campaign_status", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'campaign_status';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'campaign_status';
                $fieldInstance->label = 'LBL_CAMPAIGN_STATUS';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 0;
                $fieldInstance->columntype = 'VARCHAR(100)';
                $fieldInstance->defaultvalue = 'LBL_CREATED';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 16;
                $fieldInstance->typeofdata = 'V~O';
                $fieldInstance->generatedtype = 1;
                $fieldInstance->quickcreate = 3;
                $fieldInstance->masseditable = 0;
                $fieldInstance->summaryfield = 1;
                $fieldInstance->setPicklistValues(Array('LBL_CREATED', 'LBL_SCHEDULED', 'LBL_RUNNING', 'LBL_COMPLETED'));
                $blockInstance->addField($fieldInstance);
            }
            //End
            $funnelModuleModel = Vtiger_Module::getInstance('Funnel');
            $fieldInstance = Vtiger_Field::getInstance("funnelid", $moduleInstance);
            if ($fieldInstance === false && $funnelModuleModel) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'funnelid';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'funnelid';
                $fieldInstance->label = 'LBL_FUNNEL';
                $fieldInstance->columntype = 'INT(11)';
                $fieldInstance->uitype = 10;
                $fieldInstance->typeofdata = 'V~O';
                $fieldInstance->generatedtype = 1;
                $fieldInstance->quickcreate = 3;
                $fieldInstance->masseditable = 0;
                $blockInstance->addField($fieldInstance);
                $fieldInstance->setRelatedModules(array('Funnel'));
            } 

            // Custom link params
            $fieldInstance = Vtiger_Field::getInstance("custom_link_params", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'custom_link_params';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'custom_link_params';
                $fieldInstance->label = 'LBL_CUSTOM_LINK_PARAMS';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'VARCHAR(255)';
                $fieldInstance->maximumlength = 255;
                $fieldInstance->uitype = 1;
                $fieldInstance->typeofdata = 'V~O';
                $fieldInstance->generatedtype = 1;
                $blockInstance->addField($fieldInstance);
            }
            //End
            // Aggiunta campo assignto
            $fieldInstance = Vtiger_Field::getInstance("assignto", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'assignto';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'assignto';
                $fieldInstance->label = 'LBL_ASSIGNTO';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'INT(19)';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 53;
                $fieldInstance->typeofdata = 'V~O';
                $fieldInstance->generatedtype = 1;
                $blockInstance->addField($fieldInstance);
            }
            /* VTCONN #GG - Fine */

            $blockLIInstance = Vtiger_Block::getInstance("List Information", $moduleInstance);
            $fieldInstance = Vtiger_Field::getInstance("notwhopenemail", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'notwhopenemail';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'notwhopenemail';
                $fieldInstance->label = 'LBL_SEND_SUBSCRIBER_NOT_OPEN_EMAIL';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'VARCHAR(3) DEFAULT \'0\'';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 56;
                $fieldInstance->typeofdata = 'C~O';
                $fieldInstance->generatedtype = 1;
                $blockLIInstance->addField($fieldInstance);
            }
            $fieldInstance = Vtiger_Field::getInstance("notemailclicklink", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'notemailclicklink';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'notemailclicklink';
                $fieldInstance->label = 'LBL_SEND_SUBSCRIBER_NOT_EMAIL_LINK_CLICK';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'VARCHAR(3) DEFAULT \'0\'';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 56;
                $fieldInstance->typeofdata = 'C~O';
                $fieldInstance->generatedtype = 1;
                $blockLIInstance->addField($fieldInstance);
            }
            $fieldInstance = Vtiger_Field::getInstance("allprevsubcribers", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'allprevsubcribers';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'allprevsubcribers';
                $fieldInstance->label = 'LBL_SEND_ALL_PREV_SUBCRIBERS';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'VARCHAR(3) DEFAULT \'0\'';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 56;
                $fieldInstance->typeofdata = 'C~O';
                $fieldInstance->generatedtype = 1;
                $blockLIInstance->addField($fieldInstance);
            }
            
            // Aggiornamento filtro ALL Rif. TT17389 - I484 - Start
            $adb = PearDatabase::getInstance();
            $adb->pquery("delete FROM vtiger_cvcolumnlist WHERE CVID=(select cvid from vtiger_customview  WHERE entitytype='EmailCampaigns' AND viewname='All') ", array());
            $adb->pquery("INSERT INTO vtiger_cvcolumnlist VALUES
                            ((select cvid from vtiger_customview  WHERE entitytype='EmailCampaigns' AND viewname='All'),0,'vtiger_emailcampaigns:campaign_name:campaign_name:EmailCampaigns_Campaign_Name:V'),
                            ((select cvid from vtiger_customview  WHERE entitytype='EmailCampaigns' AND viewname='All'),1,'vtiger_emailcampaigns:subject:subject:EmailCampaigns_Email_Subject:V'),
                            ((select cvid from vtiger_customview  WHERE entitytype='EmailCampaigns' AND viewname='All'),2,'vtiger_emailcampaigns:campaign_status:campaign_status:EmailCampaigns_LBL_CAMPAIGN_STATUS:V'),
                            ((select cvid from vtiger_customview  WHERE entitytype='EmailCampaigns' AND viewname='All'),3,'vtiger_emailcampaigns:tosent_tot:tosent_tot:EmailCampaigns_LBL_TOSENT_TOT:I'),
                            ((select cvid from vtiger_customview  WHERE entitytype='EmailCampaigns' AND viewname='All'),4,'vtiger_emailcampaigns:mailsent_tot:mailsent_tot:EmailCampaigns_LBL_MAILSENT_TOT:I'),
                            ((select cvid from vtiger_customview  WHERE entitytype='EmailCampaigns' AND viewname='All'),5,'vtiger_emailcampaigns:uniqueopen_tot:uniqueopen_tot:EmailCampaigns_LBL_UNIQUEOPEN_TOT:I'),
                            ((select cvid from vtiger_customview  WHERE entitytype='EmailCampaigns' AND viewname='All'),6,'vtiger_emailcampaigns:uniqueopen_per:uniqueopen_per:EmailCampaigns_LBL_UNIQUEOPEN_PER:N'),
                            ((select cvid from vtiger_customview  WHERE entitytype='EmailCampaigns' AND viewname='All'),7,'vtiger_emailcampaigns:clickonlink_tot:clickonlink_tot:EmailCampaigns_LBL_CLICKONLINK_TOT:I'),
                            ((select cvid from vtiger_customview  WHERE entitytype='EmailCampaigns' AND viewname='All'),8,'vtiger_emailcampaigns:unsubscribers_tot:unsubscribers_tot:EmailCampaigns_LBL_UNSUBSCRIBERS_TOT:I')  ", array());
// Aggiornamento filtro ALL Rif. TT17389 - End

            /* AGGIUNTA CAMPI */
        } else if ($eventType == 'module.disabled') {
            $moduleInstance = Vtiger_Module::getInstance($moduleName);
            $moduleInstance->deleteLink('HEADERSCRIPT', 'emailcampaign', 'layouts/vlayout/Settings/EmailCampaigns/resources/EmailCampaigns.js');
            $adb->pquery('UPDATE vtiger_settings_field SET active = 1  WHERE  name= ?', array($displayLabel));
            // TODO Handle actions before this module is being uninstalled.
        } else if ($eventType == 'module.preuninstall') {
            // TODO Handle actions when this module is about to be deleted.
        } else if ($eventType == 'module.preupdate') {
            //AGGIORNAMENTO STATISTICHE PRECEDENTI
            // mailsent_tot
            $adb->pquery("UPDATE vtiger_emailcampaigns e inner join (
						SELECT vtiger_emailcamp_sendemail.emailcampaignsid, count(*) as tot FROM  vtiger_emaildetails
							INNER JOIN vtiger_emailcamp_sendemail ON vtiger_emaildetails.emailid  = vtiger_emailcamp_sendemail.activityid
						WHERE  vtiger_emaildetails.email_flag = 'SENT' group by vtiger_emailcamp_sendemail.emailcampaignsid )  t on t.emailcampaignsid = e.emailcampaignsid set e.mailsent_tot=t.tot ", array());
            // uniqueopen_tot
            $adb->pquery("UPDATE vtiger_emailcampaigns e inner join (
						SELECT vtiger_emailcamp_sendemail.emailcampaignsid,count(*) as tot
							FROM vtiger_emaildetails
							INNER JOIN vtiger_email_track ON vtiger_emaildetails.emailid = vtiger_email_track.mailid
							INNER JOIN vtiger_emailcamp_sendemail ON vtiger_emailcamp_sendemail.activityid  = vtiger_email_track.mailid
						WHERE  vtiger_email_track.access_count > 0 group by vtiger_emailcamp_sendemail.emailcampaignsid ) t on t.emailcampaignsid = e.emailcampaignsid set e.uniqueopen_tot=t.tot", array());
            // uniqueopen_per
            $adb->pquery("UPDATE vtiger_emailcampaigns set uniqueopen_per = round((uniqueopen_tot * 100) / mailsent_tot,2)", array());

            // TODO Handle actions before this module is updated.
        } else if ($eventType == 'module.postupdate') {
            $this->setupIcon();
            try {
                $adb->pquery("UPDATE vtiger_field SET presence=1 WHERE tablename='vtiger_emailcampaigns' AND fieldname IN ('from_email','from_name','reply_to');", array());
            } catch (Exception $e) {
                //This to catch ex in case column doesn't exist.
            }

            if (vtlib_isModuleActive("Workflow2")) {
                $wf2 = CRMEntity::getInstance("Workflow2");
                $wf2->addTrigger("EMARKETING_CLICK", "LBL_EMARKETING_CLICK", "EmailCampaigns", "Triggered when the user clicks on a link");
                $wf2->addTrigger("EMARKETING_OPEN", "LBL_EMARKETING_OPEN", "EmailCampaigns", "Triggered when the mail is opened");
            }

            $rlist = $adb->pquery("SELECT '1' FROM vtiger_relatedlists WHERE name='get_report' AND label='Report' AND actions='ADD'", array());
            if ($adb->num_rows($rlist) == 0) {
                $moduleInstance = Vtiger_Module::getInstance('EmailCampaigns');
                $leadsmodule = Vtiger_Module::getInstance('Leads');
                $relationLabel = 'Report';
                $moduleInstance->setRelatedList($leadsmodule, $relationLabel, Array('ADD'), 'get_report');
            }

            $tabId = getTabid("EmailCampaigns");
            $rlist = $adb->pquery("SELECT '1' FROM vtiger_relatedlists WHERE name='get_attachments' AND label='Documents' AND tabid=?", array($tabId));
            if ($adb->num_rows($rlist) == 0) {
                $moduleInstance = Vtiger_Module::getInstance('EmailCampaigns');
                $accountsModule = Vtiger_Module::getInstance('Documents');
                $relationLabel = 'Documents';
                $moduleInstance->setRelatedList(
                    $accountsModule, $relationLabel, Array('1'), 'get_attachments'
                );
            }


            /* VTCONN #GG - Inizio */
            $moduleInstance = Vtiger_Module::getInstance($moduleName);
            // Aggiungta blocco Contatori Report
            $blockInstance = Vtiger_Block::getInstance("LBL_CAMPAIGN_REPORT", $moduleInstance);
            if ($blockInstance === false) {
                $blockInstance = new Vtiger_Block();
                $blockInstance->label = 'LBL_CAMPAIGN_REPORT';
                $moduleInstance->addBlock($blockInstance);
            }
            // Aggiunta campo mailsent_tot
            $fieldInstance = Vtiger_Field::getInstance("mailsent_tot", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'mailsent_tot';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'mailsent_tot';
                $fieldInstance->label = 'LBL_MAILSENT_TOT';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'INT(10)';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 7;
                $fieldInstance->typeofdata = 'I~O';
                $fieldInstance->generatedtype = 1;
                $blockInstance->addField($fieldInstance);
            }
            
            // Aggiunta campo tosent_tot
            $fieldInstance = Vtiger_Field::getInstance("tosent_tot", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'tosent_tot';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'tosent_tot';
                $fieldInstance->label = 'LBL_TOSENT_TOT';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'INT(10)';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 7;
                $fieldInstance->typeofdata = 'I~O';
                $fieldInstance->generatedtype = 1;
                $blockInstance->addField($fieldInstance);
            }


            $fieldInstance = Vtiger_Field::getInstance("select_option", $moduleInstance);
            if ($fieldInstance) {

                $pickListValues = $adb->pquery("SELECT select_option FROM `vtiger_select_option`", array());
                $pickListValueArr = array();
                while ($row = $adb->fetch_array($pickListValues)) {
                    $pickListValueArr[] = $row['select_option'];
                }
                if (!in_array("Select from Flex report", $pickListValueArr)) {
                    $rolesArr = array();
                    $roles = $adb->pquery("SELECT * FROM vtiger_role;");
                    while ($row = $adb->fetch_array($roles)) {
                        $rolesArr[] = $row["roleid"];
                    }

                    $pickListModel = Settings_Picklist_Module_Model::getInstance($moduleName);
                    $fieldModel = Settings_Picklist_Field_Model::getInstance("select_option", $pickListModel);
                    $status = $pickListModel->addPickListValues($fieldModel, 'Select from Flex report', $rolesArr);
                }
            }
            // Aggiunta campo uniqueopen_tot
            $fieldInstance = Vtiger_Field::getInstance("uniqueopen_tot", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'uniqueopen_tot';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'uniqueopen_tot';
                $fieldInstance->label = 'LBL_UNIQUEOPEN_TOT';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'INT(10)';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 7;
                $fieldInstance->typeofdata = 'I~O';
                $fieldInstance->generatedtype = 1;
                $blockInstance->addField($fieldInstance);
            }
            // Aggiunta campo uniqueopen_per
            $fieldInstance = Vtiger_Field::getInstance("uniqueopen_per", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'uniqueopen_per';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'uniqueopen_per';
                $fieldInstance->label = 'LBL_UNIQUEOPEN_PER';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'DECIMAL(5,2)';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 9;
                $fieldInstance->typeofdata = 'N~O~2~2';
                $fieldInstance->generatedtype = 1;
                $blockInstance->addField($fieldInstance);
            }
            // Aggiunta campo subscribers_tot
            $fieldInstance = Vtiger_Field::getInstance("subscribers_tot", $moduleInstance);
            if ($fieldInstance === true) {
                $fieldInstance->delete();
            }
            // Aggiunta campo unsubscribers_tot
            $fieldInstance = Vtiger_Field::getInstance("unsubscribers_tot", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'unsubscribers_tot';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'unsubscribers_tot';
                $fieldInstance->label = 'LBL_UNSUBSCRIBERS_TOT';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'INT(10)';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 7;
                $fieldInstance->typeofdata = 'I~O';
                $fieldInstance->generatedtype = 1;
                $blockInstance->addField($fieldInstance);
            }
            // Aggiunta campo clickonlink_tot
            $fieldInstance = Vtiger_Field::getInstance("clickonlink_tot", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'clickonlink_tot';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'clickonlink_tot';
                $fieldInstance->label = 'LBL_CLICKONLINK_TOT';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'INT(10)';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 7;
                $fieldInstance->typeofdata = 'I~O';
                $fieldInstance->generatedtype = 1;
                $blockInstance->addField($fieldInstance);
            }

            // Aggiunta campo emlog
            $fieldInstance = Vtiger_Field::getInstance("eclog", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'eclog';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'eclog';
                $fieldInstance->label = 'LBL_ECLOG';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'TEXT';
                $fieldInstance->maximumlength = 0;
                $fieldInstance->uitype = 19;
                $fieldInstance->typeofdata = 'V~O';
                $fieldInstance->generatedtype = 1;
                $fieldInstance->displaytype = 3;
                $blockInstance->addField($fieldInstance);
            }

            $blockInstance = Vtiger_Block::getInstance("Campaign Details", $moduleInstance);

            // Aggiunta campo typeofassignment
            $fieldInstance = Vtiger_Field::getInstance("typeofassignment", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'typeofassignment';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'typeofassignment';
                $fieldInstance->label = 'LBL_TYPEOFASSIGNMENT';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'VARCHAR(100)';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 16;
                $fieldInstance->defaultvalue = 'LBL_ASS_CAMPAIGN';
                $fieldInstance->typeofdata = 'V~M';
                $fieldInstance->generatedtype = 1;
                $fieldInstance->setPicklistValues(Array('LBL_ASS_CAMPAIGN', 'LBL_ASS_ENTITY', 'LBL_ASS_FIX'));
                $blockInstance->addField($fieldInstance);
            }

            $fieldInstance = Vtiger_Field::getInstance("smtpsetting", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'smtpsetting';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'smtpsetting';
                $fieldInstance->label = 'LBL_SMTPSETTING';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'VARCHAR(100)';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 16;
                $fieldInstance->typeofdata = 'V~M';
                $fieldInstance->generatedtype = 1;
                $fieldInstance->setPicklistValues(Array());
                $blockInstance->addField($fieldInstance);
            }
                        // Status field I374
            $fieldInstance = Vtiger_Field::getInstance("campaign_status", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'campaign_status';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'campaign_status';
                $fieldInstance->label = 'LBL_CAMPAIGN_STATUS';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 0;
                $fieldInstance->columntype = 'VARCHAR(100)';
                $fieldInstance->defaultvalue = 'LBL_CREATED';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 16;
                $fieldInstance->typeofdata = 'V~O';
                $fieldInstance->generatedtype = 1;
                $fieldInstance->quickcreate = 3;
                $fieldInstance->masseditable = 0;
                $fieldInstance->summaryfield = 1;
                $fieldInstance->setPicklistValues(Array('LBL_CREATED', 'LBL_SCHEDULED', 'LBL_RUNNING', 'LBL_COMPLETED'));
                $blockInstance->addField($fieldInstance);
            }
            
            $funnelModuleModel = Vtiger_Module::getInstance('Funnel');
            $fieldInstance = Vtiger_Field::getInstance("funnelid", $moduleInstance);
            if ($fieldInstance === false && $funnelModuleModel) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'funnelid';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'funnelid';
                $fieldInstance->label = 'LBL_FUNNEL';
                $fieldInstance->columntype = 'INT(11)';
                $fieldInstance->uitype = 10;
                $fieldInstance->typeofdata = 'V~O';
                $fieldInstance->generatedtype = 1;
                $fieldInstance->quickcreate = 3;
                $fieldInstance->masseditable = 0;
                $blockInstance->addField($fieldInstance);
                $fieldInstance->setRelatedModules(array('Funnel'));
            }
            //End

            // Custom link params
            $fieldInstance = Vtiger_Field::getInstance("custom_link_params", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'custom_link_params';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'custom_link_params';
                $fieldInstance->label = 'LBL_CUSTOM_LINK_PARAMS';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'VARCHAR(255)';
                $fieldInstance->maximumlength = 255;
                $fieldInstance->uitype = 1;
                $fieldInstance->typeofdata = 'V~O';
                $fieldInstance->generatedtype = 1;
                $blockInstance->addField($fieldInstance);
            }
            //End
            
            // Aggiunta campo assignto
            $fieldInstance = Vtiger_Field::getInstance("assignto", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'assignto';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'assignto';
                $fieldInstance->label = 'LBL_ASSIGNTO';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'INT(19)';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 53;
                $fieldInstance->typeofdata = 'V~O';
                $fieldInstance->generatedtype = 1;
                $blockInstance->addField($fieldInstance);
            }

            $blockLIInstance = Vtiger_Block::getInstance("List Information", $moduleInstance);
            $fieldInstance = Vtiger_Field::getInstance("notwhopenemail", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'notwhopenemail';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'notwhopenemail';
                $fieldInstance->label = 'LBL_SEND_SUBSCRIBER_NOT_OPEN_EMAIL';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'VARCHAR(3) DEFAULT \'0\'';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 56;
                $fieldInstance->typeofdata = 'C~O';
                $fieldInstance->generatedtype = 1;
                $blockLIInstance->addField($fieldInstance);
            }
            $fieldInstance = Vtiger_Field::getInstance("notemailclicklink", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'notemailclicklink';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'notemailclicklink';
                $fieldInstance->label = 'LBL_SEND_SUBSCRIBER_NOT_EMAIL_LINK_CLICK';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'VARCHAR(3) DEFAULT \'0\'';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 56;
                $fieldInstance->typeofdata = 'C~O';
                $fieldInstance->generatedtype = 1;
                $blockLIInstance->addField($fieldInstance);
            }
            $fieldInstance = Vtiger_Field::getInstance("allprevsubcribers", $moduleInstance);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'allprevsubcribers';
                $fieldInstance->table = 'vtiger_emailcampaigns';
                $fieldInstance->column = 'allprevsubcribers';
                $fieldInstance->label = 'LBL_SEND_ALL_PREV_SUBCRIBERS';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'VARCHAR(3) DEFAULT \'0\'';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 56;
                $fieldInstance->typeofdata = 'C~O';
                $fieldInstance->generatedtype = 1;
                $blockLIInstance->addField($fieldInstance);
            }
            /* VTCONN #GG - Fine */
            // Aggiornamento filtro ALL Rif. TT17389 - Start
            $adb->pquery("delete FROM vtiger_cvcolumnlist WHERE CVID=(select cvid from vtiger_customview  WHERE entitytype='EmailCampaigns' AND viewname='All') ", array());
            $adb->pquery("INSERT INTO vtiger_cvcolumnlist VALUES
                            ((select cvid from vtiger_customview  WHERE entitytype='EmailCampaigns' AND viewname='All'),0,'vtiger_emailcampaigns:campaign_name:campaign_name:EmailCampaigns_Campaign_Name:V'),
                            ((select cvid from vtiger_customview  WHERE entitytype='EmailCampaigns' AND viewname='All'),1,'vtiger_emailcampaigns:subject:subject:EmailCampaigns_Email_Subject:V'),
                            ((select cvid from vtiger_customview  WHERE entitytype='EmailCampaigns' AND viewname='All'),2,'vtiger_emailcampaigns:campaign_status:campaign_status:EmailCampaigns_LBL_CAMPAIGN_STATUS:V'),
                            ((select cvid from vtiger_customview  WHERE entitytype='EmailCampaigns' AND viewname='All'),3,'vtiger_emailcampaigns:tosent_tot:tosent_tot:EmailCampaigns_LBL_TOSENT_TOT:I'),
                            ((select cvid from vtiger_customview  WHERE entitytype='EmailCampaigns' AND viewname='All'),4,'vtiger_emailcampaigns:mailsent_tot:mailsent_tot:EmailCampaigns_LBL_MAILSENT_TOT:I'),
                            ((select cvid from vtiger_customview  WHERE entitytype='EmailCampaigns' AND viewname='All'),5,'vtiger_emailcampaigns:uniqueopen_tot:uniqueopen_tot:EmailCampaigns_LBL_UNIQUEOPEN_TOT:I'),
                            ((select cvid from vtiger_customview  WHERE entitytype='EmailCampaigns' AND viewname='All'),6,'vtiger_emailcampaigns:uniqueopen_per:uniqueopen_per:EmailCampaigns_LBL_UNIQUEOPEN_PER:N'),
                            ((select cvid from vtiger_customview  WHERE entitytype='EmailCampaigns' AND viewname='All'),7,'vtiger_emailcampaigns:clickonlink_tot:clickonlink_tot:EmailCampaigns_LBL_CLICKONLINK_TOT:I'),
                            ((select cvid from vtiger_customview  WHERE entitytype='EmailCampaigns' AND viewname='All'),8,'vtiger_emailcampaigns:unsubscribers_tot:unsubscribers_tot:EmailCampaigns_LBL_UNSUBSCRIBERS_TOT:I')  ", array());

            // Aggiornamento filtro ALL Rif. TT17389 - End
//                            $adb->query('ALTER TABLE vtiger_emailcampaign_outgoingserverdetail ADD smtp_auth varchar(5) DEFAULT NULL');
            // TODO Handle actions after this module is updated.

            $moduleInstanceEtr = Vtiger_Module::getInstance('EmailTrackingReport');
            $blockInstanceEtr = Vtiger_Block::getInstance('Link Tracker Information', $moduleInstanceEtr);
            $fieldInstance = Vtiger_Field::getInstance("linklist", $moduleInstanceEtr);
            if ($fieldInstance === false) {
                $fieldInstance = new Vtiger_Field();
                $fieldInstance->name = 'linklist';
                $fieldInstance->table = 'vtiger_emailtrackingreport';
                $fieldInstance->column = 'linklist';
                $fieldInstance->label = 'LBL_LINKS_LIST';
                $fieldInstance->readonly = 1;
                $fieldInstance->presence = 2;
                $fieldInstance->columntype = 'TEXT';
                $fieldInstance->maximumlength = 100;
                $fieldInstance->uitype = 33;
                $fieldInstance->typeofdata = 'V~O';
                $fieldInstance->generatedtype = 1;
                $fieldInstance->setPicklistValues(Array('None'));
                $blockInstanceEtr->addField($fieldInstance);
            }


            $adb->pquery("UPDATE vtiger_field SET typeofdata='V~O' WHERE fieldname='subscribers_list' AND tablename='vtiger_emailcampaigns'");
        } else if ($eventType == 'module.enabled') {
            $moduleInstance = Vtiger_Module::getInstance($moduleName);
            $moduleInstance->addLink('HEADERSCRIPT', 'emailcampaign', 'layouts/vlayout/Settings/EmailCampaigns/resources/EmailCampaigns.js');
            $adb->pquery('UPDATE vtiger_settings_field SET active = 0  WHERE  name= ?', array($displayLabel));
        }
    }

    public function setupIcon()
    {
        if (file_exists(rtrim(vglobal('root_directory'), '/') . DS . 'layouts' . DS . 'v7' . DS . 'skins' . DS . 'images' . DS)) {
            copy(dirname(__FILE__) . DS . 'icon.png', rtrim(vglobal('root_directory'), '/') . DS . 'layouts' . DS . 'v7' . DS . 'skins' . DS . 'images' . DS . basename(dirname(__FILE__)) . '.png');
        }
    }

    private function updateSettings()
    {
        $adb = PearDatabase::getInstance();
        $fieldid = $adb->getUniqueID('vtiger_settings_field');
        $blockid = getSettingsBlockId('LBL_OTHER_SETTINGS');
        $seq_res = $adb->pquery("SELECT max(sequence) AS max_seq FROM vtiger_settings_field WHERE blockid = ?", array($blockid));
        if ($adb->num_rows($seq_res) > 0) {
            $cur_seq = $adb->query_result($seq_res, 0, 'max_seq');
            if ($cur_seq != null)
                $seq = $cur_seq + 1;
        }

        $result = $adb->pquery('SELECT 1 FROM vtiger_settings_field WHERE name=?', array('EmailCampaign'));
        if (!$adb->num_rows($result)) {
            $adb->pquery('INSERT INTO vtiger_settings_field(fieldid, blockid, name, iconpath, description, linkto, sequence)
		VALUES (?,?,?,?,?,?,?)', array($fieldid, $blockid, 'EmailCampaign', '', 'Email Campaign', 'index.php?module=EmailCampaigns&parent=Settings&view=EmailCampaignDetails', $seq));
        }
    }

    function get_emaillist_account($id, $cur_tab_id, $rel_tab_id, $actions = false)
    {
        global $log, $singlepane_view, $currentModule, $current_user;
        $log->debug("Entering get_emaillist_account(" . $id . ") method ...");
        $this_module = $currentModule;


        $related_module = vtlib_getModuleNameById($rel_tab_id);
        require_once("modules/$related_module/$related_module.php");
        $other = new $related_module();
        vtlib_setup_modulevars($related_module, $other);
        $singular_modname = vtlib_toSingular($related_module);

//		$result2 = $this->db->pquery("SELECT* FROM vtiger_emailcampaigns WHERE emailcampaignsid = ?", array($id));
//		$related_recorts = $this->db->query_result($result2, 0, 'related_recorts');
//
        $userNameSql = getSqlForNameInDisplayFormat(array('first_name' =>
            'vtiger_users.first_name', 'last_name' => 'vtiger_users.last_name'), 'Users');

        $query = "SELECT  vtiger_crmentity.*,vtiger_account.*,vtiger_accountbillads.*
				,vtiger_accountshipads.*,vtiger_accountscf.*, case when
			(vtiger_users.user_name not like '') then trim($userNameSql) else vtiger_groups.groupname
			end as user_name from vtiger_account
                        inner join vtiger_emailtrackingreport on vtiger_emailtrackingreport.parent_id = vtiger_account.accountid
			INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_account.accountid
			INNER JOIN vtiger_accountbillads ON vtiger_accountbillads.accountaddressid = vtiger_account.accountid
			INNER JOIN vtiger_accountshipads ON vtiger_accountshipads.accountaddressid = vtiger_account.accountid
			INNER JOIN vtiger_accountscf ON vtiger_accountscf.accountid = vtiger_account.accountid

			LEFT JOIN vtiger_groups	ON vtiger_groups.groupid = vtiger_crmentity.smownerid
			LEFT JOIN vtiger_users ON vtiger_crmentity.smownerid = vtiger_users.id
			WHERE vtiger_crmentity.deleted = 0 and vtiger_emailtrackingreport.emailcampaignsid = $id";

//		if(!empty($related_recorts)) {
//			$query .= " AND vtiger_account.accountid IN (".$related_recorts.")";
//		}
        $return_value = GetRelatedList($this_module, $related_module, $other, $query, $button, $returnset);

        if ($return_value == null)
            $return_value = Array();
        $return_value['CUSTOM_BUTTON'] = $button;

        $log->debug("Exiting get_emaillist_account method ...");
        return $return_value;
    }

    function get_emaillist_contact($id, $cur_tab_id, $rel_tab_id, $actions = false)
    {
        global $log, $singlepane_view, $currentModule, $current_user;
        $log->debug("Entering get_emaillist_contact(" . $id . ") method ...");
        $this_module = $currentModule;


        $related_module = vtlib_getModuleNameById($rel_tab_id);
        require_once("modules/$related_module/$related_module.php");
        $other = new $related_module();
        vtlib_setup_modulevars($related_module, $other);
        $singular_modname = vtlib_toSingular($related_module);


//		$result2 = $this->db->pquery("SELECT* FROM vtiger_emailcampaigns WHERE emailcampaignsid = ?", array($id));
//		$related_recorts = $this->db->query_result($result2, 0, 'related_recorts');

        $userNameSql = getSqlForNameInDisplayFormat(array('first_name' =>
            'vtiger_users.first_name', 'last_name' => 'vtiger_users.last_name'), 'Users');
        $query = "SELECT  vtiger_crmentity.*,vtiger_contactdetails.* ,case when
			(vtiger_users.user_name not like '') then trim($userNameSql) else vtiger_groups.groupname
			end as user_name from vtiger_contactdetails
                        inner join vtiger_emailtrackingreport on vtiger_emailtrackingreport.parent_id = vtiger_contactdetails.contactid
			INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_contactdetails.contactid
			LEFT JOIN vtiger_account ON vtiger_account.accountid = vtiger_contactdetails.accountid
			INNER JOIN vtiger_contactaddress ON vtiger_contactdetails.contactid = vtiger_contactaddress.contactaddressid
			INNER JOIN vtiger_contactsubdetails ON vtiger_contactdetails.contactid = vtiger_contactsubdetails.contactsubscriptionid
			INNER JOIN vtiger_customerdetails ON vtiger_contactdetails.contactid = vtiger_customerdetails.customerid
			INNER JOIN vtiger_contactscf ON vtiger_contactdetails.contactid = vtiger_contactscf.contactid
			LEFT JOIN vtiger_groups	ON vtiger_groups.groupid = vtiger_crmentity.smownerid
			LEFT JOIN vtiger_users ON vtiger_crmentity.smownerid = vtiger_users.id
			WHERE vtiger_crmentity.deleted = 0 and vtiger_emailtrackingreport.emailcampaignsid = $id
			";
//		if(!empty($related_recorts)) {
//			$query .= " AND vtiger_contactdetails.contactid IN (".$related_recorts.")";
//		}



        $return_value = GetRelatedList($this_module, $related_module, $other, $query, $button, $returnset);

        if ($return_value == null)
            $return_value = Array();
        $return_value['CUSTOM_BUTTON'] = $button;

        $log->debug("Exiting get_emaillist_contact method ...");
        return $return_value;
    }

    function get_emaillist_leads($id, $cur_tab_id, $rel_tab_id, $actions = false)
    {
        global $log, $singlepane_view, $currentModule, $current_user;
        $log->debug("Entering get_emaillist_leads(" . $id . ") method ...");
        $this_module = $currentModule;


        $related_module = vtlib_getModuleNameById($rel_tab_id);
        require_once("modules/$related_module/$related_module.php");
        $other = new $related_module();
        vtlib_setup_modulevars($related_module, $other);
        $singular_modname = vtlib_toSingular($related_module);


//		$result2 = $this->db->pquery("SELECT* FROM vtiger_emailcampaigns WHERE emailcampaignsid = ?", array($id));
//		$related_recorts = $this->db->query_result($result2, 0, 'related_recorts');

        $userNameSql = getSqlForNameInDisplayFormat(array('first_name' =>
            'vtiger_users.first_name', 'last_name' => 'vtiger_users.last_name'), 'Users');
        $query = "SELECT  vtiger_crmentity.*,vtiger_leaddetails.* ,case when
			(vtiger_users.user_name not like '') then trim($userNameSql) else vtiger_groups.groupname
			end as user_name from vtiger_leaddetails
                        inner join vtiger_emailtrackingreport on vtiger_emailtrackingreport.parent_id = vtiger_leaddetails.leadid
			INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_leaddetails.leadid
			INNER JOIN vtiger_leadsubdetails ON vtiger_leadsubdetails.leadsubscriptionid = vtiger_leaddetails.leadid
			INNER JOIN vtiger_leadaddress ON vtiger_leaddetails.leadid = vtiger_leadaddress.leadaddressid
			INNER JOIN vtiger_leadscf ON vtiger_leaddetails.leadid = vtiger_leadscf.leadid
			LEFT JOIN vtiger_groups	ON vtiger_groups.groupid = vtiger_crmentity.smownerid
			LEFT JOIN vtiger_users ON vtiger_crmentity.smownerid = vtiger_users.id
			WHERE vtiger_crmentity.deleted = 0 and vtiger_emailtrackingreport.emailcampaignsid = $id
			";

//		if(!empty($related_recorts)) {
//			$query .= " AND vtiger_leaddetails.leadid IN (".$related_recorts.")";
//		}



        $return_value = GetRelatedList($this_module, $related_module, $other, $query, $button, $returnset);

        if ($return_value == null)
            $return_value = Array();
        $return_value['CUSTOM_BUTTON'] = $button;

        $log->debug("Exiting get_emaillist_leads method ...");
        return $return_value;
    }

    function get_emails($id, $cur_tab_id, $rel_tab_id, $actions = false)
    {
        global $log, $singlepane_view, $currentModule, $current_user;
        $log->debug("Entering get_emails(" . $id . ") method ...");
        $this_module = $currentModule;

        $related_module = vtlib_getModuleNameById($rel_tab_id);
        require_once("modules/$related_module/$related_module.php");
        $other = new $related_module();
        vtlib_setup_modulevars($related_module, $other);
        $singular_modname = vtlib_toSingular($related_module);

        $parenttab = getParentTab();



        $button = '';

        $result2 = $this->db->pquery("SELECT* FROM vtiger_emailcampaigns WHERE emailcampaignsid = ?", array($id));
        $related_recorts = $this->db->query_result($result2, 0, 'related_recorts');


        $userNameSql = getSqlForNameInDisplayFormat(array('first_name' =>
            'vtiger_users.first_name', 'last_name' => 'vtiger_users.last_name'), 'Users');
        $query = "select case when (vtiger_users.user_name not like '') then trim($userNameSql) else vtiger_groups.groupname end as user_name," .
            " vtiger_activity.activityid, vtiger_activity.subject, vtiger_activity.semodule, vtiger_activity.activitytype," .
            " vtiger_emaildetails.email_flag," .
            " vtiger_activity.date_start, vtiger_activity.time_start, vtiger_activity.status, vtiger_activity.priority, vtiger_crmentity.crmid," .
            " vtiger_crmentity.smownerid,vtiger_crmentity.modifiedtime, vtiger_users.user_name, vtiger_emailcamp_sendemail.related_id as parent_id, " .
            " vtiger_email_track.access_count" .
            " from vtiger_activity" .
            " inner join vtiger_emailcamp_sendemail on vtiger_emailcamp_sendemail.activityid=vtiger_activity.activityid" .
            " inner join vtiger_emaildetails on vtiger_emaildetails.emailid  = vtiger_emailcamp_sendemail.activityid" .
            " inner join vtiger_crmentity on vtiger_crmentity.crmid=vtiger_activity.activityid" .
            " LEFT JOIN vtiger_email_track on vtiger_email_track.crmid = vtiger_emaildetails.emailid" .
            " left join vtiger_groups on vtiger_groups.groupid=vtiger_crmentity.smownerid" .
            " left join vtiger_users on  vtiger_users.id=vtiger_crmentity.smownerid" .
            " where vtiger_activity.activitytype='Emails' and vtiger_emaildetails.email_flag = 'SENT' and vtiger_crmentity.deleted=0 and vtiger_emailcamp_sendemail.emailcampaignsid=" . $id;




        $return_value = GetRelatedList($this_module, $related_module, $other, $query, $button, $returnset);

        if ($return_value == null)
            $return_value = Array();
        $return_value['CUSTOM_BUTTON'] = $button;

        $log->debug("Exiting get_emails method ...");
        return $return_value;
    }

    /**
     * Dummy function to prevent report related list error.
     */
    function get_report()
    {
        return '';
    }
}
