<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
include_once 'modules/Vtiger/CRMEntity.php';
require_once 'vtlib/Vtiger/Net/Client.php';

function SendNotificationFollowRecord($entityData){
	$adb = PearDatabase::getInstance();
	$moduleName = $entityData->getModuleName();
	$wsId = $entityData->getId();
	$parts = explode('x', $wsId);
	$recordId = $parts[1];
	$moduleId = $parts[0];

	$titleMessageSQL = $adb->pquery("SELECT notification_title,notification_message FROM ctmobile_notification_settings WHERE notification_type = ?",array('follow_record'));
	$title = decode_html(decode_html($adb->query_result($titleMessageSQL, 0, "notification_title")));
	$message = decode_html(decode_html($adb->query_result($titleMessageSQL, 0, "notification_message")));
	
	$getFollowUserSql = $adb->pquery("SELECT userid FROM vtiger_crmentity_user_field WHERE recordid = ? AND starred = '1'",array($recordId));
	if($adb->num_rows($getFollowUserSql)){
		for ($i=0; $i < $adb->num_rows($getFollowUserSql); $i++) { 
			$userid = $adb->query_result($getFollowUserSql,$i,'userid');
			if(checkPermission('follow_record',$userid)){
				$perm_qry = "SELECT devicetoken,device_type FROM ctmobile_userdevicetoken  WHERE userid = ? ";
				$perm_result = $adb->pquery($perm_qry, array($userid));
				$perm_rows = $adb->num_rows($perm_result);
				if($perm_rows > 0){
					$devicetoken = $adb->query_result($perm_result, 0, "devicetoken");
					$device_type = $adb->query_result($perm_result,0,'device_type');
					if($devicetoken != '' && $device_type != ''){
						$record_id = saveNotification($title,$message,$userid,$recordId,'Draft',$devicetoken);
						if($record_id != ''){
							$result = sendpushnotification($message,$devicetoken,$device_type,$wsId,$moduleName,$title);
							if($result){
								$recordModel = Vtiger_Record_Model::getInstanceById($record_id, $module_Name);
								$modelData = $recordModel->getData();
								$recordModel->set('mode', 'edit');
								$recordModel->set('pushnotification_response', $result);
								$recordModel->set('pushnotificationstatus', 'Send');
								$recordModel->save();
							}
						}
					}else{
						$record_id = saveNotification($title,$message,$userid,$recordId,'Failed','');
					}
				}
			}else{
				$record_id = saveNotification($title,$message,$userid,$recordId,'Failed','');
			}
		}
	}
}

function SendEventNotificationInviteUser($entityData){
	$adb = PearDatabase::getInstance();
	$moduleName = $entityData->getModuleName();
	$wsId = $entityData->getId();
	$parts = explode('x', $wsId);
	$recordId = $parts[1];
	$moduleId = $parts[0];

	$titleMessageSQL = $adb->pquery("SELECT notification_title,notification_message FROM ctmobile_notification_settings WHERE notification_type = ?",array('event_invitation'));
	$title = decode_html(decode_html($adb->query_result($titleMessageSQL, 0, "notification_title")));
	$message = decode_html(decode_html($adb->query_result($titleMessageSQL, 0, "notification_message")));
	$message = getMergedDescription($message, $recordId, 'Events');

	$getInvites = $adb->pquery("SELECT inviteeid FROM vtiger_invitees where activityid = ?", array($recordId));
	if($adb->num_rows($getInvites)){
		for ($i=0; $i < $adb->num_rows($getInvites); $i++) { 
			$inviteId = $adb->query_result($getInvites, $i, 'inviteeid');
			if(checkPermission('event_invitation',$inviteId)){
				$perm_qry = "SELECT devicetoken,device_type FROM ctmobile_userdevicetoken  WHERE userid = ?";
				$perm_result = $adb->pquery($perm_qry, array($inviteId));
				$perm_rows = $adb->num_rows($perm_result);
				if($perm_rows > 0){
					$devicetoken = $adb->query_result($perm_result, 0, "devicetoken");
					$device_type = $adb->query_result($perm_result,0,'device_type');
					if($devicetoken != '' && $device_type != ''){
						$record_id = saveNotification($title,$message,$inviteId,$recordId,'Draft',$devicetoken);
						if($record_id != ''){
							$result = sendpushnotification($message,$devicetoken,$device_type,$wsId,$moduleName,$title);
							if($result){
								$results = json_decode($result,true);
		                        if($results['success']){
		                            $sendstatus = "Send";
		                        }else{
		                            $sendstatus = "Failed";
		                        }
								$recordModel = Vtiger_Record_Model::getInstanceById($record_id, $module_Name);
								$modelData = $recordModel->getData();
								$recordModel->set('mode', 'edit');
								$recordModel->set('pushnotification_response', $result);
								$recordModel->set('pushnotificationstatus', $sendstatus);
								$recordModel->save();
							}
						}
					}else{
						$record_id = saveNotification($title,$message,$inviteId,$recordId,'Draft','');
					}
				}
			}else{
				$record_id = saveNotification($title,$message,$inviteId,$recordId,'Draft','');
			}
		}
	}
}

function SendEventReminderNotification($entityData){
	$adb = PearDatabase::getInstance();
	$moduleName = $entityData->getModuleName();
	$wsId = $entityData->getId();
	$parts = explode('x', $wsId);
	$recordId = $parts[1];
	$moduleId = $parts[0];
	$title = 'event_reminder';
	$message = 'event_reminder';
	$moduleModel = Vtiger_Module_Model::getInstance('CTPushNotification');
	$presence = array('0', '2');
	$perm_qry = "SELECT userid,devicetoken,device_type FROM ctmobile_userdevicetoken";
	$perm_result = $adb->pquery($perm_qry, array());
	$perm_rows = $adb->num_rows($perm_result);
	if($perm_rows > 0){
		for ($i=0; $i < $perm_rows; $i++) {
			$userid = $adb->query_result($perm_result, $i, "userid");
			$devicetoken = $adb->query_result($perm_result, $i, "devicetoken");
			$device_type = $adb->query_result($perm_result,$i,'device_type');
			if($devicetoken != '' && $device_type != '' && $userid > 0){
				$userPrivModel = Users_Privileges_Model::getInstanceById($userid);
				if(($userPrivModel->isAdminUser() ||
								$userPrivModel->hasGlobalReadPermission() ||
								$userPrivModel->hasModulePermission($moduleModel->get('id'))) &&in_array($moduleModel->get('presence'), $presence)){
					$result = sendpushnotification($message,$devicetoken,$device_type,'','',$title);
				}
			}
		}
	}
}

function SendTaskReminderNotification($entityData){
	$adb = PearDatabase::getInstance();
	$moduleName = $entityData->getModuleName();
	$wsId = $entityData->getId();
	$parts = explode('x', $wsId);
	$recordId = $parts[1];
	$moduleId = $parts[0];
	$title = 'event_reminder';
	$message = 'event_reminder';
	$perm_qry = "SELECT devicetoken,device_type FROM ctmobile_userdevicetoken";
	$perm_result = $adb->pquery($perm_qry, array());
	$perm_rows = $adb->num_rows($perm_result);
	if($perm_rows > 0){
		for ($i=0; $i < $perm_rows; $i++) {
			$devicetoken = $adb->query_result($perm_result, $i, "devicetoken");
			$device_type = $adb->query_result($perm_result,$i,'device_type');
			if($devicetoken != '' && $device_type != ''){
				$result = sendpushnotification($message,$devicetoken,$device_type,'','',$title);
			}
		}
	}
}

function sendpushnotification($message,$devicekey, $device_type, $ws_id, $linktoModule, $title) {
		
	 define( 'API_ACCESS_KEY', 'AAAA_kGRtQ8:APA91bEWdbKg2fAycMdQGfhh6wWgdorH8D4J7lmcKq6tLE8RTKFg6_BKOQLNa_-agDsJugMCM3BrhFIPbvNq6EqW2PKO5E6SN-KwFs4RWRNcfl7TWrbNCkFhuaLtVg9F_FTrHal1tn7t' );
   
	
    $fcmMsg = array(
		 'content_available'=> 'true',
    );
    if($device_type == 'ios'){
    	if($title == 'event_reminder' && $message == 'event_reminder'){
    		$notification = array('alert'=>array('title' =>$title,'content-available'=>1) , 'text' => $message, 'sound' => 'default');
    	}else if($title == 'task_reminder' && $message == 'task_reminder'){
    		$notification = array('alert'=>array('title' =>$title,'content-available'=>1) , 'text' => $message, 'sound' => 'default');
    	}else{
			$notification = array('title' =>$title , 'body' => $message, 'sound' => 'default');
    	}
		$dataPayload = array('type'=>'record','recordId' => $ws_id , 'moduleName' => $linktoModule);
		$fcmFields = array(
			'to' => $devicekey ,
			'priority' => 'high',
			'notification' => $notification,
			'data' => $dataPayload
		);
		
	}else{
		$dataPayload = array('type'=>'record','message' => $message, 'title' => $title, 'recordId' => $ws_id , 'moduleName' => $linktoModule);
		
		$fcmFields = array(
			'to' => $devicekey ,
			'priority' => 'high',
			'notification' => $fcmMsg,
			'data' => $dataPayload

		);
	}
	
    $headers = array();
    $headers['Authorization'] = 'Bearer ' .API_ACCESS_KEY;
    $headers['Content-Type'] = 'application/json';
     
    $serviceURL = 'https://fcm.googleapis.com/fcm/send';
	$httpClient = new Vtiger_Net_Client($serviceURL);
	$httpClient->setHeaders($headers);
    $result = $httpClient->doPost(json_encode($fcmFields));
    $result = trim($result);
   
	return $result;
}

function checkPermission($notification_type,$userid){
	if($userid == ''){
		return false;
	}
	$adb = PearDatabase::getInstance();
	$userPrivModel = Users_Privileges_Model::getInstanceById($userid);
	$moduleModel = Vtiger_Module_Model::getInstance('CTPushNotification');
	$presence = array('0', '2');
	if(($userPrivModel->isAdminUser() ||
								$userPrivModel->hasGlobalReadPermission() ||
								$userPrivModel->hasModulePermission($moduleModel->get('id'))) &&in_array($moduleModel->get('presence'), $presence)){
		$main_perm_query = "SELECT * FROM ctmobile_notification_settings WHERE notification_type = ? AND notification_enabled = '1'";
		$main_perm_result = $adb->pquery($main_perm_query,array($notification_type));
		if($adb->num_rows($main_perm_result)){
			$notification_id = $adb->query_result($main_perm_result,0,'notification_id');
			$sub_perm_query = "SELECT * FROM ctmobile_notification_restriction WHERE user_id = ? AND notification_id = ?";
			$sub_perm_result = $adb->pquery($sub_perm_query,array($userid,$notification_id));
			if($adb->num_rows($sub_perm_result) == 0){
				return true;
			}else{
				return false;
			}
		}else{
			return false;
		}
	}else{
		return false;
	}
}

function saveNotification($title,$message,$assigned_user_id,$pn_related='',$pushnotificationstatus='Draft',$devicetoken=''){
	$module_Name = 'CTPushNotification';
	$focus = CRMEntity::getInstance($module_Name);
	$focus->column_fields['description'] = $message;
	$focus->column_fields['assigned_user_id'] = $assigned_user_id;
	$focus->column_fields['pn_related'] = $pn_related;
	$focus->column_fields['pushnotificationstatus'] = $pushnotificationstatus;
	$focus->column_fields['devicekey'] = $devicetoken;
	$focus->column_fields['pn_title'] =  $title;
	$focus->column_fields['read_status'] = 'Unread';
	$focus->save($module_Name);
	$record_id = $focus->id;
	return $record_id;
}
