<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
include_once dirname(__FILE__) . '/FetchRecordWithGrouping.php';

class CTMobile_WS_RelatedRecords extends CTMobile_WS_FetchRecordWithGrouping {
	
	protected $record = false;

	function process(CTMobile_API_Request $request) {
		global $adb, $current_user;
		$current_user = $this->getActiveUser();
		$userPrivModel = Users_Privileges_Model::getInstanceById($current_user->id);
		global $site_URL;
		$presence = array('0', '2');
		$userPrivModel = Users_Privileges_Model::getInstanceById($current_user->id);
		$default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');
		$db = PearDatabase::getInstance();
		$query = "SELECT vtiger_tab.name FROM  `vtiger_relatedlists` INNER JOIN vtiger_tab ON vtiger_tab.tabid = vtiger_relatedlists.tabid WHERE vtiger_relatedlists.label =  'Documents'";
		$result = $db->pquery($query,array());
		$num_rows = $db->num_rows($result);
		$documentModules = array();
		for($i=0;$i<$num_rows;$i++){
			$documentModules[] = $db->query_result($result,$i,'name');
		}
		$inventoryModules = array('Invoice','SalesOrder','PurchaseOrder','Quotes');
		$query1 = "SELECT vtiger_tab.name, vtiger_tab.tabid FROM vtiger_links INNER JOIN vtiger_tab ON vtiger_links.tabid = vtiger_tab.tabid where vtiger_links.linklabel = ?";
		$params1 = array("DetailViewBlockCommentWidget");
		$results1 = $db->pquery($query1 , $params1);
		$numrows1 = $db->num_rows($results1);
		$CommentsModule = array();
		for($i=0;$i<$numrows1;$i++){
			$CommentsModule[] = $db->query_result($results1,$i,'name');
		}

		if(in_array($request->get('module'), $inventoryModules)){
			if(Inventory_Module_Model::isCommentEnabled()){
				$CommentsModule[] = $request->get('module');
			}
		}


		$query2 = "SELECT vtiger_tab.name, vtiger_tab.tabid FROM vtiger_relatedlists INNER JOIN vtiger_tab ON vtiger_relatedlists.tabid = vtiger_tab.tabid where vtiger_relatedlists.presence = 0 AND vtiger_relatedlists.label=?";
		$params2 = array("Activities");
		$result2 = $db->pquery($query2 , $params2);
		$numrows2 = $db->num_rows($result2);
		$ActivitiesModule = array();
		for($i=0;$i<$numrows2;$i++){
			$ActivitiesModule[] = $db->query_result($result2,$i,'name');
		}
		$record = trim($request->get('record'));
		$module = trim($request->get('module'));
		$moduleModel = Vtiger_Module_Model::getInstance($module);
		$FieldModels = $moduleModel->getFields();

		$wsid = CTMobile_WS_Utils::getEntityModuleWSId($module);
		$records = explode('x',$record);
		$parentId = $records[1];
		$request->set('record',$record);
		$request->set('module',$module);
		$response = parent::process($request);
		$resultRecord = $response->result['record'];
		$recordLabel = $resultRecord['recordLabel'];
		$relatedRecordList = array();
		$fields = array();
		$signDocumentField = array();

		$summaryFieldsList = $moduleModel->getSummaryViewFieldsList();
		if(!empty($summaryFieldsList)) {
			foreach($resultRecord['blocks'] as $key => $blocks){
				if($blocks['name'] == 'LBL_SIGNATURE_INFORMATION'){
					$signDocumentField[] = $blocks;
				}
				foreach($blocks['fields'] as $fieldkey => $field){
					$fieldName = $field['name']; 
					if($field['summaryfield'] != 1){
					}else{
						$filename = $field['name'];
						$FieldModel = $FieldModels[$filename];
						$displaytype = $FieldModel->get('displaytype');
						if($displaytype == 1){
							$fields['fields'][] = $field;
						}
					}
				}
				
			}
		}else{
			foreach($resultRecord['blocks'] as $key => $blocks){
				if($blocks['name'] == 'LBL_SIGNATURE_INFORMATION'){
					$signDocumentField[] = $blocks;
				}
				foreach($blocks['fields'] as $fieldkey => $field){
					$fieldName = $field['name']; 
					$FieldModel = $FieldModels[$fieldName];
					$displaytype = $FieldModel->get('displaytype');
					if($displaytype == 1){
						$fields['fields'][] = $field;
					}
					
				}
				
			}
		}

		if(!empty($fields)){
			$relatedRecordList['summary'][] = $fields;
		}else{
			$relatedRecordList['summary'] = $fields;
		}

		if($module == 'Project'){
			$summaryinfo = $this->getSummaryInfo($parentId);
			$relatedRecordList['Project Key Metrics'] = $summaryinfo;
		}

		$recordModel = Vtiger_DetailView_Model::getInstance($module, $parentId);
		$detailViewLinkParams = array('MODULE'=>$module,'RECORD'=>$parentId);
		$detailViewLinks = $recordModel->getDetailViewLinks($detailViewLinkParams);
		foreach ($detailViewLinks['DETAILVIEWWIDGET'] as $key => $Widget) {
			if($Widget->get('linklabel') != 'LBL_UPDATES'){
				if($Widget->get('linklabel') == 'ModComments'){
					$moduleModel = Vtiger_Module_Model::getInstance('ModComments');
					if (($userPrivModel->isAdminUser() ||
						$userPrivModel->hasGlobalReadPermission() ||
						$userPrivModel->hasModulePermission($moduleModel->getId())) && in_array($moduleModel->get('presence'), $presence)) {
						$Comments = $this->getComments($parentId);
						$relatedRecordList['ModComments'][] = $Comments;
					}
				}else if($Widget->get('linklabel') == 'Documents' || $Widget->get('linkName') == 'Documents'){
					if($relatedRecordList['Documents']){
						continue;
					}
					$moduleModel = Vtiger_Module_Model::getInstance('Documents');
					if (($userPrivModel->isAdminUser() ||
						$userPrivModel->hasGlobalReadPermission() ||
						$userPrivModel->hasModulePermission($moduleModel->getId())) && in_array($moduleModel->get('presence'), $presence)) {
						$Documents = $this->getDocuments($parentId);
						$relatedRecordList['Documents'][] = $Documents;
					}
					
				}else{
					if($Widget->get('linkName') != ''){
						$relatedModuleName = $Widget->get('linkName');
						$moduleModel = Vtiger_Module_Model::getInstance($relatedModuleName);
						if (($userPrivModel->isAdminUser() ||
						$userPrivModel->hasGlobalReadPermission() ||
						$userPrivModel->hasModulePermission($moduleModel->getId())) && in_array($moduleModel->get('presence'), $presence)) {
							$parentRecordModel = Vtiger_Record_Model::getInstanceById($parentId, $module);
							$relationListView = Vtiger_RelationListView_Model::getInstance($parentRecordModel, $relatedModuleName);
							$query = $relationListView->getRelationQuery();
							$query.=" LIMIT 0,5";

							$relResult = $db->pquery($query);
							$relrecords =  array();
							if($db->num_rows($relResult)){
								for ($i=0; $i < $db->num_rows($relResult); $i++) { 
									if($relatedModuleName == 'HelpDesk'){
										$relrecords['records'][$i]['crmid'] = CTMobile_WS_Utils::getEntityModuleWSId($relatedModuleName).'x'.$db->query_result($relResult,$i,'crmid');
										//$Tickets['records'][$i]['title'] = $db->query_result($ticketsresult,$i,'title');
										$relrecords['records'][$i]['title'] = html_entity_decode($db->query_result($relResult,$i,'title'), ENT_QUOTES, $default_charset);
										$relrecords['records'][$i]['priority'] = $db->query_result($relResult,$i,'priority');

										//code start for Dynamic Field Add by Darshan 

										$relrecords['records'][$i]['field1'] = array('name'=>'title','label'=>vtranslate('Title',$relatedModuleName),'value'=>html_entity_decode($db->query_result($relResult,$i,'title'), ENT_QUOTES, $default_charset));

										$relrecords['records'][$i]['field2'] = array('name'=>'priority','label'=>vtranslate('Priority',$relatedModuleName),'value'=>$db->query_result($relResult,$i,'priority'));

										// code end for Dynamic Field Add by Darshan

									}else if($relatedModuleName == 'Contacts'){
										$relrecords['records'][$i]['crmid'] = CTMobile_WS_Utils::getEntityModuleWSId($relatedModuleName).'x'.$db->query_result($relResult,$i,'crmid');
										$relrecords['records'][$i]['firstname'] = $db->query_result($relResult,$i,'firstname');
										$relrecords['records'][$i]['lastname'] = $db->query_result($relResult,$i,'lastname');
										$relrecords['records'][$i]['phone'] = $db->query_result($relResult,$i,'phone');
										$relrecords['records'][$i]['email'] = $db->query_result($relResult,$i,'email');
										$relrecords['records'][$i]['mailingcity'] = $db->query_result($relResult,$i,'mailingcity');
										$relrecords['records'][$i]['mailingcountry'] = $db->query_result($relResult,$i,'mailingcountry');

							
										//code start for Dynamic Field Add by Darshan 

										$relrecords['records'][$i]['field1'] = array('name'=>'firstname','label'=>vtranslate('First Name',$relatedModuleName),'value'=>html_entity_decode($db->query_result($relResult,$i,'firstname'), ENT_QUOTES, $default_charset));

										$relrecords['records'][$i]['field2'] = array('name'=>'lastname','label'=>vtranslate('Last Name',$relatedModuleName),'value'=>html_entity_decode($db->query_result($relResult,$i,'lastname'), ENT_QUOTES, $default_charset));

										// code end for Dynamic Field Add by Darshan

									}else if($relatedModuleName == 'Products'){
										
										$relrecords['records'][$i]['crmid'] = $tabid.'x'.$db->query_result($relResult,$i,'crmid');
										$relrecords['records'][$i]['productname'] = $db->query_result($relResult,$i,'productname');
										$relrecords['records'][$i]['unit_price'] = $db->query_result($relResult,$i,'unit_price');
										$relrecords['records'][$i]['unit_price'] = number_format($relrecords['records'][$i]['unit_price'],$current_user->no_of_currency_decimals,'.','');

										//code start for Dynamic Field Add by Darshan 

										$relrecords['records'][$i]['field1'] = array('name'=>'productname','label'=>vtranslate('Product Name',$relatedModuleName),'value'=>html_entity_decode($db->query_result($relResult,$i,'productname'), ENT_QUOTES, $default_charset));

										$relrecords['records'][$i]['field2'] = array('name'=>'unit_price','label'=>vtranslate('Unit Price($)',$relatedModuleName),'value'=>html_entity_decode($db->query_result($relResult,$i,'unit_price'), ENT_QUOTES, $default_charset));

										// code end for Dynamic Field Add by Darshan


									}else if($relatedModuleName == 'ProjectTask'){
										$tabid = CTMobile_WS_Utils::getEntityModuleWSId('ProjectTask');
										$relrecords['records'][$i]['crmid'] = $tabid.'x'.$db->query_result($relResult,$i,'crmid');
										//$ProjectTask['records'][$i]['projecttaskname'] = $db->query_result($taskresult,$i,'projecttaskname');
										$relrecords['records'][$i]['projecttaskname'] = html_entity_decode($db->query_result($relResult,$i,'projecttaskname'), ENT_QUOTES, $default_charset);
										$relrecords['records'][$i]['projecttaskprogress'] = $db->query_result($relResult,$i,'projecttaskprogress');
										$relrecords['records'][$i]['projecttaskstatus'] = $db->query_result($relResult,$i,'projecttaskstatus');
										$recordid = $db->query_result($relResult,$i,'crmid');

										//code start for Dynamic Field Add by Darshan 

										$relrecords['records'][$i]['field1'] = array('name'=>'projecttaskname','label'=>vtranslate('Project Task Name',$relatedModuleName),'value'=>html_entity_decode($db->query_result($relResult,$i,'projecttaskname'), ENT_QUOTES, $default_charset));

										$relrecords['records'][$i]['field2'] = array('name'=>'projecttaskprogress','label'=>vtranslate('Progress',$relatedModuleName),'value'=>html_entity_decode($db->query_result($relResult,$i,'projecttaskprogress'), ENT_QUOTES, $default_charset));

										// code end for Dynamic Field Add by Darshan

									}else if($relatedModuleName == 'ProjectMilestone'){
										$tabid = CTMobile_WS_Utils::getEntityModuleWSId('ProjectMilestone');
										$relrecords['records'][$i]['crmid'] = $tabid.'x'.$db->query_result($relResult,$i,'crmid');
										//$ProjectMilestone['records'][$i]['projectmilestonename'] = $db->query_result($milestoneresult,$i,'projectmilestonename');
										$relrecords['records'][$i]['projectmilestonename'] = html_entity_decode($db->query_result($relResult,$i,'projectmilestonename'), ENT_QUOTES, $default_charset);
										$relrecords['records'][$i]['projectmilestonedate'] = $db->query_result($relResult,$i,'projectmilestonedate');

										//code start for Dynamic Field Add by Darshan 

										$relrecords['records'][$i]['field1'] = array('name'=>'projectmilestonename','label'=>vtranslate('Project Milestone Name',$relatedModuleName),'value'=>html_entity_decode($db->query_result($relResult,$i,'projectmilestonename'), ENT_QUOTES, $default_charset));

										$relrecords['records'][$i]['field2'] = array('name'=>'projectmilestonedate','label'=>vtranslate('Milestone Date',$relatedModuleName),'value'=>html_entity_decode($db->query_result($relResult,$i,'projectmilestonedate'), ENT_QUOTES, $default_charset));

										// code end for Dynamic Field Add by Darshan

									}else{

										//code start for Dynamic Field Add by Darshan 

									    if ($relatedModuleName) {
										    $tabid = CTMobile_WS_Utils::getEntityModuleWSId($relatedModuleName);
										    $relatedfield = CTMobile_WS_Utils::getEntityFieldnames($relatedModuleName);
										    
										    $relrecords = array('records' => array());
										    
										    for ($i = 0; $i < $db->num_rows($relResult); $i++) {
										        $record = array();
										        $record['crmid'] = $tabid . 'x' . $db->query_result($relResult, $i, 'crmid');

										        foreach ($relatedfield as $field) {
										            $fieldLabel = vtranslate($field, $relatedModuleName);
										            $fieldValue = html_entity_decode($db->query_result($relResult, $i, $field), ENT_QUOTES, $default_charset);
										            $record['field1'] = array('name' => $field, 'label' => $fieldLabel, 'value' => $fieldValue);
										        }

										        $relrecords['records'][] = $record;
										    }
										}	

										// code end for Dynamic Field Add by Darshan

									}  
								}
							}
							$relatedRecordList[$relatedModuleName][] = $relrecords;
						}
					}
				}
			}
		}

		if(in_array($module,$ActivitiesModule)){
			$moduleModel = Vtiger_Module_Model::getInstance('Calendar');
			if (($userPrivModel->isAdminUser() ||
					$userPrivModel->hasGlobalReadPermission() ||
					$userPrivModel->hasModulePermission($moduleModel->getId())) && in_array($moduleModel->get('presence'), $presence)) {
			global $currentModule;
			$currentModule = $module;
			$parentRecordModel = Vtiger_Record_Model::getInstanceById($parentId, $module);
			$relatedModuleName = 'Calendar';
			$relationListView = Vtiger_RelationListView_Model::getInstance($parentRecordModel,$relatedModuleName,'Activities');
			$query = $relationListView->getRelationQuery();
			$query.= ' LIMIT 0,5';
			$Activities['fields'] = array('subject'=>vtranslate('Subject','Calendar'),'activitytype'=>vtranslate('Activity Type','Calendar'),'eventstatus'=>vtranslate('Status','Calendar'));
			$getfunctionres = $db->pquery($query,array());
			$numofrows2 = $db->num_rows($getfunctionres);
			if($numofrows2 > 0){
				for($i=0; $i< $numofrows2; $i++ ) {
					if($db->query_result($getfunctionres,$i,'activitytype') == 'Task'){
						$semodule = 'Calendar';
					}else{
						$semodule = 'Events';
					}
					$tabid = CTMobile_WS_Utils::getEntityModuleWSId($semodule);
					$Activities['records'][$i]['crmid'] = $tabid.'x'.$db->query_result($getfunctionres,$i,'crmid');
					$Activities['records'][$i]['module'] = $semodule;
					$Activities['records'][$i]['modulelabel'] = vtranslate($semodule,$semodule);
					$Activities['records'][$i]['subject'] = $db->query_result($getfunctionres,$i,'subject');
					$Activities['records'][$i]['activitytype'] = $db->query_result($getfunctionres,$i,'activitytype');
					$Activities['records'][$i]['eventstatus'] = $db->query_result($getfunctionres,$i,'eventstatus');
					$Activities['records'][$i]['date_start'] = $db->query_result($getfunctionres,$i,'date_start');
					$Activities['records'][$i]['time_start'] = $db->query_result($getfunctionres,$i,'time_start');
					$Activities['records'][$i]['due_date'] = $db->query_result($getfunctionres,$i,'due_date');
					$Activities['records'][$i]['time_end'] = $db->query_result($getfunctionres,$i,'time_end');
					$Activities['records'][$i]['modifiedtime'] = Vtiger_Util_Helper::formatDateDiffInStrings($db->query_result($getfunctionres,$i,'modifiedtime'));
				}
			}else{
				$Activities['records']=array();
			}
			$relatedRecordList['Activities'][] = $Activities;
			}
		}
		
		

		$relatedModulesList =  array();
		$count = 0;
		foreach($relatedRecordList as $key => $values){
			$relatedModulesList[$count]['related_module_name'] = $key;
			if(in_array($key,array('summary','Activities'))){
				if($key == 'summary'){
					$key = 'LBL_KEY_FIELD';
				}else{
					$key = 'LBL_'.strtoupper($key);
				}
			}

			if($key != 'LBL_KEY_FIELD' && $key != 'Project Key Metrics'){
				if($key == 'LBL_ACTIVITIES'){
					$moduleModel =  Vtiger_Module_Model::getInstance('Calendar');
				}else if($key == 'Tickets'){
					$moduleModel =  Vtiger_Module_Model::getInstance('HelpDesk');
				}else{
					$moduleModel =  Vtiger_Module_Model::getInstance($key);
				}
				$createAction = $userPrivModel->hasModuleActionPermission($moduleModel->getId(), 'CreateView');
			}

			if($key == 'Tickets'){
				$relatedModulesList[$count]['related_module_label'] = vtranslate('HelpDesk','HelpDesk');
			}else{
				$relatedModulesList[$count]['related_module_label'] = vtranslate($key,'Vtiger');
			}
			$relatedModulesList[$count]['related_module_list'] = $values;
			$relatedModulesList[$count]['createAction'] = $createAction;
			if($key == 'Documents'){
				$relatedModulesList[$count]['is_show_document_option'] = true;
			}
			$count++;
		}

		foreach ($signDocumentField as $key => $signblocks) {
			$relatedModulesList[$count]['related_module_name'] = $signblocks['name'];
			$relatedModulesList[$count]['related_module_label'] = $signblocks['label'];
			$relatedModulesList[$count]['fieldType'] = $signblocks['fieldType'];
			$relatedModulesList[$count]['related_module_list'] = $signblocks['fields'];
			$relatedModulesList[$count]['createAction'] = $signblocks['createAction'];
			$count++;
		}

		//code start for permission
		
		$related['related_records']= $relatedModulesList;
		//$related['signature_blocks'] = $signDocumentField;
		$related['recordLabel'] = $recordLabel;
		$related['editAction'] = $resultRecord['editAction'];
		$related['deleteAction'] = $resultRecord['deleteAction'];
		$related['duplicateAction'] = $resultRecord['duplicateAction'];
		$related['commentModuleAccess'] = $resultRecord['commentModuleAccess'];
		$related['ActivityModuleAccess'] = $resultRecord['ActivityModuleAccess'];
		$related['isAttachmentSupport'] = $resultRecord['isAttachmentSupport'];
		$related['recordShortcut'] = $resultRecord['recordShortcut'];
		if($module == 'Leads'){
			$related['ConvertLead'] = $resultRecord['ConvertLead'];
		}
		$related['isDownloadPDF'] = $resultRecord['isDownloadPDF'];
		$related['isEmailPDF'] = $resultRecord['isEmailPDF'];
		$related['PDFType'] = $resultRecord['PDFType'];
		$related['toMailNamesList'] = $resultRecord['toMailNamesList'];
		$related['conversion'] = $resultRecord['conversion'];
		$related['latitude'] = $resultRecord['latitude'];
		$related['longitude'] = $resultRecord['longitude'];
		
		//code for image url
		$parentRecordModel = Vtiger_Record_Model::getInstanceById($parentId, $module);
		$imageDetails = $parentRecordModel->getImageDetails();
		if(!empty($imageDetails)){
			global $site_URL;
			$related['ImageUrl'] = $site_URL.$imageDetails[0]['path'].'_'.$imageDetails[0]['name'];
		}else{
			$related['ImageUrl'] = "";
		}
		//code end for permission

		if($module == 'Documents'){
			$related['is_show_document_option'] = $resultRecord['is_show_document_option'];
		}
		$response = new CTMobile_API_Response();
		$response->setResult($related);
		return $response;
	}

	public function getDocuments($parentId){
		global $site_URL;
		$default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');
		$db = PearDatabase::getInstance();
		//Documents
		$limitQuery = 'SELECT DISTINCT vtiger_crmentity.crmid,vtiger_notes.title, vtiger_notes.folderid, vtiger_crmentity.smownerid, vtiger_crmentity.modifiedtime, vtiger_notes.filename, vtiger_notes.filelocationtype, vtiger_notes.filestatus, vtiger_attachments.path, vtiger_attachments.attachmentsid,vtiger_attachments.type FROM vtiger_notes inner join vtiger_senotesrel on vtiger_senotesrel.notesid= vtiger_notes.notesid left join vtiger_notescf ON vtiger_notescf.notesid= vtiger_notes.notesid inner join vtiger_crmentity on vtiger_crmentity.crmid= vtiger_notes.notesid and vtiger_crmentity.deleted=0 inner join vtiger_crmentity crm2 on crm2.crmid=vtiger_senotesrel.crmid LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid left join vtiger_seattachmentsrel on vtiger_seattachmentsrel.crmid =vtiger_notes.notesid left join vtiger_attachments on vtiger_seattachmentsrel.attachmentsid = vtiger_attachments.attachmentsid left join vtiger_users on vtiger_crmentity.smownerid= vtiger_users.id where crm2.crmid=? AND vtiger_notes.filestatus = 1 LIMIT 0,5';
		$params = array($parentId);
		$result = $db->pquery($limitQuery, $params);
		$Documents['fields'] = array('title'=>vtranslate('Title',$module),'filename'=>vtranslate('File Name',$module));
		if($db->num_rows($result)>0){
			for($i=0; $i< $db->num_rows($result); $i++ ) {
				$tabid = CTMobile_WS_Utils::getEntityModuleWSId('Documents');
				$Documents['records'][$i]['crmid'] = $tabid.'x'.$db->query_result($result,$i,'crmid');
				$Documents['records'][$i]['module'] = 'Documents';
				$Documents['records'][$i]['modulelabel'] = vtranslate('Documents','Documents');
				//$Documents['records'][$i]['title'] = $db->query_result($result,$i,'title'); html_entity_decode($db->query_result($result,$i,'title'), ENT_QUOTES, $default_charset);
				$Documents['records'][$i]['title'] = html_entity_decode($db->query_result($result,$i,'title'), ENT_QUOTES, $default_charset);
				$Documents['records'][$i]['filename'] = $db->query_result($result,$i,'filename');

				$Documents['records'][$i]['filelocationtype'] = $db->query_result($result,$i,'filelocationtype');
				$Documents['records'][$i]['modifiedtime'] = Vtiger_DateTime_UIType::getDisplayValue($db->query_result($result,$i,'modifiedtime'));
				$attachmentsid = $db->query_result($result,$i,'attachmentsid');
				$path = $db->query_result($result,$i,'path');
				$Documents['records'][$i]['type'] = $db->query_result($result,$i,'type');
				$Documents['records'][$i]['path'] = $site_URL.$path.$attachmentsid.'_'.$Documents['records'][$i]['filename'];
				$Download_URL = $site_URL.'/CTMobileApi.php?operation=DownloadUrl&record='.$attachmentsid;
				$Documents['records'][$i]['actionUrl'] = $Download_URL;
				/*$recordid = $db->query_result($result,$i,'crmid');
				$getCommentsData = $this->getCommentsData($recordid);
				$Documents['records'][$i]['commentData'] = $getCommentsData;*/

				$Documents['records'][$i]['isURL'] = false;
				if($Documents['records'][$i]['filename'] != ''){
					//$field['value'] = $resultRecord['filename'];
					if(filter_var($Documents['records'][$i]['filename'], FILTER_VALIDATE_URL)){
						$Documents['records'][$i]['isURL'] = true;
					}
				}
			}
		}else {
			$Documents['records']=array();
		}
		return $Documents;
	}

	public function getComments($parentId){
		global $adb,$site_URL;
		$default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');
		$db = PearDatabase::getInstance();
		//Comments
		$focus = CRMEntity::getInstance('ModComments');
		$query = $focus->get_comments();
		$query.= " AND vtiger_modcomments.related_to = ? ORDER BY vtiger_modcomments.modcommentsid DESC LIMIT 0,5";
		$getCommentQuery = $db->pquery($query, array($parentId));
		$countComment = $db->num_rows($getCommentQuery);
		
		$Comments['fields'] = array('commentcontent'=>vtranslate('Comment','ModComments'),'related_to'=>vtranslate('Related To','ModComments'));


		$Comments_detail['field1'] = array('name'=>'title','lable'=>vtranslate('Comment','ModComments'),'value'=>html_entity_decode($db->num_rows($getCommentQuery), ENT_QUOTES, $default_charset));
	
		if($countComment > 0){
			for($i=0;$i<$countComment;$i++) {
				$modcommentId = $db->query_result($getCommentQuery, $i, 'modcommentsid');
				$commentcontent = $db->query_result($getCommentQuery, $i, 'commentcontent');
				$commentcontent = html_entity_decode($commentcontent, ENT_QUOTES, $default_charset);
				$reasontoedit = $adb->query_result($getCommentQuery,$i,'reasontoedit');
				$reasontoedit = html_entity_decode($reasontoedit, ENT_QUOTES, $default_charset);
				$relatedTo = $db->query_result($getCommentQuery, $i, 'related_to');
				$Comments_detail['field1'] = array('name'=>'title','lable'=>vtranslate('Comment','ModComments'),'value'=>html_entity_decode($db->num_rows($getCommentQuery), ENT_QUOTES, $default_charset));
	
				$ModRecordModel = ModComments_Record_Model::getInstanceById($modcommentId);
				$files = $ModRecordModel->getAttachmentDetails();
				$Attachments = array();
				foreach ($files as $key => $file) {
					$fileid = $file['fileid'];
					$filename = "";
					$file_URL = "";
					$fileAccess =  true;
					$AccessMessage = "";
					if($fileid != '' && $fileid != 0){
						$filename = $file['attachment'];
						$file_URL = $fileDetails['file_URL'];
						$file_URL = $site_URL.'/CTMobileApi.php?operation=DownloadUrl&record='.$fileid;
						$ext = pathinfo($fileDetails['file_URL'], PATHINFO_EXTENSION);
						if(file_get_contents($file_URL) == ""){
							$fileAccess = false;
							$AccessMessage = $this->CTTranslate('You don\'t have permission to access this resource');
						}
					}
					$Attachments[] = array('filename'=>$filename,'file_URL'=>$file_URL,'fileAccess'=>$fileAccess,'AccessMessage'=>$AccessMessage,'extension'=>$ext);
				}
				$userId = $db->query_result($getCommentQuery, $i, 'smownerid');
				$createdtime = $db->query_result($getCommentQuery, $i, 'createdtime');
				$commentedtime = Vtiger_Util_Helper::formatDateDiffInStrings($createdtime);
				$modifiedtime = $adb->query_result($getCommentQuery, $i, 'modifiedtime');
				$isModified = false;
				$modifiedText = "";
				if($createdtime != $modifiedtime){
					$isModified = true;
					$modifiedtime = Vtiger_Util_Helper::formatDateDiffInStrings($modifiedtime);
					$modifiedText = vtranslate('LBL_COMMENT','ModComments').' '.strtolower(vtranslate('LBL_MODIFIED','ModComments')).' '.$modifiedtime;
				}
				if($userId) {
					$userRecordModel = Vtiger_Record_Model::getInstanceById($userId, 'Users');
					$firstname = $userRecordModel->get('first_name');
					$firstname = html_entity_decode($firstname, ENT_QUOTES, $default_charset);
					$lastname = $userRecordModel->get('last_name');
					$lastname = html_entity_decode($lastname, ENT_QUOTES, $default_charset);
					$userImage = CTMobile_WS_Utils::getUserImage($userId);
				}
				$isEdit = false;
				if(Users_Privileges_Model::isPermitted('ModComments', 'EditView')){
					if($userId == $current_user->id){
						$isEdit = true;
					}
				}
				$isReply = false;
				if(Users_Privileges_Model::isPermitted('ModComments', 'EditView')){
					$isReply = true;
				}
				$tabid = CTMobile_WS_Utils::getEntityModuleWSId('ModComments');

	

				$Comments['records'][$i] = array('modcommentId'=>$tabid.'x'.$modcommentId,'commentcontent'=>$commentcontent,'relatedTo' => $relatedTo,'reasontoedit'=>$reasontoedit,'userid'=>$userId,'attachments'=>$Attachments,'userName'=>$firstname." ".$lastname,'userImage'=>$userImage,'createdtime'=>$createdtime,'ModifiedTime'=>$commentedtime,'isEdit'=>$isEdit,'isModified'=>$isModified,'modifiedText'=>$modifiedText,'isReply'=>$isReply);

				// Code Started By Darshan for Dynamic Field Add 

				$Comments['records'][$i]['field1'] = array('name'=>'title','lable'=>vtranslate('Title',$module),'value'=>$commentcontent);

				// Code End
			}
		}else{
			$Comments['records']=array();
		}
		return $Comments;
	}
	
	public function getCommentsData($record){
		global $current_user;
		global $site_URL;
		$current_user = $this->getActiveUser();
		$adb = PearDatabase::getInstance();

		$focus = CRMEntity::getInstance('ModComments');
		$query = $focus->get_comments();
		$query.= " AND vtiger_modcomments.related_to = ? ORDER BY vtiger_modcomments.modcommentsid DESC LIMIT 0,5";
		$getCommentQuery = $adb->pquery($query, array($record));
		$countComment = $adb->num_rows($getCommentQuery);
		$modcommentsData = array();
		for($i=0;$i<$countComment;$i++) {
			$modcommentId = $adb->query_result($getCommentQuery, $i, 'modcommentsid');
			$commentcontent = $adb->query_result($getCommentQuery, $i, 'commentcontent');
			$reasontoedit = $adb->query_result($getCommentQuery,$i,'reasontoedit');
			//$reasontoedit = html_entity_decode($reasontoedit, ENT_QUOTES, $default_charset);
			$relatedTo = $adb->query_result($getCommentQuery, $i, 'related_to');
			$ModRecordModel = ModComments_Record_Model::getInstanceById($modcommentId);
			$files = $ModRecordModel->getAttachmentDetails();
			$Attachments = array();
			foreach ($files as $key => $file) {
				$fileid = $file['fileid'];
				$filename = "";
				$file_URL = "";
				$fileAccess =  true;
				$AccessMessage = "";
				if($fileid != '' && $fileid != 0){
					$filename = $file['attachment'];
					$file_URL = $fileDetails['file_URL'];
					$file_URL = $site_URL.'/CTMobileApi.php?operation=DownloadUrl&record='.$fileid;
					$ext = pathinfo($fileDetails['file_URL'], PATHINFO_EXTENSION);
					if(file_get_contents($file_URL) == ""){
						$fileAccess = false;
						$AccessMessage = $this->CTTranslate('You don\'t have permission to access this resource');
					}
				}
				$Attachments[] = array('filename'=>$filename,'file_URL'=>$file_URL,'fileAccess'=>$fileAccess,'AccessMessage'=>$AccessMessage,'extension'=>$ext);
			}
			$userId = $adb->query_result($getCommentQuery, $i, 'smownerid');
			$createdtime = $adb->query_result($getCommentQuery, $i, 'createdtime');
			$commentedtime = Vtiger_Util_Helper::formatDateDiffInStrings($createdtime);
			$modifiedtime = $adb->query_result($getCommentQuery, $i, 'modifiedtime');
			$isModified = false;
			$modifiedText = "";
			if($createdtime != $modifiedtime){
				$isModified = true;
				$modifiedtime = Vtiger_Util_Helper::formatDateDiffInStrings($modifiedtime);
				$modifiedText = vtranslate('LBL_COMMENT','ModComments').' '.strtolower(vtranslate('LBL_MODIFIED','ModComments')).' '.$modifiedtime;
			}
			if($userId) {
				$userRecordModel = Vtiger_Record_Model::getInstanceById($userId, 'Users');
				$firstname = $userRecordModel->get('first_name');
				$firstname = html_entity_decode($firstname, ENT_QUOTES, $default_charset);
				$lastname = $userRecordModel->get('last_name');
				$lastname = html_entity_decode($lastname, ENT_QUOTES, $default_charset);
				$userImage = CTMobile_WS_Utils::getUserImage($userId);
			}
			$isEdit = false;
			if(Users_Privileges_Model::isPermitted('ModComments', 'EditView')){
				if($userId == $current_user->id){
					$isEdit = true;
				}
			}
			$isReply = false;
			if(Users_Privileges_Model::isPermitted('ModComments', 'EditView')){
				$isReply = true;
			}
			$modcommentsData[] = array('modcommentId'=>'31x'.$modcommentId, 'commentcontent'=>$commentcontent, 'relatedTo' => $relatedTo,'reasontoedit'=>$reasontoedit,'userid'=>$userId,'attachments'=>$Attachments, 'userName'=>$firstname." ".$lastname,'userImage'=>$userImage, 'createdtime'=>$createdtime,'ModifiedTime'=>$commentedtime,'isEdit'=>$isEdit,'isModified'=>$isModified,'modifiedText'=>$modifiedText,'isReply'=>$isReply);
		}
		return array('countComment'=>$countComment,'comments'=>$modcommentsData);
	}
	
	public function getSummaryInfo($id) {
		
		$adb = PearDatabase::getInstance();

		$query ='SELECT smownerid,enddate,projecttaskstatus,projecttaskpriority
				FROM vtiger_projecttask
						INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid=vtiger_projecttask.projecttaskid
							AND vtiger_crmentity.deleted=0
						WHERE vtiger_projecttask.projectid = ? ';

		$result = $adb->pquery($query, array($id));

		$tasksOpen = $taskProgress= $taskCompleted = $taskDue = $taskDeferred = $numOfPeople = 0;
		$highTasks = $lowTasks = $normalTasks = $otherTasks = 0;
		$currentDate = date('Y-m-d');
		$inProgressStatus = array('Open', 'In Progress');
		$usersList = array();

		while($row = $adb->fetchByAssoc($result)) {
			$projectTaskStatus = $row['projecttaskstatus'];
			switch($projectTaskStatus){
				case 'Open'		: $tasksOpen++;		break;
				case 'In Progress' : $taskProgress++;break;
				case 'Deferred'	: $taskDeferred++;	break;
				case 'Completed': $taskCompleted++;	break;
			}
			$projectTaskPriority = $row['projecttaskpriority'];
			switch($projectTaskPriority){
				case 'high' : $highTasks++;break;
				case 'low' : $lowTasks++;break;
				case 'normal' : $normalTasks++;break;
				default : $otherTasks++;break;
			}

			if(!empty($row['enddate']) && (strtotime($row['enddate']) < strtotime($currentDate)) &&
					(in_array($row['projecttaskstatus'], $inProgressStatus))) {
				$taskDue++;
			}
			$usersList[] = $row['smownerid'];
		}

		$usersList = array_unique($usersList);
		$numOfPeople = count($usersList);

		$summaryInfo['projecttaskstatus'] =  array(array('Label'=>vtranslate('LBL_TASKS_OPEN','Project'),'value'=>$tasksOpen),
			array('Label'=>vtranslate('Progress','Project'),'value'=>$taskProgress),
			array('Label'=>vtranslate('LBL_TASKS_DUE','Project'),'value'=>$taskDue),
			array('Label'=>vtranslate('LBL_TASKS_COMPLETED','Project'),'value'=>$taskCompleted));

		$summaryInfo['projecttaskpriority'] =  array(array('Label'=>vtranslate('LBL_TASKS_HIGH','Project'),'value'=>$highTasks),
			array('Label'=>vtranslate('LBL_TASKS_NORMAL','Project'),'value'=>$normalTasks),
			array('Label'=>vtranslate('LBL_TASKS_LOW','Project'),'value'=>$lowTasks),
			array('Label'=>vtranslate('LBL_TASKS_OTHER','Project'),'value'=>$otherTasks));

		return $summaryInfo;
	}
	
}
