<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */


class CTMobile_WS_GetTimeControlData extends CTMobile_WS_Controller {
	
	function process(CTMobile_API_Request $request) {
		global $current_user,$adb;
		$current_user = $this->getActiveUser();
		$default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');
		$presence = array('0', '2');
		$response = new CTMobile_API_Response();
		$cttimetrackerid = $request->get('cttimetrackerid');
		if(empty($cttimetrackerid)){
			$message =  $this->CTTranslate('cttimetrackerid fields is Required');
			throw new WebServiceException(404,$message);
		}
		
		$data = array();
		$sql = "SELECT vtiger_cttimecontrol.*,vtiger_crmentity.createdtime,vtiger_crmentity.modifiedtime FROM vtiger_cttimecontrol INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_cttimecontrol.cttimecontrolid WHERE vtiger_crmentity.deleted = 0 AND vtiger_crmentity.crmid > 0 ";

		if(!empty($cttimetrackerid))
			$sql.=" AND vtiger_cttimecontrol.related_tracking = '$cttimetrackerid'";

		$sql.= " ORDER BY vtiger_crmentity.modifiedtime DESC";
		
		$result2 = $adb->pquery($sql,array());
		$numofrows = $adb->num_rows($result2);
		$last_latitude = '';
		$last_longitude = '';
		$isLast = true;
		for($i=0;$i<$numofrows;$i++){
			$row = $adb->query_result_rowdata($result2,$i);

			if($row['date_start'] != ''){
				$row['date_start'] = Vtiger_Date_UIType::getDisplayValue($row['date_start']);
			}
			if($row['date_end'] != ''){
				$row['date_end'] = Vtiger_Date_UIType::getDisplayValue($row['date_end']);
			}
			if($row['time_start'] != ''){
				$row['time_start'] = Vtiger_Time_UIType::getDisplayValue($row['time_start']);
			}
			if($row['time_end'] != ''){
				$row['time_end'] = Vtiger_Time_UIType::getDisplayValue($row['time_end']);
			}
			
			$total_time = $row['duration'];

			$hours = floor($total_time / 3600);
		    $minutes = floor(($total_time / 60) % 60);
		    $seconds = $total_time % 60;

		    $user_total_time = "$hours:$minutes:$seconds";
			
			if(Users_Privileges_Model::isPermitted('CTTimeControl', 'DetailView', $row['cttimecontrolid'])){
				array_push($data,array('cttimecontrolid'=>$row['cttimecontrolid'],'cttimecontrol_no'=>$row['cttimecontrol_no'],'tracking_notes'=>decode_html(decode_html($row['tracking_notes'])),'duration'=>$row['duration'],'total_time'=>$user_total_time,'date_start'=>$row['date_start'],'date_end'=>$row['date_end'],'time_start'=>$row['time_start'],'time_end'=>$row['time_end'],'start_date_time'=>$row['date_start'].' '.$row['time_start'],'end_date_time'=>$row['date_end'].' '.$row['time_end'],'check_in_location'=>$row['check_in_location'],'check_out_location'=>$row['check_out_location'],'check_in_address'=>$row['check_in_address'],'check_out_address'=>$row['check_out_address']));
			}
		}
		
		if(count($data) == 0){
			$message = $this->CTTranslate('No records found');
			$response->setResult(array('Data'=>array(),'code'=>404,'message'=>$message));
		}else{
			$response->setResult(array('Data'=>$data));
		}
		
		return $response;
	}
	
}
