<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

class CTMobile_WS_GetFilterFields extends CTMobile_WS_Controller {

	function process(CTMobile_API_Request $request) {
		$default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');
		global $current_user,$adb, $site_URL;
		$current_user = $this->getActiveUser();
		$moduleName = trim($request->get('module'));

		$moduleModel = Vtiger_Module_Model::getInstance($moduleName);
		$recordStructureInstance = Vtiger_RecordStructure_Model::getInstanceForModule($moduleModel, Vtiger_RecordStructure_Model::RECORD_STRUCTURE_MODE_FILTER);
		$recordStructure = $recordStructureInstance->getStructure();
		$blocks = array();
		foreach ($recordStructure as $key => $blockfields) {
			$fields = array();
			foreach($blockfields as $fieldname => $fieldModel){
				$module = $fieldModel->get('block')->module->get('name');
				$datatype = $fieldModel->getFieldDataType();
				$uitype = $fieldModel->get('uitype');
				if($datatype == 'salutation'){
					$datatype = 'string';
					$uitype = '1';
				}else if($datatype == 'fileLocationType'){
					$datatype = 'string';
					$uitype = '1';
				}
				$fmoduleModel = $fieldModel->getModule();
				if($fmoduleModel->get('name') != $moduleName){

					$fields[] = array('name'=>$fieldModel->get('name'),
									'label'=>'('.vtranslate($fmoduleModel->get('name'),$fmoduleModel->get('name')).') '.decode_html(decode_html(vtranslate($fieldModel->get('label'),$moduleName))),
									'mandatory'=>$fieldModel->isMandatory(),
									'type'=>array('name'=>$datatype,
												  'defaultValue'=>$fieldModel->get('defaultvalue')),
									'isunique'=>$fieldModel->get('isunique'),
									'nullable'=>'',
									'editable'=>$fieldModel->isEditable(),
									'default'=>$fieldModel->get('defaultvalue'),
									'readonly'=>$fieldModel->get('readonly'),
									'displaytype'=>$fieldModel->get('displaytype'),
									'typeofdata'=>$fieldModel->get('typeofdata'),
									'uitype'=>$uitype,
									'summaryfield'=>$fieldModel->get('summaryfield'),
									'presence'=>$fieldModel->get('presence'),
									'modulename'=>$module,
									'columnname'=>decode_html(decode_html($fieldModel->getCustomViewColumnName()))
									);

				}else{

					if($moduleName == 'Calendar' && $fieldModel->get('name') == 'duration_hours'){
						$uitype = "2";
					}else if($moduleName == 'Calendar' && $fieldModel->get('name') == 'recurringtype'){
						$datatype = "picklist";
					}
					$fields[] = array('name'=>$fieldModel->get('name'),
									'label'=>decode_html(decode_html(vtranslate($fieldModel->get('label'),$moduleName))),
									'mandatory'=>$fieldModel->isMandatory(),
									'type'=>array('name'=>$datatype,
												  'defaultValue'=>$fieldModel->get('defaultvalue')),
									'isunique'=>$fieldModel->get('isunique'),
									'nullable'=>'',
									'editable'=>$fieldModel->isEditable(),
									'default'=>$fieldModel->get('defaultvalue'),
									'readonly'=>$fieldModel->get('readonly'),
									'displaytype'=>$fieldModel->get('displaytype'),
									'typeofdata'=>$fieldModel->get('typeofdata'),
									'uitype'=>$uitype,
									'summaryfield'=>$fieldModel->get('summaryfield'),
									'presence'=>$fieldModel->get('presence'),
									'modulename'=>$module,
									'columnname'=>decode_html(decode_html($fieldModel->getCustomViewColumnName()))
									);
				}
				

			}
			$blocks[] = array('blockname'=>$key,
							  'blocklabel'=>vtranslate($key,$moduleName),
							  'fields'=>$fields);
		}

		if($moduleName == 'Calendar'){
			$relatedModuleName = 'Events';
			$relatedModuleModel = Vtiger_Module_Model::getInstance($relatedModuleName);
			$relatedRecordStructureInstance = Vtiger_RecordStructure_Model::getInstanceForModule($relatedModuleModel, Vtiger_RecordStructure_Model::RECORD_STRUCTURE_MODE_FILTER);
			$eventBlocksFields = $relatedRecordStructureInstance->getStructure();
		}

		foreach ($eventBlocksFields as $key => $blockfields) {
			$fields = array();
			foreach($blockfields as $fieldname => $fieldModel){
				$module = $fieldModel->get('block')->module->get('name');
				$datatype = $fieldModel->getFieldDataType();
				$uitype = $fieldModel->get('uitype');
				if($datatype == 'salutation'){
					$datatype = 'string';
					$uitype = '1';
				}
				$fmoduleModel = $fieldModel->getModule();
				if($fmoduleModel->get('name') != $moduleName){

					if($fmoduleModel->get('name') == 'Events' && $fieldModel->get('name') == 'duration_hours'){
						$uitype = "2";
					}else if($fmoduleModel->get('name') == 'Events' && $fieldModel->get('name') == 'recurringtype'){
						$datatype = "picklist";
					}

					$fields[] = array('name'=>$fieldModel->get('name'),
									'label'=>'('.vtranslate($fmoduleModel->get('name'),$fmoduleModel->get('name')).') '.decode_html(decode_html(vtranslate($fieldModel->get('label'),$moduleName))),
									'mandatory'=>$fieldModel->isMandatory(),
									'type'=>array('name'=>$datatype,
												  'defaultValue'=>$fieldModel->get('defaultvalue')),
									'isunique'=>$fieldModel->get('isunique'),
									'nullable'=>'',
									'editable'=>$fieldModel->isEditable(),
									'default'=>$fieldModel->get('defaultvalue'),
									'readonly'=>$fieldModel->get('readonly'),
									'displaytype'=>$fieldModel->get('displaytype'),
									'typeofdata'=>$fieldModel->get('typeofdata'),
									'uitype'=>$uitype,
									'summaryfield'=>$fieldModel->get('summaryfield'),
									'presence'=>$fieldModel->get('presence'),
									'modulename'=>$module,
									'columnname'=>decode_html(decode_html($fieldModel->getCustomViewColumnName()))
									);

				}


			}
			$blocks[] = array('blockname'=>$key,
							  'blocklabel'=>vtranslate($key,$moduleName),
							  'fields'=>$fields);
		}
	
		$response = new CTMobile_API_Response();
		$response->setResult(array('blocks'=>$blocks, 'module'=>$moduleName, 'message'=>''));
		return $response;
	}
}
