<?php

require_once('config.php');
require_once('include/utils/utils.php');

date_default_timezone_set ( "Europe/Amsterdam" );

// @todo handle wva visits on demand via werkstroom
$linkedIn = new LinkedInAutoLoader();
$linkedIn->run();
echo $linkedIn->getHTML();

die();

// --------------------------------------------------


class LinkedInAutoLoader
{

  // link or string
  var $type = 'link';

  // default reload after 900 seconds = 15 mins
  var $nextLoadAfterSecs = 900;
  
  var $break = false;
  
  var $breaktime = 1800;
  
  // default reload in milliseconds
  var $nextLoadAfterMSecs = 900000;
  
  var $allowedModules = array('lead','contact','account');
  
  var $module = 'lead';
  
  var $crmid;

  var $day;

  var $hour;

  function __construct()
  {
    $this->nextLoadAfterSecs = mt_rand (400, 900 ); // seconds 900 = 15 mins

    $mod = mt_rand (0, 20 ) % 5;
    $this->break  = ($mod == 0) ? true : false; // break in 1/5
    $this->breaktime  = mt_rand (1800, 3600 ); // seconds 900 = 15 mins

    if ($this->break) {
      $this->nextLoadAfterSecs = $this->nextLoadAfterSecs + $this->breaktime;
    }

    $this->nextLoadAfterMSecs = $this->nextLoadAfterSecs * 10000; // make milliseconds
  
    $this->day = date("N");
    $this->hour = date("H");

    // Random choose lead, account of contact
    $max = count($this->allowedModules);
    $moduleNr = mt_rand (0, 2);
    $this->module = $this->allowedModules[$moduleNr];
  }
 
  public function run()
  {
    global $adb;
  
    // get linkdIn adres
    // @todo  dont visit competitors (acc type = Concurrent)
    // @todo  ? make field dont auto visit soc media
    switch ($this->module)
    {
      case 'lead':
        // @todo  use either company name or linkedIn profile
        // @todo  dont visit Qualified Out
        $urlField1 = 'c_linkedin_account';
        $urlField2= 'c_linkedin_contact';
        $textField = 'company';
        $idField = 'leadid';

        $query = "SELECT t.{$urlField1}, t.{$urlField2}, t.{$textField}, t.{$idField} 
                  FROM vtiger_leaddetails AS t
                  INNER JOIN vtiger_crmentity AS ce
                  ON t.{$idField} = ce.crmid
                  WHERE ce.deleted=0 AND ({$urlField1} != '' OR {$urlField2} != '')
                  ORDER BY RAND() LIMIT 1;";

        break;
        
      case 'account':      
//        $query = 'SELECT cf_1679, accountname, accountid FROM vtiger_accountscf WHERE cf_1679 != "" ORDER BY RAND() LIMIT 1';
        $urlField = 'c_linkedin_account';
        $textField = 'accountname'; // t.{$textField}
        $idField = 'accountid';
 
        $query = "SELECT t.{$urlField}, t.{$idField} 
                  FROM vtiger_account AS t
                  INNER JOIN vtiger_crmentity AS ce
                  ON t.{$idField} = ce.crmid
                  WHERE ce.deleted=0 AND {$urlField} != ''
                  ORDER BY RAND() LIMIT 1;";
                  
        break;
        
      case 'contact':
        // LinkedIn lookup by name does not makee sense, cause you get a list and not a specific visit
//        $query = 'SELECT c_linkedin, contactid FROM vtiger_contactdetails WHERE c_linkedin != "" ORDER BY RAND() LIMIT 1';
        $table = 'vtiger_contactdetails';
        $urlField = 'c_linkedin_contact';
        $textField = 'lastname';
        $idField = 'contactid';

        $query = "SELECT t.{$urlField}, t.{$textField}, t.{$idField} 
                  FROM vtiger_contactdetails AS t
                  INNER JOIN vtiger_crmentity AS ce
                  ON t.{$idField} = ce.crmid
                  WHERE ce.deleted=0 AND {$urlField} != ''
                  ORDER BY RAND() LIMIT 1;";

        break;
        
      default:
        $this->linkedInUrl = '';
        return false;
    }
                        
//    print $query;
    
    $result = $adb->pquery($query, array());
    
    $aResult = $adb->fetch_array($result);
//    print_r($aResult);

    if ($aResult[$urlField] != '' ) {
      $this->type = 'link';
    } 
    elseif ($aResult[$urlField1] != '' ) {
      $urlField = $urlField1;
      $this->type = 'link';
    }
    elseif ($aResult[$urlField2] != '' ) {
      $urlField = $urlField2;
      $this->type = 'link';
    }
    else {
      $this->type = 'string';
    }

    $this->crmid = $aResult[$idField];
    $this->getUrl($aResult[$urlField]);

  }
 
  
  function getUrl($url)
  {
      https://www.linkedin.com/search/results/index/?keywords=Gerwin%20van%20Essen
  
      $url = $this->_validateUrl($url);
      $url = $this->_cleanUp($url);
      $this->linkedInUrl = $url;
  }

  function _cleanUp($url)
  {
    $url = str_replace('http://', 'https://', $url);
    $urlLeft = substr($url, 0, 8);
    if ($urlLeft != 'https://') {
      $url = 'https://'.$url;
    }
    return $url;
  }
  
  function _validateUrl($url)
  {
    if (!preg_match("/\b(?:(?:https?|ftp):\/\/|www\.)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i",$url)) {
      @mail("lro@vicus.nl", "error - linkedin autoloader", "Invalid URL for {$this->module} id {$this->crmid}");
    }
    return $url;
  }

  function _runQuery()
  {
  
  }

  public function getHTML()
  {

    $html = '
<!DOCTYPE html>
<html lang="nl-NL">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="Language" content="NL" />
  <meta name="copyright" content="2003-2017 Vicus eBusiness Solutions bv" />
  <meta name="robots" content="noindex, nofollow">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Vicus JourneyFunnel | LinkedIn loader</title>
  <link rel="shortcut icon" href="//castellum.vicus.nl/veb/images/linkedin.ico" id="favicon-ico">
  <script type="text/javascript" src="libraries/jquery/jquery.min.js"></script>
  <style>
    body{font-family:"Helvetica Neue",Helvetica,Arial,sans-serif;font-size:14px;line-height:1;color:#333;background-color:#fff;padding:15px;}
    .container{padding:15px 10% 15px 10%;float:left;width:80%;margin:0 0 20px 0;background-color:#4e4e6c;}
  </style>
</head>
<body>
    <div class="container">
      <div style="float:left;">
        <img src="//castellum.vicus.nl/veb/linkedin/vicus_logo_35.png" alt="Vicus">        
      </div>
      <div style="float:right;padding-right:15px;">
        <h1 style="color:#fff;font-size:14px;">LinkedIn Auto profile loader</h1>
      </div>
    </div>
    <div>
  
  <br><br>
  <p style="margin-top:30px;color:red;">Dit scherm open laten!</p>';

  $html .= '<p>'.date("Y-m-d H:i:s").'</p>';
  
  if ($this->day == 6 OR $this->day == 7 OR $this->hour < 8 OR $this->hour > 19) {
    $html .= "<p>Break buiten kantoortijden (dag {$this->day}, uur {$this->hour})</p>";
    $html .= '<p>Reload over: <div id="time"></div></p>';
  } else
  {
  
  $this->logUrl($this->linkedInUrl);
  
  $html .= '<p>Opent profiel '.$this->linkedInUrl.' in een nieuwe tab automatisch een nieuw linkedIn profiel over: <div id="time"></div></p>
  
  <script>
    var url = "'. $this->linkedInUrl .'";
    $("<a>").attr("href", url).attr("target", "wvalinkedin1")[0].click();
  </script>
  ';
  }
  $html .= '<script type="text/javascript">
    var insertZero = n => n < 10 ? "0"+n : ""+n,
    displayTime = n => n ? time.textContent = insertZero(~~(n/3600)%3600) + ":" +
                                             insertZero(~~(n/60)%60) + ":" +
                                             insertZero(n%60)
                        : location.reload(),
    countDownFrom = n => (displayTime(n), setTimeout(_ => n ? sid = countDownFrom(--n)
                                                         : displayTime(n), 1000)), 
                    sid;
    countDownFrom('.$this->nextLoadAfterSecs.');
    </script>';

$html .= '
</div>
</body>
</html>';
    return $html;
  } 
  
  function logUrl($url)
  {
    $this->crmid;
    $this->module;
    $line = date("YmdHis")." - {$this->module} {$this->crmid} {$url}\n";
    file_put_contents("logs/linkedin.log",$line,FILE_APPEND);
  }
  
}
