/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

jQuery.Class('Vtiger_Widget_Js',{

	widgetPostLoadEvent : 'Vtiget.Dashboard.PostLoad',
	widgetPostRefereshEvent : 'Vtiger.Dashboard.PostRefresh',

	getInstance : function(container, widgetName, moduleName) {
		if(typeof moduleName == 'undefined') {
			moduleName = app.getModuleName();
		}
		var widgetClassName = widgetName.toCamelCase();
		var moduleClass = window[moduleName+"_"+widgetClassName+"_Widget_Js"];
		var fallbackClass = window["Vtiger_"+widgetClassName+"_Widget_Js"];

		var basicClass = Vtiger_Widget_Js;
		if(typeof moduleClass != 'undefined') {
			var instance = new moduleClass(container);
		}else if(typeof fallbackClass != 'undefined') {
			var instance = new fallbackClass(container);
		} else {
			var instance = new basicClass(container);
		}
		return instance;
	}
},{
	container : false,
	plotContainer : false,
	
	init : function (container) {
		this.setContainer(jQuery(container));
		this.registerWidgetPostLoadEvent(container);
		//this.tksloadChart(container);
		//this.registerRefreshWidget();
		this.registerEvents();
	},
	getContainer : function() {
		if(this.container == false) {
			this.container = jQuery('.gridster ul');
		}
		return this.container;
	},
	
	setContainer : function(element) {
		this.container = element;
		return this;
	},
	
	registerWidgetPostLoadEvent : function(container) {
		var thisInstance = this;
		container.on(Vtiger_Widget_Js.widgetPostLoadEvent, function(e) {
			thisInstance.postLoadWidget();
		})
	},
	
	postLoadWidget : function() {
		if(!this.isEmptyData()) {
			this.loadChart();
		}else{
			this.positionNoDataMsg();
		}
		
	},
	
	registerRefreshWidget_tks : function() {
		var thisInstance = this;
		this.getContainer().on('click', 'a[name="drefresh_tks"]', function(e) {
			var element = $(e.currentTarget);
			var parent = element.closest('li');
			var url = element.data('url');
			var name = thisInstance.getUrlParameters("name", url, true);//Technokrafts	Streamline	
			if(name	==	'WVALeadSourceWidget')
			{
				thisInstance.refreshWidget(parent);
				return;
			}
		});
	},
	
	


	registerSalesTargets : function() {
		
		var thisInstance  = this;
		var parent = thisInstance.getContainer();
		var contentContainer = parent.find('.dashboardWidgetContent');
		var element = parent.find('a[name="drefresh_tks"]');
		var url = element.data('url');
		
		var name = thisInstance.getUrlParameters("name", url, true);//Technokrafts	Streamline	
		if(name	==	'WVALeadSourceWidget')
		{
			parent.find('table.jqplot-table-legend').css('width','95px');
			parent.find('.dashboardWidgetContenttks').css("height","200px");
			//parent.find('.slimScrollDiv').css("height","200px");
			//parent.find('.[data-sizey="1"]').css("height","281px");
		}
		var value = new Date();
		var year = jQuery('[name="year"]');
		year.on('change',function(e){
			element = $(e.currentTarget);
			parent = element.closest('li');		
			var name = thisInstance.getUrlParameters("name", url, true);//Technokrafts	Streamline	
			if(name	==	'WVALeadSourceWidget')
			{
				thisInstance.tksRefreshWidget(parent);	
			}
		});
	},
	
	getUrlParameters:function(parameter, staticURL, decode){
	   /*
		Function: getUrlParameters
		Description: Get the value of URL parameters either from 
					 current URL or static URL
		Author: Tirumal
		URL: www.code-tricks.com
	   */
	   var currLocation = (staticURL.length)? staticURL : window.location.search,
		   parArr = currLocation.split("?")[1].split("&"),
		   returnBool = true;
	   
	   for(var i = 0; i < parArr.length; i++){
			parr = parArr[i].split("=");
			if(parr[0] == parameter){
				return (decode) ? decodeURIComponent(parr[1]) : parr[1];
				returnBool = true;
			}else{
				returnBool = false;            
			}
	   }
	   
	   if(!returnBool) return false;  
	},
	
	tksRefreshWidget : function(parent) {
		if(parent)
		{
			var thisInstance  = this
			var element = parent.find('a[name="drefresh_tks"]');
			var url = element.data('url');
			var name = thisInstance.getUrlParameters("name", url, true);//Technokrafts	Streamline	
			if(name	==	'WVALeadSourceWidget')
			{
				var contentContainer = parent.find('.dashboardWidgetContent');
				params =  "index.php?module=Home&view=ShowWidget&name=WVALeadSourceWidget&linkid=122&widgetid=28&linkid=122&content=data&year="+year;
				var refreshContainer = parent.find('.refresh');
				refreshContainer.progressIndicator({
					'smallLoadingImage' : true
				});
				AppConnector.request(params).then(
					function(data){
						refreshContainer.progressIndicator({'mode': 'hide'});
						contentContainer.html(data);
						thisInstance.tksloadChart();
					},
					function(){
						refreshContainer.progressIndicator({'mode': 'hide'});
					}
				);
			}
		}
		
	},
	
	refreshWidget : function(parent) {
		if(parent)
		{
			var thisInstance  = this
			//var parent = thisInstance.getContainer();
			var element = parent.find('a[name="drefresh_tks"]');
			var url = element.data('url');
			
			var contentContainer = parent.find('.dashboardWidgetContent');
			parent.find('.slimScrollBar').css("position","fixed");
			var name = thisInstance.getUrlParameters("name", url, true);//Technokrafts	Streamline	
			if(name	==	'WVALeadSourceWidget')
			{
				params =  url;
				var refreshContainer = parent.find('.refresh');
				refreshContainer.progressIndicator({
					'smallLoadingImage' : true
				});
				AppConnector.request(params).then(
					function(data){
						refreshContainer.progressIndicator({'mode': 'hide'});
						contentContainer.html(data).trigger(Vtiger_Widget_Js.widgetPostRefereshEvent);
						thisInstance.tksloadChart();
					},
					function(){
						refreshContainer.progressIndicator({'mode': 'hide'});
					}
				);
			}
		}
	},
	
	registerEvents : function() {
		this.registerRefreshWidget_tks();
	},
	
	
	tksloadChart : function() {
		var chartData = this.generateData();
		jQuery('.slimScrollBar').css("position","fixed");
		jQuery('.dashboardWidgetContent').css("overflow","unset");
		if(chartData == undefined)
		{
			this.positionNoDataMsg();
		}
		else
		{
			this.getPlotContainer(false).jqplot([chartData['chartData']], {
				seriesDefaults:{
					renderer:jQuery.jqplot.PieRenderer,
					rendererOptions: {
						showDataLabels: true,
						dataLabels: 'value'
					}
				},
				legend: {
					show: true,
					location: 'e'
				},
				title : chartData['title']
			});
		}
		
		this.postInitializeCalls();
	},
	
	getPlotContainer : function(useCache) {
		if(typeof useCache == 'undefined'){
			useCache = false;
		}
		if(this.plotContainer == false || !useCache) {
			var container = this.getContainer();
			this.plotContainer = jQuery('#widgetChartContainer123');
		}
		return this.plotContainer;
	},

 	generateData:function()
	{	
		jQuery('.slimScrollBar').css("position","fixed");
		jQuery('.dashboardWidgetContent').css("overflow","unset");
		var jsonData = jQuery('input[name=data123]').val();
		
		if(jsonData == undefined)
		{
			this.positionNoDataMsg();
		}
		else
		{	
			var data = this.data = JSON.parse(jsonData);
			var values = data['values'];
	
			var chartData = [];
			for(var i in values) {
				chartData[i] = [];
				chartData[i].push(data['labels'][i]);
				chartData[i].push(values[i]);
			}
		
			return {'chartData':chartData, 'labels':data['labels'], 'data_labels':data['data_labels'], 'title' : data['graph_label']};
		}
			
	},
	postLoadWidget : function() {
		if(!this.isEmptyData()) {
			this.tksloadChart();
		}else{
			this.positionNoDataMsg();
		}
		
	},
	
	isEmptyData : function() {
		var jsonData = jQuery('input[name=data123]').val();
		if(jsonData == undefined)
		{
			return true;
		}
		else
		{
			var data = JSON.parse(jsonData);
			var values = data['values'];
			if(jsonData == '' || values == '') {
				return true;
			}
			return false;
		}
	},
	
	positionNoDataMsg : function() {
		this.displayNoDataMessage();
	},
	
	displayNoDataMessage : function() {
		$('#widgetChartContainer123').html('<div>'+app.vtranslate('JS_NO_CHART_DATA_AVAILABLE')+'</div>').css(
								{'text-align':'center', 'position':'relative', 'top':'100px'});
	},
	
	postInitializeCalls : function() {
		jQuery('table.jqplot-table-legend').css('width','95px');
		var thisInstance = this;

		$('#widgetChartContainer123').on('jqplotDataClick', function(ev, gridpos, datapos, neighbor, plot) {
			
			var jsonData	=	jQuery('input[name=data123]').val();
			var data	 	=	this.data = JSON.parse(jsonData);
			var linkUrl 	=	data['links'][0];
			if(linkUrl) window.location.href = linkUrl;
		});

		$('#widgetChartContainer123').on("jqplotDataHighlight", function(evt, seriesIndex, pointIndex, neighbor) {
			$('.jqplot-event-canvas').css( 'cursor', 'pointer' );
		});
		$('#widgetChartContainer123').on("jqplotDataUnhighlight", function(evt, seriesIndex, pointIndex, neighbor) {
			$('.jqplot-event-canvas').css( 'cursor', 'auto' );
		});
	},


});
