/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

jQuery.Class('Vtiger_Widget_Js',{

	widgetPostLoadEvent : 'Vtiget.Dashboard.PostLoad',
	widgetPostRefereshEvent : 'Vtiger.Dashboard.PostRefresh',

	getInstance : function(container, widgetName, moduleName) {
		if(typeof moduleName == 'undefined') {
			moduleName = app.getModuleName();
		}
		var widgetClassName = widgetName.toCamelCase();
		var moduleClass = window[moduleName+"_"+widgetClassName+"_Widget_Js"];
		var fallbackClass = window["Vtiger_"+widgetClassName+"_Widget_Js"];

		var basicClass = Vtiger_Widget_Js;
		if(typeof moduleClass != 'undefined') {
			var instance = new moduleClass(container);
		}else if(typeof fallbackClass != 'undefined') {
			var instance = new fallbackClass(container);
		} else {
			var instance = new basicClass(container);
		}
		return instance;
	}
},{
	container : false,
	plotContainer : false,
	
	init : function (container) {
		this.registerEvents();
		try {
			this.tksloadChart(container);
		} catch(error) {
			console.log("error");
			console.log(error);
			return;
		}
		
		//this.registerRefreshWidget();
		
	},
	getContainer : function() {
		if(this.container == false) {
			this.container = jQuery('.gridster ul');
		}
		return this.container;
	},
	
	registerRefreshWidget_tks : function() {
		var thisInstance = this;
		this.getContainer().on('click', 'a[name="drefresh_tks"]', function(e) {
			var element = $(e.currentTarget);
			var parent = element.closest('li');
			var url = element.data('url');
			var name = thisInstance.getUrlParameters("name", url, true);//Technokrafts	Streamline	
			if(name	==	'SalesTargetsWidget')
			{
				thisInstance.refreshWidget(parent);
				return;
			}
		});
	},
	
	


	registerSalesTargets : function() {
		
		var thisInstance  = this;
		var parent = thisInstance.getContainer();
		var contentContainer = parent.find('.dashboardWidgetContent');
		var element = parent.find('a[name="drefresh_tks"]');
		var url = element.data('url');
		
		var name = thisInstance.getUrlParameters("name", url, true);//Technokrafts	Streamline	
		if(name	==	'SalesTargetsWidget')
		{
			parent.find('table.jqplot-table-legend').css('width','95px');
			parent.find('.dashboardWidgetContenttks').css("height","200px");
			//parent.find('.slimScrollDiv').css("height","200px");
			//parent.find('.[data-sizey="1"]').css("height","281px");
		}
		var value = new Date();
		var year = jQuery('[name="year"]');
		year.on('change',function(e){
			element = $(e.currentTarget);
			parent = element.closest('li');		
			var name = thisInstance.getUrlParameters("name", url, true);//Technokrafts	Streamline	
			if(name	==	'SalesTargetsWidget')
			{
				thisInstance.tksRefreshWidget(parent);	
			}
		});
		var tks_user = jQuery('[name="tks_user"]');
		tks_user.on('change',function(e){
			element = $(e.currentTarget);
			parent = element.closest('li');		
			var name = thisInstance.getUrlParameters("name", url, true);//Technokrafts	Streamline	
			if(name	==	'SalesTargetsWidget')
			{
				thisInstance.tksRefreshWidget(parent);	
			}
		});
	},
	
	getUrlParameters:function(parameter, staticURL, decode){
	   /*
		Function: getUrlParameters
		Description: Get the value of URL parameters either from 
					 current URL or static URL
		Author: Tirumal
		URL: www.code-tricks.com
	   */
	   var currLocation = (staticURL.length)? staticURL : window.location.search,
		   parArr = currLocation.split("?")[1].split("&"),
		   returnBool = true;
	   
	   for(var i = 0; i < parArr.length; i++){
			parr = parArr[i].split("=");
			if(parr[0] == parameter){
				return (decode) ? decodeURIComponent(parr[1]) : parr[1];
				returnBool = true;
			}else{
				returnBool = false;            
			}
	   }
	   
	   if(!returnBool) return false;  
	},
	
	tksRefreshWidget : function(parent) {
		if(parent)
		{
			var thisInstance  = this
			//var parent = thisInstance.getContainer();
			var element = parent.find('a[name="drefresh_tks"]');
			var url = element.data('url');
			var name = thisInstance.getUrlParameters("name", url, true);//Technokrafts	Streamline	
			if(name	==	'SalesTargetsWidget')
			{
				var contentContainer = parent.find('.dashboardWidgetContent');
				/*contentContainer.css("height","200px");
				parent.find('.slimScrollDiv').css("height","200px");
				parent.find('.[data-sizey="1"]').css("height","300px");
				parent.find('table.jqplot-table-legend').css('width','95px');*/
			
				var year = jQuery('[name="year"]').val();
				var tks_user = jQuery('[name="tks_user"]').val();
				
				params =  "index.php?module=Home&view=ShowWidget&name=SalesTargetsWidget&linkid=122&widgetid=28&linkid=122&content=data&year="+year+"&tks_user="+tks_user;
				var refreshContainer = parent.find('.refresh');
				refreshContainer.progressIndicator({
					'smallLoadingImage' : true
				});
				AppConnector.request(params).then(
					function(data){
						refreshContainer.progressIndicator({'mode': 'hide'});
						contentContainer.html(data);
						//thisInstance.tksloadChart();
						try {
							thisInstance.tksloadChart();
						} catch(error) {
							console.log("error");
							console.log(error);
							return;
						}
					},
					function(){
						refreshContainer.progressIndicator({'mode': 'hide'});
					}
				);
			}
		}
		
	},
	
	refreshWidget : function(parent) {
		if(parent)
		{
			var thisInstance  = this
			//var parent = thisInstance.getContainer();
			var element = parent.find('a[name="drefresh_tks"]');
			var url = element.data('url');
			var contentContainer = parent.find('.dashboardWidgetContent');
		/*	contentContainer.css("height","200px");
			parent.find('.slimScrollDiv').css("height","200px");
			parent.find('.[data-sizey="1"]').css("height","300px");
			parent.find('table.jqplot-table-legend').css('width','95px');*/
			var current_year = new Date().getFullYear();
			jQuery('[name="year"]').val(current_year);
			var year = jQuery('[name="year"]').val();
			jQuery('[name="tks_user"]').val('0');
			var tks_user = jQuery('[name="tks_user"]').val();
			var name = thisInstance.getUrlParameters("name", url, true);//Technokrafts	Streamline	
			if(name	==	'SalesTargetsWidget')
			{
				params =  "index.php?module=Home&view=ShowWidget&name=SalesTargetsWidget&linkid=122&widgetid=28&linkid=122&content=data&year="+year+"&tks_user="+tks_user;
				var refreshContainer = parent.find('.refresh');
				refreshContainer.progressIndicator({
					'smallLoadingImage' : true
				});
				AppConnector.request(params).then(
					function(data){
						refreshContainer.progressIndicator({'mode': 'hide'});
						contentContainer.html(data).trigger(Vtiger_Widget_Js.widgetPostRefereshEvent);
						//thisInstance.tksloadChart();
						try {
							thisInstance.tksloadChart();
						} catch(error) {
							console.log("error");
							console.log(error);
							return;
						}
					},
					function(){
						refreshContainer.progressIndicator({'mode': 'hide'});
					}
				);
			}
		}
	},
	
	registerEvents : function() {
		//this.registerRefreshWidget();
		this.registerSalesTargets();
		this.registerRefreshWidget_tks();
	},
	
	tksloadChart: function (container)
	{
		var data = this.generateData();
		
		var plot2 = $.jqplot('chartcontent', data['chartData'], {
			title: data['title'],
			legend:{
				show:true,
				labels:data['data_labels'],
				location:'ne',
				showSwatch : true,
				showLabels : true,
				placement: 'outside'
 	    	},
			seriesDefaults: {
				pointLabels: {
					show: true
				}
			},
			axes: {
				xaxis: {
					min:0,
					pad: 1,
					renderer: $.jqplot.CategoryAxisRenderer,
					ticks:data['labels'],
					tickOptions: {
						formatString: '%b %#d'
					}
				}
				,
				yaxis: {
					// Don't pad out the bottom of the data range.  By default,
					// axes scaled as if data extended 10% above and below the
					// actual range to prevent data points right on grid boundaries.
					// Don't want to do that here.
					padMin: 0,
					min:0
				}
			},
			cursor: {
				show: true
			}
		});
		
		/*jQuery('table.jqplot-table-legend').css('width','95px');
		jQuery('.dashboardWidgetContent').css("height","200px");
		jQuery('.slimScrollDiv').css("height","200px");
		jQuery('.[data-sizey="1"] ').css("height","281px");*/
	},


 	generateData:function()
	{
		
		var jsonData = jQuery('input[name=data]').val();
		var data = this.data = JSON.parse(jsonData);
		var values = data['values'];
		if(jsonData == '' || values == '') {
			$('#chartcontent').html('<div>'+app.vtranslate('TKS_NO_CHART_DATA_AVAILABLE')+'</div>').css(
								{'text-align':'center', 'position':'relative', 'top':'100px'});
			return false;
		}
		var chartData = [];
		var yMaxValue = 0;

		chartData[1] = []
	//	chartData[2] = []
		chartData[0] = []
		for(var i in values) {
			var value =  values[i];
			for(var j in value) {
				chartData[j].push(value[j]);
			}
		}
		yMaxValue = yMaxValue + yMaxValue*0.15;

		return {'chartData':chartData,
				'yMaxValue':yMaxValue,
				'labels':data['labels'],
				'data_labels':data['data_labels'],
				'title' : data['graph_label']
			};
	},


});
