/**
 * VGS Visual Pipeline Module
 *
 *
 * @package        VGSVisualPipeline Module
 * @author         www.vgsglobal.com
 * @license        vTiger Public License.
 * @version        Release: 1.0
 */

jQuery.Class("VGSVisualPipelineSetting_Js", {}, {
    SourceModuleUpdate: function () {
        jQuery('#module1').on('change', function (e) {

            var module1 = jQuery(this).val();
            jQuery('#picklist1').find('option').remove().end().append('<option value="--">--</option>').val('--').trigger('liszt:updated');

            jQuery(".notice").hide();
            jQuery("#fieldvalueshide").html('');
            jQuery("#fieldtable").html('');


            var dataUrl = "module=VGSVisualPipeline&action=VGSGetPicklistFields&source_module=" + module1;
            AppConnector.request(dataUrl).then(
                function (data) {

                    if (data.success) {

                        var result = data.result;
                        if (result.result == 'ok') {

                            jQuery.each(result.options, function (i, item) {
                                var o = new Option(item, i);
                                jQuery(o).html(item);
                                jQuery("#picklist1").append(o);
                            });

                            jQuery("#picklist1").trigger('liszt:updated');
                            jQuery("#fieldtable").html(result.fieldtable);

                        } else {
                            alert(app.translate('JS_ERROR_LOADING_FIELDS'));
                        }
                    }
                },
                function (error, err) {

                }
            );

        });
    },
    sourceFieldUpdate: function () {
        jQuery('#picklist1').on('change', function (e) {

            var dataUrl = "module=VGSVisualPipeline&action=VGSGetPicklistFields&mode=fieldValues&modulename=" + jQuery('#module1').val() + "&fieldname=" + jQuery('#picklist1').val();
            AppConnector.request(dataUrl).then(
                function (data) {

                    if (data.success) {

                        var result = data.result;
                        if (result.result == 'ok') {

                            jQuery('#fieldtable').show();
                            jQuery("#fieldvalueshide").html(result.fieldvaluestohide);
                            app.showSelect2ElementView(jQuery('body').find('select.select2'));

                        } else {
                            alert(app.translate('JS_ERROR_LOADING_FIELDS'));
                        }
                    }
                },
                function (error, err) {

                }
            );

        });
    },
    saveEntry: function () {
        jQuery('#add_entry').on('click', function (e) {
            var fields = [];
            jQuery('input[type=checkbox]').each(function () {
                var sThisVal = (this.checked ? $(this).val() : "");
                if (this.checked) {
                    fields.push(this.name);
                }
            });

            if (fields.length == 0) {
                app.helper.showAlertBox({'message' : app.vtranslate('Please choose at least one field to be displayed in the kanban view')});

                return false;
            } else {
               
                var progressIndicatorElement = jQuery.progressIndicator({
                    'message': "",
                    'position': 'html',
                    'blockInfo': {
                        'enabled': true
                    }
                });

                var params = {
                    module: 'VGSVisualPipeline',
                    action: 'VGSsave',
                    mode: 'addEntry',
                    module1: jQuery("#module1").val(),
                    picklist1: jQuery("#picklist1").val(),
                    field_selected: fields,
                    hidden_field_val: jQuery('#fieldsSelect').val(),
                };

                AppConnector.request(params).then(
                    function (data) {

                        if (data.success) {
                            var response = data.result;

                            progressIndicatorElement.progressIndicator({
                                'mode': 'hide'
                            });

                            if (response.result == 'ok') {

                                window.location = 'index.php?module=VGSVisualPipeline&view=VGSIndexSettings&parent=Settings';

                            } else {
                            
                               alert(response.message);

                            }
                        }
                    },
                    function (error, err) {
                        progressIndicatorElement.progressIndicator({
                            'mode': 'hide'
                        });
                        alert('Error Processing your request');
                    }
                );
            }



        });
    },
    deleteEntry: function () {
        jQuery('.deleteRecordButton').on('click', function (e) {
             
            var progressIndicatorElement = jQuery.progressIndicator({
                'message': "",
                'position': 'html',
                'blockInfo': {
                    'enabled': true
                }
            });

            
            var params = {
                module: 'VGSVisualPipeline',
                action: 'VGSsave',
                mode: 'deleteRecord',
                module1: jQuery(this).data('sourcemodule'),
                record_id: jQuery(this).attr('id')
            };

            var line = jQuery(this).closest('tr');

            AppConnector.request(params).then(
                function (data) {

                    if (data.success) {
                        var response = data.result;

                        if (response.result == 'ok') {
                            line.hide('slow');

                            progressIndicatorElement.progressIndicator({
                                'mode': 'hide'
                            });

                        } else {

                                
                           alert(response.message);
                                            
                            progressIndicatorElement.progressIndicator({
                                'mode': 'hide'
                            });
                        }
                    }
                },
                function (error, err) {

                }
            );

        });
    },
    registerEvents: function () {
        this.SourceModuleUpdate();
        this.saveEntry();
        this.deleteEntry();
        this.sourceFieldUpdate();
    }

});

jQuery(document).ready(function () {
    var instance = new VGSVisualPipelineSetting_Js();
    instance.registerEvents();
});

        