/************************************************************************************************
** The contents of this file are subject to the Vtiger EchoSign Module License Version 1.0
 * ( "License" ); You may not use this file except in compliance with the License
 * The Original Code is:  Technokrafts Labs Pvt Ltd
 * The Initial Developer of the Original Code is Technokrafts Labs Pvt Ltd.
 * Portions created by Technokrafts Labs Pvt Ltd are Copyright ( C ) Technokrafts Labs Pvt Ltd.
 * All Rights Reserved.
**
************************************************************************************************/

/*Settings_Vtiger_Edit_Js('Settings_EchoSign_Edit_Js', {}, {*/
						
jQuery.Class("Settings_WebVisits_Edit_Js",{},{
			 
	//Container which stores the payment elements
	editViewContainer : false,
	
	/**
	 * Function to get the Edit View Container
	 * @return : jQuery object
	 */
	getEditViewContainer : function() {
		if(this.editViewContainer == false) {
			this.setEditViewContainer(jQuery('#EditView'));
		}
		return this.editViewContainer;
	},
	
	/**
	 * Function to set Edit View container
	 * @param : element - jQuery object which represents payment result container
	 * @result : current instance
	 */
	setEditViewContainer : function(element) {
		this.editViewContainer = element;
		return this;
	},
	
	/**
	 * Function to register form for validation
	 */
	registerFormForValidation : function(){
		var editViewForm = this.getEditViewContainer();
		editViewForm.validationEngine(app.getvalidationEngineOptions(true));
	},
	
	/**
	 * Function to set Edit View container
	 * @param : api - string echosign api key save to settigns
	 * @param : apiid - integer table id
	 * @param : selectpdf - checked option select pdf option
	 * @result : Deferred
	 */
	WebVisitsSetting:function(webvisitanalyser,minimumscore,newleadstatus,reactivateleads,statusses,reactivateleadstatus,piwikenabled,piwiklocation,piwiksites,salesfeedenabled,salesfeedaccnt,snoobienabled,snoobiaccnt,id){
		var thisInstance 		= this;
		var editViewForm = this.getEditViewContainer();
		var aDeferred = jQuery.Deferred();
		var progressIndicatorElement = jQuery.progressIndicator({
			'position' 		: 'html',
			'message' 		: app.vtranslate('Please Wait'),
			'blockInfo' 	: {
				'enabled' 	: true
			}
		});
		
		var params = {
			'module' 				: 'WebVisits',
			'action' 				: 'SaveWebVisit',
			'parent' 				: 'Settings',
			'mode'   				: 'tks_mode',
			'wcnum'	 				: webvisitanalyser,
			'min_score' 			: minimumscore,
			'status_new_lead'		: newleadstatus,
			'reactivate_lead'	 	: reactivateleads,
			'ass_close_sta' 		: statusses,
			'status_react_lead'		: reactivateleadstatus,
			'piwik_enabled'	 		: piwikenabled,
			'piwik_location' 		: piwiklocation,
			'piwik_sites'			: piwiksites,
			'salesfeed_enabled'	 	: salesfeedenabled,
			'salesfeed_accnum' 		: salesfeedaccnt,
			'snoobi_enabled'		: snoobienabled,
			'snoobi_accnum'			: snoobiaccnt,
			'id'   					: id
		}
		AppConnector.request(params).then(
			function(data) {
				progressIndicatorElement.progressIndicator({'mode' : 'hide'});
				data = data['result'];
				var params = {};
				if(data['success'] == true)
				{
						params['text'] = data['msg'];
						params['type'] = 'success';
				}
				else
				{
					params['text'] = data['msg'];
					params['type'] = 'error';
				}
				Settings_Vtiger_Index_Js.showMessage(params);
				/**/
				aDeferred.resolve(data);
				
			},
			function(error) {
				progressIndicatorElement.progressIndicator({'mode' : 'hide'});
				params['text'] = app.vtranslate('Save Error');
				params['type'] = 'error';
				Settings_Vtiger_Index_Js.showMessage(params);
				aDeferred.reject(error);
			}
		);
		return aDeferred.promise();
	 },
	
	/**
	 * Function to register save settings button click
	 */
	registerSaveSettingsClick:function(){
		var thisInstance 		= this;
		var container = this.getEditViewContainer();
		var apiObj = '';
		//register the event to click on close the related module
		var button = container.find('#SaveWebVisitsSettings');
		container.find('#SaveWebVisitsSettings').click(function(e) {													   
			var webvisitanalyser = container.find('#webvisitanalyser').val();
			var minimumscore = container.find('#minimumscore').val();
			//var newleadstatus = container.find('#newleadstatus').val();
			var newleadstatus = container.find('#newleadstatus option:selected').text();
			var reactivateleads = 0;
			if (container.find('#reactivateleads').is(':checked'))
				reactivateleads = 1;
			//var statusses = container.find('#statusses').val();
			var statusses = container.find('#statusses option:selected').text();
			var reactivateleadstatus = container.find('#reactivateleadstatus').val();
			var piwikenabled = 0;
			if (container.find('#piwikenabled').is(':checked'))
				piwikenabled = 1;
			var piwiklocation = container.find('#piwiklocation').val();
			var piwiksites = container.find('#piwiksites').val();
			var salesfeedenabled = 0;
			if (container.find('#salesfeedenabled').is(':checked'))
				salesfeedenabled = 1;
			var salesfeedaccnt = container.find('#salesfeedaccnt').val();
			var snoobienabled = 0;
			if (container.find('#snoobienabled').is(':checked'))
				snoobienabled = 1;
			var snoobiaccnt = container.find('#snoobiaccnt').val();
			var id = container.find('#settingid').val();	
			if(piwikenabled == 1 && salesfeedenabled == 1 && snoobienabled == 1)	
			{
				thisInstance.WebVisitsSetting(webvisitanalyser,minimumscore,newleadstatus,reactivateleads,statusses,reactivateleadstatus,piwikenabled,piwiklocation,piwiksites,salesfeedenabled,salesfeedaccnt,snoobienabled,snoobiaccnt,id);
			}
			else
			{
			 	var apiObj1 = container.find('#piwikenabled');
				var apiObj2 = container.find('#salesfeedenabled');
				var apiObj3 = container.find('#snoobienabled');
				if(piwikenabled == 0)
				{
					apiObj1.validationEngine('showPrompt', app.vtranslate('JS_REQUIRED_FIELD') , 'error','topLeft',true);
					apiObj1.focus(function(e) {apiObj1.validationEngine('hide')});
				}
				if(salesfeedenabled == 0)
				{
					apiObj2.validationEngine('showPrompt', app.vtranslate('JS_REQUIRED_FIELD') , 'error','topLeft',true);
					apiObj2.focus(function(e) {apiObj2.validationEngine('hide')});
				}
				if(snoobienabled == 0)
				{
					apiObj3.validationEngine('showPrompt', app.vtranslate('JS_REQUIRED_FIELD') , 'error','topLeft',true);
					apiObj3.focus(function(e) {apiObj3.validationEngine('hide')});
				}
			}
		})	
	},
	 
	/**
	 * Function which will handle the registrations for the elements 
	 */
	registerEvents : function() {
		this.registerFormForValidation();
		this.registerSaveSettingsClick();
	}
});
/**
 * Code to create current Class object on JQuery load event
 */
jQuery(document).ready(function() {
	var instance =  new Settings_WebVisits_Edit_Js();
	Settings_WebVisits_Edit_Js.currentInstance = instance;
})