/*********************************************************************************
 * The content of this file is subject to the ListView Colors 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

Settings_ListViewColors_Edit_Js("Settings_ListViewColors_Edit3_Js",{},{
	
    step3Container : false,

    advanceFilterInstance : false,

    ckEditorInstance : false,

    fieldValueMap : false,

    init : function() {
            this.initialize();
    },
    /**
     * Function to get the container which holds all the reports step1 elements
     * @return jQuery object
     */
    getContainer : function() {
        return this.step3Container;
    },

    /**
     * Function to set the reports step1 container
     * @params : element - which represents the reports step1 container
     * @return : current instance
     */
    setContainer : function(element) {
        this.step3Container = element;
        return this;
    },

    /**
     * Function  to intialize the reports step1
     */
    initialize : function(container) {
        if(typeof container == 'undefined') {
                container = jQuery('#listviewcolor_step3');
        }
        if(container.is('#listviewcolor_step3')) {
                this.setContainer(container);
        }else{
                this.setContainer(jQuery('#listviewcolor_step3'));
        }
    },


    getModuleName : function() {
        return app.getModuleName();
    },

    getFieldValueMapping : function() {
        var fieldValueMap = this.fieldValueMap;
        if(fieldValueMap != false){
                return fieldValueMap;
        } else {
                return '';
        }
    },


    registerEvents : function(){
        var container = this.getContainer();
        
        var listviewcolorel = jQuery('#listviewcolor_val');
        var listviewcolor_val = listviewcolorel.val();
        //color picker params for add calendar view
        var customParams = {
                color : listviewcolor_val
        };

        //register color picker
        var params = {
                onChange : function(hsb, hex, rgb) {
                        var selectedColor = '#'+hex;
                        listviewcolorel.val(selectedColor);
                }
        };

        if(typeof customParams != 'undefined'){
                params = jQuery.extend(params,customParams);
        }

        listviewcolorel.ColorPicker(params);
        //data.find('.calendarColorPicker').ColorPicker(params);
    }
});