/* * *******************************************************************************
 * The content of this file is subject to the ITS4YouGoogleCalendarSync_License_Js license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

jQuery.Class("Settings_ITS4YouGoogleCalendarSync_UsersList_Js",{},{
	init : function() {
        var container = jQuery('.usersListForm');
        container.find('.removeConnection').on('click', function(e){
            var element = jQuery(e.currentTarget);
            var url = element.data('url');
            var userid = element.data('id');

            var message = app.vtranslate('LBL_REMOVE_CONNECTION_QUESTION','Settings:ITS4YouGoogleCalendarSync');
            Vtiger_Helper_Js.showConfirmationBox({'message': message}).then(function(data) {

                var progressIndicatorElement = jQuery.progressIndicator({
                    'position' : 'html',
                    'blockInfo' : {
                        'enabled' : true
                    }
                });

                AppConnector.request(url).then(
                    function(data) {
                        progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                        jQuery("#googleusersynctr"+userid).remove();
                    }, function(error, err) {
                        progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                    }
                );
            });
        });
	}
});

jQuery(document).ready(function(){
    var usersListInstance = new Settings_ITS4YouGoogleCalendarSync_UsersList_Js();
    usersListInstance.init();
})
