/* * *******************************************************************************
 * The content of this file is subject to the ITS4YouGoogleCalendarSync_License_Js license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

jQuery.Class("Settings_ITS4YouGoogleCalendarSync_Uninstall_Js", {
    uninstallITS4YouGoogleCalendarSync: function () {
        var message = app.vtranslate('LBL_UNINSTALL_CONFIRM','ITS4YouGoogleCalendarSync');
        Vtiger_Helper_Js.showConfirmationBox({'message': message}).then(function() {

            var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                    'enabled' : true
                }
            });

            AppConnector.request('index.php?module=ITS4YouGoogleCalendarSync&action=UninstallGoogleSync&parent=Settings').then(
                function(data) {
                    if (data.result.success == true) {
                        var params = {
                            text:  app.vtranslate('JS_ITEMS_DELETED_SUCCESSFULLY'),
                            type: 'info'
                        };
                        window.location.href = "index.php";
                    } else {
                        var params = {
                            title : app.vtranslate('JS_ERROR'),
                            type: 'error'
                        };
                    }
                    progressIndicatorElement.progressIndicator({'mode':'hide'});
                    params.animation = "show";
                    Vtiger_Helper_Js.showPnotify(params);

                }, function(error, err) {
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                }
            );
        });
    },
    registerActions : function() {
        var thisInstance = this;
        jQuery('#uninstall_its4yougooglecalendarsync_btn').click(function(e) {
            thisInstance.uninstallITS4YouGoogleCalendarSync();
        });
    },
    init: function () {
        this.registerActions();
    }
});


jQuery(document).ready(function(){
    var googleCalendarSyncUninstallInstance = new Settings_ITS4YouGoogleCalendarSync_Uninstall_Js();
    googleCalendarSyncUninstallInstance.init();
})
