/* * *******************************************************************************
 * The content of this file is subject to the ITS4YouGoogleCalendarSync_License_Js license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

Vtiger_List_Js("ITS4YouGoogleCalendarSync_License_Js", {
    licenseInstance: false,
    getInstance: function () {
        if (ITS4YouGoogleCalendarSync_License_Js.licenseInstance == false) {
            var instance = new window["ITS4YouGoogleCalendarSync_License_Js"]();
            ITS4YouGoogleCalendarSync_License_Js.licenseInstance = instance;
            return instance;
        }

        return ITS4YouGoogleCalendarSync_License_Js.licenseInstance;
    }
}, {
    /*
     * Function to get the value of the step
     * returns 1 or 2 or 3
     */
    getStepValue : function(){
        var container = this.currentInstance.getContainer();
        return jQuery('.step',container).val();
    },
    /*
     * Function to initiate all the operations for a step
     * @params step value
     */
    initiateStep : function(stepVal) {
        var step = 'step'+stepVal;
        this.activateHeader(step);
        jQuery('#stepContent'+(stepVal - 1)).hide();
        jQuery('#stepContent'+stepVal).show();
    },
    /*
     * Function to activate the header based on the class
     * @params class name
     */
    activateHeader : function(step) {
        var headersContainer = jQuery('.crumbs');
        headersContainer.find('.active').removeClass('active');
        jQuery('#'+step,headersContainer).addClass('active');
    },

    saveLicenseKey: function (form,is_install) {
        var thisInstance = this;
        if (is_install){
            var licensekey_val = jQuery('#licensekey').val();

            var params = {
                module : app.getModuleName(),
                licensekey : licensekey_val,
                action : 'License',
                parent : 'Settings',
                mode : 'editLicense',
                type : 'activate'
            };
        }
        else {
            var params = jQuery(form).serializeFormData();
        }
        thisInstance.validateLicenseKey(params).then(
            function(data) {
                if (!is_install){
                    app.hideModalWindow();
                    var params = {
                        text: app.vtranslate(data['message'])
                    };
                    thisInstance.showMessage(params);

                    jQuery('#license_key_val').val(data.licensekey);
                    jQuery('#license_key_label').html(data.licensekey);

                    jQuery('#divgroup1').hide();
                    jQuery('#divgroup2').show();
                } else {
                    thisInstance.initiateStep(2);
                }
            }
        );

    },
    validateLicenseKey: function (data) {
        var thisInstance = this;
        var aDeferred = jQuery.Deferred();

        thisInstance.checkLicenseKey(data).then(
            function(data) {
                aDeferred.resolve(data);
            },
            function(err){
                aDeferred.reject();
            }
        );
        return aDeferred.promise();
    },
    checkLicenseKey : function(params) {
        var aDeferred = jQuery.Deferred();
        var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
                'enabled' : true
            }
        });

        AppConnector.request(params).then(function(data) {
            var response = data['result'];
            progressIndicatorElement.progressIndicator({'mode':'hide'});

            var result = response.success;
            if(result == true) {
                aDeferred.resolve(response);
            } else {

                var params = {
                    title : app.vtranslate('JS_ERROR'),
                    text: response.message,
                    type: 'error'
                };
                Vtiger_Helper_Js.showMessage(params);

                aDeferred.reject(response);
            }
        });
        return aDeferred.promise();
    },
    saveFirstCompany: function () {
        var aDeferred = jQuery.Deferred();
        var params = {
            module: app.getModuleName(),
            action: 'SaveFirstCompany'
        };
        AppConnector.request(params).then(function(data) {
            var response = data['result'];
            aDeferred.resolve(response);
        });
        return aDeferred.promise();
    },
    editLicense : function(){
        var aDeferred = jQuery.Deferred();
        var thisInstance = this;
        var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
                'enabled' : true
            }
        });
        var license_key = jQuery('#license_key_val').val();
        url = "index.php?module=ITS4YouGoogleCalendarSync&parent=Settings&view=IndexAjax&mode=editLicense";
        AppConnector.request(url).then(
            function(data) {
                var callBackFunction = function(data) {
                    //cache should be empty when modal opened
                    var form = jQuery('#editLicense');
                    var params = app.validationEngineOptions;
                    params.onValidationComplete = function(form, valid){
                        if(valid){
                            thisInstance.saveLicenseKey(form,false);
                            return valid;
                        }
                    }
                    form.validationEngine(params);
                    form.submit(function(e){
                        e.preventDefault();
                    })
                }
                progressIndicatorElement.progressIndicator({'mode':'hide'});
                app.showModalWindow(data,function(data){
                    if(typeof callBackFunction == 'function'){
                        callBackFunction(data);
                    }
                }, {'width':'500px'});
            },
            function(error) {
                aDeferred.reject(error);
            }
        );
        return aDeferred.promise();
    },
    saveAttributes: function (form) {
        var thisInstance = this;
        var params = jQuery(form).serializeFormData();
        thisInstance.validateLicenseKey(params).then(
            function(data) {
                app.hideModalWindow();
                var params = {
                    text: app.vtranslate(data['message'])
                };
                thisInstance.showMessage(params);

                jQuery('#clientid_val').text(data.clientid);
                jQuery('#client_secret_val').text(data.client_secret);

                jQuery('.google_attr_content').removeClass("hide");
                jQuery('.add_google_attr_content').addClass("hide");
            }
        );
    },
    editSync : function() {
        var aDeferred = jQuery.Deferred();
        var thisInstance = this;

        var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
                'enabled' : true
            }
        });

        var postData = {
            "module": 'ITS4YouGoogleCalendarSync',
            "view": 'IndexAjax',
            "parent": 'Settings',
            "mode": 'editSync'
        }

        AppConnector.request(postData).then(
            function(data) {
                var callBackFunction = function(data) {
                    //cache should be empty when modal opened
                    var form = jQuery('#editAttributes');

                    var params = app.validationEngineOptions;
                    params.onValidationComplete = function(form, valid){
                        if(valid) {
                            thisInstance.saveAttributes(form,false);
                            return valid;
                        }
                    }
                    form.validationEngine(params);

                    form.submit(function(e) {
                        e.preventDefault();
                    })
                }

                progressIndicatorElement.progressIndicator({'mode':'hide'});
                app.showModalWindow(data,function(data){
                    if(typeof callBackFunction == 'function'){
                        callBackFunction(data);
                    }
                }, {'width':'500px'});
            },
            function(error) {
                //TODO : Handle error
                aDeferred.reject(error);
            }
        );

        AppConnector.request(postData).then(function(response) {
            progressIndicatorElement.progressIndicator({'mode':'hide'})
            ;
            app.showModalWindow(response, function (modalContainer) {
                modalContainer.find('#js-edit-attributes').on('click', function (e){
                    var form = modalContainer.find('#editAttributes');
                    var params = {
                        submitHandler: function (form) {
                            if (!this.valid) {
                                return false;
                            }
                            thisInstance.saveAttributes(form, false);
                        }
                    };
                    form.vtValidate(params);
                });
            }, {'width':'500px'});
        });

        return aDeferred.promise();
    },
    deleteSync: function() {
        if (confirm(app.vtranslate('LBL_DELETE_CONFIRMATION'))) {
            var postData = {
                "module": 'ITS4YouGoogleCalendarSync',
                "action": 'License',
                "parent": 'Settings',
                "mode": 'deleteSync'
            }

            AppConnector.request(postData).then(function(data) {
                jQuery('.google_attr_content').addClass("hide");
                jQuery('.add_google_attr_content').removeClass("hide");
            });
        }
    },
    registerActions : function() {
        var thisInstance = this;
        jQuery('#activate_license_btn').click(function() {

            thisInstance.editLicense();
        });
        jQuery('#deactivate_license_btn').click(function() {
            thisInstance.deactivateLicense();
        });
        jQuery('.edit_sync_btn').click(function() {
            thisInstance.editSync();
        });
        jQuery('#delete_sync_btn').click(function() {
            thisInstance.deleteSync();
        });
    },
    registerEvents: function() {
        this.registerActions();
    },
    deactivateLicense: function () {
        var deactivateActionUrl = 'index.php?module=ITS4YouGoogleCalendarSync&action=License&mode=deactivateLicense&parent=Settings';
        var message = app.vtranslate('LBL_DEACTIVATE_QUESTION','ITS4YouGoogleCalendarSync');
        Vtiger_Helper_Js.showConfirmationBox({'message': message}).then(function(data) {
            var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                    'enabled' : true
                }
            });
            AppConnector.request(deactivateActionUrl).then(function(data) {
                if (data.result.success == true) {
                    var params = {
                        text: data.result.deactivate,
                        type: 'info'
                    };

                    jQuery('#license_key_val').val("");
                    jQuery('#license_key_label').html("");

                    jQuery('#divgroup1').show();
                    jQuery('#divgroup2').hide();
                } else {
                    var params = {
                        title : app.vtranslate('JS_ERROR'),
                        text: data.result.deactivate,
                        type: 'error'
                    };
                }

                progressIndicatorElement.progressIndicator({'mode':'hide'});
                Vtiger_Helper_Js.showMessage(params);
            });
        });
    },
    registerInstallActions : function() {
        jQuery('#next_button').click(function() {
            window.location.href = "index.php?module=ITS4YouGoogleCalendarSync&view=List&parent=Settings";
        });
    },
    registerInstallEvents: function() {
        var thisInstance = this;
        var form = jQuery('#editLicense');
        form.on('submit', function(e){
            e.preventDefault();
            thisInstance.saveLicenseKey(form,true);
        });
        this.registerInstallActions();
        this.registerActions();
    },
    showMessage : function(customParams){
        var params = {};
        params.animation = "show";
        params.type = 'info';
        params.title = app.vtranslate('JS_MESSAGE');

        if(typeof customParams != 'undefined') {
            var params = jQuery.extend(params,customParams);
        }
        Vtiger_Helper_Js.showPnotify(params);
    }

});

