/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions.
 * All Rights Reserved.
 *************************************************************************************/

jQuery.Class("Settings_GeoTools_ModuleEditor_Js",{

    //holds the editor instance
    geotoolsInstance : false,
    
    /**
     * This function used to trigger the Add Module popup
     */
    moduleAdd : function(event) {
        event.stopPropagation();
        var instance = Settings_GeoTools_ModuleEditor_Js.geotoolsInstance;
        instance.showAddModule();
    },
    
    /**
     * This function used to trigger the Delete Module popup
     */
    moduleDel : function(event, module) {
        event.stopPropagation();
        var instance = Settings_GeoTools_ModuleEditor_Js.geotoolsInstance;
        instance.showDelModule(module);
    },
    
    /**
     * This function used to trigger the Update Module save routine
     */
    moduleUpdate : function(event) {
        event.stopPropagation();
        var instance = Settings_GeoTools_ModuleEditor_Js.geotoolsInstance;
        instance.saveModuleEditor();
    },
    
        /**
     * This function used to trigger the Add Action Link popup
     */
    addAction : function(event, module) {
        event.stopPropagation();
        var instance = Settings_GeoTools_ModuleEditor_Js.geotoolsInstance;
        instance.showAddAction(module);
    },
    
    delAction : function(event, module) {
        event.stopPropagation();
        var instance = Settings_GeoTools_ModuleEditor_Js.geotoolsInstance;
        instance.showDelAction(module);
    },
    
}, {    
    
    //constructor
    init : function() {
        Settings_GeoTools_ModuleEditor_Js.geotoolsInstance = this;
    },
    
        
    /**
     * function to show the Add Module popup for GeoTools
     */
    showAddModule : function() {
        var thisInstance = this;
        var aDeferred = jQuery.Deferred();
        
        var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
                'enabled' : true
            }
        });
        
        var params = {};
        params['module'] = app.getModuleName();
        params['parent'] = app.getParentModuleName();
        params['view'] = 'AddAjax';
        
        AppConnector.request(params).then(
            function(data) {
                var callBackFunction = function(data) {
                    var addModuleform = jQuery('#addModule');
                    
                    //register all select2 Elements
                    app.showSelect2ElementView(addModuleform.find('select.select2'));
                    
                    var params = app.validationEngineOptions;
                    params.onValidationComplete = function(addModuleform, valid){
                        if(valid) {
                            thisInstance.saveAddModule(addModuleform);
                            return valid;
                        }
                    }
                    addModuleform.validationEngine(params);
                    
                    addModuleform.submit(function(e) {
                        e.preventDefault();
                    })
                }
                
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                app.showModalWindow(data,function(data){
                    if(typeof callBackFunction == 'function'){
                        callBackFunction(data);
                    }
                }, {'width':'400px'});
            },
            function(error) {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                //TODO : Handle error
                aDeferred.reject(error);
            }
        );
        return aDeferred.promise();
    },
    
    
    /**
     * This function will save the new module details
     */
    saveAddModule : function(form) {
        var thisInstance = this;
        var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
                'enabled' : true
            }
        });
        
        var data = form.serializeFormData();
        data['module'] = app.getModuleName();
        data['parent'] = app.getParentModuleName();
        data['action'] = 'ModuleEditorSaveAjax';
        data['mode'] = 'addModule';
        
        AppConnector.request(data).then(
            function(data) {
                if(data['success']) {
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                    app.hideModalWindow();
                    var params = {};
                    params.text = app.vtranslate('JS_NEW_MODULE_ADDED');
                    Settings_Vtiger_Index_Js.showMessage(params);
                    thisInstance.loadModuleEditorViewContents();
                }
            },
            function(error) {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                //TODO : Handle error
            }
        );
    },
    
    
    /**
     * function to show the Delete Module warning popup for GeoTools
     */
    showDelModule : function(module) {
        var thisInstance = this;
        var aDeferred = jQuery.Deferred();
        
        var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
                'enabled' : true
            }
        });
        
        var params = {};
        params['module'] = app.getModuleName();
        params['parent'] = app.getParentModuleName();
        params['view'] = 'DelAjax';
        params['delModule'] = module;
        
        AppConnector.request(params).then(
            function(data) {
                var callBackFunction = function(data) {
                    var delModuleform = jQuery('#delModule');
                    
                    //register all select2 Elements
                    //app.showSelect2ElementView(delModuleform.find('select.select2'));
                    
                    var params = app.validationEngineOptions;
                    params.onValidationComplete = function(delModuleform, valid){
                        if(valid) {
                            thisInstance.saveDeleteModule(delModuleform);
                            return valid;
                        }
                    }
                    delModuleform.validationEngine(params);
                    
                    delModuleform.submit(function(e) {
                        e.preventDefault();
                    })
                }
                
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                app.showModalWindow(data,function(data){
                    if(typeof callBackFunction == 'function'){
                        callBackFunction(data);
                    }
                }, {'width':'400px'});
            },
            function(error) {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                //TODO : Handle error
                aDeferred.reject(error);
            }
        );
        return aDeferred.promise();
    },
    
    /**
     * This function will delete the module details
     */
    saveDeleteModule : function(form) {
        var thisInstance = this;
        var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
                'enabled' : true
            }
        });
        
        var data = form.serializeFormData();
        data['module'] = app.getModuleName();
        data['parent'] = app.getParentModuleName();
        data['action'] = 'ModuleEditorSaveAjax';
        data['mode'] = 'delModule';
        
        AppConnector.request(data).then(
            function(data) {
                if(data['success']) {
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                    app.hideModalWindow();
                    var params = {};
                    params.text = app.vtranslate('JS_MODULE_DELETED');
                    Settings_Vtiger_Index_Js.showMessage(params);
                    thisInstance.loadModuleEditorViewContents();
                }
            },
            function(error) {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                //TODO : Handle error
            }
        );
    },
    
    /**
     * function to show the Add Action popup for GeoTools
     */
    showAddAction : function(module) {
        var thisInstance = this;
        var aDeferred = jQuery.Deferred();
        
        var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
                'enabled' : true
            }
        });
        
        var params = {};
        params['module'] = app.getModuleName();
        params['parent'] = app.getParentModuleName();
        params['view'] = 'AddActionAjax';
        params['srcmod'] = module;

        AppConnector.request(params).then(
            function(data) {
                var callBackFunction = function(data) {
                    var addActionform = jQuery('#addAction');
                    
                    //register all select2 Elements
                    app.showSelect2ElementView(addActionform.find('select.select2'));
                    
                    // Register change event for Filter List
                    thisInstance.updateFilterList(addActionform);
                    
                    var params = app.validationEngineOptions;
                    params.onValidationComplete = function(addActionform, valid){
                        if(valid) {
                            thisInstance.saveAddAction(addActionform);
                            return valid;
                        }
                    }
                    addActionform.validationEngine(params);
                    
                    addActionform.submit(function(e) {
                        e.preventDefault();
                    })
                }
                
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                app.showModalWindow(data,function(data){
                    if(typeof callBackFunction == 'function'){
                        callBackFunction(data);
                    }
                }, {'width':'400px'});
            },
            function(error) {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                //TODO : Handle error
                aDeferred.reject(error);
            }
        );
        return aDeferred.promise();
    },

    updateFilterList : function(addActionform) {
        var filterParams = {};
        filterParams['module'] = app.getModuleName();
        filterParams['parent'] = app.getParentModuleName();
        filterParams['action'] = 'ModuleEditorSaveAjax';
        filterParams['mode']   = 'getFilterList';
    
        var moduleSelector = jQuery('[name="targetModule"]', addActionform);
        var filterSelector = jQuery('[name="targetFilter"]', addActionform);
        moduleSelector.change(function(e) {
            var targetModule = e.val;
            filterParams['targetModule'] = targetModule;
            AppConnector.request(filterParams).then(
                function(filters) {
                    filterSelector.empty(); // remove old options
                    jQuery.each(filters.result, function(value, key) {
                        filterSelector.append($("<option></option>")
                           .attr("value", value).text(key));
                    });
                    // Replace Pick list contents with new Filter options and reload
                    filterSelector.trigger("liszt:updated");
                },
                function(error) {
                    //TODO : Handle error
                }
            );
        });
    },
    
    /**
     * This function will save the new Action Link details
     */
    saveAddAction : function(form) {
        var thisInstance = this;
        var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
                'enabled' : true
            }
        });
        
        var data = form.serializeFormData();
        data['module'] = app.getModuleName();
        data['parent'] = app.getParentModuleName();
        data['action'] = 'ModuleEditorSaveAjax';
        data['mode'] = 'addAction';
        
        AppConnector.request(data).then(
            function(data) {
                if(data['success']) {
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                    app.hideModalWindow();
                    var params = {};
                    params.text = app.vtranslate('JS_ACTION_LINK_ADDED');
                    Settings_Vtiger_Index_Js.showMessage(params);
                    thisInstance.loadModuleEditorViewContents();
                }
            },
            function(error) {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                //TODO : Handle error
            }
        );
    },
    
        /**
     * function to show the Delete Action popup for GeoTools
     */
    showDelAction : function(module) {
        var thisInstance = this;
        var aDeferred = jQuery.Deferred();
        
        var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
                'enabled' : true
            }
        });
        
        var params = {};
        params['module'] = app.getModuleName();
        params['parent'] = app.getParentModuleName();
        params['view'] = 'DelActionAjax';
        params['srcmod'] = module;
        
        AppConnector.request(params).then(
            function(data) {
                var callBackFunction = function(data) {
                    var delActionform = jQuery('#delAction');
                    
                    //register all select2 Elements
                    app.showSelect2ElementView(delActionform.find('select.select2'));
                    
                    var params = app.validationEngineOptions;
                    params.onValidationComplete = function(delActionform, valid){
                        if(valid) {
                            thisInstance.saveDelAction(delActionform);
                            return valid;
                        }
                    }
                    delActionform.validationEngine(params);
                    
                    delActionform.submit(function(e) {
                        e.preventDefault();
                    })
                }
                
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                app.showModalWindow(data,function(data){
                    if(typeof callBackFunction == 'function'){
                        callBackFunction(data);
                    }
                }, {'width':'400px'});
            },
            function(error) {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                //TODO : Handle error
                aDeferred.reject(error);
            }
        );
        return aDeferred.promise();
    },
    
        /**
     * This function will delete the Action details
     */
    saveDelAction : function(form) {
        var thisInstance = this;
        var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
                'enabled' : true
            }
        });
        
        var data = form.serializeFormData();
        data['module'] = app.getModuleName();
        data['parent'] = app.getParentModuleName();
        data['action'] = 'ModuleEditorSaveAjax';
        data['mode'] = 'delAction';
        
        AppConnector.request(data).then(
            function(data) {
                if(data['success']) {
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                    app.hideModalWindow();
                    var params = {};
                    params.text = app.vtranslate('JS_ACTION_LINK_DELETED');
                    Settings_Vtiger_Index_Js.showMessage(params);
                    thisInstance.loadModuleEditorViewContents();
                }
            },
            function(error) {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                //TODO : Handle error
            }
        );
    },
    
    /**
     * This function will load the listView contents
     */
    loadModuleEditorViewContents : function() {
        var thisInstance = this;
        var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
                'enabled' : true
            }
        });
        
        var params = {};
        params['module'] = app.getModuleName();
        params['parent'] = app.getParentModuleName();
        params['view'] = 'ModuleEditor';
        
        AppConnector.request(params).then(
            function(data) {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                jQuery('.contentsDiv').html(data);
            }, function(error, err) {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
            }
        );
    },
    
    
    /*
     * Function to save the Editor content
     */
    saveModuleEditor : function() {
        var thisInstance = this;
        var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
                'enabled' : true
            }
        });
    
        var aDeferred = jQuery.Deferred();
        var form = jQuery('#ModuleEditorForm'); 
        var data = form.serializeFormData();
        
        var updatedModules = {};
        jQuery.each(data, function(key, value) {
            updatedModules[key] = value;
        })
        
        var params = {
            'module' : app.getModuleName(),
            'parent' : app.getParentModuleName(),
            'action' : 'ModuleEditorSaveAjax',
            'mode'   : 'updateModules', 
            'updatedModules' : JSON.stringify(updatedModules)
        }

        AppConnector.request(params).then(
            function(data) {
                if(data['success']) {
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                    var params = {};
                    params.text = app.vtranslate('JS_MODULE_DETAILS_SAVED');
                    Settings_Vtiger_Index_Js.showMessage(params);
                    thisInstance.loadModuleEditorViewContents();
                }
            },
            function(error,err){
                aDeferred.reject();
            }
        );
        return aDeferred.promise();
    },
    
        /*
     * Function to load the contents from the url through pjax
     */
    loadContents : function(url) {
        var aDeferred = jQuery.Deferred();
        AppConnector.requestPjax(url).then(
            function(data){
                aDeferred.resolve(data);
            },
            function(error, err){
                aDeferred.reject();
            }
        );
        return aDeferred.promise();
    },
    
    /**
     * function to register the events
     */
    registerModuleEditorEvents : function() {
        var thisInstance = this;
        var form = jQuery('#ModuleEditorForm');
        var detailUrl = form.data('detailUrl');
        
        //register all select2 Elements
        app.showSelect2ElementView(form.find('select.select2'), {dropdownCss : {'z-index' : 0}});
        
        //register validation engine
        var params = app.validationEngineOptions;
        params.onValidationComplete = function(form, valid){
            if(valid) {
                var progressIndicatorElement = jQuery.progressIndicator({
                    'position' : 'html',
                    'blockInfo' : {
                        'enabled' : true
                    }
                });
                thisInstance.saveModuleEditor(form).then(
                    function(data) {
                        var params = {};
                        if(data['success']) {
                            params['text'] = app.vtranslate('JS_CONFIGURATION_DETAILS_SAVED');
                            thisInstance.loadContents(detailUrl).then(
                                function(data) {
                                    progressIndicatorElement.progressIndicator({'mode':'hide'});
                                    jQuery('.contentsDiv').html(data);
                                }
                            );
                        } else {
                            progressIndicatorElement.progressIndicator({'mode':'hide'});
                            params['text'] = data['error']['message'];
                            params['type'] = 'error';
                        }
                        Settings_Vtiger_Index_Js.showMessage(params);
                    },function(error, err) {
                        progressIndicatorElement.progressIndicator({'mode':'hide'});
                    }
                );
                return valid;
            }
        }
        form.validationEngine(params);
        
        form.submit(function(e) {
            e.preventDefault();
        })
        
        //Register click event for cancel link
        var cancelLink = form.find('.cancelLink');
        cancelLink.click(function() {
            var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                    'enabled' : true
                }
            });
            history.go(-1);
        });
    },
    
    registerEvents: function() {
        if(jQuery('#ModuleEditorForm').length > 0) {
            this.registerModuleEditorEvents();
        }
    }
});

jQuery(document).ready(function(e){
    var geotoolsInstance = new Settings_GeoTools_ModuleEditor_Js();
    geotoolsInstance.registerEvents();
})

