/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions.
 * All Rights Reserved.
 *************************************************************************************/

jQuery.Class("Settings_GeoTools_CoreEditor_Js",{},{
    
    /*
     * Function to save the Editor content
     */
    saveCoreEditor : function(form) {
        var aDeferred = jQuery.Deferred();
        var data = form.serializeFormData();
        var updatedFields = {};
        jQuery.each(data, function(key, value) {
            updatedFields[key] = value;
        });
        
        var params = {
            'module' : app.getModuleName(),
            'parent' : app.getParentModuleName(),
            'action' : 'CoreEditorSaveAjax',
			'mode'   : 'saveCoreEditor',
            'updatedFields' : JSON.stringify(updatedFields)
        }

        AppConnector.request(params).then(
            function(data) {
                aDeferred.resolve(data);
            },
            function(error,err){
                aDeferred.reject();
            }
        );
        return aDeferred.promise();
    },

	/**
	 * Function to show the Popup for configuring the GeoTools
	 * Provider (Map or Geocoder)
	 */
	showCheckProvider : function(type, providerId) {
		var thisInstance = this;
		var aDeferred = jQuery.Deferred();
		
		var progressIndicatorElement = jQuery.progressIndicator({
			'position' : 'html',
			'blockInfo' : {
				'enabled' : true
			}
		});
		
		var params = {
			'module' : app.getModuleName(),
			'parent' : app.getParentModuleName(),
			'view'   : 'CheckProvider',
			'type'   : type,
			'providerId' : providerId
		};
		
		AppConnector.request(params).then(
		    function(data) {
		        try {
                    data = JSON.parse(data);
                } catch (e) {
                    if (e instanceof SyntaxError) {
                        console.log("This is html. Move along");
                    }
                }
           		if(data['success'] !== true) {
				    var callBackFunction = function(data) {
			            jQuery('#checkProvider')
                            // indirectly bind the handler to form
                            .submit(function(e) {
                                e.preventDefault();
                                if(thisInstance.checkForm.apply(jQuery(this).find(':input')[0])) {
                                    thisInstance.saveProvider(this);
                                }
					        })
                            // look for input elements
                            .find('input[data-rule-required="true"]')
                            // bind the handler to input elements
                            .keyup(thisInstance.checkForm)
                            // immediately fire it to initialize buttons state
                            .keyup();
				    };

				    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
				    app.showModalWindow(data,function(data){
					    if(typeof callBackFunction == 'function'){
						    callBackFunction(data);
					    }
				    }, {'width':'400px'});
			    } else {
				    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
			        // "data" is empty (No required params for Provider) so nothing to do
                    aDeferred.reject();
                }
			},
		    function(error) {
			    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
			    //TODO : Handle error
			    aDeferred.reject(error);
		    }
		);
		return aDeferred.promise();
	},

    /**
     * Serialise and save provider config over Ajax
    **/
	saveProvider : function(form) {
		var aDeferred = jQuery.Deferred();
		var thisInstance = this;
		
		var progressIndicatorElement = jQuery.progressIndicator({
			'position' : 'html',
			'blockInfo' : {
				'enabled' : true
			}
		});
		
	    var providerForm = jQuery(form);		
		var params = providerForm.serializeFormData();

		params['module'] = app.getModuleName();
		params['parent'] = app.getParentModuleName();
		params['action'] = 'CoreEditorSaveAjax';
		params['mode'] = 'saveProvider';
	    
		AppConnector.request(params).then(
				function(data) {
				    var msg = {};
					if(data['success']) {
					    msg.title = app.vtranslate('JS_GEOTOOLS_PROVIDER_SAVED');
					    msg.text = app.vtranslate('JS_GEOTOOLS_PROVIDER_UPDATED');
					    msg.type = 'success';
						progressIndicatorElement.progressIndicator({'mode' : 'hide'});
					} else {
					    msg.title = app.vtranslate('JS_GEOTOOLS_PROVIDER_ERROR');;
					    msg.text = data['error']['message'];
					    msg.type = 'error';
	       				progressIndicatorElement.progressIndicator({'mode' : 'hide'});
					}
	                Settings_Vtiger_Index_Js.showMessage(msg);
					aDeferred.resolve(data);
				},
				function(error,err){
					progressIndicatorElement.progressIndicator({'mode' : 'hide'});
					aDeferred.reject();
				}
			);
		return aDeferred.promise();
	},
    
    /**
     * This function will attempt to Geocode the Company address
     */
    geocodeCompany : function() {
        var thisInstance = this;
        var geocodingMessage = app.vtranslate('JS_GEOTOOLS_ATTEMPTING_TO_GEOCODE_ADDRESS');
        var progressIndicatorElement = jQuery.progressIndicator({
            'message' : geocodingMessage,
            'position' : 'html',
            'blockInfo' : {
                'enabled' : true
            }
        });
        
        var params = {
            'module' : app.getModuleName(),
            'parent' : app.getParentModuleName(),
            'action' : 'CoreEditorGeocodeAjax',
        };
        
        AppConnector.request(params).then(
            function(data) {
                var msg = {};
                if(data['success']) {
                    msg.title = app.vtranslate('JS_GEOTOOLS_LOCATION_SAVED');
                    msg.text = app.vtranslate('JS_GEOTOOLS_LOCATION_UPDATED');
                    msg.type = 'success';
                    var location = data['result'][0];
                    $('input[name="companyloc"]').val(location);
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                } else {
                    msg.title = app.vtranslate('JS_GEOTOOLS_ERROR');;
                    msg.text = data['error']['message'];
                    msg.type = 'error';
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                }
                Settings_Vtiger_Index_Js.showMessage(msg);
            },
            function(error) {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                //TODO : Handle error
            }
        );
    },

    /*
     * Function to load the contents from the url through pjax
     */
    loadContents : function(url) {
        var aDeferred = jQuery.Deferred();
        AppConnector.requestPjax(url).then(
            function(data){
                aDeferred.resolve(data);
            },
            function(error, err){
                aDeferred.reject();
            }
        );
        return aDeferred.promise();
    },

    /**
     * https://codereview.stackexchange.com/questions/148072/disable-button-when-required-inputs-are-not-filled-in
    **/
    checkForm : function() {
          // "this" is an input element
          var isValidForm = true;
          jQuery(this.form).find('input[data-rule-required="true"]').each(function() {
            if (!this.value.trim()) {
              isValidForm = false;
            }
          });
          jQuery(this.form).find('button[name="saveButton"]').prop('disabled', !isValidForm);
          return isValidForm;
    },

    /*
     * function to register the events in editView
     */
    registerEditViewEvents : function() {
        var thisInstance = this;
        var form = jQuery('#CoreEditorForm');
        var detailUrl = form.data('detailUrl');
        
		// Want to get the original values
		var geocoderselectVal = jQuery('select[name="geocoder"]').val();
		var mapserviceselectVal = jQuery('select[name="mapservice"]').val();

        //register all select2 Elements
        app.showSelect2ElementView(form.find('select.select2'), {dropdownCss : {'z-index' : 0}});
        
        //register Geocode Company Address button click
        var btn = $('#geocodeCompany');
        btn.click(function() {
            thisInstance.geocodeCompany();
		});

        // TODO Needs re-writing for Select2 elements
		jQuery('select[name="geocoder"]').on('change', function() {
			var el = jQuery(this);
			var name = el.attr('name');
			var provider = el.val();
			// Only trigger if *really* changed
			if((name == 'geocoder' && provider != geocoderselectVal) || (name == 'mapservice' && provider != mapserviceselectVal)) {
				thisInstance.showCheckProvider(name, provider);
			}
        });
        
        //register validation engine
        var params = app.validationEngineOptions;
        params.onValidationComplete = function(form, valid){
            if(valid) {
                var progressIndicatorElement = jQuery.progressIndicator({
                    'position' : 'html',
                    'blockInfo' : {
                        'enabled' : true
                    }
                });
                thisInstance.saveCoreEditor(form).then(
                    function(data) {
                        var params = {};
                        if(data['success']) {
                            params['text'] = app.vtranslate('JS_CONFIGURATION_DETAILS_SAVED');
                            thisInstance.loadContents(detailUrl).then(
                                function(data) {
                                    progressIndicatorElement.progressIndicator({'mode':'hide'});
                                    jQuery('.contentsDiv').html(data);
                                    thisInstance.registerDetailViewEvents();
                                }
                            );
                        } else {
                            progressIndicatorElement.progressIndicator({'mode':'hide'});
                            params['text'] = data['error']['message'];
                            params['type'] = 'error';
                        }
                        Settings_Vtiger_Index_Js.showMessage(params);
                    },function(error, err) {
                        progressIndicatorElement.progressIndicator({'mode':'hide'});
                    }
                );
                return valid;
            }
        }
        form.validationEngine(params);
        
        form.submit(function(e) {
            e.preventDefault();
        })
        
        //Register click event for cancel link
        var cancelLink = form.find('.cancelLink');
        cancelLink.click(function() {
            var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                    'enabled' : true
                }
            });
            thisInstance.loadContents(detailUrl).then(
                function(data) {
                    progressIndicatorElement.progressIndicator({'mode':'hide'})
                    jQuery('.contentsDiv').html(data);
                    thisInstance.registerDetailViewEvents();
                }
            );
        })
    },
    
    /*
     * function to register the events in DetailView
     */
    registerDetailViewEvents : function() {
        var thisInstance = this;
        var container = jQuery('#CoreEditorDetails');
        var editButton = container.find('.editButton');
        
        //Register click event for edit button
        editButton.click(function() {
            var url = editButton.data('url');
            var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                    'enabled' : true
                }
            });
            thisInstance.loadContents(url).then(
                function(data) {
                    progressIndicatorElement.progressIndicator({'mode':'hide'});
                    jQuery('.contentsDiv').html(data);
                    thisInstance.registerEditViewEvents();
                }, function(error, err) {
                    progressIndicatorElement.progressIndicator({'mode':'hide'});
                }
            );
        });
    },
    
    registerEvents: function() {
        if(jQuery('#CoreEditorDetails').length > 0) {
            this.registerDetailViewEvents();
        } else {
            this.registerEditViewEvents();
        }
    }

});

Vtiger_Base_Validator_Js("Vtiger_LatLng_Validator_Js",{

    /**
     *Function which invokes field validation
     *@param accepts field element as parameter
     * @return error if validation fails true on success
     */
    invokeValidation: function(field, rules, i, options){
        var instance = new Vtiger_FieldLabel_Validator_Js();
        instance.setElement(field);
        var response = instance.validate();
        if(response != true){
            return instance.getError();
        }
    }

},{
    /**
     * Function to validate the field label
     * @return true if validation is successfull
     * @return false if validation error occurs
     */
    validate: function(){
        var fieldValue = this.getFieldValue();
        return this.validateValue(fieldValue);
    },

    validateValue : function(fieldValue){
        var latlngVal = /^-?([0-8]?[0-9]|90)\.[0-9]{1,7},-?((1?[0-7]?|[0-9]?)[0-9]|180)\.[0-9]{1,7}$/;
        var invalid_latlng = app.vtranslate('JS_GEOTOOLS_INVALID_LATLNG');
        
        // Validate Latitude and Longitude
        if(!latlngVal.test(fieldValue)) {
            this.setError(invalid_latlng);
            return false;
        }
        return true;
    }
});

jQuery(document).ready(function(e){
    var tacInstance = new Settings_GeoTools_CoreEditor_Js();
    tacInstance.registerEvents();
});
