{*<!--
/*********************************************************************************
** The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions.
 * All Rights Reserved.
 ********************************************************************************/
-->*}
{strip}
<div class="container-fluid">
    <div class="contents">
        <form id="ModuleEditorForm" class="form-horizontal" data-detail-url="{$MODULE_MODEL->getDetailViewUrl()}">
            <div class="widget_header row-fluid">
                <div class="span8"><h3>{vtranslate('LBL GEOTOOLS MODULE EDITOR', $QUALIFIED_MODULE)}</h3>&nbsp;{vtranslate('LBL GEOTOOLS MODULE DESCRIPTION', $QUALIFIED_MODULE)}</div>
                <div class="span4 btn-toolbar">
                    <div class="pull-right">
                        <button class="btn btn-success saveButton" type="button" onclick="Settings_GeoTools_ModuleEditor_Js.moduleUpdate(event);"><strong>{vtranslate('LBL_SAVE', $QUALIFIED_MODULE)}</strong></button>
                        <a type="reset" class="cancelLink" title="{vtranslate('LBL_CANCEL', $QUALIFIED_MODULE)}" href="javascript:history.back()">{vtranslate('LBL_CANCEL', $QUALIFIED_MODULE)}</a>
                    </div>
                </div>
            </div>
            <hr>
            <table class="table table-bordered table-condensed themeTableColor">
                <thead>
                    <tr>
                        <th class="blockHeader">
                            <span class="h3">{vtranslate('LBL GEOTOOLS MODULE DETAILS', $QUALIFIED_MODULE)}</span>
                            <button class="btn addButton pull-right" type="button" onclick="Settings_GeoTools_ModuleEditor_Js.moduleAdd(event);" title="{vtranslate('LBL GEOTOOLS ADD MODULE', $QUALIFIED_MODULE)}">
                                <strong>{vtranslate('LBL GEOTOOLS ADD MODULE', $QUALIFIED_MODULE)}</strong>
                            </button>
                        </th>                       
                    </tr>
                </thead>
                <tbody>
                    {foreach from=$CONFIGURED_MODULES item=FIELDS key=MODNAME}
                        {assign var="COUNT" value=$MODULE_MODEL->getCount($MODNAME)}
                        <tr>
                            <td colspan="2">
                                <table class="table table-bordered table-condensed themeTableColor">
                                    <thead>
                                        <tr class="blockHeader">
                                            <th colspan="2">
                                                <span class="modname">{vtranslate($MODNAME, 'Vtiger')} {vtranslate('LBL GEOTOOLS MODULE', $QUALIFIED_MODULE)} ({$COUNT['coded']} {vtranslate('LBL GEOTOOLS OF', $QUALIFIED_MODULE)} {$COUNT['total']} {vtranslate('LBL GEOTOOLS RECORDS ENCODED', $QUALIFIED_MODULE)})</span>
                                                <button class="btn delButton pull-right" type="button" onclick="Settings_GeoTools_ModuleEditor_Js.moduleDel(event, '{$MODNAME}');" title="{vtranslate('LBL GEOTOOLS DEL MODULE', $QUALIFIED_MODULE)}">
                                                    <strong>{vtranslate('LBL GEOTOOLS DEL MODULE', $QUALIFIED_MODULE)}</strong>
                                                </button>
                                                <button style="margin:0 1em;" class="btn delButton pull-right" type="button" onclick="Settings_GeoTools_ModuleEditor_Js.delAction(event, '{$MODNAME}');" title="{vtranslate('LBL GEOTOOLS DELETE ACTION LINK', $QUALIFIED_MODULE)}">
                                                    <strong>{vtranslate('LBL GEOTOOLS DELETE ACTION LINK', $QUALIFIED_MODULE)}</strong>
                                                </button>
                                                <button class="btn addButton pull-right" type="button" onclick="Settings_GeoTools_ModuleEditor_Js.addAction(event, '{$MODNAME}');" title="{vtranslate('LBL GEOTOOLS ADD ACTION LINK', $QUALIFIED_MODULE)}">
                                                    <strong>{vtranslate('LBL GEOTOOLS ADD ACTION LINK', $QUALIFIED_MODULE)}</strong>
                                                </button>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tr>
                                        {foreach name=COUNT from=$FIELDS item=FIELD key=FIELDNAME}
                                            {if $FIELD['fieldtype'] == 'field' || $FIELD['fieldtype'] == 'icon'}
                                                {if $smarty.foreach.COUNT.iteration is not div by 2}<tr>{/if}
                                                    {if $FIELD['fieldtype'] == 'icon'}
                                                        <td width="30%">
                                                            <label class="muted pull-right marginRight10px">{$FIELD['fieldlabel']}</label>
                                                        </td>
                                                        <td>
                                                            {foreach item=RADIO from=$FIELD['radio']}
                                                                {if $RADIO['checked'] == 1}
                                                                    <input type="radio" checked="checked" value="{$RADIO['icon']}" name="{$MODNAME}__{$FIELDNAME}">
                                                                {else}
                                                                    <input type="radio" value="{$RADIO['icon']}" name="{$MODNAME}__{$FIELDNAME}">
                                                                {/if}
                                                                <span class="icon"><img src="{$RADIO['icon']}" width="12px"></span>
                                                            {/foreach}
                                                        </td>
                                                    {else}
                                                        <td width="30%"><label class="muted pull-right marginRight10px">{$FIELD['fieldlabel']}</label></td>
                                                        <td>
                                                            <select class="chzn-select row-fluid" name="{$MODNAME}__{$FIELDNAME}">
                                                                {foreach item=OPTION from=$FIELD['select']}
                                                                    <option value="{$OPTION['value']}" {$OPTION['selected']}>{$OPTION['label']}</option>
                                                                {/foreach}
                                                            </select>
                                                        </td>
                                                    {/if}
                                                {if $smarty.foreach.COUNT.iteration is not div by 2}</tr>{/if}
                                            {/if}
                                        {/foreach}
                                    </tr>
                                    {assign var="PICKLISTS" value=$MODULE_MODEL->getPicklistsForModule($MODNAME)}
                                    {if $MODNAME neq 'Users' && $PICKLISTS}
                                        <tr>
                                            <td>
                                                <label class="muted pull-right marginRight10px" for="{$MODNAME}__icon_picklist">{vtranslate('LBL GEOTOOLS PICKLIST FOR MAP ICONS', $QUALIFIED_MODULE)}</label>
                                            </td>
                                            <td>
                                                <select class="chzn-select" name="{$MODNAME}__icon_picklist">
                                                    <option value="">{vtranslate('LBL_SELECT_OPTION','Vtiger')}</option>
                                                    {foreach item=PICKLIST from=$PICKLISTS}
                                                        <option value="{$PICKLIST['name']}" {if $PICKLIST['name'] eq $FIELDS['icon_picklist']['fieldid']}selected{/if}>{vtranslate($PICKLIST['model']->get('label'), $MODNAME)}</option>
                                                    {/foreach}
                                                </select>
                                            </td>
                                        </tr>
                                    {/if}
                                    {assign var="AVAILABLE_FILTERS" value=$MODULE_MODEL->getFilters($MODNAME)}
                                    {if $AVAILABLE_FILTERS}
                                        <tr>
                                            <td>
                                                <label class="muted pull-right marginRight10px" for="{$MODNAME}__{$FIELDNAME}">{vtranslate('LBL GEOTOOLS MODULE DEFAULT FILTER', $QUALIFIED_MODULE)}</label>
                                            </td>
                                            <td>
                                                <select class="chzn-select" name="{$MODNAME}__{$FIELDNAME}">
                                                    {foreach from=$AVAILABLE_FILTERS item=FILTERNAME key=FILTERID}
                                                        <option value="{$FILTERID}" {if $FILTERID eq $FIELDS['default_filter']['fieldid']}selected{/if}>{vtranslate($FILTERNAME, $MODNAME)}</option>
                                                    {/foreach}
                                                </select>
                                            </td>
                                        </tr>
                                    {/if}
                                </table>
                            </td>
                        </tr>
                    {/foreach}
                </tbody>
            </table>
        </form>
    </div>
</div>

{/strip}
