{*<!--
/*********************************************************************************
** The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions
 * All Rights Reserved.
 ********************************************************************************/
-->*}
{strip}
<div class="container-fluid">
    <div class="contents">
        <form id="CoreEditorForm" class="form-horizontal" data-detail-url="{$MODULE_MODEL->getDetailViewUrl()}">
            <div class="widget_header row-fluid">
                <div class="span8"><h3>{vtranslate('LBL GEOTOOLS CORE EDITOR', $QUALIFIED_MODULE)}</h3>&nbsp;{vtranslate('LBL GEOTOOLS CONFIG DESCRIPTION', $QUALIFIED_MODULE)}</div>
                <div class="span4 btn-toolbar">
                    <div class="pull-right">
                        <button class="btn btn-success saveButton" type="submit" title="{vtranslate('LBL_SAVE', $QUALIFIED_MODULE)}">
                            <strong>{vtranslate('LBL_SAVE', $QUALIFIED_MODULE)}</strong>
                        </button>
                        <a type="reset" class="cancelLink" title="{vtranslate('LBL_CANCEL', $QUALIFIED_MODULE)}">{vtranslate('LBL_CANCEL', $QUALIFIED_MODULE)}</a>
                    </div>
                </div>
            </div>
            <hr>
            <table class="table table-bordered table-condensed themeTableColor">
                <thead>
                    <tr class="blockHeader"><th colspan="2">{vtranslate('LBL GEOTOOLS CONFIG', $QUALIFIED_MODULE)}</th></tr>
                </thead>
                <tbody>
                    <tr>
                        <td width="30%">
                            <label class="muted pull-right marginRight10px">{vtranslate('geocoder', $QUALIFIED_MODULE)}</label>
                        </td>
                        <td style="border-left: none;" class="row-fluid">
                            <span class="span3">
                                <select class="select2 row-fluid" name="geocoder">
                                    {foreach key=optionName item=optionLabel from=$MODULE_MODEL->getPicklistValues('geocoder')}
                                        <option value="{$optionName}" {if $optionName == {$MODULE_MODEL->get('geocoder')}} selected {/if}>
                                            {vtranslate($optionLabel, $QUALIFIED_MODULE)}
                                        </option>
                                    {/foreach}
                                </select>
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <td width="30%">
                            <label class="muted pull-right marginRight10px">{vtranslate('mapservice', $QUALIFIED_MODULE)}</label>
                        </td>
                        <td style="border-left: none;" class="row-fluid">
                            <span class="span3">
                                <select class="select2 row-fluid" name="mapservice">
                                    {foreach key=optionName item=optionLabel from=$MODULE_MODEL->getPicklistValues('mapservice')}
                                        <option value="{$optionName}" {if $optionName == {$MODULE_MODEL->get('mapservice')}} selected {/if}>
                                            {vtranslate($optionLabel, $QUALIFIED_MODULE)}
                                        </option>
                                    {/foreach}
                                </select>
                            </span>
                        </td>
                    </tr>
					<tr>
			            <td width="30%">
                            <label class="muted pull-right marginRight10px">{vtranslate('rate', $QUALIFIED_MODULE)}</label>
                        </td>
                        <td style="border-left: none;" class="row-fluid">
                            <input type="text" name="rate" data-validator='{Zend_Json::encode([['name'=>'Integer']])}' data-validation-engine="validate[required, funcCall[Vtiger_Base_Validator_Js.invokeValidation]]" value="{$MODULE_MODEL->get('rate')}" />
                        </td>
                    </tr>
                    <tr>
                        <td width="30%">
                            <label class="muted pull-right marginRight10px">{vtranslate('defaultmod', $QUALIFIED_MODULE)}</label>
                        </td>
                        <td style="border-left: none;" class="row-fluid">
                            <span class="span3">
                                <select class="select2 row-fluid" name="defaultmod">
                                    {foreach key=optionName item=optionLabel from=$MODULE_MODEL->getPicklistValues('defaultmod')}}
                                        <option value="{$optionName}" {if $optionName == {$MODULE_MODEL->get('defaultmod')}} selected {/if}>
                                            {vtranslate($optionLabel, $QUALIFIED_MODULE)}
                                        </option>
                                    {/foreach}
                                </select>
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <td width="30%">
                            <label class="muted pull-right marginRight10px">{vtranslate('radius', $QUALIFIED_MODULE)}</label>
                        </td>
                        <td style="border-left: none;" class="row-fluid">
                            <input type="text" name="radius" data-validator='{Zend_Json::encode([['name'=>'Integer']])}' data-validation-engine="validate[required, funcCall[Vtiger_Base_Validator_Js.invokeValidation]]" value="{$MODULE_MODEL->get('radius')}" />
                        </td>
                    </tr>
                    <tr>
                        <td width="30%">
                            <label class="muted pull-right marginRight10px">{vtranslate('distance', $QUALIFIED_MODULE)}</label>
                        </td>
                        <td style="border-left: none;" class="row-fluid">
                            <span class="span3">
                                <select class="select2 row-fluid" name="distance">
                                    {foreach key=optionName item=optionLabel from=$MODULE_MODEL->getPicklistValues('distance')}
                                        <option value="{$optionName}" {if $optionName == {$MODULE_MODEL->get('distance')}} selected {/if}>
                                            {vtranslate($optionLabel, $QUALIFIED_MODULE)}
                                        </option>
                                    {/foreach}
                                </select>
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <td width="30%">
                            <label class="muted pull-right marginRight10px">{vtranslate('zoom', $QUALIFIED_MODULE)}</label>
                        </td>
                        <td style="border-left: none;" class="row-fluid">
                            <input type="text" name="zoom" data-validator='{Zend_Json::encode([['name'=>'Integer']])}' data-validation-engine="validate[required, funcCall[Vtiger_Base_Validator_Js.invokeValidation]]" value="{$MODULE_MODEL->get('zoom')}" />
                        </td>
                    </tr>
                    <tr>
                        <td width="30%">
                            <label class="muted pull-right marginRight10px">{vtranslate('mapcentre', $QUALIFIED_MODULE)}</label>
                        </td>
                        <td style="border-left: none;" class="row-fluid">
                            <input type="text" name="mapcentre" data-validator='{Zend_Json::encode([['name'=>'LatLng']])}' data-validation-engine="validate[required, funcCall[Vtiger_Base_Validator_Js.invokeValidation]]" value="{$MODULE_MODEL->get('mapcentre')}" />
                        </td>
                    </tr>                                                               
                    <tr>
                        <td width="30%">
                            <label class="muted pull-right marginRight10px">{vtranslate('companyloc', $QUALIFIED_MODULE)}</label>
                        </td>
                        <td style="border-left: none;" class="row-fluid">
                            <input type="text" name="companyloc" data-validator='{Zend_Json::encode([['name'=>'LatLng']])}' data-validation-engine="validate[funcCall[Vtiger_Base_Validator_Js.invokeValidation]]" value="{$MODULE_MODEL->get('companyloc')}" />&nbsp;
                            <button class="btn btn-success saveButton" type="button" id="geocodeCompany" title="{vtranslate('LBL GEOTOOLS GEOCODE COMPANY ADDRESS', $QUALIFIED_MODULE)}">
                                <strong>{vtranslate('LBL GEOTOOLS GEOCODE COMPANY ADDRESS', $QUALIFIED_MODULE)}</strong>
                            </button>
                        </td>
                    </tr>
                    <tr>
                        <td width="30%">
                            <label class="muted pull-right marginRight10px">{vtranslate('defaultcentre', $QUALIFIED_MODULE)}</label>
                        </td>
                        <td style="border-left: none;" class="row-fluid">
                            <span class="span3">
                                <select class="select2 row-fluid" name="defaultcentre">
                                    {foreach key=optionName item=optionLabel from=$DEFAULTCENTRE}
                                        <option value="{$optionName}" {if $optionName == {$MODULE_MODEL->get('defaultcentre')}} selected {/if}>
                                            {vtranslate($optionLabel, $QUALIFIED_MODULE)}
                                        </option>
                                    {/foreach}
                                </select>
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <td width="30%">
                            <label class="muted pull-right marginRight10px">{vtranslate('iconpath', $QUALIFIED_MODULE)}</label>
                        </td>
                        <td style="border-left: none;" class="row-fluid">
                            {foreach key=ID item=PATH from=$MODULE_MODEL->getIconMarkers()}
                                <input type="radio" name="iconpath" value="{$PATH}" {if $PATH == {$MODULE_MODEL->get('iconpath')}} checked="checked" {/if} />
                                <span class="icon"><img src="{$PATH}" /></span>
                            {/foreach}
                        </td>
                    </tr>
                    <tr>
                        <td width="30%">
                            <label class="muted pull-right marginRight10px">{vtranslate('listentries', $QUALIFIED_MODULE)}</label>
                        </td>
                        <td style="border-left: none;" class="row-fluid">
                            <input type="text" name="listentries" data-validator='{Zend_Json::encode([['name'=>'Integer']])}' data-validation-engine="validate[required, funcCall[Vtiger_Base_Validator_Js.invokeValidation]]" value="{$MODULE_MODEL->get('listentries')}" />
                        </td>
                    </tr>
                </tbody>
            </table>
        </form>
    </div>
</div>
{/strip}
